/**
 * @file        g32m3101_device_cfg.h
 *
 * @brief       This file provides all configuration support for device
 *
 * @version     V1.0.0
 *
 * @date        2025-01-01
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef G32M3101_DEVICE_CFG_H
#define G32M3101_DEVICE_CFG_H

#ifdef __cplusplus
  extern "C" {
#endif

/* Includes ***************************************************************/
#include "g32m3101_ddl_adc.h"
#include "g32m3101_ddl_atmr.h"
#include "g32m3101_ddl_btmr.h"
#include "g32m3101_ddl_bus.h"
#include "g32m3101_ddl_comp.h"
#include "g32m3101_ddl_cortex.h"
#include "g32m3101_ddl_crc.h"
#include "g32m3101_ddl_div.h"
#include "g32m3101_ddl_dma.h"
#include "g32m3101_ddl_eint.h"
#include "g32m3101_ddl_gpio.h"
#include "g32m3101_ddl_flash.h"
#include "g32m3101_ddl_iwdt.h"
#include "g32m3101_ddl_gtmr.h"
#include "g32m3101_ddl_lptmr.h"
#include "g32m3101_ddl_spi.h"
#include "g32m3101_ddl_scu.h"
#include "g32m3101_ddl_usart.h"
#include "g32m3101_ddl_utils.h"
#include "g32m3101_ddl_wwdt.h"

#include "g32m3101_gpio_cfg.h"
#include "g32m3101_rcm_cfg.h"
#include "g32m3101_nvic_cfg.h"
#include "g32m3101_usart_cfg.h"
#include "g32m3101_lptmr_cfg.h"
#include "board_g32m3101_eval_ddl.h"

#if defined(USE_FULL_ASSERT)
#include "g32_assert.h"
#endif /* USE_FULL_ASSERT */

/* Exported macro *********************************************************/

/* Exported typedef *******************************************************/

/* Exported function prototypes *******************************************/
void DDL_DeviceConfig(void);
void DDL_DeviceReset(void);
void DDL_SysClkConfig(void);

#ifdef __cplusplus
}
#endif

#endif /* G32M3101_DEVICE_CFG_H */
