/**
 * @file        g32m3101_wwdt_cfg.c
 *
 * @brief       This file provides configuration support for WWDT
 *
 * @version     V1.0.0
 *
 * @date        2023-07-31
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "g32m3101_iwdt_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/


/**
 * @brief   WWDT configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DDL_IWDT_Config(void)
{
    /* Colck is 1000Hz(32K / 32) */
    DDL_IWDT_Enable(IWDT);
    DDL_IWDT_EnableWriteAccess(IWDT);
    DDL_IWDT_SetPrescaler(IWDT, DDL_IWDT_PSC_32);
    DDL_IWDT_SetReloadCounter(IWDT, 4095U);
    DDL_IWDT_ReloadCounter(IWDT);
}
