/**
 * @file        g32m3101_adc_cfg.c
 *
 * @brief       This file provides configuration support for ADC
 *
 * @version     V1.0.0
 *
 * @date        2025-06-01
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "g32m3101_adc_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/


/**
 * @brief   ADC1 configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DDL_ADC1_Config(void)
{ 
    DDL_SCU_Unlock(); 
    DDL_SCU_EnableAPBPeripheralClock(DDL_SCU_APB_PERIPHERAL_ADC1);
    DDL_SCU_Lock();
 
    /* Enable and set ADC1 Interrupt priority */
    NVIC_SetPriority((IRQn_Type)(ADC_IRQn), NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 0u, 0u));
    NVIC_EnableIRQ((IRQn_Type)(ADC_IRQn));
    
    /* Set ADC Prescaler value */
    DDL_SCU_Unlock();
    DDL_SCU_SetADCClkDiv(DDL_SCU_ADCCLK_DIVISION_16);
    DDL_SCU_Lock();

    if(!DDL_ADC_IsConversionOngoing(ADC1))
    {
        DDL_ADC_REG_SetTriggerSource(ADC1, DDL_ADC_REG_TRIG_SOFTWARE);
    
        /* Set ADC data alignment */
        DDL_ADC_SetDataAlignment(ADC1, DDL_ADC_ALIGNMENT_RIGHT);
        
        /* Enable ADC continuous conversion mode */
        DDL_ADC_REG_SetContinuousMode(ADC1, DDL_ADC_REG_CONV_CONTINUOUS);
        DDL_ADC_REG_SetSequencerDiscont(ADC1, DDL_ADC_REG_SEQ_DISCONT_DISABLE);
        
        /* Disable ADC DMA continuous request */
        DDL_ADC_REG_SetDMATransfer(ADC1, DDL_ADC_REG_DMA_TRANSFER_DISABLE);
        
        /* Set sampling time  */
        DDL_ADC_SetSlowChannelSamplingTime(ADC1, DDL_ADC_SAMPLINGTIME_SLOW_256CYCLES);
        
        /* Set ADC number of conversion, 1 */
        DDL_ADC_REG_SetSequencerLength(ADC1, DDL_ADC_REG_SEQ_SCAN_DISABLE);
        
        /* Configure for the selected ADC regular channel */
        DDL_ADC_REG_SetSequencerRanks(ADC1, DDL_ADC_REG_RANK_1, DDL_ADC_CHANNEL_8);
        
        DDL_ADC_SetVREF(ADC1, DDL_ADC_VREF_SEL_VDD5);
    }
}
