/**
 * @file        apm32f4xx_rcm_cfg.c
 *
 * @brief       This file provides configuration support for RCM
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_rcm_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   Peripheral Clock configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_RCM_PeripheralClkConfig(void)
{
    RCM_PeriphCLKInitTypeDef PeriphClk_InitStruct = {0};
    
    /* I2S clock */
    PeriphClk_InitStruct.PeriphClockSelection   = RCM_PERIPHCLK_I2S;
    PeriphClk_InitStruct.PLLI2S.PLL2A           = 50U;
    PeriphClk_InitStruct.PLLI2S.PLL2C           = 7U;
    if (DAL_RCMEx_PeriphCLKConfig(&PeriphClk_InitStruct) != DAL_OK)
    {
        Error_Handler();
    }
}
