/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2025-05-08
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "usbd_composite_winusb_itf.h"
#include "usbd_composite_cdc_vcp.h"
#include <string.h>

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/**
 * @brief User application state
 */
typedef enum
{
    USER_APP_INIT,
    USER_APP_RUN,
} USER_APP_STATE_T;

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern USBD_INFO_T gUsbDeviceFS;

extern USBD_CDC_VCP_INFO_T gCDCVCP;
extern uint8_t cdcTxBuffer[USBD_CDC_TX_BUF_LEN];
extern uint8_t cdcRxBuffer[USBD_CDC_RX_BUF_LEN];

extern USBD_WINUSB_ITF_INFO_T gWinusbItf;
extern uint8_t winusbTxBuffer[USBD_WINUSB_TX_BUF_LEN];
extern uint8_t winusbRxBuffer[USBD_WINUSB_RX_BUF_LEN];

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Infinite loop */
    while (1)
    {
        USB_DevUserApplication();
    }
}

/**
 * @brief       User application
 *
 * @param       None
 *
 * @retval      None
 */
void USB_DevUserApplication(void)
{
    static uint8_t userAppState = USER_APP_INIT;
    static uint8_t interval = 0;
    
    switch (userAppState)
    {
        case USER_APP_INIT:
            interval = USBD_Composite_CDC_ReadInterval(&gUsbDeviceFS);
            userAppState = USER_APP_RUN;
            break;

        case USER_APP_RUN:
            if(gUsbDeviceFS.devState == USBD_DEV_CONFIGURE)
            {
                /* Loopback */
                if(gCDCVCP.state == USBD_CDC_VCP_REV_UPDATE)
                {
                    gCDCVCP.state = USBD_CDC_VCP_IDLE;
                    
                    USBD_FS_CDC_ItfSend((uint8_t *)cdcRxBuffer, (uint16_t)gCDCVCP.rxUpdateLen);
                    
                    USBD_FS_CDC_ItfSend((uint8_t *)"\r\n", strlen("\r\n"));
                }

                if(gWinusbItf.state == USBD_WINUSB_ITF_REV_UPDATE)
                {
                    gWinusbItf.state = USBD_WINUSB_ITF_IDLE;
                    
                    USBD_FS_WINUSB_ItfSend((uint8_t *)winusbRxBuffer, (uint16_t)gWinusbItf.rxUpdateLen);
                    
                    USBD_FS_WINUSB_ItfSend((uint8_t *)"\r\n", strlen("\r\n"));
                }

                DAL_Delay(interval);
            }
            break;
    }
}
