/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2025-05-08
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern TMR_HandleTypeDef htmr1;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    uint32_t dir = 0U;
    uint32_t encode = 0U;

    /* Device configuration */
    DAL_DeviceConfig();

    /* Start the encoder interface */
    DAL_TMR_Encoder_Start(&htmr1, TMR_CHANNEL_ALL);

    /* Infinite loop */
    while (1)
    {
        dir = (uint32_t)__DAL_TMR_IS_TMR_COUNTING_DOWN(&htmr1);
        encode = (uint32_t)(__DAL_TMR_GET_COUNTER(&htmr1));
      
        LOGI(tag,"Encoder dir:%d, encode:%d\r\n",dir,encode);
    }
}
