/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2025-05-08
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern TMR_HandleTypeDef htmr9;
extern TMR_HandleTypeDef htmr10;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    uint32_t temp;

    /* Device configuration */
    DAL_DeviceConfig();

    /* Start TMR */
    if (DAL_TMR_Base_Start(&htmr9) != DAL_OK)
    {
        Error_Handler();
    }

    if (DAL_TMR_Base_Start(&htmr10) != DAL_OK)
    {
        Error_Handler();
    }

    /* Infinite loop */
    while (1)
    {
        temp = TMR9->CNT << 16U;
        temp |= TMR10->CNT;
        LOGI(tag, "Count Value: 0x%08x\r\n", temp);
        DAL_Delay(500U);
    }
}
