/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2025-05-08
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";

/* Private function prototypes ********************************************/
static void PMU_StandbyMode(void);

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Enable PMU clock */
    __DAL_RCM_PMU_CLK_ENABLE();

    /* Clear the wake-up flag */
    if (__DAL_PMU_GET_FLAG(PMU_FLAG_WU) != RESET)
    {
        __DAL_PMU_CLEAR_FLAG(PMU_FLAG_WU);
    }

    /* If system was resumed from Standby mode */
    if(__DAL_PMU_GET_FLAG(PMU_FLAG_SB) != RESET)
    {
        __DAL_PMU_CLEAR_FLAG(PMU_FLAG_SB);
        LOGI(tag, "System was resumed from standby mode\r\n");
        
        while (1)
        {
            BOARD_LED_Toggle(LED2);
            DAL_Delay(500U);
        }
    }

    /* Infinite loop */
    while (1)
    {
        if (!BOARD_BUTTON_GetState(BUTTON_KEY2))
        {
            DAL_Delay(10U);
            if (!BOARD_BUTTON_GetState(BUTTON_KEY2))
            {
                PMU_StandbyMode();
            }
            while (!BOARD_BUTTON_GetState(BUTTON_KEY2))
            {
            }
        }
    }
}

/* Private functions ******************************************************/

/**
 * @brief   PMU standby mode
 *  
 * @param   None
 *  
 * @retval  None
 */
static void PMU_StandbyMode(void)
{
    LOGI(tag, "Enter standby mode\r\n");

    /* Enable PMU Clock*/
    __DAL_RCM_PMU_CLK_ENABLE();

    /* Allow access to backup */
    DAL_PMU_EnableBkUpAccess();

    /* Reset RTC domain */
    __DAL_RCM_BACKUPRESET_FORCE();
    __DAL_RCM_BACKUPRESET_RELEASE();

    /* Disable all used wake-up sources: PA0 */
    DAL_PMU_DisableWakeUpPin(PMU_WAKEUP_PIN1);

    /* Clear all related wake-up flags */
    __DAL_PMU_CLEAR_FLAG(PMU_FLAG_WU);

    /* Re-enable all used wake-up sources: PA0 */
    DAL_PMU_EnableWakeUpPin(PMU_WAKEUP_PIN1);

    /* Enter STANDBY mode  */
    DAL_PMU_EnterSTANDBYMode();
}
