/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern TMR_HandleTypeDef htmr2;
extern TMR_HandleTypeDef htmr3;
extern TMR_HandleTypeDef htmr4;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Start Master PWM generation */
    if (DAL_TMR_PWM_Start(&htmr2, TMR_CHANNEL_1) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start Slave1 PWM generation */
    if (DAL_TMR_PWM_Start(&htmr3, TMR_CHANNEL_1) != DAL_OK)
    {
        Error_Handler();
    }
    /* Start Slave2 PWM generation */
    if (DAL_TMR_PWM_Start(&htmr4, TMR_CHANNEL_1) != DAL_OK)
    {
        Error_Handler();
    }

    /* Infinite loop */
    while (1)
    {
        
    }
}

/**
 * @brief   Period elapsed callback in non-blocking mode
 *
 * @param   htmr TMR handle
 *
 * @retval  None
 */
void DAL_TMR_PeriodElapsedCallback(TMR_HandleTypeDef *htmr)
{
    BOARD_LED_Toggle(LED2);
}
