/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
uint32_t comp1OutVal = 0U;
uint32_t comp2OutVal = 0U;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern COMP_HandleTypeDef hcomp1;
extern COMP_HandleTypeDef hcomp2;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Start COMP1 */
    if (DAL_COMP_Start(&hcomp1) != DAL_OK)
    {
        Error_Handler();
    }

    /* Lock COMP1 */
    if (DAL_COMP_Lock(&hcomp1) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start COMP2 */
    if (DAL_COMP_Start(&hcomp2) != DAL_OK)
    {
        Error_Handler();
    }

    /* Lock COMP2 */
    if (DAL_COMP_Lock(&hcomp2) != DAL_OK)
    {
        Error_Handler();
    }

    /* Infinite loop */
    while (1)
    {
        comp1OutVal = DAL_COMP_GetOutputLevel(&hcomp1);
        comp2OutVal = DAL_COMP_GetOutputLevel(&hcomp2);

        if (comp1OutVal != 0U)
        {
            BOARD_LED_Toggle(LED2);
        }

        if (comp2OutVal != 0U)
        {
            BOARD_LED_Toggle(LED3);
        }

        DAL_Delay(500);
    }
}
