/**
 * @file        apm32f4xx_comp_cfg.c
 *
 * @brief       This file provides configuration support for COMP
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_comp_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
COMP_HandleTypeDef hcomp1;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief  Initialize the COMP MSP
 * 
 * @param  hcomp COMP handle
 * 
 * @retval None
 */
void DAL_COMP_MspInit(COMP_HandleTypeDef *hcomp)
{
    GPIO_InitTypeDef GPIO_InitStruct = {0};

    if (hcomp->Instance == COMP1)
    {
        /* GPIO ports clock enable */
        __DAL_RCM_GPIOC_CLK_ENABLE();

        /* Peripheral clock enable */
        __DAL_RCM_COMP1_CLK_ENABLE();

        /**COMP1 GPIO Configuration
        PC0     ------> COMP1_INP
        */
        GPIO_InitStruct.Pin = GPIO_PIN_0;
        GPIO_InitStruct.Mode = GPIO_MODE_ANALOG;
        GPIO_InitStruct.Pull = GPIO_NOPULL;
        DAL_GPIO_Init(GPIOC, &GPIO_InitStruct);
    }
}

/**
 * @brief  DeInitialize COMP MSP
 * 
 * @param  hcomp COMP handle
 * 
 * @retval None
 */
void DAL_COMP_MspDeInit(COMP_HandleTypeDef *hcomp)
{
    if (hcomp->Instance == COMP1)
    {
        /* Peripheral clock disable */
        __DAL_RCM_COMP1_CLK_DISABLE();

        /* Disable COMP GPIOs clock */
        __DAL_RCM_GPIOC_CLK_DISABLE();

        /* Disable COMP GPIOs clock */
        DAL_GPIO_DeInit(GPIOC, GPIO_PIN_0);
    }
}

/**
 * @brief   COMP1 configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_COMP1_Config(void)
{
    hcomp1.Instance             = COMP1;
    hcomp1.Init.WindowMode      = COMP_WINDOWMODE_DISABLE;
    hcomp1.Init.InvertingInput  = COMP_INVERTING_INPUT_VREFINT;
    hcomp1.Init.OutputPol       = COMP_OUTPUTPOL_NONINVERTED;
    hcomp1.Init.Output          = COMP_OUTPUT_TMR1BKIN;
    if(DAL_COMP_Init(&hcomp1) != DAL_OK)
    {
        Error_Handler();
    }
}
