/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "usbd_cdc.h"
#include "usbd_cdc_vcp.h"
#include <string.h>

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/**
 * @brief User application state
 */
typedef enum
{
    USER_APP_INIT,
    USER_APP_RUN,
} USER_APP_STATE_T;

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern USBD_INFO_T gUsbDeviceHS;

extern USBD_CDC_VCP_INFO_T gUsbVCP;

extern uint8_t cdcRxBuffer[USBD_CDC_RX_BUF_LEN];

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Infinite loop */
    while (1)
    {
        USB_DevUserApplication();
    }
}

/**
 * @brief       User application
 *
 * @param       None
 *
 * @retval      None
 */
void USB_DevUserApplication(void)
{
    static uint8_t userAppState = USER_APP_INIT;
    static uint8_t interval = 0;
    static uint16_t i = 0;
    static char str[] = "Hello      \r\n";

    switch (userAppState)
    {
        case USER_APP_INIT:
            interval = USBD_CDC_ReadInterval(&gUsbDeviceHS);
            userAppState = USER_APP_RUN;
            break;

        case USER_APP_RUN:
            /* Loopback */
            if(gUsbVCP.state == USBD_CDC_VCP_REV_UPDATE)
            {
                gUsbVCP.state = USBD_CDC_VCP_IDLE;

                USBD_HS_CDC_ItfSend((uint8_t *)cdcRxBuffer, (uint16_t)gUsbVCP.rxUpdateLen);

                USBD_HS_CDC_ItfSend((uint8_t *)"\r\n", strlen("\r\n"));
            }
            else
            {
                i++;
                sprintf(str,"Hello %d\r\n",i);
                USBD_HS_CDC_ItfSend((uint8_t *)str, strlen(str));
            }

            DAL_Delay(interval);
            break;
    }
}
