/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern TMR_HandleTypeDef htmr1;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    uint32_t buffer[6] = {999U, 0U, 800U, 700U, 600U, 500U};

    /* Device configuration */
    DAL_DeviceConfig();

    /* Start channel 1 */
    if (DAL_TMR_PWM_Start(&htmr1, TMR_CHANNEL_1) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start channel 1N */
    if (DAL_TMREx_PWMN_Start(&htmr1, TMR_CHANNEL_1) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start channel 2 */
    if (DAL_TMR_PWM_Start(&htmr1, TMR_CHANNEL_2) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start channel 2N */
    if (DAL_TMREx_PWMN_Start(&htmr1, TMR_CHANNEL_2) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start channel 3 */
    if (DAL_TMR_PWM_Start(&htmr1, TMR_CHANNEL_3) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start channel 3N */
    if (DAL_TMREx_PWMN_Start(&htmr1, TMR_CHANNEL_3) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start channel 4 */
    if (DAL_TMR_PWM_Start(&htmr1, TMR_CHANNEL_4) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start DMA burst transfer */ 
    DAL_TMR_DMABurst_WriteStart(&htmr1, TMR_DMABASE_AUTORLD, TMR_DMA_UPDATE,
                               (uint32_t*)buffer, TMR_DMABURSTLENGTH_6TRANSFERS);

    /* Infinite loop */
    while (1)
    {
        
    }
}
