/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
__IO uint32_t PWMStep = 0U;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern TMR_HandleTypeDef htmr1;
extern TMR_OC_InitTypeDef OC_ConfigStruct;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Start TMR1 channel 1 */
    if (DAL_TMR_OC_Start(&htmr1, TMR_CHANNEL_1) != DAL_OK)
    {
        Error_Handler();
    }
    
    /* Start TMR1 channel 1N */
    if (DAL_TMREx_OCN_Start(&htmr1, TMR_CHANNEL_1) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start TMR1 channel 2 */
    if (DAL_TMR_OC_Start(&htmr1, TMR_CHANNEL_2) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start TMR1 channel 2N */
    if (DAL_TMREx_OCN_Start(&htmr1, TMR_CHANNEL_2) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start TMR1 channel 3 */
    if (DAL_TMR_OC_Start(&htmr1, TMR_CHANNEL_3) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start TMR1 channel 3N */
    if (DAL_TMREx_OCN_Start(&htmr1, TMR_CHANNEL_3) != DAL_OK)
    {
        Error_Handler();
    }

    /* Infinite loop */
    while (1)
    {
        
    }
}

/**
 * @brief   Hall commutation changed callback in non-blocking mode
 *
 * @param   htmr TMR handle
 *
 * @retval  None
 */
void DAL_TMREx_CommutCallback(TMR_HandleTypeDef *htmr)
{
    OC_ConfigStruct.OCMode     = TMR_OCMODE_PWM1;

    if(PWMStep == 0U)
    {
        /* Configure channel 1 */
        DAL_TMR_PWM_ConfigChannel(htmr, &OC_ConfigStruct, TMR_CHANNEL_1);
        DAL_TMR_PWM_Start(htmr, TMR_CHANNEL_1);
        DAL_TMREx_OCN_Stop(htmr, TMR_CHANNEL_1);

        /* Configure channel 3 */
        DAL_TMR_PWM_ConfigChannel(htmr, &OC_ConfigStruct, TMR_CHANNEL_3);
        DAL_TMREx_OCN_Start(htmr, TMR_CHANNEL_3);
        DAL_TMR_PWM_Stop(htmr, TMR_CHANNEL_3);

        /* Configure channel 2 */
        DAL_TMR_OC_Stop(htmr, TMR_CHANNEL_2);
        DAL_TMREx_OCN_Stop(htmr, TMR_CHANNEL_2);
        PWMStep = 1U;
    }

    if (PWMStep == 1U)
    {
        /* Configure channel 2 */
        DAL_TMR_PWM_ConfigChannel(htmr, &OC_ConfigStruct, TMR_CHANNEL_2);
        DAL_TMREx_OCN_Start(htmr, TMR_CHANNEL_2);

        /* Configure channel 3 */
        DAL_TMREx_OCN_Stop(htmr, TMR_CHANNEL_3);
        PWMStep++;
    }
    else if (PWMStep == 2U)
    {
        /* Configure channel 3 */
        DAL_TMR_PWM_ConfigChannel(htmr, &OC_ConfigStruct, TMR_CHANNEL_3);
        DAL_TMR_PWM_Start(htmr, TMR_CHANNEL_3);

        /* Configure channel 1 */
        DAL_TMR_OC_Stop(htmr, TMR_CHANNEL_1);
        PWMStep++;
    }
    else if(PWMStep == 3U)
    {
        /* Configure channel 2 */
        DAL_TMREx_OCN_Stop(htmr, TMR_CHANNEL_2);

        /* Configure channel 1 */
        DAL_TMR_PWM_ConfigChannel(htmr, &OC_ConfigStruct, TMR_CHANNEL_1);
        DAL_TMREx_OCN_Start(htmr, TMR_CHANNEL_1);
        PWMStep++;
    }
    else if(PWMStep == 4U)
    {
        /* Configure channel 3 */
        DAL_TMR_OC_Stop(htmr, TMR_CHANNEL_3);

        /* Configure channel 2 */
        DAL_TMR_PWM_ConfigChannel(htmr, &OC_ConfigStruct, TMR_CHANNEL_2);
        DAL_TMR_PWM_Start(htmr, TMR_CHANNEL_2);
        PWMStep++;
    }
    else if(PWMStep == 5U)
    {
        /* Configure channel 3 */
        DAL_TMR_PWM_ConfigChannel(htmr, &OC_ConfigStruct, TMR_CHANNEL_3);
        DAL_TMREx_OCN_Start(htmr, TMR_CHANNEL_3);

        /* Configure channel 1 */
        DAL_TMREx_OCN_Stop(htmr, TMR_CHANNEL_1);
        PWMStep++;
    }
    else
    {
        /* Configure channel 1 */
        DAL_TMR_PWM_ConfigChannel(htmr, &OC_ConfigStruct, TMR_CHANNEL_1);
        DAL_TMR_PWM_Start(htmr, TMR_CHANNEL_1);

        /* Configure channel 2 */
        DAL_TMR_OC_Stop(htmr, TMR_CHANNEL_2);
        PWMStep = 1U;
    }
}
