/**
 * @file        apm32f4xx_rng_cfg.c
 *
 * @brief       This file provides configuration support for RNG
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_rng_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
RNG_HandleTypeDef hrng;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief  Initializes the RNG MSP
 *
 * @param  hrng pointer to a RNG_HandleTypeDef structure that contains
 *                the configuration information for RNG
 *
 * @retval None
 */
void DAL_RNG_MspInit(RNG_HandleTypeDef *hrng)
{
    /* Enable peripheral clock */
    __DAL_RCM_RNG_CLK_ENABLE();
}

/**
 * @brief  DeInitializes the RNG MSP
 *
 * @param  hrng pointer to a RNG_HandleTypeDef structure that contains
 *                the configuration information for RNG
 *
 * @retval None
 */
void DAL_RNG_MspDeInit(RNG_HandleTypeDef *hrng)
{
    /* Reset peripheral */
    __DAL_RCM_RNG_FORCE_RESET();
    __DAL_RCM_RNG_RELEASE_RESET();
}

/**
 * @brief   RNG configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_RNG_Config(void)
{
    hrng.Instance = RNG;
    if (DAL_RNG_Init(&hrng) != DAL_OK)
    {
        Error_Handler();
    }
}
