/**
 * @file        apm32f4xx_cryp_cfg.c
 *
 * @brief       This file provides configuration support for CRYP
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_cryp_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
CRYP_HandleTypeDef hcryp;

/* TDE keys */
uint32_t TDESKey[6] =
{
    0x01234567U, 0x89ABCDEFU, 0x23456789U,
    0xABCDEF01U, 0x456789ABU, 0xCDEF0123U
};

/* Initialization vector */
uint32_t initVectorCBC[2] =
{
    0xF69F2445U ,0xDF4F9B17U
};

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief  Initializes the CRYP MSP
 *
 * @param  hcryp: pointer to a CRYP_HandleTypeDef structure that contains
 *         the configuration information for CRYP module
 *
 * @retval None
 */
void DAL_CRYP_MspInit(CRYP_HandleTypeDef *hcryp)
{
    /* Enable peripheral clock */
    __DAL_RCM_CRYP_CLK_ENABLE();
}

/**
 * @brief  DeInitializes CRYP MSP
 (
 * @param  hcryp: pointer to a CRYP_HandleTypeDef structure that contains
 *         the configuration information for CRYP module
 *
 * @retval None
 */
void DAL_CRYP_MspDeInit(CRYP_HandleTypeDef *hcryp)
{
    /* Disable peripheral clock */
    __DAL_RCM_CRYP_CLK_DISABLE();
}

/**
 * @brief   CRYP TDES ECB configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_CRYP_TDESECBConfig(void)
{
    hcryp.Instance              = CRYP;
    hcryp.Init.DataType         = CRYP_DATATYPE_32B;
    hcryp.Init.pKey             = TDESKey;
    hcryp.Init.Algorithm        = CRYP_TDES_ECB;
    hcryp.Init.KeyIVConfigSkip  = CRYP_KEYIVCONFIG_ALWAYS;
    if (DAL_CRYP_Init(&hcryp) != DAL_OK)
    {
        Error_Handler();
    }
}

/**
 * @brief   CRYP TDES CBC configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_CRYP_TDESCBCConfig(void)
{
    hcryp.Instance              = CRYP;
    hcryp.Init.DataType         = CRYP_DATATYPE_32B;
    hcryp.Init.pKey             = TDESKey;
    hcryp.Init.Algorithm        = CRYP_TDES_CBC;
    hcryp.Init.pInitVect        = initVectorCBC;
    if (DAL_CRYP_Init(&hcryp) != DAL_OK)
    {
        Error_Handler();
    }
}
