/**
 * @file        board_sd.c
 *
 * @brief       Header for board_sd.c file
 *
 * @attention
 *
 *  Copyright (C) 2024 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef BOARD_SD_H
#define BOARD_SD_H

#ifdef __cplusplus
    extern "C" {
#endif

/* Includes ***************************************************************/
#include "apm32f4xx_dal.h"

/* Exported macro *********************************************************/

/**
 * @brief SD status
 */
#define SD_OK               0x00U
#define SD_ERROR            0x01U

#define SD_NOT_PRESENT      0x00U
#define SD_PRESENT          0x01U

#define SD_XFER_OK          0x00U
#define SD_XFER_BUSY        0x01U

/* Exported typedef *******************************************************/

/* Exported function prototypes *******************************************/
uint8_t BOARD_SD_Init(void);
uint8_t BOARD_SD_IsDetected(void);
uint8_t BOARD_SD_WriteBlocks(uint32_t *buffer, uint32_t addr, uint32_t blkNum, uint32_t timeout);
uint8_t BOARD_SD_ReadBlocks(uint32_t *buffer, uint32_t addr, uint32_t blkNum, uint32_t timeout);
uint8_t BOARD_SD_WriteBlocks_DMA(uint32_t *buffer, uint32_t addr, uint32_t blkNum);
uint8_t BOARD_SD_ReadBlocks_DMA(uint32_t *buffer, uint32_t addr, uint32_t blkNum);
uint8_t BOARD_SD_Erase(uint32_t startAddr, uint32_t endAddr);
uint8_t BOARD_SD_ReadCardState(void);
void BOARD_SD_ReadCardInfo(DAL_SD_CardInfoTypeDef *cardInfo);

void BOARD_SD_AbortCallback(void);
void BOARD_SD_WriteCpltCallback(void);
void BOARD_SD_ReadCpltCallback(void);

#ifdef __cplusplus
}
#endif

#endif /* BOARD_SD_H */
