/**
 * @file        apm32f4xx_pmu_cfg.c
 *
 * @brief       This file provides configuration support for PMU
 *
 * @version     V1.0.0
 *
 * @date        2023-07-31
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_pmu_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   PMU configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_PMU_Config(void)
{
    PMU_PVDTypeDef PVD_ConfigStruct = {0};

    /* Enable PMU Clock */
    __DAL_RCM_PMU_CLK_ENABLE();

    /* Configure the PVD Level and mode */
    PVD_ConfigStruct.PVDLevel   = PMU_PVDLEVEL_3;
    PVD_ConfigStruct.Mode       = PMU_PVD_MODE_IT_RISING_FALLING;
    DAL_PMU_ConfigPVD(&PVD_ConfigStruct);

    /* Enable the PVD Output */
    DAL_PMU_EnablePVD();
}
