/**
 * @file        apm32f4xx_crc_cfg.c
 *
 * @brief       This file provides configuration support for CRC
 *
 * @version     V1.0.0
 *
 * @date        2023-07-31
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_crc_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
CRC_HandleTypeDef hcrc;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   Initializes the CRC MSP
 *
 * @param   hcrc CRC handle
 *
 * @retval  None
 */
void DAL_CRC_MspInit(CRC_HandleTypeDef *hcrc)
{
    /* Enable peripheral clock */
    __DAL_RCM_CRC_CLK_ENABLE();
}

/**
 * @brief  DeInitialize the CRC MSP
 *
 * @param  hcrc CRC handle
 *
 * @retval None
 */
void DAL_CRC_MspDeInit(CRC_HandleTypeDef *hcrc)
{
    /* Disable peripheral clock */
    __DAL_RCM_CRC_CLK_DISABLE();
}

/**
 * @brief   CRC configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_CRC_Config(void)
{
    hcrc.Instance = CRC;
    if (DAL_CRC_Init(&hcrc) != DAL_OK)
    {
        Error_Handler();
    }
}
