/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "lcd.h"
#include "apm32f4xx_device_cfg.h"
#include <string.h>
#include <stdbool.h>

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/
static void LCD_Demo(void);

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Initialize LCD */
    LCD_Init();

    /* LCD demo */
    LCD_Demo();
}

/**
 * @brief   LCD demo
 *
 * @param   None
 *
 * @retval  None
 */
static void LCD_Demo(void)
{
    static uint8_t status = 0;

    LCD_PutString(185, 90, "LCD Demo", LCD_COLOR_FOREGROUND);
    LCD_DrawLine(10, 120, 470, 120, LCD_COLOR_FOREGROUND);
    LCD_DrawRectangle(10, 130, LCD_GetMaxX() - 10, LCD_GetMaxY() - 10, LCD_COLOR_FOREGROUND);

    while(1)
    {
        /* Open a window */
        LCD_OpenWindow(11, 131, LCD_GetMaxX() - 21, LCD_GetMaxY() - 141);

        /* Clear window */
        LCD_FillWindow(LCD_GetBackColor());

        switch(status)
        {
            case 0:
                LCD_DrawCircle(240, 300, 100, LCD_COLOR_RED, ENABLE);
                LCD_DrawCircle(360, 500, 100, LCD_COLOR_YELLOW, ENABLE);
                LCD_DrawCircle(120, 500, 100, LCD_COLOR_BLUE, ENABLE);

                BOARD_LED_On(LED1);
                BOARD_LED_Off(LED2);
                BOARD_LED_Off(LED3);
                break;

            case 1:
                LCD_DrawRectangle(100, 400, 380, 500, LCD_COLOR_BLACK);
                LCD_DrawRectangle(180, 320, 300, 580, LCD_COLOR_RED);

                BOARD_LED_Off(LED1);
                BOARD_LED_On(LED2);
                BOARD_LED_Off(LED3);
                break;

            default:
                LCD_DrawLine(240, 300, 120, 500, LCD_COLOR_RED);
                LCD_DrawLine(240, 300, 360, 500, LCD_COLOR_YELLOW);
                LCD_DrawLine(120, 500, 360, 500, LCD_COLOR_BLUE);
                LCD_DrawLine(240, 550, 120, 350, LCD_COLOR_BLACK);
                LCD_DrawLine(240, 550, 360, 350, LCD_COLOR_USER);
                LCD_DrawLine(120, 350, 360, 350, LCD_COLOR_GREEN);
                LCD_DrawCircle(240, 425, 150, LCD_COLOR_FOREGROUND, DISABLE);

                BOARD_LED_Off(LED1);
                BOARD_LED_Off(LED2);
                BOARD_LED_On(LED3);
                break;
        }

        while(1)
        {
            if (!BOARD_BUTTON_GetState(BUTTON_KEY1))
            {
                while(!BOARD_BUTTON_GetState(BUTTON_KEY1));
                status++;
                if (status > 2)
                {
                    status = 0;
                }
                break;
            }
        }
    }
}
