/**
 * @file        ethernetif.h
 *
 * @brief       Header for ethernetif.c module
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef ETHERNETIF_H
#define ETHERNETIF_H

#ifdef __cplusplus
  extern "C" {
#endif

/* Includes ***************************************************************/
#include "lwip/err.h"
#include "lwip/netif.h"

/* Exported macro *********************************************************/

/**
 * @brief PHY hardware reset
 */
#define PHY_HARDWARE_RESET

#if defined(PHY_HARDWARE_RESET)
#define PHY_RESET_GPIO_PORT         GPIOD
#define PHY_RESET_GPIO_PIN          GPIO_PIN_11
#endif /* PHY_HARDWARE_RESET */

/* Exported typedef *******************************************************/

/* Exported function prototypes *******************************************/
err_t ethernetif_init(struct netif *netif);
void ethernetif_input(struct netif *netif);
void ethernetif_checkEthLinkState(struct netif *netif);

#ifdef __cplusplus
}
#endif

#endif /* ETHERNETIF_H */
