/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-07-31
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include <string.h>
#include <stdbool.h>

/* Private includes *******************************************************/

/* Private macro **********************************************************/
#define BUFFER_SIZE         100U

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
uint32_t txBuffer[BUFFER_SIZE];
uint32_t rxBuffer[BUFFER_SIZE];

/* Private function prototypes ********************************************/
static bool BufferCmp(uint32_t *buf1, uint32_t *buf2, uint32_t size);

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    uint32_t i;

    /* Device configuration */
    DAL_DeviceConfig();

    /* Init SDRAM */
    SDRAM_Config();

    /* Fill buffer */
    for (i = 0U; i < BUFFER_SIZE; i++)
    {
        txBuffer[i] = i + 0xABCD0000U;
    }

    /* Write data to the SDRAM memory */
    SDRAM_WriteData(SDRAM_DEVICE_ADDR, txBuffer, BUFFER_SIZE);

    /* Read back data from the SDRAM memory */
    SDRAM_ReadData(SDRAM_DEVICE_ADDR, rxBuffer, BUFFER_SIZE);

    if (BufferCmp(txBuffer, rxBuffer, BUFFER_SIZE) != true)
    {
        BOARD_LED_On(LED3);
        Error_Handler();
    }

    /* Infinite loop */
    while (1)
    {
        BOARD_LED_Toggle(LED2);
        DAL_Delay(500U);
    }
}

/**
 * @brief   Buffer compare
 *
 * @param   buf1: First buffer to be compared
 *
 * @param   buf2: Second buffer to be compared
 *
 * @param   size: Buffer size
 *
 * @retval  Comparison result(ture or false)
 */
static bool BufferCmp(uint32_t *buf1, uint32_t *buf2, uint32_t size)
{
    uint32_t i;

    bool status = true;

    for (i = 0U; i < size; i++)
    {
        if (buf1[i] != buf2[i])
        {
            status = false;
            break;
        }
    }

    return status;
}
