/**
 * @file        apm32f4xx_sdram_cfg.h
 *
 * @brief       This file provides configuration support for SDRAM
 *
 * @version     V1.0.0
 *
 * @date        2023-07-31
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef APM32F4XX_SDRAM_CFG_H
#define APM32F4XX_SDRAM_CFG_H

#ifdef __cplusplus
  extern "C" {
#endif

/* Includes ***************************************************************/
#include "apm32f4xx_dal.h"

/* Exported macro *********************************************************/
#define SDRAM_OK                0x00U
#define SDRAM_ERROR             0x01U

#define SDRAM_DEVICE_ADDR       ((uint32_t)0x60000000U)
#define SDRAM_DEVICE_SIZE       ((uint32_t)0x200000U)  /* SDRAM device size in Bytes (2MB) */

/* Exported typedef *******************************************************/

/* Exported function prototypes *******************************************/
void SDRAM_Config(void);
uint8_t SDRAM_WriteData(uint32_t startAddr, uint32_t *buffer, uint32_t dataSize);
uint8_t SDRAM_ReadData(uint32_t startAddr, uint32_t *buffer, uint32_t dataSize);
uint8_t SDRAM_WriteDataDMA(uint32_t startAddr, uint32_t *buffer, uint32_t dataSize);
uint8_t SDRAM_WriteDataDMA(uint32_t startAddr, uint32_t *buffer, uint32_t dataSize);

#ifdef __cplusplus
}
#endif

#endif /* APM32F4XX_SDRAM_CFG_H */
