/**
 * @file        camera.c
 *
 * @brief       This file provides application support for camera
 *
 * @version     V1.0.0
 *
 * @date        2023-07-31
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "camera.h"

/* Private includes *******************************************************/
#include "cameraif.h"
#include "lcd.h"
#include "apm32f4xx_device_cfg.h"

/* Private macro **********************************************************/

/* Camera data buffer size*/
#define CAMERA_BUF_SIZE         10U * 1024U

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern DCI_HandleTypeDef hdci1;
extern UART_HandleTypeDef huart1;

/* External functions *****************************************************/

/**
 * @brief   Init camera
 *
 * @param   None
 *
 * @retval  None
 */
void Camera_Init(void)
{
    CAMERA_Config(CAMERA_IMG_UXGA);
}

/**
 * @brief   Starts camera capture in continuous mode
 *
 * @param   None
 *
 * @retval  None
 */
void Camera_StartContinuousCapture(void)
{
    //__DAL_DCI_ENABLE_IT(&hdci1, DCI_IT_FRAME);
    
    DAL_DCI_Start_DMA(&hdci1, DCI_MODE_CONTINUOUS, \
                     (uint32_t)LCD_DATA_SMC_ADDR, 1U);
}

/**
 * @brief   Suspends camera capture
 *
 * @param   None
 *
 * @retval  None
 */
void Camera_SuspendCapture(void)
{
    DAL_DCI_Suspend(&hdci1);
}

/**
 * @brief   Resumes camera capture
 *
 * @param   None
 *
 * @retval  None
 */
void Camera_ResumesCapture(void)
{
    DAL_DCI_Resume(&hdci1);
}

/**
 * @brief   Stops camera capture
 *
 * @param   None
 *
 * @retval  None
 */
void Camera_StopCapture(void)
{
    DAL_DCI_Stop(&hdci1);
}

/**
 * @brief  Line Event callback
 *
 * @param  hdci pointer to a DCI_HandleTypeDef structure that contains
 *                the configuration information for DCI
 *
 * @retval None
 */
void DAL_DCI_LineEventCallback(DCI_HandleTypeDef *hdci)
{
    
}

/**
 * @brief  VSYNC Event callback
 *
 * @param  hdci pointer to a DCI_HandleTypeDef structure that contains
 *                the configuration information for DCI
 *
 * @retval None
 */
void DAL_DCI_VsyncEventCallback(DCI_HandleTypeDef *hdci)
{
    
}

/**
 * @brief  Frame Event callback
 *
 * @param  hdci pointer to a DCI_HandleTypeDef structure that contains
 *                the configuration information for DCI
 *
 * @retval None
 */
void DAL_DCI_FrameEventCallback(DCI_HandleTypeDef *hdci)
{
    
}

/**
 * @brief  Error DCI callback
 *
 * @param  hdci pointer to a DCI_HandleTypeDef structure that contains
 *                the configuration information for DCI
 *
 * @retval None
 */
void DAL_DCI_ErrorCallback(DCI_HandleTypeDef *hdci)
{
    
}
