/**
 * @file        apm32f4xx_wwdt_cfg.c
 *
 * @brief       This file provides configuration support for WWDT
 *
 * @version     V1.0.0
 *
 * @date        2024-12-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_wwdt_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
WWDT_HandleTypeDef hwwdt;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   Initialize the WWDT MSP
 *
 * @param   hwwdt  pointer to a WWDT_HandleTypeDef structure that contains
 *                the configuration information for the specified WWDT module
 *
 * @note    When rewriting this function in user file, mechanism may be added
 *          to avoid multiple initialize when DAL_WWDT_Init function is called
 *          again to change parameters
 *
 * @retval  None
 */
void DAL_WWDT_MspInit(WWDT_HandleTypeDef *hwwdt)
{
    /* Enableperipheral clock */
    __DAL_RCM_WWDT_CLK_ENABLE();
}

/**
 * @brief   WWDT configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_WWDT_Config(void)
{
    /* WWDT TimeBase =  PCLK1 (60MHz) / 4096) / 8 = 1831Hz (~0.546ms)
       Set Window value to 80; WWDT counter should be refreshed only when the counter
       is below 80 (and greater than 64) otherwise a reset will be generated.
       Enable WWDT and set counter value to 127, WWDT timeout = ~546 us * 64 = 34.952 ms
       In this case the refresh window is: ~0.546 * (127 - 80) = 25.668ms < refresh window < ~0.546 * 64 = 34.952ms
    */
    hwwdt.Instance          = WWDT;
    hwwdt.Init.Prescaler    = WWDT_PRESCALER_8;
    hwwdt.Init.Counter      = 127U;
    hwwdt.Init.Window       = 80U;
    if (DAL_WWDT_Init(&hwwdt) != DAL_OK)
    {
        Error_Handler();
    }
}
