/**
 * @file        apm32f4xx_tmr_cfg.c
 *
 * @brief       This file provides configuration support for TMR
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_tmr_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
TMR_HandleTypeDef htmr2;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief  Initializes the TMR Base MSP
 *
 * @param  htmr TMR Base handle
 *
 * @retval None
 */
void DAL_TMR_Base_MspInit(TMR_HandleTypeDef *htmr)
{
    if (htmr->Instance == TMR2)
    {
        /* Enable peripheral clock */
        __DAL_RCM_TMR2_CLK_ENABLE();
    }
}

/**
 * @brief  DeInitializes TMR Base MSP
 *
 * @param  htmr TMR Base handle
 *
 * @retval None
 */
void DAL_TMR_Base_MspDeInit(TMR_HandleTypeDef *htmr)
{
    if (htmr->Instance == TMR2)
    {
        /* Enable peripheral clock */
        __DAL_RCM_TMR2_CLK_DISABLE();

        /* Disable peripheral interrupt */
        DAL_NVIC_DisableIRQ(TMR2_IRQn);
    }
}

/**
 * @brief   TMR2 configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_TMR2_Config(void)
{
    htmr2.Instance                  = TMR2;
    htmr2.Init.Prescaler            = 119U;
    htmr2.Init.CounterMode          = TMR_COUNTERMODE_UP;
    htmr2.Init.Period               = 0xFFFFFFFFU;
    htmr2.Init.ClockDivision        = TMR_CLOCKDIVISION_DIV1;
    htmr2.Init.RepetitionCounter    = 0U;
    htmr2.Init.AutoReloadPreload    = TMR_AUTORELOAD_PRELOAD_ENABLE;
    if (DAL_TMR_Base_Init(&htmr2) != DAL_OK)
    {
        Error_Handler();
    }
}
