/**
 * @file        apm32f4xx_tmr_cfg.c
 *
 * @brief       This file provides configuration support for TMR
 *
 * @version     V1.0.0
 *
 * @date        2024-08-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_tmr_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
TMR_HandleTypeDef htmr3;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief  Initializes the TMR Base MSP
 *
 * @param  htmr TMR Base handle
 *
 * @retval None
 */
void DAL_TMR_Base_MspInit(TMR_HandleTypeDef *htmr)
{
    if (htmr->Instance == TMR3)
    {
        /* Enable peripheral clock */
        __DAL_RCM_TMR3_CLK_ENABLE();
    }
}

/**
 * @brief  DeInitializes TMR Base MSP
 *
 * @param  htmr TMR Base handle
 *
 * @retval None
 */
void DAL_TMR_Base_MspDeInit(TMR_HandleTypeDef *htmr)
{
    if (htmr->Instance == TMR3)
    {
        /* Enable peripheral clock */
        __DAL_RCM_TMR3_CLK_DISABLE();
    }
}

/**
 * @brief   TMR3 configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_TMR3_Config(void)
{
    TMR_MasterConfigTypeDef sMasterConfig = {0};

    htmr3.Instance                  = TMR3;
    htmr3.Init.Prescaler            = 120 - 1;
    htmr3.Init.CounterMode          = TMR_COUNTERMODE_UP;
    htmr3.Init.Period               = 1000 - 1;
    htmr3.Init.ClockDivision        = TMR_CLOCKDIVISION_DIV1;
    htmr3.Init.RepetitionCounter    = 0U;
    htmr3.Init.AutoReloadPreload    = TMR_AUTORELOAD_PRELOAD_DISABLE;
    if (DAL_TMR_Base_Init(&htmr3) != DAL_OK)
    {
        Error_Handler();
    }

    sMasterConfig.MasterOutputTrigger = TMR_TRGO_UPDATE;
    sMasterConfig.MasterSlaveMode = TMR_MASTERSLAVEMODE_DISABLE;
    DAL_TMREx_MasterConfigSynchronization(&htmr3, &sMasterConfig);
}
