/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2024-08-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";

/* Private function prototypes ********************************************/
static void DAL_RTC_ShowTime(void);

/* External variables *****************************************************/
extern RTC_HandleTypeDef hrtc;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Infinite loop */
    while (1)
    {
        DAL_RTC_ShowTime();
    }
}

/**
 * @brief   Display the current time
 *
 * @param   None
 *
 * @retval  None
 */
static void DAL_RTC_ShowTime(void)
{
    RTC_TimeTypeDef Time_ConfigStruct = {0};

    static uint32_t temp = 0U;

    /* Get the RTC current Time */
    DAL_RTC_GetTime(&hrtc, &Time_ConfigStruct, RTC_FORMAT_BIN);

    if (temp != Time_ConfigStruct.Seconds)
    {
        /* Display time format : hh:mm:ss */
        LOGI(tag, "Current Time:%02d:%02d:%02d\r\n", Time_ConfigStruct.Hours, Time_ConfigStruct.Minutes, Time_ConfigStruct.Seconds);
    }

    temp = Time_ConfigStruct.Seconds;
}
