/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2024-12-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern UART_HandleTypeDef huart1;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Enable PMU clock */
    __DAL_RCM_PMU_CLK_ENABLE();
    __DAL_RCM_BAKP_CLK_ENABLE();

    /* NVIC Priority Set */
    DAL_NVIC_SetPriority(EINT0_IRQn, 0, 1);
    DAL_NVIC_SetPriority(EINT0_IRQn, 1, 1);
    DAL_NVIC_EnableIRQ(EINT0_IRQn);
    DAL_NVIC_EnableIRQ(EINT1_IRQn);
    
    LOG_Print("Press KEY1 to Enter STOP Mode\r\n");

    /* Infinite loop */
    while (1)
    {
        BOARD_LED_Toggle(LED2);
        DAL_Delay(500);
    }
}

/**
 * @brief   GPIO EINT Callback
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_GPIO_EINT_Callback(uint16_t GPIO_Pin)
{
    if (GPIO_Pin == GPIO_PIN_1)
    {
        BOARD_LED_On(LED3);
        BOARD_LED_Off(LED2);

        LOG_Print("\r\nSystem have entered STOP mode\r\n");
        LOG_Print("now, LED2 remains in the previous state\r\n");
        LOG_Print("please press KEY2 or reset System to exit STOP mode\r\n");
        /* Enter STOP Mode in WFI*/
        DAL_PMU_EnterSTOPMode(PMU_MAINREGULATOR_ON, PMU_STOPENTRY_WFI);
    }
    else if (GPIO_Pin == GPIO_PIN_0)
    {
        SystemInit();
        DAL_SysClkConfig();

        BOARD_LED_Off(LED3);

        LOG_Print("Wake up from STOP Mode\r\n");
    }
}
