/**
 * @file        apm32f4xx_int.c
 *
 * @brief       Main interrupt service routines
 *
 * @version     V1.0.0
 *
 * @date        2024-12-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_int.h"

/* Private includes *******************************************************/
#include "apm32f4xx_i2s_cfg.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

extern I2S_HandleTypeDef hi2s2;

extern uint16_t txBuffer[BUFFERSIZE];
extern uint16_t rxBuffer[BUFFERSIZE];
extern volatile uint32_t txCnt;
extern volatile uint32_t rxCnt;

/* External functions *****************************************************/

/**
 * @brief     This function handles NMI exception
 *
 * @param     None
 *
 * @retval    None
 *
 */
void NMI_Handler(void)
{
}

/**
 * @brief     This function handles Hard Fault exception
 *
 * @param     None
 *
 * @retval    None
 *
 */
void HardFault_Handler(void)
{
    /* Go to infinite loop when Hard Fault exception occurs */
    while (1)
    {
    }
}

/**
 * @brief     This function handles Memory Manage exception
 *
 * @param     None
 *
 * @retval    None
 *
 */
void MemManage_Handler(void)
{
    /* Go to infinite loop when Memory Manage exception occurs */
    while (1)
    {
    }
}

/**
 * @brief     This function handles Bus Fault exception
 *
 * @param     None
 *
 * @retval    None
 *
 */
void BusFault_Handler(void)
{
    /* Go to infinite loop when Bus Fault exception occurs */
    while (1)
    {
    }
}

/**
 * @brief     This function handles Usage Fault exception
 *
 * @param     None
 *
 * @retval    None
 *
 */
void UsageFault_Handler(void)
{
    /* Go to infinite loop when Usage Fault exception occurs */
    while (1)
    {
    }
}

/**
 * @brief     This function handles SVCall exception
 *
 * @param     None
 *
 * @retval    None
 *
 */
void SVC_Handler(void)
{
}

/**
 * @brief     This function handles Debug Monitor exception
 *
 * @param     None
 *
 * @retval    None
 *
 */
void DebugMon_Handler(void)
{
}

/**
 * @brief     This function handles PendSV_Handler exception
 *
 * @param     None
 *
 * @retval    None
 *
 */
void PendSV_Handler(void)
{
}

/**
 * @brief     This function handles SysTick request
 *
 * @param     None
 *
 * @retval    None
 *
 */
void SysTick_Handler(void)
{
    DAL_IncTick();
}

/**
 * @brief     This function handles SPI2 request
 *
 * @param     None
 *
 * @retval    None
 *
 */
void SPI2_IRQHandler(void)
{
#ifdef IS_MASTER_BOARD
    if ((hi2s2.Instance->STS & I2S_FLAG_TXE) == I2S_FLAG_TXE)
    {
        if (txCnt < BUFFERSIZE)
        {
            hi2s2.Instance->DATA = txBuffer[txCnt];
            txCnt++;
        }
        else
        {
            __DAL_I2S_DISABLE_IT(&hi2s2, (I2S_IT_TXE | I2S_IT_ERR));
        }

    }
#else
    if ((hi2s2.Instance->STS & I2S_FLAG_RXNE) == I2S_FLAG_RXNE)
    {
        uint32_t currentRxCnt = rxCnt;
        rxBuffer[currentRxCnt] = (uint16_t)hi2s2.Instance->DATA;
        currentRxCnt++;
        rxCnt = currentRxCnt; 
    }
    
    if (rxCnt == BUFFERSIZE)
    {
        __DAL_I2S_DISABLE_IT(&hi2s2, (I2S_IT_RXNE | I2S_IT_ERR));
    }
#endif
}
