/**
 * @file        apm32f4xx_dma_cfg.c
 *
 * @brief       This file provides configuration support for DMA
 *
 * @version     V1.0.0
 *
 * @date        2024-08-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_dma_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
DMA_HandleTypeDef hdma_memtomem_dma2_channel1;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   DMA configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_DMA_Config(void)
{
    __DAL_RCM_DMA2_CLK_ENABLE();

    /* Configure DMA2_Channel1 */
    hdma_memtomem_dma2_channel1.Instance = DMA2_Channel1;
    hdma_memtomem_dma2_channel1.Init.Direction = DMA_MEMORY_TO_MEMORY;
    hdma_memtomem_dma2_channel1.Init.PeriphInc = DMA_PINC_ENABLE;
    hdma_memtomem_dma2_channel1.Init.MemInc = DMA_MINC_ENABLE;
    hdma_memtomem_dma2_channel1.Init.PeriphDataAlignment = DMA_PDATAALIGN_WORD;
    hdma_memtomem_dma2_channel1.Init.MemDataAlignment = DMA_MDATAALIGN_WORD;
    hdma_memtomem_dma2_channel1.Init.Mode = DMA_NORMAL;
    hdma_memtomem_dma2_channel1.Init.Priority = DMA_PRIORITY_LOW;
    if (DAL_DMA_Init(&hdma_memtomem_dma2_channel1) != DAL_OK)
    {
        Error_Handler();
    }

    /* Enable DMA interrupt */
    DAL_NVIC_SetPriority(DMA2_Channel1_IRQn, 0U, 0U);
    DAL_NVIC_EnableIRQ(DMA2_Channel1_IRQn);
}
