/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2024-08-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"

/* Private macro **********************************************************/
#define BKP_DATA_SIZE   10

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
__IO uint8_t tamper1Event = 0;

uint32_t bkpDataReg[BKP_DATA_SIZE] = {
    RTC_BKP_DR1, RTC_BKP_DR2, RTC_BKP_DR3,
    RTC_BKP_DR4, RTC_BKP_DR5, RTC_BKP_DR6, RTC_BKP_DR7,
    RTC_BKP_DR8, RTC_BKP_DR9, RTC_BKP_DR10,
};
/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern RTC_HandleTypeDef hrtc;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    uint8_t i;

    /* Device configuration */
    DAL_DeviceConfig();

    /* Write data to backup register */
    for (i = 0; i < BKP_DATA_SIZE; i++)
    {
        DAL_RTCEx_BKUPWrite(&hrtc, bkpDataReg[i], 0x1234 + (i * 0xA5));
    }

    /* Check data is written to backup register */
    for (i = 0; i < BKP_DATA_SIZE; i++)
    {
        if (DAL_RTCEx_BKUPRead(&hrtc, bkpDataReg[i]) != (0x1234 + (i * 0xA5)))
        {
            while (1)
            {
                BOARD_LED_Toggle(LED2);
                DAL_Delay(500);
            }
        }
    }

    while (tamper1Event == 0)
    {
        BOARD_LED_Toggle(LED3);
        DAL_Delay(200);
    }

    /* Tamper event occurred */
    BOARD_LED_On(LED3);

    /* Infinite loop */
    while (1)
    {
        
    }
}


/**
  * @brief  Tamper 1 callback.
  * @param  hrtc pointer to a RTC_HandleTypeDef structure that contains
  *                the configuration information for RTC.
  * @retval None
  */
void DAL_RTCEx_Tamper1EventCallback(RTC_HandleTypeDef *hrtc)
{
    uint8_t i;

    __DAL_RTC_TAMPER_DISABLE_IT(hrtc, RTC_IT_TAMP1);

    /* Check data is cleared in backup register */
    for (i = 0; i < BKP_DATA_SIZE; i++)
    {
        if (DAL_RTCEx_BKUPRead(hrtc, bkpDataReg[i]) != 0)
        {
            while (1)
            {
                BOARD_LED_Toggle(LED2);
                DAL_Delay(500);
            }
        }
    }

    tamper1Event = 1;
}
