/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2024-08-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";

__IO uint32_t adcConvValue[1] = {0U};

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern ADC_HandleTypeDef hadc1;
extern ADC_HandleTypeDef hadc2;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Run the ADC calibration */
    if (DAL_ADCEx_Calibration_Start(&hadc1) != DAL_OK)
    {
        Error_Handler();
    }

    if (DAL_ADCEx_Calibration_Start(&hadc2) != DAL_OK)
    {
        Error_Handler();
    }

    /* Strat ADC conversation */
    if(DAL_ADC_Start(&hadc2) != DAL_OK)
    {
        Error_Handler();
    }
    
    /* Start ADC1 and ADC2 multimode conversion process and enable DMA */
    if (DAL_ADCEx_MultiModeStart_DMA(&hadc1, (uint32_t*)&adcConvValue, 1U) != DAL_OK)
    {
        Error_Handler();
    }

    /* Infinite loop */
    while (1)
    {
    }
}

/**
 * @brief  Regular conversion complete callback in non blocking mode
 *
 * @param  hadc pointer to a ADC_HandleTypeDef structure that contains
 *         the configuration information for the specified ADC
 *
 * @retval None
 */
void DAL_ADC_ConvCpltCallback(ADC_HandleTypeDef* hadc)
{
    uint16_t temp1 = 0;
    uint16_t temp2 = 0;

    temp1 = adcConvValue[0] & 0xFFFFU;
    temp2 = (adcConvValue[0] & 0xFFFF0000U) >> 16U;

    LOGI(tag, "ADC1 CH0 Value: %d mV\r\n",(temp1 * 3300U) / 4095U);
    LOGI(tag, "ADC2 CH1 Value: %d mV\r\n",(temp2 * 3300U) / 4095U);
}
