/*!
 * @file        apm32f446.h
 *
 * @brief       CMSIS Cortex-M4 Device Peripheral Access Layer Header File.
 *
 * @details     This file contains all the peripheral register's definitions, bits definitions and memory mapping
 *
 * @version     V1.0.0
 *
 * @date        2026-01-31
 *
 * @attention
 *
 *  Copyright (C) 2026 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */


/** @addtogroup APM32F445_446
  * @{
  */


#ifndef APM32F445_446_H
#define APM32F445_446_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Enum_IRQn_Type
  * @{
  */

/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */
typedef enum {
  NotAvail_IRQn             = -128,             /* Not available device specific interrupt */
/* =======================================  ARM Cortex-M4 Specific Interrupt Numbers  ====================================== */
  Reset_IRQn                = -15,              /* -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /* -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /* -13  Hard Fault, all classes of Fault                                     */
  MemoryManagement_IRQn     = -12,              /* -12  Memory Management, MPU mismatch, including Access Violation
                                                     and No Match                                                            */
  BusFault_IRQn             = -11,              /* -11  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                     related Fault                                                           */
  UsageFault_IRQn           = -10,              /* -10  Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
  SVCall_IRQn               =  -5,              /* -5 System Service Call via SVC instruction                                */
  DebugMonitor_IRQn         =  -4,              /* -4 Debug Monitor                                                          */
  PendSV_IRQn               =  -2,              /* -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /* -1 System Tick Timer                                                      */
/* =========================================  APM32F446 Specific Interrupt Numbers  =========================================== */
  DMA0_IRQn                 =   0U,              /* 0  DMA0                                                                   */
  DMA1_IRQn                 =   1U,              /* 1  DMA1                                                                   */
  DMA2_IRQn                 =   2U,              /* 2  DMA2                                                                   */
  DMA3_IRQn                 =   3U,              /* 3  DMA3                                                                   */
  DMA4_IRQn                 =   4U,              /* 4  DMA4                                                                   */
  DMA5_IRQn                 =   5U,              /* 5  DMA5                                                                   */
  DMA6_IRQn                 =   6U,              /* 6  DMA6                                                                   */
  DMA7_IRQn                 =   7U,              /* 7  DMA7                                                                   */
  DMA8_IRQn                 =   8U,              /* 8  DMA8                                                                   */
  DMA9_IRQn                 =   9U,              /* 9  DMA9                                                                   */
  DMA10_IRQn                =  10U,              /* 10 DMA10                                                                  */
  DMA11_IRQn                =  11U,              /* 11 DMA11                                                                  */
  DMA12_IRQn                =  12U,              /* 12 DMA12                                                                  */
  DMA13_IRQn                =  13U,              /* 13 DMA13                                                                  */
  DMA14_IRQn                =  14U,              /* 14 DMA14                                                                  */
  DMA15_IRQn                =  15U,              /* 15 DMA15                                                                  */
  DMA_Error_IRQn            =  16U,              /* 16 DMA_Error                                                              */
  MC_IRQn                   =  17U,              /* 17 MC                                                                     */
  FLASH_IRQn                =  18U,              /* 18 FLASH                                                                  */
  Read_Collision_IRQn       =  19U,              /* 19 Read_Collision                                                         */
  LVD_LVW_IRQn              =  20U,              /* 20 LVD_LVW                                                                */
  FLASH_Fault_IRQn          =  21U,              /* 21 FLASH_Fault                                                            */
  WDT_EWDT_IRQn             =  22U,              /* 22 WDT_EWDT                                                               */
  RMU_IRQn                  =  23U,              /* 23 RMU                                                                    */
  LPI2C_Master_IRQn         =  24U,              /* 24 LPI2C_Master                                                           */
  LPI2C_Slave_IRQn          =  25U,              /* 25 LPI2C_Slave                                                            */
  LPSPI0_IRQn               =  26U,              /* 26 LPSPI0                                                                 */
  LPSPI1_IRQn               =  27U,              /* 27 LPSPI1                                                                 */
  LPSPI2_IRQn               =  28U,              /* 28 LPSPI2                                                                 */
  LPUART0_RxTx_IRQn         =  31U,              /* 31 LPUART0_RxTx                                                           */
  LPUART1_RxTx_IRQn         =  33U,              /* 33 LPUART1_RxTx                                                           */
  LPUART2_RxTx_IRQn         =  35U,              /* 35 LPUART2_RxTx                                                           */
  ADC0_IRQn                 =  39U,              /* 39 ADC0                                                                   */
  ADC1_IRQn                 =  40U,              /* 40 ADC1                                                                   */
  COMP_IRQn                 =  41U,              /* 41 COMP                                                                   */
  EREP_single_fault_IRQn    =  44U,              /* 44 EREP_single_fault                                                      */
  EREP_double_fault_IRQn    =  45U,              /* 45 EREP_double_fault                                                      */
  RTC_IRQn                  =  46U,              /* 46 RTC                                                                    */
  RTC_Seconds_IRQn          =  47U,              /* 47 RTC_Seconds                                                            */
  LPITMR_Ch0_IRQn           =  48U,              /* 48 LPITMR_Ch0                                                             */
  LPITMR_Ch1_IRQn           =  49U,              /* 49 LPITMR_Ch1                                                             */
  LPITMR_Ch2_IRQn           =  50U,              /* 50 LPITMR_Ch2                                                             */
  LPITMR_Ch3_IRQn           =  51U,              /* 51 LPITMR_Ch3                                                             */
  PDU0_IRQn                 =  52U,              /* 52 PDU0                                                                   */
  SCG_IRQn                  =  57U,              /* 57 SCG                                                                    */
  LPTMR_IRQn                =  58U,              /* 58 LPTMR                                                                  */
  PMA_IRQn                  =  59U,              /* 59 PMA                                                                    */
  PMB_IRQn                  =  60U,              /* 60 PMB                                                                    */
  PMC_IRQn                  =  61U,              /* 61 PMC                                                                    */
  PMD_IRQn                  =  62U,              /* 62 PMD                                                                    */
  PME_IRQn                  =  63U,              /* 63 PME                                                                    */
  SWI_IRQn                  =  64U,              /* 64 SWI                                                                    */
  PDU1_IRQn                 =  68U,              /* 68 PDU1                                                                   */
  CFGIO_IRQn                =  69U,         /* 69 CFGIO                                                                 */
  CAN0_ORed_IRQn            =  78U,         /* 78 CAN0_ORed                                                           */
  CAN0_Error_IRQn           =  79U,         /* 79 CAN0_Error                                                          */
  CAN0_Wake_Up_IRQn         =  80U,         /* 80 CAN0_Wake_Up                                                        */
  CAN0_ORed_0_15_MB_IRQn    =  81U,         /* 81 CAN0_ORed_0_15_MB                                                   */
  CAN0_ORed_16_31_MB_IRQn   =  82U,         /* 82 CAN0_ORed_16_31_MB                                                  */
  CAN1_ORed_IRQn            =  85U,         /* 85 CAN1_ORed                                                           */
  CAN1_Error_IRQn           =  86U,         /* 86 CAN1_Error                                                          */
  CAN1_ORed_0_15_MB_IRQn    =  88U,         /* 88 CAN1_ORed_0_15_MB                                                   */
  CAN1_ORed_16_31_MB_IRQn   =  89U,         /* 88 CAN1_ORed_16_31_MB                                                   */
  CAN2_ORed_IRQn            =  92U,         /* 92 CAN2_ORed                                                           */
  CAN2_Error_IRQn           =  93U,         /* 93 CAN2_Error                                                          */
  CAN2_ORed_0_15_MB_IRQn    =  95U,         /* 95 CAN2_ORed_0_15_MB                                                   */
  CFGTMR0_Ch0_Ch1_IRQn        =  99U,             /* 99 CFGTMR0_Ch0_Ch1                                                           */
  CFGTMR0_Ch2_Ch3_IRQn        = 100U,             /* 100  CFGTMR0_Ch2_Ch3                                                         */
  CFGTMR0_Ch4_Ch5_IRQn        = 101U,             /* 101  CFGTMR0_Ch4_Ch5                                                         */
  CFGTMR0_Ch6_Ch7_IRQn        = 102U,             /* 102  CFGTMR0_Ch6_Ch7                                                         */
  CFGTMR0_Fault_IRQn          = 103U,             /* 103  CFGTMR0_Fault                                                           */
  CFGTMR0_Ovf_Reload_IRQn     = 104U,             /* 104  CFGTMR0_Ovf_Reload                                                      */
  CFGTMR1_Ch0_Ch1_IRQn        = 105U,             /* 105  CFGTMR1_Ch0_Ch1                                                         */
  CFGTMR1_Ch2_Ch3_IRQn        = 106U,             /* 106  CFGTMR1_Ch2_Ch3                                                         */
  CFGTMR1_Ch4_Ch5_IRQn        = 107U,             /* 107  CFGTMR1_Ch4_Ch5                                                         */
  CFGTMR1_Ch6_Ch7_IRQn        = 108U,             /* 108  CFGTMR1_Ch6_Ch7                                                         */
  CFGTMR1_Fault_IRQn          = 109U,             /* 109  CFGTMR1_Fault                                                           */
  CFGTMR1_Ovf_Reload_IRQn     = 110U,             /* 110  CFGTMR1_Ovf_Reload                                                      */
  CFGTMR2_Ch0_Ch1_IRQn        = 111U,             /* 111  CFGTMR2_Ch0_Ch1                                                         */
  CFGTMR2_Ch2_Ch3_IRQn        = 112U,             /* 112  CFGTMR2_Ch2_Ch3                                                         */
  CFGTMR2_Ch4_Ch5_IRQn        = 113U,             /* 113  CFGTMR2_Ch4_Ch5                                                         */
  CFGTMR2_Ch6_Ch7_IRQn        = 114U,             /* 114  CFGTMR2_Ch6_Ch7                                                         */
  CFGTMR2_Fault_IRQn          = 115U,             /* 115  CFGTMR2_Fault                                                           */
  CFGTMR2_Ovf_Reload_IRQn     = 116U,             /* 116  CFGTMR2_Ovf_Reload                                                      */
  CFGTMR3_Ch0_Ch1_IRQn        = 117U,             /* 117  CFGTMR3_Ch0_Ch1                                                         */
  CFGTMR3_Ch2_Ch3_IRQn        = 118U,             /* 118  CFGTMR3_Ch2_Ch3                                                         */
  CFGTMR3_Ch4_Ch5_IRQn        = 119U,             /* 119  CFGTMR3_Ch4_Ch5                                                         */
  CFGTMR3_Ch6_Ch7_IRQn        = 120U,             /* 120  CFGTMR3_Ch6_Ch7                                                         */
  CFGTMR3_Fault_IRQn          = 121U,             /* 121  CFGTMR3_Fault                                                           */
  CFGTMR3_Ovf_Reload_IRQn     = 122U,             /* 122  CFGTMR3_Ovf_Reload                                                      */
  CFGTMR4_Ch0_Ch1_IRQn        = 123u,             /**< CFGTMR4 Channel 0 and 1 interrupt                                          */
  CFGTMR4_Ch2_Ch3_IRQn        = 124u,             /**< CFGTMR4 Channel 2 and 3 interrupt                                          */
  CFGTMR4_Ch4_Ch5_IRQn        = 125u,             /**< CFGTMR4 Channel 4 and 5 interrupt                                          */
  CFGTMR4_Ch6_Ch7_IRQn        = 126u,             /**< CFGTMR4 Channel 6 and 7 interrupt                                          */
  CFGTMR4_Fault_IRQn          = 127u,             /**< CFGTMR4 Fault interrupt                                                    */
  CFGTMR4_Ovf_Reload_IRQn     = 128u,             /**< CFGTMR4 Counter overflow and Reload interrupt                              */
  CFGTMR5_Ch0_Ch1_IRQn        = 129u,             /**< CFGTMR5 Channel 0 and 1 interrupt                                          */
  CFGTMR5_Ch2_Ch3_IRQn        = 130u,             /**< CFGTMR5 Channel 2 and 3 interrupt                                          */
  CFGTMR5_Ch4_Ch5_IRQn        = 131u,             /**< CFGTMR5 Channel 4 and 5 interrupt                                          */
  CFGTMR5_Ch6_Ch7_IRQn        = 132u,             /**< CFGTMR5 Channel 6 and 7 interrupt                                          */
  CFGTMR5_Fault_IRQn          = 133u,             /**< CFGTMR5 Fault interrupt                                                    */
  CFGTMR5_Ovf_Reload_IRQn     = 134u              /**< CFGTMR5 Counter overflow and Reload interrupt                              */
} IRQn_Type;

/** @} */ /* End of group Enum_IRQn_Type */

/** @addtogroup Configuration_of_CMSIS
  * @{
  */
/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ==========================  Configuration of the ARM Cortex-M4 Processor and Core Peripherals  =========================== */
#define __CM4_REV                      1U        /* CM4 Core Revision                                                         */
#define __NVIC_PRIO_BITS               4U        /* Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0U        /* Set to 1 if different SysTick Config is used                              */
#define __MPU_PRESENT                  0U        /* MPU present                                                               */
#define __FPU_PRESENT                  1U        /* FPU present                                                               */

/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                           /* ARM Cortex-M4 processor and core peripherals                               */
#include "apm_core_cm4.h"
#include "system_apm32f445_446.h"                     /* APM32F445_446 System                                                            */

/** @addtogroup Exported_Types
  * @{
  */

#ifndef __IM
#define __IM   __I
#endif
#ifndef __OM
#define __OM   __O
#endif
#ifndef __IOM
#define __IOM  __IO
#endif
/** @} */ /* End of group Exported_Types */

/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif

/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */
/** @addtogroup Device_Peripheral_peripherals
  * @{
  */
/* =========================================================================================================================== */
/* ================                                         CSE_PRAM                                          ================ */
/* =========================================================================================================================== */

/**
  * @brief CSE_PRAM (CSE_PRAM)
  */

/** CSE_PRAM - Size of Registers Arrays */
#define CSE_PRAM_RAMn_COUNT                      32U

/** CSE_PRAM - Register Layout Typedef */
typedef struct {
  union {                                  /* offset: 0x0, array step: 0x4                                                      */
    __IO uint32_t DATA_32;                 /* CSE PRAM 0 Register..CSE PRAM 31 Register, array offset: 0x0, array step: 0x4     */
    struct {                               /* offset: 0x0, array step: 0x4                                                      */
      __IO uint8_t DATA_8LL;               /* CSE PRAM0LL register...CSE PRAM31LL register., array offset: 0x0, array step: 0x4 */
      __IO uint8_t DATA_8LU;               /* CSE PRAM0LU register...CSE PRAM31LU register., array offset: 0x1, array step: 0x4 */
      __IO uint8_t DATA_8HL;               /* CSE PRAM0HL register...CSE PRAM31HL register., array offset: 0x2, array step: 0x4 */
      __IO uint8_t DATA_8HU;               /* CSE PRAM0HU register...CSE PRAM31HU register., array offset: 0x3, array step: 0x4 */
    } ACCESS8BIT;
  } RAMn[CSE_PRAM_RAMn_COUNT];
} CSE_PRAM_T;


/* =========================================================================================================================== */
/* ================                                            AC                                             ================ */
/* =========================================================================================================================== */


/**
  * @brief Access Controller (AC)
  */

typedef struct {                                /* (@ 0x40000000) AC Structure                                               */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Master Privilege Register A                                */

    struct {
      __IM  uint32_t RESERVED0  : 16;
      __IOM uint32_t MPLCFG3    : 1;            /* [16..16] Master 3 Privilege Level Configure                               */
      __IOM uint32_t MTWA3      : 1;            /* [17..17] Master 3 Trusted For Writes                                      */
      __IOM uint32_t MTRA3      : 1;            /* [18..18] Master 3 Trusted For Read                                        */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t MPLCFG2    : 1;            /* [20..20] Master 2 Privilege Level Configure                               */
      __IOM uint32_t MTWA2      : 1;            /* [21..21] Master 2 Trusted For Writes                                      */
      __IOM uint32_t MTRA2      : 1;            /* [22..22] Master 2 Trusted For Read                                        */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t MPLCFG1    : 1;            /* [24..24] Master 1 Privilege Level Configure                               */
      __IOM uint32_t MTWA1      : 1;            /* [25..25] Master 1 Trusted for Writes                                      */
      __IOM uint32_t MTRA1      : 1;            /* [26..26] Master 1 Trusted for Read                                        */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t MPLCFG0    : 1;            /* [28..28] Master 0 Privilege Level Configure                               */
      __IOM uint32_t MTWA0      : 1;            /* [29..29] Master 0 Trusted For Writes                                      */
      __IOM uint32_t MTRA0      : 1;            /* [30..30] Master 0 Trusted For Read                                        */
      __IM  uint32_t RESERVED4  : 1;
    } bit;
  } MPRIA;
  __IM  uint32_t  RESERVED[7];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000020) Peripheral Access Control Register A                       */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t TPCFG1     : 1;            /* [24..24] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG1     : 1;            /* [25..25] Write Protect Configure                                          */
      __IOM uint32_t SPCFG1     : 1;            /* [26..26] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TPCFG0     : 1;            /* [28..28] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG0     : 1;            /* [29..29] Write Protect Configure                                          */
      __IOM uint32_t SPCFG0     : 1;            /* [30..30] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
    } bit;
  } PACCTRLA;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000024) Peripheral Access Control Register B                       */

    struct {
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t TPCFG5     : 1;            /* [8..8] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG5     : 1;            /* [9..9] Write Protect Configure                                            */
      __IOM uint32_t SPCFG5     : 1;            /* [10..10] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED1  : 13;
      __IOM uint32_t TPCFG1     : 1;            /* [24..24] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG1     : 1;            /* [25..25] Write Protect Configure                                          */
      __IOM uint32_t SPCFG1     : 1;            /* [26..26] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t TPCFG0     : 1;            /* [28..28] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG0     : 1;            /* [29..29] Write Protect Configure                                          */
      __IOM uint32_t SPCFG0     : 1;            /* [30..30] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 1;
    } bit;
  } PACCTRLB;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000002C) Peripheral Access Control Register D                       */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t TPCFG1     : 1;            /* [24..24] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG1     : 1;            /* [25..25] Write Protect Configure                                          */
      __IOM uint32_t SPCFG1     : 1;            /* [26..26] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TPCFG0     : 1;            /* [28..28] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG0     : 1;            /* [29..29] Write Protect Configure                                          */
      __IOM uint32_t SPCFG0     : 1;            /* [30..30] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
    } bit;
  } PACCTRLD;
  __IM  uint32_t  RESERVED2[4];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000040) Off-Platform Peripheral Access Control Register A          */

    struct {
      __IOM uint32_t TPCFG7     : 1;            /* [0..0] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG7     : 1;            /* [1..1] Write Protect Configure                                            */
      __IOM uint32_t SPCFG7     : 1;            /* [2..2] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t TPCFG6     : 1;            /* [4..4] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG6     : 1;            /* [5..5] Write Protect Configure                                            */
      __IOM uint32_t SPCFG6     : 1;            /* [6..6] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TPCFG5     : 1;            /* [8..8] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG5     : 1;            /* [9..9] Write Protect Configure                                            */
      __IOM uint32_t SPCFG5     : 1;            /* [10..10] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t TPCFG4     : 1;            /* [12..12] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG4     : 1;            /* [13..13] Write Protect Configure                                          */
      __IOM uint32_t SPCFG4     : 1;            /* [14..14] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 9;
      __IOM uint32_t TPCFG1     : 1;            /* [24..24] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG1     : 1;            /* [25..25] Write Protect Configure                                          */
      __IOM uint32_t SPCFG1     : 1;            /* [26..26] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED4  : 1;
      __IOM uint32_t TPCFG0     : 1;            /* [28..28] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG0     : 1;            /* [29..29] Write Protect Configure                                          */
      __IOM uint32_t SPCFG0     : 1;            /* [30..30] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED5  : 1;
    } bit;
  } OPACCTRLA;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000044) Off-Platform Peripheral Access Control Register B          */

    struct {
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t TPCFG6     : 1;            /* [4..4] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG6     : 1;            /* [5..5] Write Protect Configure                                            */
      __IOM uint32_t SPCFG6     : 1;            /* [6..6] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TPCFG5     : 1;            /* [8..8] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG5     : 1;            /* [9..9] Write Protect Configure                                            */
      __IOM uint32_t SPCFG5     : 1;            /* [10..10] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t TPCFG4     : 1;            /* [12..12] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG4     : 1;            /* [13..13] Write Protect Configure                                          */
      __IOM uint32_t SPCFG4     : 1;            /* [14..14] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t TPCFG3     : 1;            /* [16..16] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG3     : 1;            /* [17..17] Write Protect Configure                                          */
      __IOM uint32_t SPCFG3     : 1;            /* [18..18] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED4  : 13;
    } bit;
  } OPACCTRLB;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000048) Off-Platform Peripheral Access Control Register C          */

    struct {
      __IOM uint32_t TPCFG7     : 1;            /* [0..0] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG7     : 1;            /* [1..1] Write Protect Configure                                            */
      __IOM uint32_t SPCFG7     : 1;            /* [2..2] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t TPCFG6     : 1;            /* [4..4] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG6     : 1;            /* [5..5] Write Protect Configure                                            */
      __IOM uint32_t SPCFG6     : 1;            /* [6..6] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED1  : 13;
      __IOM uint32_t TPCFG2     : 1;            /* [20..20] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG2     : 1;            /* [21..21] Write Protect Configure                                          */
      __IOM uint32_t SPCFG2     : 1;            /* [22..22] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t TPCFG1     : 1;            /* [24..24] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG1     : 1;            /* [25..25] Write Protect Configure                                          */
      __IOM uint32_t SPCFG1     : 1;            /* [26..26] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 5;
    } bit;
  } OPACCTRLC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000004C) Off-Platform Peripheral Access Control Register D          */

    struct {
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t TPCFG5     : 1;            /* [8..8] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG5     : 1;            /* [9..9] Write Protect Configure                                            */
      __IOM uint32_t SPCFG5     : 1;            /* [10..10] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED1  : 5;
      __IOM uint32_t TPCFG3     : 1;            /* [16..16] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG3     : 1;            /* [17..17] Write Protect Configure                                          */
      __IOM uint32_t SPCFG3     : 1;            /* [18..18] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t TPCFG2     : 1;            /* [20..20] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG2     : 1;            /* [21..21] Write Protect Configure                                          */
      __IOM uint32_t SPCFG2     : 1;            /* [22..22] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t TPCFG1     : 1;            /* [24..24] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG1     : 1;            /* [25..25] Write Protect Configure                                          */
      __IOM uint32_t SPCFG1     : 1;            /* [26..26] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED4  : 1;
      __IOM uint32_t TPCFG0     : 1;            /* [28..28] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG0     : 1;            /* [29..29] Write Protect Configure                                          */
      __IOM uint32_t SPCFG0     : 1;            /* [30..30] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED5  : 1;
    } bit;
  } OPACCTRLD;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000050) Off-Platform Peripheral Access Control Register E          */

    struct {
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t TPCFG6     : 1;            /* [4..4] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG6     : 1;            /* [5..5] Write Protect Configure                                            */
      __IOM uint32_t SPCFG6     : 1;            /* [6..6] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED1  : 21;
      __IOM uint32_t TPCFG0     : 1;            /* [28..28] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG0     : 1;            /* [29..29] Write Protect Configure                                          */
      __IOM uint32_t SPCFG0     : 1;            /* [30..30] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
    } bit;
  } OPACCTRLE;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000054) Off-Platform Peripheral Access Control Register F         */

    struct {
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t TPCFG5     : 1;            /* [8..8] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG5     : 1;            /* [9..9] Write Protect Configure                                            */
      __IOM uint32_t SPCFG5     : 1;            /* [10..10] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TPCFG4     : 1;            /* [12..12] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG4     : 1;            /* [13..13] Write Protect Configure                                          */
      __IOM uint32_t SPCFG4     : 1;            /* [14..14] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t TPCFG3     : 1;            /* [16..16] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG3     : 1;            /* [17..17] Write Protect Configure                                          */
      __IOM uint32_t SPCFG3     : 1;            /* [18..18] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t TPCFG2     : 1;            /* [20..20] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG2     : 1;            /* [21..21] Write Protect Configure                                          */
      __IOM uint32_t SPCFG2     : 1;            /* [22..22] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED4  : 1;
      __IOM uint32_t TPCFG1     : 1;            /* [24..24] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG1     : 1;            /* [25..25] Write Protect Configure                                          */
      __IOM uint32_t SPCFG1     : 1;            /* [26..26] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED5  : 1;
      __IOM uint32_t TPCFG0     : 1;            /* [28..28] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG0     : 1;            /* [29..29] Write Protect Configure                                          */
      __IOM uint32_t SPCFG0     : 1;            /* [30..30] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED6  : 1;
    } bit;
  } OPACCTRLF;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000058) Off-Platform Peripheral Access Control Register G         */

    struct {
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t TPCFG5     : 1;            /* [8..8] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG5     : 1;            /* [9..9] Write Protect Configure                                            */
      __IOM uint32_t SPCFG5     : 1;            /* [10..10] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TPCFG4     : 1;            /* [12..12] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG4     : 1;            /* [13..13] Write Protect Configure                                          */
      __IOM uint32_t SPCFG4     : 1;            /* [14..14] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 5;
      __IOM uint32_t TPCFG2     : 1;            /* [20..20] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG2     : 1;            /* [21..21] Write Protect Configure                                          */
      __IOM uint32_t SPCFG2     : 1;            /* [22..22] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 9;
    } bit;
  } OPACCTRLG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000005C) Off-Platform Peripheral Access Control Register H          */

    struct {
      __IM  uint32_t RESERVED4  : 20;
      __IOM uint32_t TPCFG2     : 1;            /* [20..20] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG2     : 1;            /* [21..21] Write Protect Configure                                          */
      __IOM uint32_t SPCFG2     : 1;            /* [22..22] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED5  : 9;
    } bit;
  } OPACCTRLH;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000060) Off-Platform Peripheral Access Control Register I          */

    struct {
      __IOM uint32_t TPCFG7    : 1;            /* [0..0] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG7     : 1;            /* [1..1] Write Protect Configure                                            */
      __IOM uint32_t SPCFG7     : 1;            /* [2..2] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t TPCFG6     : 1;            /* [4..4] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG6     : 1;            /* [5..5] Write Protect Configure                                            */
      __IOM uint32_t SPCFG6     : 1;            /* [6..6] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TPCFG5     : 1;            /* [8..8] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG5     : 1;            /* [9..9] Write Protect Configure                                            */
      __IOM uint32_t SPCFG5     : 1;            /* [10..10] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t TPCFG4     : 1;            /* [12..12] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG4     : 1;            /* [13..13] Write Protect Configure                                          */
      __IOM uint32_t SPCFG4     : 1;            /* [14..14] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t TPCFG3     : 1;            /* [16..16] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG3     : 1;            /* [17..17] Write Protect Configure                                          */
      __IOM uint32_t SPCFG3     : 1;            /* [18..18] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED4  : 5;
      __IOM uint32_t TPCFG1     : 1;            /* [24..24] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG1     : 1;            /* [25..25] Write Protect Configure                                          */
      __IOM uint32_t SPCFG1     : 1;            /* [26..26] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED5  : 5;
    } bit;
  } OPACCTRLI;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000064) Off-Platform Peripheral Access Control Register J          */

    struct {
      __IOM uint32_t TPCFG7     : 1;            /* [0..0] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG7     : 1;            /* [1..1] Write Protect Configure                                            */
      __IOM uint32_t SPCFG7     : 1;            /* [2..2] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t TPCFG6     : 1;            /* [4..4] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG6     : 1;            /* [5..5] Write Protect Configure                                            */
      __IOM uint32_t SPCFG6     : 1;            /* [6..6] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED1  : 5;
      __IOM uint32_t TPCFG4     : 1;            /* [12..12] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG4     : 1;            /* [13..13] Write Protect Configure                                          */
      __IOM uint32_t SPCFG4     : 1;            /* [14..14] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t TPCFG3     : 1;            /* [16..16] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG3     : 1;            /* [17..17] Write Protect Configure                                          */
      __IOM uint32_t SPCFG3     : 1;            /* [18..18] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t TPCFG2     : 1;            /* [20..20] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG2     : 1;            /* [21..21] Write Protect Configure                                          */
      __IOM uint32_t SPCFG2     : 1;            /* [22..22] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED4  : 9;
    } bit;
  } OPACCTRLJ;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000068) Off-Platform Peripheral Access Control Register K          */

    struct {
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t TPCFG6     : 1;            /* [4..4] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG6     : 1;            /* [5..5] Write Protect Configure                                            */
      __IOM uint32_t SPCFG6     : 1;            /* [6..6] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED1  : 9;
      __IOM uint32_t TPCFG3     : 1;            /* [16..16] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG3     : 1;            /* [17..17] Write Protect Configure                                          */
      __IOM uint32_t SPCFG3     : 1;            /* [18..18] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 5;
      __IOM uint32_t TPCFG1     : 1;            /* [24..24] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG1     : 1;            /* [25..25] Write Protect Configure                                          */
      __IOM uint32_t SPCFG1     : 1;            /* [26..26] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t TPCFG0     : 1;            /* [28..28] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG0     : 1;            /* [29..29] Write Protect Configure                                          */
      __IOM uint32_t SPCFG0     : 1;            /* [30..30] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED4  : 1;
    } bit;
  } OPACCTRLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000006C) Off-Platform Peripheral Access Control Register L          */

    struct {
      __IOM uint32_t TPCFG7     : 1;            /* [0..0] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG7     : 1;            /* [1..1] Write Protect Configure                                            */
      __IOM uint32_t SPCFG7     : 1;            /* [2..2] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t TPCFG6     : 1;            /* [4..4] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG6     : 1;            /* [5..5] Write Protect Configure                                            */
      __IOM uint32_t SPCFG6     : 1;            /* [6..6] Supervisor Protect Configure                                       */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TPCFG5     : 1;            /* [8..8] Trusted Protect Configure                                          */
      __IOM uint32_t WPCFG5     : 1;            /* [9..9] Write Protect Configure                                            */
      __IOM uint32_t SPCFG5     : 1;            /* [10..10] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED2  : 13;
      __IOM uint32_t TPCFG1     : 1;            /* [24..24] Trusted Protect Configure                                        */
      __IOM uint32_t WPCFG1     : 1;            /* [25..25] Write Protect Configure                                          */
      __IOM uint32_t SPCFG1     : 1;            /* [26..26] Supervisor Protect Configure                                     */
      __IM  uint32_t RESERVED3  : 5;
    } bit;
  } OPACCTRLL;
} AC_T;                                      /* Size = 112 (0x70)                                                            */



/* =========================================================================================================================== */
/* ================                                            MSC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Miscellaneous System Control (MSC)
  */

typedef struct {                                /* (@ 0x40001000) MSC Structure                                              */

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000000) Processor X Type Register                                  */

    struct {
      __IM  uint32_t CPUxREV    : 8;            /* [7..0] CPUx Processor Revision                                            */
      __IM  uint32_t CPUxSEQ    : 24;           /* [31..8] CPUx Processor Specific Sequence                                  */
    } bit;
  } PCxTYPE;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000004) CPUx Logical Processor Number Register                     */

    struct {
      __IM  uint32_t CPUxLPNUM  : 1;            /* [0..0] CPUx Logical Processor Number                                      */
      __IM  uint32_t RESERVED0  : 31;
    } bit;
  } CPUxLPNUM;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000008) CPUx Physical Bus Master Number Register                   */

    struct {
      __IM  uint32_t CPUxPBMNUM : 6;            /* [5..0] CPUx Physical Bus Master Number                                    */
      __IM  uint32_t RESERVED0  : 26;
    } bit;
  } CPUxPBMNUM;

  union {
    __IM  uint32_t reg;                         /* (@ 0x0000000C) CPUx Count Register                                        */

    struct {
      __IM  uint32_t PCNT       : 2;            /* [1..0] Processor Count                                                    */
      __IM  uint32_t RESERVED0  : 30;
    } bit;
  } CPUxCNT;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000010) Processor X Information Register 0                         */

    struct {
      __IM  uint32_t DCWNUML1   : 8;            /* [7..0] Number of Level 1 Data Cache Way                                   */
      __IM  uint32_t DCSIZEL1   : 8;            /* [15..8] Level 1 Data Cache Size                                           */
      __IM  uint32_t ICWNUML1   : 8;            /* [23..16] Number of Level 1 Instruction Cache Way                          */
      __IM  uint32_t ICSIZEL1   : 8;            /* [31..24] Level 1 Instruction Cache Size                                   */
    } bit;
  } PCxINF0;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000014) Processor X Information Register 1                         */

    struct {
      __IM  uint32_t RESERVED0  : 16;
      __IM  uint32_t ICWNUML2   : 8;            /* [23..16] Number of Level 2 Instruction Cache Way                          */
      __IM  uint32_t ICSIZEL2   : 8;            /* [31..24] Level 2 Instruction Cache Size                                   */
    } bit;
  } PCxINF1;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000018) Processor X Information Register 2                         */

    struct {
      __IM  uint32_t RESERVED0  : 8;
      __IM  uint32_t TCMHSIZE   : 8;            /* [15..8] Tightly-Coupled Memory Higher Size                                */
      __IM  uint32_t RESERVED1  : 8;
      __IM  uint32_t TCMLSIZE   : 8;            /* [31..24] Tightly-Coupled Memory Lower Size                                */
    } bit;
  } PCxINF2;

  union {
    __IM  uint32_t reg;                         /* (@ 0x0000001C) Processor X Information Register 3                         */

    struct {
      __IM  uint32_t FPUFLG     : 1;            /* [0..0] Support Floating Point Unit Flag                                   */
      __IM  uint32_t ISEFLG     : 1;            /* [1..1] Support Instruction Set Extension                                  */
      __IM  uint32_t JHWFLG     : 1;            /* [2..2] Support Jazelle Hardware Flag                                      */
      __IM  uint32_t MMFLG      : 1;            /* [3..3] Support Memory Management Unit Flag                                */
      __IM  uint32_t TZFFLG     : 1;            /* [4..4] Support Trust Zone Function Flag                                   */
      __IM  uint32_t CMPHWFLG   : 1;            /* [5..5] Support Core Memory Protection Hardware Flag                       */
      __IM  uint32_t BBFLG      : 1;            /* [6..6] Support Bit Banding Flag                                           */
      __IM  uint32_t RESERVED0  : 1;
      __IM  uint32_t SYSBPNUM   : 2;            /* [9..8] Number of System Bus Ports                                         */
      __IM  uint32_t RESERVED1  : 22;
    } bit;
  } PCxINF3;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000020) Processor 0 Type Register                                  */

    struct {
      __IM  uint32_t CPU0REV    : 8;            /* [7..0] CPU0 Processor Revision                                            */
      __IM  uint32_t CPU0SEQ    : 24;           /* [31..8] CPU0 Processor Specific Sequence                                  */
    } bit;
  } PC0TYPE;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000024) CPU0 Logical Processor Number Register                     */

    struct {
      __IM  uint32_t CPU0LPNUM  : 1;            /* [0..0] Processor 0 Number                                                 */
      __IM  uint32_t RESERVED0  : 31;
    } bit;
  } CPU0LPNUM;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000028) CPU0 Physical Bus Master Number Register                   */

    struct {
      __IM  uint32_t CPU0PBMNUM : 6;            /* [5..0] CPU0 Physical Bus Master Number                                    */
      __IM  uint32_t RESERVED0  : 26;
    } bit;
  } CPU0PBNUM;

  union {
    __IM  uint32_t reg;                         /* (@ 0x0000002C) CPU0 Count Register                                        */

    struct {
      __IM  uint32_t PCNT       : 2;            /* [1..0] Processor Count                                                    */
      __IM  uint32_t RESERVED0  : 30;
    } bit;
  } CPU0CNT;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000030) Processor 0 Information Register 0                         */

    struct {
      __IM  uint32_t DCWNUML1   : 8;            /* [7..0] Number of Level 1 Data Cache Way                                   */
      __IM  uint32_t DCSIZEL1   : 8;            /* [15..8] Level 1 Data Cache Size                                           */
      __IM  uint32_t ICWNUML1   : 8;            /* [23..16] Number of Level 1 Instruction Cache Way                          */
      __IM  uint32_t ICSIZEL1   : 8;            /* [31..24] Level 1 Instruction Cache Size                                   */
    } bit;
  } PC0INF0;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000034) Processor 0 Information Register 1                         */

    struct {
      __IM  uint32_t RESERVED0  : 16;
      __IM  uint32_t ICWNUML2   : 8;            /* [23..16] Number of Level 2 Instruction Cache Way                          */
      __IM  uint32_t ICSIZEL2   : 8;            /* [31..24] Level 2 Instruction Cache Size                                   */
    } bit;
  } PC0INF1;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000038) Processor 0 Information Register 2                         */

    struct {
      __IM  uint32_t RESERVED0  : 8;
      __IM  uint32_t TCMHSIZE   : 8;            /* [15..8] Tightly-Coupled Memory Higher Size                                */
      __IM  uint32_t RESERVED1  : 8;
      __IM  uint32_t TCMLSIZE   : 8;            /* [31..24] Tightly-Coupled Memory Lower Size                                */
    } bit;
  } PC0INF2;

  union {
    __IM  uint32_t reg;                         /* (@ 0x0000003C) Processor 0 Information Register 3                         */

    struct {
      __IM  uint32_t FPUFLG     : 1;            /* [0..0] Support Floating Point Unit Flag                                   */
      __IM  uint32_t ISEFLG     : 1;            /* [1..1] Support Instruction Set Extension                                  */
      __IM  uint32_t JHWFLG     : 1;            /* [2..2] Support Jazelle Hardware Flag                                      */
      __IM  uint32_t MMFLG      : 1;            /* [3..3] Support Memory Management Unit Flag                                */
      __IM  uint32_t TZFFLG     : 1;            /* [4..4] Support Trust Zone Function Flag                                   */
      __IM  uint32_t CMPHWFLG   : 1;            /* [5..5] Support Core Memory Protection Hardware Flag                       */
      __IM  uint32_t BBFLG      : 1;            /* [6..6] Support Bit Banding Flag                                           */
      __IM  uint32_t RESERVED0  : 1;
      __IM  uint32_t SYSBPNUM   : 2;            /* [9..8] Number of System Bus Ports                                         */
      __IM  uint32_t RESERVED1  : 22;
    } bit;
  } PC0INF3;
  __IM  uint32_t  RESERVED[240];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000400) On-Chip Memory Descriptor Register 0                       */

    struct {
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t OCMCTRLF1  : 2;            /* [5..4] On-Chip Memory Control Field 1                                     */
      __IM  uint32_t RESERVED1  : 6;
      __IM  uint32_t OCMMPU     : 1;            /* [12..12] On-Chip Memory Memory Protect Unit                               */
      __IM  uint32_t OCMTYPE    : 3;            /* [15..13] On-Chip Memory Type                                              */
      __IOM uint32_t RONLY      : 1;            /* [16..16] Read-Only                                                        */
      __IM  uint32_t OCMDPWID   : 3;            /* [19..17] On-Chip Memory Datapath Width                                    */
      __IM  uint32_t RESERVED2  : 4;
      __IM  uint32_t OCMSIZE    : 4;            /* [27..24] On-Chip Memory Size                                              */
      __IM  uint32_t IFOCM      : 1;            /* [28..28] Incompletely Filled On-Chip Memory                               */
      __IM  uint32_t RESERVED3  : 2;
      __IM  uint32_t OCMVLDFLG  : 1;            /* [31..31] On-Chip Memory Valid Flag                                        */
    } bit;
  } OCMD0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000404) On-Chip Memory Descriptor Register 1                       */

    struct {
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t OCMCTRLF1  : 2;            /* [5..4] On-Chip Memory Control Field 1                                     */
      __IM  uint32_t RESERVED1  : 6;
      __IM  uint32_t OCMMPU     : 1;            /* [12..12] On-Chip Memory Memory Protect Unit                               */
      __IM  uint32_t OCMTYPE    : 3;            /* [15..13] On-Chip Memory Type                                              */
      __IOM uint32_t RONLY      : 1;            /* [16..16] Read-Only                                                        */
      __IM  uint32_t OCMDPWID   : 3;            /* [19..17] On-Chip Memory Datapath Width                                    */
      __IM  uint32_t RESERVED2  : 4;
      __IM  uint32_t OCMSIZE    : 4;            /* [27..24] On-Chip Memory Size                                              */
      __IM  uint32_t IFOCM      : 1;            /* [28..28] Incompletely Filled On-Chip Memory                               */
      __IM  uint32_t RESERVED3  : 2;
      __IM  uint32_t OCMVLDFLG  : 1;            /* [31..31] On-Chip Memory Valid Flag                                        */
    } bit;
  } OCMD1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000408) On-Chip Memory Descriptor Register2                        */

    struct {
      __IM  uint32_t RESERVED0  : 12;
      __IM  uint32_t OCMMPU     : 1;            /* [12..12] On-Chip Memory Memory Protect Unit                               */
      __IM  uint32_t OCMTYPE    : 3;            /* [15..13] On-Chip Memory Type                                              */
      __IOM uint32_t RONLY      : 1;            /* [16..16] Read-Only                                                        */
      __IM  uint32_t OCMDPWID   : 3;            /* [19..17] On-Chip Memory Datapath Width                                    */
      __IM  uint32_t RESERVED1  : 4;
      __IM  uint32_t OCMSIZE    : 4;            /* [27..24] On-Chip Memory Size                                              */
      __IM  uint32_t IFOCM      : 1;            /* [28..28] Incompletely Filled On-Chip Memory                               */
      __IM  uint32_t RESERVED2  : 2;
      __IM  uint32_t OCMVLDFLG  : 1;            /* [31..31] On-Chip Memory Valid Flag                                        */
    } bit;
  } OCMD2;
} MSC_T;                                     /* Size = 1036 (0x40c)                                                         */



/* =========================================================================================================================== */
/* ================                                            DMA                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Direct Memory Access (DMA)
  */

typedef struct {                                /* (@ 0x40008000) DMA Structure                                              */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Control Register                                           */

    struct {
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t DBGEN      : 1;            /* [1..1] Debug Enable                                                       */
      __IOM uint32_t CHASEL     : 1;            /* [2..2] Channel Arbitration Mode Select                                    */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t HALTEFLG   : 1;            /* [4..4] HALT Error Flag                                                    */
      __IOM uint32_t HALT       : 1;            /* [5..5] DMA Operations Halt                                                */
      __IOM uint32_t CLMEN      : 1;            /* [6..6] Continuous Link Mode Enable                                        */
      __IOM uint32_t MINLMEN    : 1;            /* [7..7] Minor Loop Mapping Enable                                          */
      __IM  uint32_t RESERVED2  : 8;
      __IOM uint32_t TXCNLERR   : 1;            /* [16..16] Data Transfer Cancel Error                                       */
      __IOM uint32_t TXCNL      : 1;            /* [17..17] Data Transfer Cancel                                             */
      __IM  uint32_t RESERVED3  : 13;
      __IM  uint32_t ACTFLG     : 1;            /* [31..31] DMA Active Flag                                                  */
    } bit;
  } CTRL;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000004) Error Status Register                                      */

    struct {
      __IM  uint32_t DBEFLG     : 1;            /* [0..0] Destination Bus Error Flag                                         */
      __IM  uint32_t SBEFLG     : 1;            /* [1..1] Source Bus Error Flag                                              */
      __IM  uint32_t SGCFGEFLG  : 1;            /* [2..2] Scatter/Gather Configure Error Flag                                */
      __IM  uint32_t MCCFGEFLG  : 1;            /* [3..3] MINBTCNT/CMAJICNT Configure Error Flag                             */
      __IM  uint32_t DOFCFGEFLG : 1;            /* [4..4] Destination Offset Configure Error Flag                            */
      __IM  uint32_t DADDRCFGEFLG : 1;          /* [5..5] Destination Address Configure Error Flag                           */
      __IM  uint32_t SOFCFGEFLG : 1;            /* [6..6] Source Offset Configure Error Flag                                 */
      __IM  uint32_t SADDRCFGEFLG : 1;          /* [7..7] Source Address Configure Error Flag                                */
      __IM  uint32_t ERRCHNUM   : 4;            /* [11..8] Error Channel Number                                              */
      __IM  uint32_t RESERVED0  : 2;
      __IM  uint32_t CPCFGEFLG  : 1;            /* [14..14] Channel Priority Configure Error Flag                            */
      __IM  uint32_t RESERVED1  : 1;
      __IM  uint32_t TCFLG      : 1;            /* [16..16] Transfer Canceled Flag                                           */
      __IM  uint32_t RESERVED2  : 14;
      __IM  uint32_t EEFLG      : 1;            /* [31..31] Error Exist Flag                                                 */
    } bit;
  } ESTS;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) Request Enable Register                                    */

    struct {
      __IOM uint32_t REQEN0     : 1;            /* [0..0] Channel 0 DMA Request Enable                                       */
      __IOM uint32_t REQEN1     : 1;            /* [1..1] Channel 1 DMA Request Enable                                       */
      __IOM uint32_t REQEN2     : 1;            /* [2..2] Channel 2 DMA Request Enable                                       */
      __IOM uint32_t REQEN3     : 1;            /* [3..3] Channel 3 DMA Request Enable                                       */
      __IOM uint32_t REQEN4     : 1;            /* [4..4] Channel 4 DMA Request Enable                                       */
      __IOM uint32_t REQEN5     : 1;            /* [5..5] Channel 5 DMA Request Enable                                       */
      __IOM uint32_t REQEN6     : 1;            /* [6..6] Channel 6 DMA Request Enable                                       */
      __IOM uint32_t REQEN7     : 1;            /* [7..7] Channel 7 DMA Request Enable                                       */
      __IOM uint32_t REQEN8     : 1;            /* [8..8] Channel 8 DMA Request Enable                                       */
      __IOM uint32_t REQEN9     : 1;            /* [9..9] Channel 9 DMA Request Enable                                       */
      __IOM uint32_t REQEN10    : 1;            /* [10..10] Channel 10 DMA Request Enable                                    */
      __IOM uint32_t REQEN11    : 1;            /* [11..11] Channel 11 DMA Request Enable                                    */
      __IOM uint32_t REQEN12    : 1;            /* [12..12] Channel 12 DMA Request Enable                                    */
      __IOM uint32_t REQEN13    : 1;            /* [13..13] Channel 13 DMA Request Enable                                    */
      __IOM uint32_t REQEN14    : 1;            /* [14..14] Channel 14 DMA Request Enable                                    */
      __IOM uint32_t REQEN15    : 1;            /* [15..15] Channel 15 DMA Request Enable                                    */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } REQEN;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000014) Error Interrupt Enable Register                            */

    struct {
      __IOM uint32_t EIEN0      : 1;            /* [0..0] Error Interrupt Channel 0 Enable                                   */
      __IOM uint32_t EIEN1      : 1;            /* [1..1] Error Interrupt Channel 1 Enable                                   */
      __IOM uint32_t EIEN2      : 1;            /* [2..2] Channel 2 Error Interrupt Enable                                   */
      __IOM uint32_t EIEN3      : 1;            /* [3..3] Channel 3 Error Interrupt Enable                                   */
      __IOM uint32_t EIEN4      : 1;            /* [4..4] Channel 4 Error Interrupt Enable                                   */
      __IOM uint32_t EIEN5      : 1;            /* [5..5] Channel 5 Error Interrupt Enable                                   */
      __IOM uint32_t EIEN6      : 1;            /* [6..6] Channel 6 Error Interrupt Enable                                   */
      __IOM uint32_t EIEN7      : 1;            /* [7..7] Channel 7 Error Interrupt Enable                                   */
      __IOM uint32_t EIEN8      : 1;            /* [8..8] Channel 8 Error Interrupt Enable                                   */
      __IOM uint32_t EIEN9      : 1;            /* [9..9] Channel 9 Error Interrupt Enable                                   */
      __IOM uint32_t EIEN10     : 1;            /* [10..10] Channel 10 Error Interrupt Enable                                */
      __IOM uint32_t EIEN11     : 1;            /* [11..11] Channel 11 Error Interrupt Enable                                */
      __IOM uint32_t EIEN12     : 1;            /* [12..12] Channel 12 Error Interrupt Enable                                */
      __IOM uint32_t EIEN13     : 1;            /* [13..13] Channel 13 Error Interrupt Enable                                */
      __IOM uint32_t EIEN14     : 1;            /* [14..14] Channel 14 Error Interrupt Enable                                */
      __IOM uint32_t EIEN15     : 1;            /* [15..15] Channel 15 Error Interrupt Enable                                */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } EIEN;

  union {
    __OM  uint8_t reg;                          /* (@ 0x00000018) Error Interrupt Enable Clear Register                      */

    struct {
      __OM  uint8_t EIENCLR     : 4;            /* [3..0] Channel Error Interrupt Enable Bit Clear                           */
            uint8_t             : 2;
      __OM  uint8_t AEIENCLR    : 1;            /* [6..6] All Channel Error Interrupt Bits Clear                             */
      __OM  uint8_t NOOP        : 1;            /* [7..7] No Operation                                                       */
    } bit;
  } EIENCLR;

  union {
    __OM  uint8_t reg;                          /* (@ 0x00000019) Error Interrupt Enable Set Register                        */

    struct {
      __OM  uint8_t EIENSET     : 4;            /* [3..0] Channel Error Interrupt Enable Bit Set                             */
            uint8_t             : 2;
      __OM  uint8_t AEIENSET    : 1;            /* [6..6] All Channel Error Interrupt Bits Set                               */
      __OM  uint8_t NOOP        : 1;            /* [7..7] No Operation                                                       */
    } bit;
  } EIENSET;

  union {
    __OM  uint8_t reg;                          /* (@ 0x0000001A) Request Enable Clear Register                              */

    struct {
      __OM  uint8_t REQENCLR    : 4;            /* [3..0] DMA Request Enable Clear                                           */
            uint8_t             : 2;
      __OM  uint8_t AREQENCLR   : 1;            /* [6..6] All DMA Requests Enable Clear                                      */
      __OM  uint8_t NOOP        : 1;            /* [7..7] No Operation                                                       */
    } bit;
  } REQENCLR;

  union {
    __OM  uint8_t reg;                          /* (@ 0x0000001B) Request Enable Set Register                                */

    struct {
      __OM  uint8_t REQENSET    : 4;            /* [3..0] DMA Request Enable Setup                                           */
            uint8_t             : 2;
      __OM  uint8_t AREQENSET   : 1;            /* [6..6] ALL DMA Requests Enable Set                                        */
      __OM  uint8_t NOOP        : 1;            /* [7..7] No Operation                                                       */
    } bit;
  } REQENSET;

  union {
    __OM  uint8_t reg;                          /* (@ 0x0000001C) DONE Status Clear Register                                 */

    struct {
      __OM  uint8_t DNECLR      : 4;            /* [3..0] DONE Field Clear                                                   */
            uint8_t             : 2;
      __OM  uint8_t ADNECLR     : 1;            /* [6..6] All DONE Field Clear                                               */
      __OM  uint8_t NOOP        : 1;            /* [7..7] No Operation                                                       */
    } bit;
  } DNESTSCLR;

  union {
    __OM  uint8_t reg;                          /* (@ 0x0000001D) START Set Register                                         */

    struct {
      __OM  uint8_t STATSET     : 4;            /* [3..0] START Field Set                                                    */
            uint8_t             : 2;
      __OM  uint8_t ASTATSET    : 1;            /* [6..6] All START Field Setup                                              */
      __OM  uint8_t NOOP        : 1;            /* [7..7] No Operation                                                       */
    } bit;
  } STATSET;

  union {
    __OM  uint8_t reg;                          /* (@ 0x0000001E) Error Status Clear Register                                */

    struct {
      __OM  uint8_t EFLGCLR     : 4;            /* [3..0] Error Flag Clear                                                   */
            uint8_t             : 2;
      __OM  uint8_t AEFLGCLR    : 1;            /* [6..6] All Error Flag Clear                                               */
      __OM  uint8_t NOOP        : 1;            /* [7..7] No Operation                                                       */
    } bit;
  } ESTSCLR;

  union {
    __OM  uint8_t reg;                          /* (@ 0x0000001F) Interrupt Request Clear Register                           */

    struct {
      __OM  uint8_t INTREQCLR   : 4;            /* [3..0] Interrupt Request Clear                                            */
            uint8_t             : 2;
      __OM  uint8_t AINTREQCLR  : 1;            /* [6..6] All Interrupt Request Clear                                        */
      __OM  uint8_t NOOP        : 1;            /* [7..7] No Operation                                                       */
    } bit;
  } INTREQCLR;
  __IM  uint32_t  RESERVED2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000024) Interrupt Request Register                                 */

    struct {
      __IOM uint32_t INTREQSTS0 : 1;            /* [0..0] Interrupt Request 0 Status                                         */
      __IOM uint32_t INTREQSTS1 : 1;            /* [1..1] Interrupt Request 1 Status                                         */
      __IOM uint32_t INTREQSTS2 : 1;            /* [2..2] Interrupt Request 2 Status                                         */
      __IOM uint32_t INTREQSTS3 : 1;            /* [3..3] Interrupt Request 3 Status                                         */
      __IOM uint32_t INTREQSTS4 : 1;            /* [4..4] Interrupt Request 4 Status                                         */
      __IOM uint32_t INTREQSTS5 : 1;            /* [5..5] Interrupt Request 5 Status                                         */
      __IOM uint32_t INTREQSTS6 : 1;            /* [6..6] Interrupt Request 6 Status                                         */
      __IOM uint32_t INTREQSTS7 : 1;            /* [7..7] Interrupt Request 7 Status                                         */
      __IOM uint32_t INTREQSTS8 : 1;            /* [8..8] Interrupt Request 8 Status                                         */
      __IOM uint32_t INTREQSTS9 : 1;            /* [9..9] Interrupt Request 9 Status                                         */
      __IOM uint32_t INTREQSTS10 : 1;           /* [10..10] Interrupt Request 10 Status                                      */
      __IOM uint32_t INTREQSTS11 : 1;           /* [11..11] Interrupt Request 11 Status                                      */
      __IOM uint32_t INTREQSTS12 : 1;           /* [12..12] Interrupt Request 12 Status                                      */
      __IOM uint32_t INTREQSTS13 : 1;           /* [13..13] Interrupt Request 13 Status                                      */
      __IOM uint32_t INTREQSTS14 : 1;           /* [14..14] Interrupt Request 14 Status                                      */
      __IOM uint32_t INTREQSTS15 : 1;           /* [15..15] Interrupt Request 15 Status                                      */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } INTREQ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000002C) Channel Error Status Register                              */

    struct {
      __IOM uint32_t EFLG0      : 1;            /* [0..0] Error In Channel 0 Flag                                            */
      __IOM uint32_t EFLG1      : 1;            /* [1..1] Error In Channel 1 Flag                                            */
      __IOM uint32_t EFLG2      : 1;            /* [2..2] Error In Channel 2 Flag                                            */
      __IOM uint32_t EFLG3      : 1;            /* [3..3] Error In Channel 3 Flag                                            */
      __IOM uint32_t EFLG4      : 1;            /* [4..4] Error In Channel 4 Flag                                            */
      __IOM uint32_t EFLG5      : 1;            /* [5..5] Error In Channel 5 Flag                                            */
      __IOM uint32_t EFLG6      : 1;            /* [6..6] Error In Channel 6 Flag                                            */
      __IOM uint32_t EFLG7      : 1;            /* [7..7] Error In Channel 7 Flag                                            */
      __IOM uint32_t EFLG8      : 1;            /* [8..8] Error In Channel 8 Flag                                            */
      __IOM uint32_t EFLG9      : 1;            /* [9..9] Error In Channel 9 Flag                                            */
      __IOM uint32_t EFLG10     : 1;            /* [10..10] Error In Channel 10 Flag                                         */
      __IOM uint32_t EFLG11     : 1;            /* [11..11] Error In Channel 11 Flag                                         */
      __IOM uint32_t EFLG12     : 1;            /* [12..12] Error In Channel 12 Flag                                         */
      __IOM uint32_t EFLG13     : 1;            /* [13..13] Error In Channel 13 Flag                                         */
      __IOM uint32_t EFLG14     : 1;            /* [14..14] Error In Channel 14 Flag                                         */
      __IOM uint32_t EFLG15     : 1;            /* [15..15] Error In Channel 15 Flag                                         */
      __IM  uint32_t RESERVED1  : 16;
    } bit;
  } CHESTS;
  __IM  uint32_t  RESERVED4;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000034) Hardware Request Status Register                           */

    struct {
      __IM  uint32_t HREQSTS0   : 1;            /* [0..0] Hardware Request Channel 0 Status                                  */
      __IM  uint32_t HREQSTS1   : 1;            /* [1..1] Hardware Request Channel 1 Status                                  */
      __IM  uint32_t HREQSTS2   : 1;            /* [2..2] Hardware Request Channel 2 Status                                  */
      __IM  uint32_t HREQSTS3   : 1;            /* [3..3] Hardware Request Channel 3 Status                                  */
      __IM  uint32_t HREQSTS4   : 1;            /* [4..4] Hardware Request Channel 4 Status                                  */
      __IM  uint32_t HREQSTS5   : 1;            /* [5..5] Hardware Request Channel 5 Status                                  */
      __IM  uint32_t HREQSTS6   : 1;            /* [6..6] Hardware Request Channel 6 Status                                  */
      __IM  uint32_t HREQSTS7   : 1;            /* [7..7] Hardware Request Channel 7 Status                                  */
      __IM  uint32_t HREQSTS8   : 1;            /* [8..8] Hardware Request Channel 8 Status                                  */
      __IM  uint32_t HREQSTS9   : 1;            /* [9..9] Hardware Request Channel 9 Status                                  */
      __IM  uint32_t HREQSTS10  : 1;            /* [10..10] Hardware Request Channel 10 Status                               */
      __IM  uint32_t HREQSTS11  : 1;            /* [11..11] Hardware Request Channel 11 Status                               */
      __IM  uint32_t HREQSTS12  : 1;            /* [12..12] Hardware Request Channel 12 Status                               */
      __IM  uint32_t HREQSTS13  : 1;            /* [13..13] Hardware Request Channel 13 Status                               */
      __IM  uint32_t HREQSTS14  : 1;            /* [14..14] Hardware Request Channel 14 Status                               */
      __IM  uint32_t HREQSTS15  : 1;            /* [15..15] Hardware Request Channel 15 Status                               */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } HWREQSTS;
  __IM  uint32_t  RESERVED5[3];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000044) Asynchronous Request in Stop Enable Register               */

    struct {
      __IOM uint32_t AREQSEN0   : 1;            /* [0..0] Asynchronous DMA Request Channel 0 in Stop Mode Enable             */
      __IOM uint32_t AREQSEN1   : 1;            /* [1..1] Asynchronous DMA Request Channel 1 in Stop Mode Enable             */
      __IOM uint32_t AREQSEN2   : 1;            /* [2..2] Asynchronous DMA Request Channel 2 in Stop Mode Enable             */
      __IOM uint32_t AREQSEN3   : 1;            /* [3..3] Asynchronous DMA Request Channel 3 in Stop Mode Enable             */
      __IOM uint32_t AREQSEN4   : 1;            /* [4..4] Asynchronous DMA Request Channel 4 in Stop Mode Enable             */
      __IOM uint32_t AREQSEN5   : 1;            /* [5..5] Asynchronous DMA Request Channel 5 in Stop Mode Enable             */
      __IOM uint32_t AREQSEN6   : 1;            /* [6..6] Asynchronous DMA Request Channel 6 in Stop Mode Enable             */
      __IOM uint32_t AREQSEN7   : 1;            /* [7..7] Asynchronous DMA Request Channel 7 in Stop Mode Enable             */
      __IOM uint32_t AREQSEN8   : 1;            /* [8..8] Asynchronous DMA Request Channel 8 in Stop Mode Enable             */
      __IOM uint32_t AREQSEN9   : 1;            /* [9..9] Asynchronous DMA Request Channel 9 in Stop Mode Enable             */
      __IOM uint32_t AREQSEN10  : 1;            /* [10..10] Asynchronous DMA Request Channel 10 in Stop Mode Enable          */
      __IOM uint32_t AREQSEN11  : 1;            /* [11..11] Asynchronous DMA Request Channel 11 in Stop Mode Enable          */
      __IOM uint32_t AREQSEN12  : 1;            /* [12..12] Asynchronous DMA Request Channel 12 in Stop Mode Enable          */
      __IOM uint32_t AREQSEN13  : 1;            /* [13..13] Asynchronous DMA Request Channel 13 in Stop Mode Enable          */
      __IOM uint32_t AREQSEN14  : 1;            /* [14..14] Asynchronous DMA Request Channel 14 in Stop Mode Enable          */
      __IOM uint32_t AREQSEN15 : 1;            /* [15..15] Asynchronous DMA Request Channel 15 in Stop Mode Enable          */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } AREQSEN;
  __IM  uint32_t  RESERVED6[46];

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000100) Channel 3 Priority Register                                */

    struct {
      __IOM uint8_t CHPRIA      : 4;            /* [3..0] Channel n Priority Arbitration                                     */
            uint8_t             : 2;
      __IOM uint8_t PLPRICHD    : 1;            /* [6..6] Preemption of Other Lower Priority Channel Disable                 */
      __IOM uint8_t BPHPRICHEN  : 1;            /* [7..7] being Preempted by Other Higher Channel Enable                     */
    } bit;
  } CHPRI[16];
  __IM  uint32_t  RESERVED7[956];

  struct {
    union {
      __IOM uint32_t reg;                         /* (@ 0x00001000) TCD Source Address                                       */

      struct {
        __IOM uint32_t SADDR      : 32;           /* [31..0] Source Data Address                                             */
      } bit;
    } SADDR;

    union {
      __IOM uint16_t reg;                         /* (@ 0x00001004) TCD Signed Source Address Offset                          */

      struct {
        __IOM uint16_t SADDROF    : 16;           /* [15..0] Source Address Signed Offset                                     */
      } bit;
    } SADDROF;

    union {
      __IOM uint16_t reg;                         /* (@ 0x00001006) TCD Transfer Attributes                                   */

      struct {
        __IOM uint16_t DTSIZE     : 3;            /* [2..0] Destination Data Transfer Size                                     */
        __IOM uint16_t DADDRMV    : 5;            /* [7..3] Destination Address Modulo Value                                   */
        __IOM uint16_t STSIZE     : 3;            /* [10..8] Source Data Transfer Size                                         */
        __IOM uint16_t SADDRMV    : 5;            /* [15..11] Source Address Modulo Value                                      */
      } bit;
    } TATT;

    union {
      union {
        __IOM uint32_t reg;                       /* (@ 0x00001008) TCD Minor Byte Transfer Count (Minor Loop Mapping
                                                                      Disabled) Register                                       */

        struct {
          __IOM uint32_t MINBTCNT : 32;           /* [31..0] Minor Byte Number Transfer Count                                  */
        } bit;
      } MINBCNT_MINLMD;

      union {
        __IOM uint32_t reg;                       /* (@ 0x00001008) TCD Signed Minor Loop Offset (Minor Loop Mapping
                                                                      Enabled and Offset Disabled) Register                    */

        struct {
          __IOM uint32_t MINBTCNT : 30;           /* [29..0] Minor Byte Number Transfer Count                                  */
          __IOM uint32_t DMINLOFEN : 1;           /* [30..30] Destination Address Minor Loop Offset Enable                     */
          __IOM uint32_t SMINLOFEN : 1;           /* [31..31] Source Address Minor Loop Offset Enable                          */
        } bit;
      } SMLOF_MINLMENOFD;

      union {
        __IOM uint32_t reg;                       /* (@ 0x00001008) TCD Signed Minor Loop Offset (Minor Loop Mapping
                                                                      and Offset Enabled) Register                             */

        struct {
          __IOM uint32_t MINBTCNT : 10;           /* [9..0] Minor Byte Number Transfer Count                                   */
          __IOM uint32_t MINSELOF : 20;           /* [29..10] Minor Loop Sign-extended Offset                                  */
          __IOM uint32_t DMINLOFEN : 1;           /* [30..30] Destination Address Minor Loop Offset Enable                     */
          __IOM uint32_t SMINLOFEN : 1;           /* [31..31] Source Address Minor Loop Offset Enable                          */
        } bit;
      } SMINLOF_MINLMOFEN;
    } MINBTCNT;

    union {
      __IOM uint32_t reg;                         /* (@ 0x0000100C) TCD Last Source Address Adjustment                        */

      struct {
        __IOM uint32_t SADDRAV    : 32;           /* [31..0] Source Address Adjustment Value                                   */
      } bit;
    } SADDRAV;

    union {
      __IOM uint32_t reg;                         /* (@ 0x00001010) TCD Destination Address                                   */

      struct {
        __IOM uint32_t DADDR      : 32;           /* [31..0] Destination Address                                              */
      } bit;
    } DADDR;

    union {
      __IOM uint16_t reg;                         /* (@ 0x00001014) TCD Signed Destination Address Offset                     */

      struct {
        __IOM uint16_t DADDRSOF   : 16;           /* [15..0] Destination Address Signed Offset                                */
      } bit;
    } DADDRSOF;

    union {
      union {
        __IOM uint16_t reg;                       /* (@ 0x00001016) TCD Current Major Iteration Count (Channel Linking
                                                                      Disabled) Register                                       */

        struct {
          __IOM uint16_t CMAJICNT : 15;           /* [14..0] Current Major Iteration Count                                     */
          __IOM uint16_t LINKEN   : 1;            /* [15..15] Channel-to-channel Linking Enable                                */
        } bit;
      } LINKD;

      union {
        __IOM uint16_t reg;                       /* (@ 0x00001016) TCD Current Major Iteration Count (Channel Linking
                                                                      Enabled) Register                                        */

        struct {
          __IOM uint16_t CMAJICNT  : 9;            /* [8..0] Current Major Iteration Count                                      */
          __IOM uint16_t MINLINKCH : 4;            /* [12..9] Minor Loop Link Channel Number                                    */
                uint16_t           : 2;
          __IOM uint16_t LINKEN    : 1;            /* [15..15] Channel-to-channel Linking Enable                                */
        } bit;
      } LINKEN;
    } CMAJICNT;

    union {
      __IOM uint32_t reg;                         /* (@ 0x00001018) TCD Destination Address Adjustment Value or
                                                                      SG next TCD Address Register                             */

      struct {
        __IOM uint32_t DADDRAVSGA : 32;           /* [31..0] Destination Address Adjustment Value or SG next TCD
                                                       Address                                                                 */
      } bit;
    } DADDRAVSGA;

    union {
      __IOM uint16_t reg;                         /* (@ 0x0000101C) TCD Control and Status Register                            */

      struct {
        __IOM uint16_t START      : 1;            /* [0..0] Channel Start                                                      */
        __IOM uint16_t MAJICMPIEN : 1;            /* [1..1] Major Iteration Count Complete Interrupt Enable                    */
        __IOM uint16_t MAJIHCMPIEN : 1;           /* [2..2] Major Iteration Counter Half Complete Interrupt Enable             */
        __IOM uint16_t DMAREQD    : 1;            /* [3..3] DMA Request Disable                                                */
        __IOM uint16_t SGFEN      : 1;            /* [4..4] Scatter Gather Format Enable                                       */
        __IOM uint16_t MAJILINKEN : 1;            /* [5..5] Major Iteration Channel-to-channel Linking Enable                  */
        __IOM uint16_t ACTFLG     : 1;            /* [6..6] Channel Active Flag Flag Flag                                      */
        __IOM uint16_t MAJLCMPFLG : 1;            /* [7..7] Major Loop Complete Flag                                           */
        __IOM uint16_t MAJLINKCH  : 4;            /* [11..8] Major Loop Link Channel Number                                    */
              uint16_t            : 2;
        __IOM uint16_t BWCTRL     : 2;            /* [15..14] DMA Bandwidth Control                                            */
      } bit;
    } CSTS;

    union {
      union {
        __IOM uint16_t reg;                       /* (@ 0x0000101E) TCD Major Iteration Count Start(Channel Linking
                                                                      Disabled) Register                                       */

        struct {
          __IOM uint16_t MAJICSTAT : 15;          /* [14..0] Major Iteration Count Start                                       */
          __IOM uint16_t LINKEN    : 1;           /* [15..15] Channel-to-channel Linking Enable                                */
        } bit;
      } LINKD;

      union {
        __IOM uint16_t reg;                       /* (@ 0x0000101E) TCD Major Iteration Count Start (Channel Linking
                                                                      Enabled) Register                                        */

        struct {
          __IOM uint16_t MAJICSTAT : 9;           /* [8..0] Major Iteration Count Start                                        */
          __IOM uint16_t MINLINKCH : 4;           /* [12..9] Minor Loop Link Channel Number                                    */
                uint16_t           : 2;
          __IOM uint16_t LINKEN    : 1;           /* [15..15] Channel-to-channel Linking Enable                                */
        } bit;
      } LINKEN;
    } MAJICNTSTAT;
  } TCD[16u];
} DMA_T;                                     /* Size = 4608 (0x1200)                                                           */



/* =========================================================================================================================== */
/* ================                                            MPU                                            ================ */
/* =========================================================================================================================== */

/** MPU - Size of Registers Arrays */
#define MPU_EADDR_EDETAIL_COUNT                   4U
#define MPU_REGD_COUNT                            8U
#define MPU_RDAACC_COUNT                          8U

/**
  * @brief Memory protection (MPU)
  */

typedef struct {                                /* (@ 0x4000D000) MPU Structure                                              */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Control/Error Status Register                              */

    struct {
      __IOM uint32_t MPUEN      : 1;            /* [0..0] MPU Global Enable                                                  */
      __IM  uint32_t RESERVED0  : 7;
      __IM  uint32_t RDINUM     : 4;            /* [11..8] Region Descriptors Number                                         */
      __IM  uint32_t SPCNUM     : 4;            /* [15..12] Slave Ports Connected Number                                     */
      __IM  uint32_t HWDRL      : 4;            /* [19..16] Hardware and Definition Revision Level                           */
      __IM  uint32_t RESERVED1  : 8;
      __IOM uint32_t SPEFLG3    : 1;            /* [28..28] Slave Port 3 Error Occurred Flag                                 */
      __IOM uint32_t SPEFLG2    : 1;            /* [29..29] Slave Port 2 Error Occurred Flag                                 */
      __IOM uint32_t SPEFLG1    : 1;            /* [30..30] Slave Port 2 Error Occurred Flag                                 */
      __IOM uint32_t SPEFLG0    : 1;            /* [31..31] Slave Port 2 Error Occurred Flag                                 */
    } bit;
  } CESTS;
  __IM  uint32_t  RESERVED[3];

  struct {
    union {
      __IM  uint32_t reg;                         /* (@ 0x00000010) Error Address Register, slave port 0                     */

      struct {
        __IM  uint32_t SACCEADDR  : 32;           /* [31..0] Error Address                                                   */
      } bit;
    } EADDR;

    union {
      __IM  uint32_t reg;                         /* (@ 0x00000014) Error Detail Register, slave port 0                      */

      struct {
        __IM  uint32_t RWE        : 1;            /* [0..0] Read/Write Error                                                   */
        __IM  uint32_t AINFOE     : 3;            /* [3..1] Attribute Information of Error                                     */
        __IM  uint32_t MNUME      : 4;            /* [7..4] Master Number of Error                                             */
        __IM  uint32_t PIDE       : 8;            /* [15..8] Process Identification of Error                                   */
        __IM  uint32_t RDACCE     : 16;           /* [31..16] Region Descriptor with the Access Error                          */
      } bit;
    } EDETAIL;
  } EADDR_EDETAIL[MPU_EADDR_EDETAIL_COUNT];
  __IM  uint32_t  RESERVED1[244];

  struct {
    union {
      __IOM uint32_t reg;                         /* (@ 0x00000400) Region Descriptor n, Word Register 0                                */

      struct {
        __IM  uint32_t RESERVED0  : 5;
        __IOM uint32_t SADDR      : 27;           /* [31..5] Start Address of the Memory Region                                */
      } bit;
    } WORD0;

    union {
      __IOM uint32_t reg;                         /* (@ 0x00000404) Region Descriptor n, Word Register 1                                */

      struct {
        __IM  uint32_t RESERVED0  : 5;
        __IOM uint32_t ENDADDR    : 27;           /* [31..5] End Address of the Memory Region                                  */
      } bit;
    } WORD1;

    union {
      __IOM uint32_t reg;                         /* (@ 0x00000408) Region Descriptor n, Word Register 2                                */

      struct {
        __IOM uint32_t UMCTRLM0   : 3;            /* [2..0] Bus Master 0 User Mode Access Control                              */
        __IOM uint32_t SMCTRLM0   : 2;            /* [4..3] Bus Master 0 Supervisor Mode Access Control                        */
        __IOM uint32_t PIDENM0    : 1;            /* [5..5] Bus Master 0 Process Identifier enable                             */
        __IOM uint32_t UMCTRLM1   : 3;            /* [8..6] Bus Master 1 User Mode Access Control                              */
        __IOM uint32_t SMCTRLM1   : 2;            /* [10..9] Bus Master 1 Supervisor Mode Access Control                       */
        __IOM uint32_t PIDENM1    : 1;            /* [11..11] Bus Master 1 Process Identifier enable                           */
        __IOM uint32_t UMCTRLM2   : 3;            /* [14..12] Bus Master 2 User Mode Access control                            */
        __IOM uint32_t SMCTRLM2   : 2;            /* [16..15] Bus Master 2 Supervisor Mode Access Control                      */
        __IM  uint32_t RESERVED0  : 1;
        __IOM uint32_t UMCTRLM3   : 3;            /* [20..18] Bus Master 3 User Mode Access Control                            */
        __IOM uint32_t SMCTRLM3   : 2;            /* [22..21] Bus Master 3 Supervisor Mode Access Control                      */
        __IM  uint32_t RESERVED1  : 1;
        __IOM uint32_t WENM4      : 1;            /* [24..24] Bus Master 4 Write Enable                                        */
        __IOM uint32_t RENM4      : 1;            /* [25..25] Bus Master 4 Read Enable                                         */
        __IOM uint32_t WENM5      : 1;            /* [26..26] Bus Master 5 Write Enable                                        */
        __IOM uint32_t RENM5      : 1;            /* [27..27] Bus Master 5 Read Enable                                         */
        __IOM uint32_t WENM6      : 1;            /* [28..28] Bus Master 6 Write Enable                                        */
        __IOM uint32_t RENM6      : 1;            /* [29..29] Bus Master 6 Read Enable                                         */
        __IOM uint32_t WENM7      : 1;            /* [30..30] Bus Master 7 Write Enable                                        */
        __IOM uint32_t RENM7      : 1;            /* [31..31] Bus Master 7 Read Enable                                         */
      } bit;
    } WORD2;

    union {
      __IOM uint32_t reg;                         /* (@ 0x0000040C) Region Descriptor n, Word Register 3                                */

      struct {
        __IOM uint32_t RDVALID    : 1;            /* [0..0] Region Descriptor Valid                                            */
        __IM  uint32_t RESERVED0  : 15;
        __IOM uint32_t PIDMASK    : 8;            /* [23..16] Process Identifier Mask                                          */
        __IOM uint32_t PID        : 8;            /* [31..24] Process Identifier                                               */
      } bit;
    } WORD3;
  } REGD[MPU_REGD_COUNT];
  __IM  uint32_t  RESERVED2[224];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000800) Region Descriptor Alternate Access Control 0               */

    struct {
      __IOM uint32_t UMCTRLM0   : 3;            /* [2..0] Bus Master 0 User Mode Access Control                              */
      __IOM uint32_t SMCTRLM0   : 2;            /* [4..3] Bus Master 0 Supervisor Mode Access Control                        */
      __IOM uint32_t PIDENM0    : 1;            /* [5..5] Bus Master 0 Process Identifier Enable                             */
      __IOM uint32_t UMCTRLM1   : 3;            /* [8..6] Bus Master 1 User Mode Access Control                              */
      __IOM uint32_t SMCTRLM1   : 2;            /* [10..9] Bus Master 1 Supervisor Mode Access Control                       */
      __IOM uint32_t PIDENM1    : 1;            /* [11..11] Bus Master 1 Process Identifier Enable                           */
      __IOM uint32_t UMCTRLM2   : 3;            /* [14..12] Bus Master 2 User Mode Access Control                            */
      __IOM uint32_t SMCTRLM2   : 2;            /* [16..15] Bus Master 2 Supervisor Mode Access Control                      */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t UMCTRLM3   : 3;            /* [20..18] Bus Master 3 User Mode Access Control                            */
      __IOM uint32_t SMCTRLM3   : 2;            /* [22..21] Bus Master 3 Supervisor Mode Access Control                      */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t WENM4      : 1;            /* [24..24] Bus Master 4 Write Enable                                        */
      __IOM uint32_t RENM4      : 1;            /* [25..25] Bus Master 4 Read Enable                                         */
      __IOM uint32_t WENM5      : 1;            /* [26..26] Bus Master 5 Write Enable                                        */
      __IOM uint32_t RENM5      : 1;            /* [27..27] Bus Master 5 Read Enable                                         */
      __IOM uint32_t WENM6      : 1;            /* [28..28] Bus Master 6 Write Enable                                        */
      __IOM uint32_t RENM6      : 1;            /* [29..29] Bus Master 6 Read Enable                                         */
      __IOM uint32_t WENM7      : 1;            /* [30..30] Bus Master 7 Write Enable                                        */
      __IOM uint32_t RENM7      : 1;            /* [31..31] Bus Master 7 Read Enable                                         */
    } bit;
  } RDAACC[MPU_RDAACC_COUNT];
} MPU_T;                                     /* Size = 2080 (0x820)                                                       */



/* =========================================================================================================================== */
/* ================                                           EREP                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Error Reporting (EREP)
  */

typedef struct {                                /* (@ 0x40018000) EREP Structure                                             */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Configure Register 0                                       */

    struct {
      __IM  uint32_t RESERVED0  : 26;
      __IOM uint32_t UINTNENM1  : 1;            /* [26..26] Memory 1 Uncorrectable Interrupt Notification Enable             */
      __IOM uint32_t SCINTNENM1 : 1;            /* [27..27] Memory 1 Single-Bit Correction Interrupt Notification
                                                     Enable                                                                  */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t UINTNENM0  : 1;            /* [30..30] Memory 0 Uncorrectable Interrupt Notification Enable             */
      __IOM uint32_t SCINTNENM0 : 1;            /* [31..31] Memory 0 Single-Bit Correction Interrupt Notification
                                                     Enable                                                                  */
    } bit;
  } CFG0;
  __IM  uint32_t  RESERVED[3];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) Status Register 0                                          */

    struct {
      __IM  uint32_t RESERVED0  : 26;
      __IOM uint32_t UEFLGM1    : 1;            /* [26..26] Memory 1 Uncorrectable Error Event Flag                          */
      __IOM uint32_t SBCFLGM1   : 1;            /* [27..27] Memory 1 Single-Bit Correction Event Flag                        */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t UEFLGM0    : 1;            /* [30..30] Memory 0 Uncorrectable Error Event Flag                          */
      __IOM uint32_t SBCFLGM0   : 1;            /* [31..31] Memory 0 Single-Bit Correction Event Flag                        */
    } bit;
  } STS0;
  __IM  uint32_t  RESERVED1[59];

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000100) Error Address Register 0                                   */

    struct {
      __IM  uint32_t EADDR      : 32;           /* [31..0] EADDR                                                             */
    } bit;
  } EADDR0;
  __IM  uint32_t  RESERVED2[3];

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000110) Error Address Register 1                                   */

    struct {
      __IM  uint32_t EADDR      : 32;           /* [31..0] EADDR                                                             */
    } bit;
  } EADDR1;
} EREP_T;                                    /* Size = 276 (0x114)                                                        */



/* =========================================================================================================================== */
/* ================                                           EINJ                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Error Injection (EINJ)
  */

typedef struct {                                /* (@ 0x40019000) EINJ Structure                                             */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Configure Register                                         */

    struct {
      __IOM uint32_t GEINJEN    : 1;            /* [0..0] Global Error Injection Function Enable                             */
      __IM  uint32_t RESERVED0  : 31;
    } bit;
  } CFG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) Channel Enable Register                                    */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t EINJENCH1  : 1;            /* [30..30] Error Injection CH1 Enable                                       */
      __IOM uint32_t EINJENCH0  : 1;            /* [31..31] Error Injection CH0 Enable                                       */
    } bit;
  } CHEN;
  __IM  uint32_t  RESERVED[62];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000100) Channel Descriptor 0, Word0 Register                       */

    struct {
      __IM  uint32_t RESERVED0  : 25;
      __IOM uint32_t CBCBINV    : 7;            /* [31..25] Checkbit Bus Corresponding Bit Invert                            */
    } bit;
  } CHD0_WORD0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000104) Channel Descriptor 0, Word1 Register                       */

    struct {
      __IOM uint32_t DBCBINVB0_3 : 32;          /* [31..0] Data Bus 0-3 Bytes Corresponding Bit Invert                       */
    } bit;
  } CHD0_WORD1;
  __IM  uint32_t  RESERVED1[62];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000200) Channel Descriptor 1, Word0 Register                       */

    struct {
      __IM  uint32_t RESERVED0  : 25;
      __IOM uint32_t CBCBINV    : 7;            /* [31..25] Checkbit Bus Corresponding Bit Invert                            */
    } bit;
  } CHD1_WORD0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000204) Channel Descriptor 1, Word1 Register                       */

    struct {
      __IOM uint32_t DBCBINVB0_3 : 32;          /* [31..0] Data Bus 0-3 Bytes Corresponding Bit Invert                       */
    } bit;
  } CHD1_WORD1;
} EINJ_T;                                    /* Size = 520 (0x208)                                                        */



/* =========================================================================================================================== */
/* ================                                           FLASH                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Flash Memory (FLASH)
  */

typedef struct {                                /* (@ 0x40020000) FLASH Structure                                            */

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000000) Status Register                                            */

    struct {
      __IM  uint8_t EDFLG       : 1;            /* [0..0] Error Detect Flag                                                  */
            uint8_t             : 3;
      __IOM uint8_t PROVFLG     : 1;            /* [4..4] Protection Violation Flag                                          */
      __IOM uint8_t ACCEFLG     : 1;            /* [5..5] Access Error Flag                                                  */
      __IOM uint8_t COLEFLG     : 1;            /* [6..6] Collision Error Flag                                               */
      __IOM uint8_t OCIFLG      : 1;            /* [7..7] Operation Completed Interrupt Flag                                 */
    } bit;
  } STS;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000001) Configure Register                                         */

    struct {
      __IM  uint8_t EERAMSTS    : 1;           /* [0..0] EERAM State, RAM Available for EEPROM                              */
      __IM  uint8_t RAMCSTS     : 1;            /* [1..1] RAM Current State                                                  */
            uint8_t             : 2;
      __IOM uint8_t ERACMDSUS   : 1;            /* [4..4] Erase Command Suspend                                              */
      __IM  uint8_t ERAABREQ    : 1;            /* [5..5] Erase All Blocks Request                                           */
      __IOM uint8_t RCOLEIEN    : 1;            /* [6..6] Read Collision Error Interrupt Enable                              */
      __IOM uint8_t CMDCIEN     : 1;            /* [7..7] Command Complete Interrupt Enable                                  */
    } bit;
  } CFG;

  union {
    __IM  uint8_t reg;                          /* (@ 0x00000002) Security Register                                          */

    struct {
      __IM  uint8_t SECFLG      : 2;            /* [1..0] Flash Secure Flag                                                  */
      __IM  uint8_t FCACCEN     : 2;            /* [3..2] Flash Content Access Enable                                        */
      __IM  uint8_t MERAEN      : 2;            /* [5..4] Mass Erase Enable                                                  */
      __IM  uint8_t BKEYACCEN   : 2;            /* [7..6] Backdoor Key Access Enable                                         */
    } bit;
  } SEC;

  union {
    __IM  uint8_t reg;                          /* (@ 0x00000003) Nonvolatile Option Register                                */

    struct {
      __IM  uint8_t NOPT        : 8;            /* [7..0] Nonvolatile Option                                                 */
    } bit;
  } NOPT;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000004) Common Command Data Registers 3                            */

    struct {
      __IOM uint8_t PCMDCODEP3  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATA3;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000005) Common Command Data Registers 2                            */

    struct {
      __IOM uint8_t PCMDCODEP2  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATA2;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000006) Common Command Data Registers 1                            */

    struct {
      __IOM uint8_t PCMDCODEP1  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATA1;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000007) Common Command Data Registers 0                            */

    struct {
      __IOM uint8_t PCMDCODEP0  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATA0;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000008) Common Command Data Registers 7                            */

    struct {
      __IOM uint8_t PCMDCODEP7  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATA7;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000009) Common Command Data Registers 6                            */

    struct {
      __IOM uint8_t PCMDCODEP6  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATA6;

  union {
    __IOM uint8_t reg;                          /* (@ 0x0000000A) Common Command Data Registers 5                            */

    struct {
      __IOM uint8_t PCMDCODEP5  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATA5;

  union {
    __IOM uint8_t reg;                          /* (@ 0x0000000B) Common Command Data Registers 4                            */

    struct {
      __IOM uint8_t PCMDCODEP4  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATA4;

  union {
    __IOM uint8_t reg;                          /* (@ 0x0000000C) Common Command Data Registers B                            */

    struct {
      __IOM uint8_t PCMDCODEPB  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATAB;

  union {
    __IOM uint8_t reg;                          /* (@ 0x0000000D) Common Command Data Registers A                            */

    struct {
      __IOM uint8_t PCMDCODEPA  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATAA;

  union {
    __IOM uint8_t reg;                          /* (@ 0x0000000E) Common Command Data Registers 9                            */

    struct {
      __IOM uint8_t PCMDCODEP9  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATA9;

  union {
    __IOM uint8_t reg;                          /* (@ 0x0000000F) Common Command Data Registers 8                            */

    struct {
      __IOM uint8_t PCMDCODEP8  : 8;            /* [7..0] Provide Command Code and Parameter                                 */
    } bit;
  } CCMDDATA8;

  union {
    __IOM uint8_t reg;                          /*!< (@ 0x00000010) Program Flash Protect Register 3                           */

    struct {
      __IOM uint8_t PFPRO0      : 1;            /*!< [0..0] Program Flash Protect Area 0                                       */
      __IOM uint8_t PFPRO1      : 1;            /*!< [1..1] Program Flash Protect Area 1                                       */
      __IOM uint8_t PFPRO2      : 1;            /*!< [2..2] Program Flash Protect Area 2                                       */
      __IOM uint8_t PFPRO3      : 1;            /*!< [3..3] Program Flash Protect Area 3                                       */
      __IOM uint8_t PFPRO4      : 1;            /*!< [4..4] Program Flash Protect Area 4                                       */
      __IOM uint8_t PFPRO5      : 1;            /*!< [5..5] Program Flash Protect Area 5                                       */
      __IOM uint8_t PFPRO6      : 1;            /*!< [6..6] Program Flash Protect Area 6                                       */
      __IOM uint8_t PFPRO7      : 1;            /*!< [7..7] Program Flash Protect Area 7                                       */
    } bit;
  } PFPRO3;

  union {
    __IOM uint8_t reg;                          /*!< (@ 0x00000011) Program Flash Protect Register 2                           */

    struct {
      __IOM uint8_t PFPRO8      : 1;            /*!< [0..0] Program Flash Protect Area 8                                       */
      __IOM uint8_t PFPRO9      : 1;            /*!< [1..1] Program Flash Protect Area 9                                       */
      __IOM uint8_t PFPRO10     : 1;            /*!< [2..2] Program Flash Protect Area 10                                      */
      __IOM uint8_t PFPRO11     : 1;            /*!< [3..3] Program Flash Protect Area 11                                      */
      __IOM uint8_t PFPRO12     : 1;            /*!< [4..4] Program Flash Protect Area 12                                      */
      __IOM uint8_t PFPRO13     : 1;            /*!< [5..5] Program Flash Protect Area 13                                      */
      __IOM uint8_t PFPRO14     : 1;            /*!< [6..6] Program Flash Protect Area 14                                      */
      __IOM uint8_t PFPRO15     : 1;            /*!< [7..7] Program Flash Protect Area 15                                      */
    } bit;
  } PFPRO2;

  union {
    __IOM uint8_t reg;                          /*!< (@ 0x00000012) Program Flash Protect Register 1                           */

    struct {
      __IOM uint8_t PFPRO16     : 1;            /*!< [0..0] Program Flash Protect Area 16                                      */
      __IOM uint8_t PFPRO17     : 1;            /*!< [1..1] Program Flash Protect Area 17                                      */
      __IOM uint8_t PFPRO18     : 1;            /*!< [2..2] Program Flash Protect Area 18                                      */
      __IOM uint8_t PFPRO19     : 1;            /*!< [3..3] Program Flash Protect Area 19                                      */
      __IOM uint8_t PFPRO20     : 1;            /*!< [4..4] Program Flash Protect Area 20                                      */
      __IOM uint8_t PFPRO21     : 1;            /*!< [5..5] Program Flash Protect Area 21                                      */
      __IOM uint8_t PFPRO22     : 1;            /*!< [6..6] Program Flash Protect Area 22                                      */
      __IOM uint8_t PFPRO23     : 1;            /*!< [7..7] Program Flash Protect Area 23                                      */
    } bit;
  } PFPRO1;

  union {
    __IOM uint8_t reg;                          /*!< (@ 0x00000013) Program Flash Protect Register 0                           */

    struct {
      __IOM uint8_t PFPRO24     : 1;            /*!< [0..0] Program Flash Protect Area 24                                      */
      __IOM uint8_t PFPRO25     : 1;            /*!< [1..1] Program Flash Protect Area 25                                      */
      __IOM uint8_t PFPRO26     : 1;            /*!< [2..2] Program Flash Protect Area 26                                      */
      __IOM uint8_t PFPRO27     : 1;            /*!< [3..3] Program Flash Protect Area 27                                      */
      __IOM uint8_t PFPRO28     : 1;            /*!< [4..4] Program Flash Protect Area 28                                      */
      __IOM uint8_t PFPRO29     : 1;            /*!< [5..5] Program Flash Protect Area 29                                      */
      __IOM uint8_t PFPRO30     : 1;            /*!< [6..6] Program Flash Protect Area 30                                      */
      __IOM uint8_t PFPRO31     : 1;            /*!< [7..7] Program Flash Protect Area 31                                      */
    } bit;
  } PFPRO0;
  __IM  uint8_t   RESERVED[2];

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000016) EEPROM Protect Register                                    */

    struct {
      __IOM uint8_t EEPRO        : 8;            /* [7..0] EEPROM Protect                                                     */
    } bit;
  } EEPRO;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000017) Data Flash Protect Register                                */

    struct {
      __IOM uint8_t DFPRO   : 8;            /* [7..0] Data Flash Protect                                                 */
    } bit;
  } DFPRO;
  __IM  uint8_t   RESERVED1[20];

  union {
    __IM  uint8_t reg;                          /* (@ 0x0000002C) CSE Status Register                                        */

    struct {
      __IM  uint8_t BUSY        : 1;            /* [0..0] Busy                                                               */
      __IM  uint8_t SBACTSTS    : 1;            /* [1..1] Secure Boot Activated Status                                       */
      __IM  uint8_t SBINITFLG   : 1;            /* [2..2] Secure Boot Initialization Completed flag                          */
      __IM  uint8_t SBCMPFLG    : 1;            /* [3..3] Secure Boot Complete Flag                                          */
      __IM  uint8_t SBSUCFLG    : 1;            /* [4..4] Secure Boot Successful Flag                                        */
      __IM  uint8_t RNGINITFLG  : 1;            /* [5..5] Random Number Generator Initialized Flag                           */
      __IM  uint8_t EXTDBGAFLG  : 1;            /* [6..6] External Debug Attached Flag                                       */
      __IM  uint8_t IDBGENFLG   : 1;            /* [7..7] Internal Debug Enable Flag                                         */
    } bit;
  } CSECSTS;
  __IM  uint8_t   RESERVED2;

  union {
    __IOM uint8_t reg;                          /* (@ 0x0000002E) Error Status Register                                      */

    struct {
            uint8_t             : 1;
      __IOM uint8_t DBFIFLG     : 1;            /* [1..1] Double Bit Fault Interrupt Flag                                    */
            uint8_t             : 6;
    } bit;
  } ESTS;

  union {
    __IOM uint8_t reg;                          /* (@ 0x0000002F) Error Configuration Register                               */

    struct {
            uint8_t             : 1;
      __IOM uint8_t DBFIEN      : 1;            /* [1..1] Double Bit Fault Interrupt Enable                                  */
            uint8_t             : 3;
      __IOM uint8_t EDBFINTD    : 1;            /* [5..5] Emulate Double Bit Fault Interrupt Detect                          */
            uint8_t             : 2;
    } bit;
  } ECFG;
} FLASH_T;                                   /* Size = 48 (0x30)                                                             */



/* =========================================================================================================================== */
/* ================                                          DMACHM                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief DMA Memory Access Channel Multiplexer (DMACHM)
  */

typedef struct {                                /* (@ 0x40021000) DMACHM Structure                                           */

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000000) Channel register 0                                         */

    struct {
      __IOM uint8_t SRCCFG      : 6;            /* [5..0] DMA Channel Source Configure                                       */
      __IOM uint8_t PRDTREN     : 1;            /* [6..6] DMA Channel Periodic Trigger Enable                                */
      __IOM uint8_t CHEN        : 1;            /* [7..7] DMA Channel Enable                                                 */
    } bit;
  } CFG[16u];
} DMACHM_T;                                  /* Size = 16 (0x10)                                                             */



/* =========================================================================================================================== */
/* ================                                         CAN                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Controller Local Area Network (CAN)
  */

typedef struct {                                /*  CAN Structure
                                                       (@ 0x40024000)CAN0 (@ 0x40025000)CAN1 (@ 0x4002B000)CAN2  */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Module Configure register                                  */

    struct {
      __IOM uint32_t LASTMB     : 7;            /* [6..0] Number of the Last Message Buffer                                  */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t IDFFMT     : 2;            /* [9..8] Rx FIFO ID Filter Format                                           */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t CANFDEN    : 1;            /* [11..11] CAN FD Operation Enable                                          */
      __IOM uint32_t TAEN       : 1;            /* [12..12] Tx Abort Mechanism Enable                                        */
      __IOM uint32_t LPRIEN     : 1;            /* [13..13] Local Priority Enable                                            */
      __IOM uint32_t PNEN       : 1;            /* [14..14] Pretended Networking Enable                                      */
      __IOM uint32_t DMAEN      : 1;            /* [15..15] DMA Enable for Rx FIFO                                           */
      __IOM uint32_t IRXMQEN    : 1;            /* [16..16] Individual Receive Masking and Queue Enable                      */
      __IOM uint32_t SRD        : 1;            /* [17..17] Self Reception Disable                                           */
      __IM  uint32_t RESERVED2  : 2;
      __IM  uint32_t LPM        : 1;            /* [20..20] Low-Power Mode                                                   */
      __IOM uint32_t WIEN       : 1;            /* [21..21] Warning Interrupt Enable                                         */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t SVEN       : 1;            /* [23..23] Supervisor Mode Enable                                           */
      __IM  uint32_t FRZFLG     : 1;            /* [24..24] Freeze Mode Flag                                                 */
      __IOM uint32_t CANRST     : 1;            /* [25..25] CAN Reset                                                        */
      __IM  uint32_t RESERVED4  : 1;
      __IM  uint32_t NRDY       : 1;            /* [27..27] Not Ready                                                        */
      __IOM uint32_t EFRZ       : 1;            /* [28..28] Enter Freeze Mode                                                */
      __IOM uint32_t FIFOEN     : 1;            /* [29..29] Rx FIFO Enable                                                   */
      __IOM uint32_t FRZEN      : 1;            /* [30..30] Freeze Mode Enable                                               */
      __IOM uint32_t CMD        : 1;            /* [31..31] CAN Module Disable                                               */
    } bit;
  } MCFG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) Control register 1                                         */

    struct {
      __IOM uint32_t PTS        : 3;            /* [2..0] Propagation Time Segment                                           */
      __IOM uint32_t LOEN       : 1;            /* [3..3] Listen-Only Mode Enable                                            */
      __IOM uint32_t TXLB       : 1;            /* [4..4] Transmit Lowest Buffer First                                       */
      __IOM uint32_t TMRSYN     : 1;            /* [5..5] Timer Sync Feature Enable                                          */
      __IOM uint32_t BORD       : 1;            /* [6..6] Bus Off Recovery Disable                                           */
      __IOM uint32_t TSEN       : 1;            /* [7..7] Triple Sampling Enable                                             */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t RXWIEN     : 1;            /* [10..10] Rx Warning Interrupt Enable                                      */
      __IOM uint32_t TXWIEN     : 1;            /* [11..11] Tx Warning Interrupt Enable                                      */
      __IOM uint32_t LBEN       : 1;            /* [12..12] Loop Back Mode Enable                                            */
      __IOM uint32_t CLKSEL     : 1;            /* [13..13] CAN Engine Clock Source Select                                   */
      __IOM uint32_t ERRIEN     : 1;            /* [14..14] Error Interrupt Enable                                           */
      __IOM uint32_t BOIEN      : 1;            /* [15..15] Bus Off Interrupt Enable                                         */
      __IOM uint32_t PBS2       : 3;            /* [18..16] Phase Buffer Segment 2                                           */
      __IOM uint32_t PBS1       : 3;            /* [21..19] Phase Buffer Segment 1                                           */
      __IOM uint32_t SJW        : 2;            /* [23..22] Resynchronized Jump Width                                        */
      __IOM uint32_t PDF        : 8;            /* [31..24] Prescaler Division Factor                                        */
    } bit;
  } CTRL1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) Free Running Timer register                                */

    struct {
      __IOM uint32_t FRTMR      : 16;           /* [15..0] Free Runnning Timer Value                                         */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } FRTMR;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) Rx Mailboxes Global Mask register                          */

    struct {
      __IOM uint32_t RXMASK     : 32;           /* [31..0] Rx Mailboxes Global Mask                                          */
    } bit;
  } RXMASK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000014) Rx 14 Mask register                                        */

    struct {
      __IOM uint32_t RX14MASK   : 32;           /* [31..0] Rx Buffer 14 Mask                                                 */
    } bit;
  } RX14MASK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) Rx 15 Mask register                                        */

    struct {
      __IOM uint32_t RX15MASK   : 32;           /* [31..0] Rx Buffer 15 Mask                                                 */
    } bit;
  } RX15MASK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000001C) Error Counter register                                     */

    struct {
      __IOM uint32_t TXERRCNT   : 8;            /* [7..0] Transmit Error Counter                                             */
      __IOM uint32_t RXERRCNT   : 8;            /* [15..8] Receive Error Counter                                             */
      __IOM uint32_t FTXERRCNT  : 8;            /* [23..16] Fast Transmit Error Counter                                      */
      __IOM uint32_t FRXERRCNT  : 8;            /* [31..24] Fast Receive Error Counter                                       */
    } bit;
  } ERRCNT;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000020) Error Flag register 1                                      */

    struct {
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t ERRFLG     : 1;            /* [1..1] Error Interrupt Flag                                               */
      __IOM uint32_t BOFLG      : 1;            /* [2..2] Bus Off Flag                                                       */
      __IM  uint32_t RXFLG      : 1;            /* [3..3] Being Receive Flag                                                 */
      __IM  uint32_t FCFLG      : 2;            /* [5..4] Fault Confinement Flag                                             */
      __IM  uint32_t TXFLG      : 1;            /* [6..6] Being Transmit Flag                                                */
      __IM  uint32_t BIDLEFLG   : 1;            /* [7..7] Bus Idle Flag                                                      */
      __IM  uint32_t RXERRWFLG  : 1;            /* [8..8] RX Error Warning Flag                                              */
      __IM  uint32_t TXERRWFLG  : 1;            /* [9..9] TX Error Warning Flag                                              */
      __IM  uint32_t SERRFLG    : 1;            /* [10..10] Stuffing Error Flag                                              */
      __IM  uint32_t FERRFLG    : 1;            /* [11..11] Form Error Flag                                                  */
      __IM  uint32_t CRCERRFLG  : 1;            /* [12..12] CRC Error Flag                                                   */
      __IM  uint32_t ACKERRFLG  : 1;            /* [13..13] Acknowledge Error Flag                                           */
      __IM  uint32_t B0ERRFLG   : 1;            /* [14..14] Bit0 Error Flag                                                  */
      __IM  uint32_t B1ERRFLG   : 1;            /* [15..15] Bit1 Error Flag                                                  */
      __IOM uint32_t RXWINTFLG  : 1;            /* [16..16] Rx Warning Interrupt Flag                                        */
      __IOM uint32_t TXWINTFLG  : 1;            /* [17..17] Tx Warning Interrupt Flag                                        */
      __IM  uint32_t BSYNFLG    : 1;            /* [18..18] CAN Bus Synchronization Flag                                     */
      __IOM uint32_t BOCINTFLG  : 1;            /* [19..19] Bus Off Process Complete Flag                                    */
      __IOM uint32_t FDERRFLG   : 1;            /* [20..20] Error Interrupt Detected in CAN FD Frame Data Phase
                                                     with BRS bit Set Flag                                                   */
      __IOM uint32_t OVRFLG     : 1;            /* [21..21] Overrun Flag                                                     */
      __IM  uint32_t RESERVED1  : 4;
      __IM  uint32_t FDSERRFLG  : 1;            /* [26..26] Stuffing Error in CAN FD Frame Data Phase with BRS
                                                     bit Set                                                                 */
      __IM  uint32_t FDFERRFLG  : 1;            /* [27..27] Form Error in CAN FD Frame Data Phase with BRS bit
                                                     Set                                                                      */
      __IM  uint32_t FDCRCERRFLG : 1;           /* [28..28] CRC Error in CAN FD Frame Data Phasewith BRS bit Set              */
      __IM  uint32_t RESERVED2  : 1;
      __IM  uint32_t FDB0ERRFLG : 1;            /* [30..30] Bit0 Error in CAN FD Frames Data Phase with BRS bit
                                                     Set                                                                      */
      __IM  uint32_t FDB1ERRFLG : 1;            /* [31..31] Bit1 Error in CAN FD Frames Data Phase with BRS bit
                                                     Set                                                                      */
    } bit;
  } ERRFLG1;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000028) Message Buffer i Interrupt Enable register                 */

    struct {
      __IOM uint32_t MB0IEN     : 1;            /* [0..0] Buffer MB 0-31 Mask                                                */
      __IOM uint32_t MB1IEN     : 1;            /* [1..1] Buffer MB 0-31 Mask                                                */
      __IOM uint32_t MB2IEN     : 1;            /* [2..2] Buffer MB 0-31 Mask                                                */
      __IOM uint32_t MB3IEN     : 1;            /* [3..3] Buffer MB 0-31 Mask                                                */
      __IOM uint32_t MB4IEN     : 1;            /* [4..4] Buffer MB 0-31 Mask                                                */
      __IOM uint32_t MB5IEN     : 1;            /* [5..5] Buffer MB 0-31 Mask                                                */
      __IOM uint32_t MB6IEN     : 1;            /* [6..6] Buffer MB 0-31 Mask                                                */
      __IOM uint32_t MB7IEN     : 1;            /* [7..7] Buffer MB 0-31 Mask                                                */
      __IOM uint32_t MB8IEN     : 1;            /* [8..8] Buffer MB 0-31 Mask                                                */
      __IOM uint32_t MB9IEN     : 1;            /* [9..9] Buffer MB 0-31 Mask                                                */
      __IOM uint32_t MB10IEN    : 1;            /* [10..10] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB11IEN    : 1;            /* [11..11] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB12IEN    : 1;            /* [12..12] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB13IEN    : 1;            /* [13..13] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB14IEN    : 1;            /* [14..14] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB15IEN    : 1;            /* [15..15] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB16IEN    : 1;            /* [16..16] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB17IEN    : 1;            /* [17..17] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB18IEN    : 1;            /* [18..18] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB19IEN    : 1;            /* [19..19] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB20IEN    : 1;            /* [20..20] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB21IEN    : 1;            /* [21..21] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB22IEN    : 1;            /* [22..22] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB23IEN    : 1;            /* [23..23] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB24IEN    : 1;            /* [24..24] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB25IEN    : 1;            /* [25..25] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB26IEN    : 1;            /* [26..26] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB27IEN    : 1;            /* [27..27] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB28IEN    : 1;            /* [28..28] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB29IEN    : 1;            /* [29..29] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB30IEN    : 1;            /* [30..30] Buffer MB 0-31 Mask                                              */
      __IOM uint32_t MB31IEN    : 1;            /* [31..31] Buffer MB 0-31 Mask                                              */
    } bit;
  } MBiIEN;
  __IM  uint32_t  RESERVED2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000030) Interrupt Flag register                                    */

    struct {
      __IOM uint32_t MB0INT     : 1;            /* [0..0] Buffer MB0 Interrupt or Clear FIFO Bit Flag                        */
      __IOM uint32_t MB1INT     : 1;            /* [1..1] Buffer MB1-4 Interrupt or Reserved Flag                            */
      __IOM uint32_t MB2INT     : 1;            /* [2..2] Buffer MB1-4 Interrupt or Reserved Flag                            */
      __IOM uint32_t MB3INT     : 1;            /* [3..3] Buffer MB1-4 Interrupt or Reserved Flag                            */
      __IOM uint32_t MB4INT     : 1;            /* [4..4] Buffer MB1-4 Interrupt or Reserved Flag                            */
      __IOM uint32_t MB5INT     : 1;            /* [5..5] Buffer MB5 Interrupt or Frames Available in Rx FIFO Flag           */
      __IOM uint32_t MB6INT     : 1;            /* [6..6] Buffer MB6 Interrupt or Rx FIFO Warning Flag                       */
      __IOM uint32_t MB7INT     : 1;            /* [7..7] Buffer MB7 Interrupt or Rx FIFO Overflow Flag                      */
      __IOM uint32_t MB8INT     : 1;            /* [8..8] MB8-31 Buffer Completed Transmission or Reception Flag             */
      __IOM uint32_t MB9INT     : 1;            /* [9..9] MB8-31 Buffer Completed Transmission or Reception Flag             */
      __IOM uint32_t MB10INT    : 1;            /* [10..10] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB11INT    : 1;            /* [11..11] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB12INT    : 1;            /* [12..12] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB13INT    : 1;            /* [13..13] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB14INT    : 1;            /* [14..14] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB15INT    : 1;            /* [15..15] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB16INT    : 1;            /* [16..16] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB17INT    : 1;            /* [17..17] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB18INT    : 1;            /* [18..18] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB19INT    : 1;            /* [19..19] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB20INT    : 1;            /* [20..20] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB21INT    : 1;            /* [21..21] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB22INT    : 1;            /* [22..22] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB23INT    : 1;            /* [23..23] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB24INT    : 1;            /* [24..24] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB25INT    : 1;            /* [25..25] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB26INT    : 1;            /* [26..26] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB27INT    : 1;            /* [27..27] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB28INT    : 1;            /* [28..28] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB29INT    : 1;            /* [29..29] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB30INT    : 1;            /* [30..30] MB8-31 Buffer Completed Transmission or Reception Flag           */
      __IOM uint32_t MB31INT    : 1;            /* [31..31] MB8-31 Buffer Completed Transmission or Reception Flag           */
    } bit;
  } IFLG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000034) Control register 2                                         */

    struct {
      __IM  uint32_t RESERVED0  : 11;
      __IOM uint32_t EFD        : 1;            /* [11..11] Edge Filter Disable                                              */
      __IOM uint32_t ISOFDEN    : 1;            /* [12..12] ISO CAN FD Protocol Enable                                       */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t PEEN       : 1;            /* [14..14] Protocol Exception Enable                                        */
      __IOM uint32_t TMRSRC     : 1;            /* [15..15] Time Source for the Free Running Timer                           */
      __IOM uint32_t CMPEN      : 1;            /* [16..16] IDE and RTR Bit Comparison Enable For Receive Mailboxes          */
      __IOM uint32_t RFS        : 1;            /* [17..17] Remote Request Frame Storing                                     */
      __IOM uint32_t MBPRI      : 1;            /* [18..18] Mailboxes Reception Priority Configure                           */
      __IOM uint32_t TXASD      : 5;            /* [23..19] Transmit Arbitration Start Delay                                 */
      __IOM uint32_t NUMFIFO    : 4;            /* [27..24] Number of Receive FIFO Filters                                   */
      __IM  uint32_t RESERVED2  : 2;
      __IOM uint32_t BOCIEN     : 1;            /* [30..30] Bus Off Process Complete Interrupt Enable                        */
      __IOM uint32_t FDERRIEN   : 1;            /* [31..31] Error Interrupt Detected in Fast CAN FD Frame Data
                                                     Phase Enable                                                            */
    } bit;
  } CTRL2;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000038) Error Flag register 2                                      */

    struct {
      __IM  uint32_t RESERVED0  : 13;
      __IM  uint32_t IAMBFLG    : 1;            /* [13..13] Inactive Mailbox Flag                                            */
      __IM  uint32_t CVFLG      : 1;            /* [14..14] Contents Valid Flag                                              */
      __IM  uint32_t RESERVED1  : 1;
      __IM  uint32_t LTXMB      : 7;            /* [22..16] Lowest Priority Transmission Mailbox Flag                        */
      __IM  uint32_t RESERVED2  : 9;
    } bit;
  } ERRFLG2;
  __IM  uint32_t  RESERVED3[2];

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000044) CRC register                                               */

    struct {
      __IM  uint32_t CRCV       : 15;           /* [14..0] Transmitted CRC Value                                             */
      __IM  uint32_t RESERVED0  : 1;
      __IM  uint32_t CRCMB      : 7;            /* [22..16] Number of CRC Mailbox                                            */
      __IM  uint32_t RESERVED1  : 9;
    } bit;
  } CRC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000048) Rx FIFO Global Mask register                               */

    struct {
      __IOM uint32_t FIFOGMASK  : 32;           /* [31..0] Rx FIFO Global Mask                                               */
    } bit;
  } FIFOGMASK;

  union {
    __IM  uint32_t reg;                         /* (@ 0x0000004C) Rx FIFO Information register                               */

    struct {
      __IM  uint32_t IAF        : 9;            /* [8..0] ID Acceptance Filter Hit Indicator                                 */
      __IM  uint32_t RESERVED0  : 23;
    } bit;
  } FIFOINFO;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000050) Bit Timing register                                        */

    struct {
      __IOM uint32_t EPBS2      : 5;            /* [4..0] Extended Phase Buffer Segment 2                                    */
      __IOM uint32_t EPBS1      : 5;            /* [9..5] Extended Phase Buffer Segment 1                                    */
      __IOM uint32_t EPTS       : 6;            /* [15..10] Extended Propagation Time Segment                                */
      __IOM uint32_t ESJW       : 5;            /* [20..16] Extended Resynchronized Jump Width                               */
      __IOM uint32_t EPDF       : 10;           /* [30..21] Extended Prescaler Division Factor                               */
      __IOM uint32_t EBTEN      : 1;            /* [31..31] Extended Bit Time Enable                                         */
    } bit;
  } BTIM;
  __IM  uint32_t  RESERVED4[11];

  union {
    __IOM uint32_t reg;                    /* (@ 0x00000080) Embedded RAM                                                    */

    struct {
      __IOM uint32_t DATA_BYTE_3 : 8;           /* [7..0] Data byte 3 of Rx/Tx frame.                                        */
      __IOM uint32_t DATA_BYTE_2 : 8;           /* [15..8] Data byte 2 of Rx/Tx frame.                                       */
      __IOM uint32_t DATA_BYTE_1 : 8;           /* [23..16] Data byte 1 of Rx/Tx frame.                                      */
      __IOM uint32_t DATA_BYTE_0 : 8;           /* [31..24] Data byte 0 of Rx/Tx frame.                                      */
    } bit;
  } RAMn[128];
  __IM  uint32_t  RESERVED5[384];

  union {
    __IOM uint32_t reg;                     /* (@ 0x00000880) Rx Individual Mask registers                                   */

    struct {
      __IOM uint32_t IBMASK     : 32;           /* [31..0] Individual Bits Mask                                              */
    } bit;
  } RXIMASK[32];
  __IM  uint32_t  RESERVED6[128];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000B00) Pretended Networking Control register 1                    */

    struct {
      __IOM uint32_t FCSEL      : 2;            /* [1..0] Filtering Criteria Select                                          */
      __IOM uint32_t IDFLSEL    : 2;            /* [3..2] ID Filtering Level Select                                          */
      __IOM uint32_t PFLSEL     : 2;            /* [5..4] Payload Filtering Level Select                                     */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t NUMMSG     : 8;            /* [15..8] Number of Messages Matching the Same Filtering Criteria           */
      __IOM uint32_t WUMEN      : 1;            /* [16..16] Wakeup by Match Event Enable                                     */
      __IOM uint32_t WUTEN      : 1;            /* [17..17] Wakeup by Timeout Event Enable                                   */
      __IM  uint32_t RESERVED1  : 14;
    } bit;
  } PNCTRL1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000B04) Pretended Networking Contro register 2                     */

    struct {
      __IOM uint32_t TOV        : 16;           /* [15..0] Timeout Value for No Message Matching the Filtering
                                                     Criteria                                                                */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } PNCTRL2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000B08) Pretended Networking Wake Up Match register                */

    struct {
      __IM  uint32_t RESERVED0  : 8;
      __IM  uint32_t NUMM       : 8;            /* [15..8] Number of Matches when in Pretended Networking                    */
      __IOM uint32_t WUMFLG     : 1;            /* [16..16] Wakeup by Match Event Flag                                       */
      __IOM uint32_t WUTFLG     : 1;            /* [17..17] Wakeup by Timeout Event Flag                                     */
      __IM  uint32_t RESERVED1  : 14;
    } bit;
  } PNWM;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000B0C) Pretended Networking ID Filter 1 register                  */

    struct {
      __IOM uint32_t IDF        : 29;           /* [28..0] ID Filter 1 for Pretended Networking                              */
      __IOM uint32_t RFF        : 1;            /* [29..29] Remote Frame Filter                                              */
      __IOM uint32_t EXFF       : 1;            /* [30..30] Extended Frame Format Filter                                     */
      __IM  uint32_t RESERVED0  : 1;
    } bit;
  } PNIDF1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000B10) Pretended Networking Length Code Filter register          */

    struct {
      __IOM uint32_t DLCHI      : 4;            /* [3..0] Payload Data Length Code Higher Limit                             */
      __IM  uint32_t RESERVED0  : 12;
      __IOM uint32_t DLCLO      : 4;            /* [19..16] Payload Data Length Code Lower Limit                            */
      __IM  uint32_t RESERVED1  : 12;
    } bit;
  } PNDLCF;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000B14) Pretended Networking Payload Low Filter 1 register         */

    struct {
      __IOM uint32_t BYTE3      : 8;            /* [7..0] Byte3                                                              */
      __IOM uint32_t BYTE2      : 8;            /* [15..8] Byte2                                                             */
      __IOM uint32_t BYTE1      : 8;            /* [23..16] Byte1                                                            */
      __IOM uint32_t BYTE0      : 8;            /* [31..24] Byte0                                                            */
    } bit;
  } PNPLF1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000B18) Pretended Networking Payload High Filter 1 register        */

    struct {
      __IOM uint32_t BYTE7      : 8;            /* [7..0] Byte7                                                              */
      __IOM uint32_t BYTE6      : 8;            /* [15..8] Byte6                                                             */
      __IOM uint32_t BYTE5      : 8;            /* [23..16] Byte5                                                            */
      __IOM uint32_t BYTE4      : 8;            /* [31..24] Byte4                                                            */
    } bit;
  } PNPHF1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000B1C) Pretended Networking ID Filter 2 Register                  */

    struct {
      __IOM uint32_t IDMASK     : 29;           /* [28..0] ID Mask Bits for Pretended Networking ID Filtering                */
      __IOM uint32_t RFMASK     : 1;            /* [29..29] Remote Frame Filter Mask                                         */
      __IOM uint32_t EXFMASK    : 1;            /* [30..30] Extended Frame Format Filter Mask                                */
      __IM  uint32_t RESERVED0  : 1;
    } bit;
  } PNIDF2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000B20) Pretended Networking Payload Low Filter 2 Register         */

    struct {
      __IOM uint32_t BYTE3      : 8;            /* [7..0] Byte3                                                              */
      __IOM uint32_t BYTE2      : 8;            /* [15..8] Byte2                                                             */
      __IOM uint32_t BYTE1      : 8;            /* [23..16] Byte1                                                            */
      __IOM uint32_t BYTE0      : 8;            /* [31..24] Byte0                                                            */
    } bit;
  } PNPLF2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000B24) Pretended Networking Payload High Filter 2 register        */

    struct {
      __IOM uint32_t BYTE7      : 8;            /* [7..0] Byte7                                                              */
      __IOM uint32_t BYTE6      : 8;            /* [15..8] Byte6                                                             */
      __IOM uint32_t BYTE5      : 8;            /* [23..16] Byte5                                                            */
      __IOM uint32_t BYTE4      : 8;            /* [31..24] Byte4                                                            */
    } bit;
  } PNPHF2;
  __IM  uint32_t  RESERVED7[6];

  struct {
    union {
      __IM  uint32_t reg;                         /* (@ 0x00000B40) Wake Up Message Buffer register a for C/S                */


        struct {
          __IM  uint32_t RESERVED0  : 16;
          __IM  uint32_t DLC        : 4;            /* [19..16] Data Length Code                                             */
          __IM  uint32_t RTR        : 1;            /* [20..20] Remote Transmission Request Bit                              */
          __IM  uint32_t IDE        : 1;            /* [21..21] Identifier Extension Bit                                     */
          __IM  uint32_t SRR        : 1;            /* [22..22] Substitute Remote Request                                    */
          __IM  uint32_t RESERVED1  : 9;
        } bit;
      } WMBn_CS;

      union {
        __IM  uint32_t reg;                         /* (@ 0x00000B44) Wake Up Message Buffer Register a for ID               */

        struct {
          __IM  uint32_t WMID       : 29;           /* [28..0] Wake Up Message ID                                            */
          __IM  uint32_t RESERVED0  : 3;
        } bit;
      } WMBn_ID;

      union {
        __IM  uint32_t reg;                         /* (@ 0x00000B48) Wake Up Message Buffer Register a Low Data              */

        struct {
          __IM  uint32_t BYTE3      : 8;            /* [7..0] Byte3                                                           */
          __IM  uint32_t BYTE2      : 8;            /* [15..8] Byte2                                                          */
          __IM  uint32_t BYTE1      : 8;            /* [23..16] Byte1                                                         */
          __IM  uint32_t BYTE0      : 8;            /* [31..24] Byte0                                                         */
        } bit;
      } WMBn_LDATA;

      union {
        __IM  uint32_t reg;                         /* (@ 0x00000B4C) Wake Up Message Buffer Register a for High Data         */

        struct {
          __IM  uint32_t BYTE7      : 8;            /* [7..0] Byte7                                                           */
          __IM  uint32_t BYTE6      : 8;            /* [15..8] Byte6                                                          */
          __IM  uint32_t BYTE5      : 8;            /* [23..16] Byte5                                                         */
          __IM  uint32_t BYTE4      : 8;            /* [31..24] Byte4                                                         */
        } bit;
      } WMBn_HDATA;
    }WMB[4];

  __IM  uint32_t  RESERVED8[32];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000C00) FD Control register                                        */

    struct {
      __IM  uint32_t TDCV       : 6;            /* [5..0] Transceiver Delay Compensation Value                               */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t TDCOF      : 5;            /* [12..8] Transceiver Delay Compensation Offset                             */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TDCF       : 1;            /* [14..14] Transceiver Delay Compensation Mechanism has Failed              */
      __IOM uint32_t TDCEN      : 1;            /* [15..15] Transceiver Delay Compensation Feature Enable                    */
      __IOM uint32_t MBSIZE     : 2;            /* [17..16] Message Buffer Data Size for Region 0                            */
      __IM  uint32_t RESERVED2  : 13;
      __IOM uint32_t BRSEN      : 1;            /* [31..31] Bit Rate Switch Enable                                           */
    } bit;
  } FDCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000C04) FD Bit Timing register                                     */

    struct {
      __IOM uint32_t FPBS2      : 3;            /* [2..0] Fast Phase Buffer Segment 2                                        */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t FPBS1      : 3;            /* [7..5] Fast Phase Buffer Segment 1                                        */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t FPTS       : 5;            /* [14..10] Fast Propagation Time Segment                                    */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t FSJW       : 3;            /* [18..16] Fast Resynchronized Jump Width                                   */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t FPDF       : 10;           /* [29..20] Fast Prescaler Division Factor                                   */
      __IM  uint32_t RESERVED4  : 2;
    } bit;
  } FDBTIM;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000C08) FD CRC register                                            */

    struct {
      __IM  uint32_t EXTCRCV    : 21;           /* [20..0] Extended CRC Value of the Transmitted Message                     */
      __IM  uint32_t RESERVED0  : 3;
      __IM  uint32_t EXTCRCMB   : 7;            /* [30..24] Number of Extended CRC Mailbox                                   */
      __IM  uint32_t RESERVED1  : 1;
    } bit;
  } FDCRC;
} CAN_T;                                /* Size = 3084 (0xc0c)                                                           */



/* =========================================================================================================================== */
/* ================                                           CFGTMR                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Configurable Timer (CFGTMR)
  */

typedef struct {                                /*  CFGTMR Structure
                                             (@ 0x40038000)CFGTMR0 (@ 0x40039000)CFGTMR1 (@ 0x4003A000)CFGTMR2 (@ 0x40026000)CFGTMR3
                                             (@ 0x4006E000)CFGTMR4 (@ 0x4006F000)CFGTMR5                                         */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Control and Status Register                                */

    struct {
      __IOM uint32_t CLKDFSEL   : 3;            /* [2..0] Clock Division Factor Select                                       */
      __IOM uint32_t CCLKSSEL   : 2;            /* [4..3] Counter Clock Source Select                                        */
      __IOM uint32_t CMSEL      : 1;            /* [5..5] CFGTMR Counter Mode Select                                           */
      __IOM uint32_t RPIEN      : 1;            /* [6..6] Reload Point Interrupt Enable                                      */
      __IOM  uint32_t RFLG       : 1;            /* [7..7] Reload Flag                                                       */
      __IOM uint32_t CFGTMROIEN   : 1;            /* [8..8] CFGTMR Overflow Interrupt Enable                                     */
      __IOM  uint32_t CFGTMROFLG   : 1;            /* [9..9] CFGTMR Overflow Flag                                                */
      __IM  uint32_t RESERVED0  : 6;
      __IOM uint32_t PWMOENCH0  : 1;            /* [16..16] PWM Channel 0-7 Output Enable                                    */
      __IOM uint32_t PWMOENCH1  : 1;            /* [17..17] PWM Channel 0-7 Output Enable                                    */
      __IOM uint32_t PWMOENCH2  : 1;            /* [18..18] PWM Channel 0-7 Output Enable                                    */
      __IOM uint32_t PWMOENCH3  : 1;            /* [19..19] PWM Channel 0-7 Output Enable                                    */
      __IOM uint32_t PWMOENCH4  : 1;            /* [20..20] PWM Channel 0-7 Output Enable                                    */
      __IOM uint32_t PWMOENCH5  : 1;            /* [21..21] PWM Channel 0-7 Output Enable                                    */
      __IOM uint32_t PWMOENCH6  : 1;            /* [22..22] PWM Channel 0-7 Output Enable                                    */
      __IOM uint32_t PWMOENCH7  : 1;            /* [23..23] PWM Channel 0-7 Output Enable                                    */
      __IOM uint32_t FPSCSEL    : 4;            /* [27..24] Filter Prescale Select                                           */
      __IM  uint32_t RESERVED1  : 4;
    } bit;
  } CSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) Counter Register                                           */

    struct {
      __IOM uint32_t CNT        : 16;           /* [15..0] Counter Value                                                     */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } CNT;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) Modulo Register                                            */

    struct {
      __IOM uint32_t MOD        : 16;           /* [15..0] Modulo Value                                                      */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } MOD;

  struct {
      union {
        __IOM uint32_t reg;                         /* (@ 0x0000000C) Channel (n) Control And Status Register                */

        struct {
          __IOM uint32_t DMAEN      : 1;            /* [0..0] DMA Enable                                                     */
          __IOM uint32_t CRSTCTRL   : 1;            /* [1..1] CFGTMR Counter Reset Control                                     */
          __IOM uint32_t CHMSEL0    : 1;            /* [2..2] Channel (n) Mode Select 0                                      */
          __IOM uint32_t CHMSEL1    : 1;            /* [3..3] Channel (n) Mode Select 1                                      */
          __IOM uint32_t CHMSEL2    : 1;            /* [4..4] Channel (n) Mode Select 2                                      */
          __IOM uint32_t CHMSEL3    : 1;            /* [5..5] Channel (n) Mode Select 3                                      */
          __IOM uint32_t CHIEN      : 1;            /* [6..6] Channel (n) Interrupt Enable                                   */
          __IOM uint32_t CHEVFLG    : 1;            /* [7..7] Channel (n) Event Flag                                        */
          __IOM uint32_t CHOTMCTRL  : 1;            /* [8..8] Channel (n) Output Trigger Mode Control                        */
          __IM  uint32_t CHISTS     : 1;            /* [9..9] Channel (n) Input State                                        */
          __IM  uint32_t CHOLSEL    : 1;            /* [10..10] Channel (n) Output Value Select                              */
        __IM  uint32_t RESERVED0  : 21;
        } bit;
      } CHnCSTS;

      union {
        __IOM uint32_t reg;                         /* (@ 0x00000010) Channel (n) Value Register                             */

        struct {
          __IOM uint32_t CHV        : 16;           /* [15..0] Channel Value                                                 */
          __IM  uint32_t RESERVED0  : 16;
        } bit;
      } CHnV;
  } CONTROLS[8];

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000004C) Initial Value Register                                     */

    struct {
      __IOM uint32_t INITV      : 16;           /* [15..0] Initial Value                                                     */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } INITV;

  union {
    __IOM  uint32_t reg;                         /* (@ 0x00000050) Capture and Compare Status Register                     */

    struct {
      __IOM  uint32_t CHEVFLG0   : 1;            /* [0..0] Channel 0 Flag                                                   */
      __IOM  uint32_t CHEVFLG1   : 1;            /* [1..1] Channel 1 Flag                                                   */
      __IOM  uint32_t CHEVFLG2   : 1;            /* [2..2] Channel 2 Flag                                                   */
      __IOM  uint32_t CHEVFLG3   : 1;            /* [3..3] Channel 3 Flag                                                   */
      __IOM  uint32_t CHEVFLG4   : 1;            /* [4..4] Channel 4 Flag                                                   */
      __IOM  uint32_t CHEVFLG5   : 1;            /* [5..5] Channel 5 Flag                                                   */
      __IOM  uint32_t CHEVFLG6   : 1;            /* [6..6] Channel 6 Flag                                                   */
      __IOM  uint32_t CHEVFLG7   : 1;            /* [7..7] Channel 7 Flag                                                   */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } CCSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000054) Features Mode Select Register                              */

    struct {
      __IOM uint32_t CFGTMREN     : 1;            /* [0..0] CFGTMR Module Enable                                                 */
      __OM  uint32_t INITSTS    : 1;            /* [1..1] Channels Output Initialization Status                              */
      __IOM uint32_t WPUNLOCK   : 1;            /* [2..2] Write Protection unlock                                            */
      __IOM uint32_t PWMSMCFG   : 1;            /* [3..3] PWM Synchronization Mode Configure                                 */
      __IOM uint32_t CTMEN      : 1;            /* [4..4] Capture Test Mode Enable                                           */
      __IOM uint32_t FCTRLMSEL  : 2;            /* [6..5] Fault Control Mode Select                                          */
      __IOM uint32_t FCTRLIEN   : 1;            /* [7..7] Fault Control Interrupt Enable                                     */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } FMSEL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000058) Synchronization Register                                   */

    struct {
      __IOM uint32_t MINLPEN    : 1;            /* [0..0] Minimum Loading Point Enable                                       */
      __IOM uint32_t MAXLPEN    : 1;            /* [1..1] Maximum Loading Point Enable                                       */
      __IOM uint32_t CFGTMRCRINT  : 1;            /* [2..2] Reinitialization CFGTMR Counter Value Synchronization                */
      __IOM uint32_t OVSMSEL    : 1;            /* [3..3] Output Value Synchronization Mode Select                           */
      __IOM uint32_t HWT0SEL    : 1;            /* [4..4] PWM Synchronization Hardware Trigger 0 Select                      */
      __IOM uint32_t HWT1SEL    : 1;            /* [5..5] PWM Synchronization Hardware Trigger 1 Select                      */
      __IOM uint32_t HWT2SEL    : 1;            /* [6..6] PWM Synchronization Hardware Trigger 2 Select                      */
      __IOM uint32_t SWTSEL     : 1;            /* [7..7] PWM Synchronization Software Trigger Select                        */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } SYN;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000005C) Channel Output Initialization Register                 */

    struct {
      __IOM uint32_t CHOISEL0   : 1;            /* [0..0] Channel 0 Output Initialization Value                            */
      __IOM uint32_t CHOISEL1   : 1;            /* [1..1] Channel 1 Output Initialization Value                            */
      __IOM uint32_t CHOISEL2   : 1;            /* [2..2] Channel 2 Output Initialization Value                            */
      __IOM uint32_t CHOISEL3   : 1;            /* [3..3] Channel 3 Output Initialization Value                            */
      __IOM uint32_t CHOISEL4   : 1;            /* [4..4] Channel 4 Output Initialization Value                            */
      __IOM uint32_t CHOISEL5   : 1;            /* [5..5] Channel 5 Output Initialization Value                            */
      __IOM uint32_t CHOISEL6   : 1;            /* [6..6] Channel 6 Output Initialization Value                            */
      __IOM uint32_t CHOISEL7   : 1;            /* [7..7] Channel 7 Output Initialization Value                            */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } CHOI;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000060) Output Mask Register                                     */

    struct {
      __IOM uint32_t CHOMASK0   : 1;            /* [0..0] Channel 0 Output Mask                                            */
      __IOM uint32_t CHOMASK1   : 1;            /* [1..1] Channel 1 Output Mask                                            */
      __IOM uint32_t CHOMASK2   : 1;            /* [2..2] Channel 2 Output Mask                                            */
      __IOM uint32_t CHOMASK3   : 1;            /* [3..3] Channel 3 Output Mask                                            */
      __IOM uint32_t CHOMASK4   : 1;            /* [4..4] Channel 4 Output Mask                                            */
      __IOM uint32_t CHOMASK5   : 1;            /* [5..5] Channel 5 Output Mask                                            */
      __IOM uint32_t CHOMASK6   : 1;            /* [6..6] Channel 6 Output Mask                                            */
      __IOM uint32_t CHOMASK7   : 1;            /* [7..7] Channel 7 Output Mask                                            */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } OMASK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000064) Function For Linked Channels Register                      */

    struct {
      __IOM uint32_t CHCM0      : 1;            /* [0..0] Channels Combine Mode For n=0                                      */
      __IOM uint32_t CCHO0      : 1;            /* [1..1] Complement Channel (n) Output for n=0                              */
      __IOM uint32_t DECMEN0    : 1;            /* [2..2] Dual Edge Capture Mode Enable For n=0                              */
      __IOM uint32_t DECSTS0    : 1;            /* [3..3] Dual Edge Capture Status For n=0                                   */
      __IOM uint32_t DTIEN0     : 1;            /* [4..4] Deadtime Insertion Enable For n=0                                  */
      __IOM uint32_t PWMSYNEN0  : 1;            /* [5..5] PWM Synchronization Enable For n=0                                 */
      __IOM uint32_t FCTRLEN0   : 1;            /* [6..6] Fault Control Enable For n=0                                       */
      __IOM uint32_t MCM0       : 1;            /* [7..7] Modified Combine Mode For n=0                                      */
      __IOM uint32_t CHCM1      : 1;            /* [8..8] Channels Combine Mode For n=2                                      */
      __IOM uint32_t CCHO1      : 1;            /* [9..9] Dual Edge Capture Mode Enable For n=2                              */
      __IOM uint32_t DECMEN1    : 1;            /* [10..10] Dual Edge Capture Status For n=2                                 */
      __IOM uint32_t DECSTS1    : 1;            /* [11..11] Dual Edge Capture Status For n=2                                 */
      __IOM uint32_t DTIEN1     : 1;            /* [12..12] Deadtime Insertion Enable For n=2                                */
      __IOM uint32_t PWMSYNEN1  : 1;            /* [13..13] PWM Synchronization Enable For n=2                               */
      __IOM uint32_t FCTRLEN1   : 1;            /* [14..14] Fault Control Enable For n=2                                     */
      __IOM uint32_t MCM1       : 1;            /* [15..15] Modified Combine Mode For n=2                                    */
      __IOM uint32_t CHCM2      : 1;            /* [16..16] Channels Combine Mode For n=4                                    */
      __IOM uint32_t CCHO2      : 1;            /* [17..17] Complement Channel (n) Output for n=4                            */
      __IOM uint32_t DECMEN2    : 1;            /* [18..18] Dual Edge Capture Mode Enable For n=4                            */
      __IOM uint32_t DECSTS2    : 1;            /* [19..19] Dual Edge Capture Status For n=4                                 */
      __IOM uint32_t DTIEN2     : 1;            /* [20..20] Deadtime Insertion Enable For n=4                                */
      __IOM uint32_t PWMSYNEN2  : 1;            /* [21..21] PWM Synchronization Enable For n=4                               */
      __IOM uint32_t FCTRLEN2   : 1;            /* [22..22] Fault Control Enable For n=4                                     */
      __IOM uint32_t MCM2       : 1;            /* [23..23] Modified Combine Mode For n=4                                    */
      __IOM uint32_t CHCM3      : 1;            /* [24..24] Channels Combine Mode For n=6                                    */
      __IOM uint32_t CCHO3      : 1;            /* [25..25] Complement Channel (n) Output for n=6                            */
      __IOM uint32_t DECMEN3    : 1;            /* [26..26] Dual Edge Capture Mode Enable For n=6                            */
      __IOM uint32_t DECSTS3    : 1;            /* [27..27] Dual Edge Capture Status For n=6                                 */
      __IOM uint32_t DTIEN3     : 1;            /* [28..28] Deadtime Insertion Enable For n=6                                */
      __IOM uint32_t PWMSYNEN3  : 1;            /* [29..29] PWM Synchronization Enable For n=6                               */
      __IOM uint32_t FCTRLEN3   : 1;            /* [30..30] Fault Control Enable For n=6                                     */
      __IOM uint32_t MCM3       : 1;            /* [31..31] Modified Combine Mode For n=6                                    */
    } bit;
  } FLCH;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000068) Deadtime Configure Register                                */

    struct {
      __IOM uint32_t DTVSEL     : 6;            /* [5..0] Deadtime Value Select                                              */
      __IOM uint32_t DPSCCFG    : 2;            /* [7..6] Deadtime Prescaler Factor Configure                                */
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t EDTV       : 4;            /* [19..16] Extended Deadtime Value                                          */
      __IM  uint32_t RESERVED1  : 12;
    } bit;
  } DCFG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000006C) External Trigger Register                                  */

    struct {
      __IOM uint32_t EXTTRGENCH2 : 1;           /* [0..0] Channel 2 External Trigger Generation Enable                       */
      __IOM uint32_t EXTTRGENCH3 : 1;           /* [1..1] Channel 3 External Trigger Generation Enable                       */
      __IOM uint32_t EXTTRGENCH4 : 1;           /* [2..2] Channel 4 External Trigger Generation Enable                       */
      __IOM uint32_t EXTTRGENCH5 : 1;           /* [3..3] Channel 5 External Trigger Generation Enable                       */
      __IOM uint32_t EXTTRGENCH0 : 1;           /* [4..4] Channel 0 External Trigger Generation Enable                       */
      __IOM uint32_t EXTTRGENCH1 : 1;           /* [5..5] Channel 1 External Trigger Generation Enable                       */
      __IOM uint32_t INITTRGEN  : 1;            /* [6..6] Initialization Trigger Generate Enable                             */
      __IOM  uint32_t CHTRGFLG   : 1;            /* [7..7] Channel Trigger Flag                                              */
      __IOM uint32_t EXTTRGENCH6 : 1;           /* [8..8] Channel 6 External Trigger Generation Enable                       */
      __IOM uint32_t EXTTRGENCH7 : 1;           /* [9..9] Channel 7 External Trigger Generation Enable                       */
      __IM  uint32_t RESERVED0  : 22;
    } bit;
  } EXTTRG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000070) Channel Output Polarity Register                         */

    struct {
      __IOM uint32_t CHPOL0     : 1;            /* [0..0] Channel 0-7 Output Polarity                                        */
      __IOM uint32_t CHPOL1     : 1;            /* [1..1] Channel 0-7 Output Polarity                                        */
      __IOM uint32_t CHPOL2     : 1;            /* [2..2] Channel 0-7 Output Polarity                                        */
      __IOM uint32_t CHPOL3     : 1;            /* [3..3] Channel 0-7 Output Polarity                                        */
      __IOM uint32_t CHPOL4     : 1;            /* [4..4] Channel 0-7 Output Polarity                                        */
      __IOM uint32_t CHPOL5     : 1;            /* [5..5] Channel 0-7 Output Polarity                                        */
      __IOM uint32_t CHPOL6     : 1;            /* [6..6] Channel 0-7 Output Polarity                                        */
      __IOM uint32_t CHPOL7     : 1;            /* [7..7] Channel 0-7 Output Polarity                                        */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } CHPOL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000074) Fault module status register                              */

    struct {
      __IOM uint32_t FIDFLG0    : 1;            /* [0..0] Fault Inputs Detection Flag 0                                     */
      __IOM uint32_t FIDFLG1    : 1;            /* [1..1] Fault Inputs Detection Flag 1                                     */
      __IOM uint32_t FIDFLG2    : 1;            /* [2..2] Fault Inputs Detection Flag 2                                     */
      __IOM uint32_t FIDFLG3    : 1;            /* [3..3] Fault Inputs Detection Flag 3                                     */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t FICTRL     : 1;            /* [5..5] Fault Inputs Control                                              */
      __IOM uint32_t WPEN       : 1;            /* [6..6] Write Protection Enable                                            */
      __IM  uint32_t FCDFLG     : 1;            /* [7..7] Fault Condition Detection Flag                                     */
      __IM  uint32_t RESERVED1  : 24;
    } bit;
  } FMSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000078) Input Capture Filter Control Register                      */

    struct {
      __IOM uint32_t IFVSELCH0  : 4;            /* [3..0] Channel 0 Input Filter Value Select                                */
      __IOM uint32_t IFVSELCH1  : 4;            /* [7..4] Channel 1 Input Filter Value Select                                */
      __IOM uint32_t IFVSELCH2  : 4;            /* [11..8] Channel 2 Input Filter Value Select                               */
      __IOM uint32_t IFVSELCH3  : 4;            /* [15..12] Channel 3 Input Filter Value Select                              */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } ICFCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000007C) Fault Control Register                                     */

    struct {
      __IOM uint32_t FIEN0      : 1;            /* [0..0] Fault Input 0 Enable                                               */
      __IOM uint32_t FIEN1      : 1;            /* [1..1] Fault Input 1 Enable                                               */
      __IOM uint32_t FIEN2      : 1;            /* [2..2] Fault Input 2 Enable                                               */
      __IOM uint32_t FIEN3      : 1;            /* [3..3] Fault Input 3 Enable                                               */
      __IOM uint32_t FIFEN0     : 1;            /* [4..4] Fault Input Filter 0 Enable                                        */
      __IOM uint32_t FIFEN1     : 1;            /* [5..5] Fault Input Filter 1 Enable                                        */
      __IOM uint32_t FIFEN2     : 1;            /* [6..6] Fault Input Filter 2 Enable                                        */
      __IOM uint32_t FIFEN3     : 1;            /* [7..7] Fault Input Filter 3 Enable                                        */
      __IOM uint32_t FIFVSEL    : 4;            /* [11..8] Fault Input Filter Value Select                                   */
      __IM  uint32_t RESERVED0  : 3;
      __IOM uint32_t FEOSTS     : 1;            /* [15..15] Fault Event Output Status                                        */
      __IM  uint32_t RESERVED1  : 16;
    } bit;
  } FCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000080) Quadrature Decoder Control And Status Register             */

    struct {
      __IOM uint32_t QDMEN      : 1;            /* [0..0] Quadrature Decoder Mode Enable                                     */
      __IM  uint32_t TMRODSEL   : 1;            /* [1..1] Timer Overflow Direction Select                                    */
      __IM  uint32_t CNTDIR     : 1;            /* [2..2] CFGTMR Counter Direction                                             */
      __IOM uint32_t EMSEL      : 1;            /* [3..3] Encoding Mode Select                                               */
      __IOM uint32_t PBISPOL    : 1;            /* [4..4] Phase B Input Signal Polarity Select                               */
      __IOM uint32_t PAISPOL    : 1;            /* [5..5] Phase A Input Signal Polarity Select                               */
      __IOM uint32_t PBIFEN     : 1;            /* [6..6] Phase B Input Filter Value Enable                                  */
      __IOM uint32_t PAIFEN     : 1;            /* [7..7] Phase A Input Filter Value Enable                                  */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } QDCSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000084) Configure Register                                         */

    struct {
      __IOM uint32_t ROCFG      : 5;            /* [4..0] Reload Opportunities Configure                                     */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t DBG        : 2;            /* [7..6] Debug Mode                                                         */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t EGTIMBEN   : 1;            /* [9..9] External Global Time Base Enable                                   */
      __IOM uint32_t GTIMBSGEN  : 1;            /* [10..10] Global Time Base Signal Generation Enable                        */
      __IOM uint32_t INITTRGRP  : 1;            /* [11..11] Initialization Trigger on Reload Point                           */
      __IM  uint32_t RESERVED2  : 20;
    } bit;
  } CFG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000088) Fault Input Polarity Select Register                       */

    struct {
      __IOM uint32_t FIPOLSEL0  : 1;            /* [0..0] Fault Input 0 Polarity Select                                      */
      __IOM uint32_t FIPOLSEL1  : 1;            /* [1..1] Fault Input 1 Polarity Select                                      */
      __IOM uint32_t FIPOLSEL2  : 1;            /* [2..2] Fault Input 2 Polarity Select                                      */
      __IOM uint32_t FIPOLSEL3  : 1;            /* [3..3] Fault Input 3 Polarity Select                                      */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } FIPOLSEL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000008C) Synchronization Configure Register                         */

    struct {
      __IOM uint32_t HWTRGD     : 1;            /* [0..0] Hardware Trigger Detect                                            */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t INITVSYN   : 1;            /* [2..2] CFGTMR_INITV Register Synchronization                                */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t ICTRLSYN   : 1;            /* [4..4] CFGTMR_ICTRL Register Synchronization                                */
      __IOM uint32_t SWOCTRLSYN : 1;            /* [5..5] CFGTMR_SWOCTRL Register Synchronization                              */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t SYNMSEL    : 1;            /* [7..7] Synchronization Mode Select                                        */
      __IOM uint32_t SWTAC      : 1;            /* [8..8] Software Trigger Activates CFGTMR Counter Register Synchronization   */
      __IOM uint32_t SWTAWRBUF  : 1;            /* [9..9] Software Trigger Activates CFGTMR_MOD,CFGTMR_HC,CFGTMR_INITV
                                                     and CFGTMR_CHnV (n=0...7) Register Synchronization                        */
      __IOM uint32_t SWTAOM     : 1;            /* [10..10] Software Trigger Activates CFGTMR_OMASK Register Synchronization   */
      __IOM uint32_t SWTAICTRL  : 1;            /* [11..11] Software Trigger Activates CFGTMR_ICTRL Register Synchronization   */
      __IOM uint32_t SWTASWO    : 1;            /* [12..12] Software Trigger Activates CFGTMR_SWOCTRL Register Synchronization */
      __IM  uint32_t RESERVED3  : 3;
      __IOM uint32_t HWTAC      : 1;            /* [16..16] Hardware Trigger Activates CFGTMR Counter Register Synchronization */
      __IOM uint32_t HWTAWRBUF  : 1;            /* [17..17] Hardware Trigger Activates CFGTMR_MOD,CFGTMR_HC,CFGTMR_INITV
                                                     and CFGTMR_CHnV (n=0...7) Register Synchronization                        */
      __IOM uint32_t HWTAOM     : 1;            /* [18..18] Hardware Trigger Activates CFGTMR_OMASK Register Synchronization   */
      __IOM uint32_t HWTAICTRL  : 1;            /* [19..19] Hardware Trigger Activates CFGTMR_ICTRL Register Synchronization   */
      __IOM uint32_t HWTASWO    : 1;            /* [20..20] Hardware Trigger Activates CFGTMR_SWOCTRL Register Synchronization */
      __IM  uint32_t RESERVED4  : 11;
    } bit;
  } SYNCFG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000090) Inverting Control Register                                 */

    struct {
      __IOM uint32_t CHPIEN0    : 1;            /* [0..0] Channels Pair 0 Inverting Enable                                   */
      __IOM uint32_t CHPIEN1    : 1;            /* [1..1] Channels Pair 1 Inverting Enable                                   */
      __IOM uint32_t CHPIEN2    : 1;            /* [2..2] Channels Pair 2 Inverting Enable                                   */
      __IOM uint32_t CHPIEN3    : 1;            /* [3..3] Channels Pair 3 Inverting Enable                                   */
      __IM  uint32_t RESERVED5  : 28;
    } bit;
  } ICTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000094) Software Output Control Register                         */

    struct {
      __IOM uint32_t CHSWOCTRLEN0 : 1;          /* [0..0] Channel 0 Software Output Control Enable                         */
      __IOM uint32_t CHSWOCTRLEN1 : 1;          /* [1..1] Channel 1 Software Output Control Enable                         */
      __IOM uint32_t CHSWOCTRLEN2 : 1;          /* [2..2] Channel 2 Software Output Control Enable                         */
      __IOM uint32_t CHSWOCTRLEN3 : 1;          /* [3..3] Channel 3 Software Output Control Enable                         */
      __IOM uint32_t CHSWOCTRLEN4 : 1;          /* [4..4] Channel 4 Software Output Control Enable                         */
      __IOM uint32_t CHSWOCTRLEN5 : 1;          /* [5..5] Channel 5 Software Output Control Enable                         */
      __IOM uint32_t CHSWOCTRLEN6 : 1;          /* [6..6] Channel 6 Software Output Control Enable                         */
      __IOM uint32_t CHSWOCTRLEN7 : 1;          /* [7..7] Channel 7 Software Output Control Enable                         */
      __IOM uint32_t CHSWOCTRLVSEL0 : 1;        /* [8..8] Channel 0 Software Output Control Value                          */
      __IOM uint32_t CHSWOCTRLVSEL1 : 1;        /* [9..9] Channel 1 Software Output Control Value                          */
      __IOM uint32_t CHSWOCTRLVSEL2 : 1;        /* [10..10] Channel 2 Software Output Control Value                        */
      __IOM uint32_t CHSWOCTRLVSEL3 : 1;        /* [11..11] Channel 3 Software Output Control Value                        */
      __IOM uint32_t CHSWOCTRLVSEL4 : 1;        /* [12..12] Channel 4 Software Output Control Value                        */
      __IOM uint32_t CHSWOCTRLVSEL5 : 1;        /* [13..13] Channel 5 Software Output Control Value                        */
      __IOM uint32_t CHSWOCTRLVSEL6 : 1;        /* [14..14] Channel 6 Software Output Control Value                        */
      __IOM uint32_t CHSWOCTRLVSEL7 : 1;        /* [15..15] Channel 7 Software Output Control Value                        */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } SWOCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000098) PWM Load Register                                        */

    struct {
      __IOM uint32_t CHMSEL0    : 1;            /* [0..0] Channel 0 Match Select                                           */
      __IOM uint32_t CHMSEL1    : 1;            /* [1..1] Channel 1 Match Select                                           */
      __IOM uint32_t CHMSEL2    : 1;            /* [2..2] Channel 2 Match Select                                           */
      __IOM uint32_t CHMSEL3    : 1;            /* [3..3] Channel 3 Match Select                                           */
      __IOM uint32_t CHMSEL4    : 1;            /* [4..4] Channel 4 Match Select                                           */
      __IOM uint32_t CHMSEL5    : 1;            /* [5..5] Channel 5 Match Select                                           */
      __IOM uint32_t CHMSEL6    : 1;            /* [6..6] Channel 6 Match Select                                           */
      __IOM uint32_t CHMSEL7    : 1;            /* [7..7] Channel 7 Match Select                                           */
      __IOM uint32_t HCREN      : 1;            /* [8..8] Half Cycle Reload Enable                                         */
      __IOM uint32_t LUVEN      : 1;            /* [9..9] Load Updated Values Enable                                       */
      __IOM uint32_t GLOKEN     : 1;            /* [10..10] Global Load OK Enable                                          */
      __OM  uint32_t GLOP       : 1;            /* [11..11] Global Load OK Present                                         */
      __IM  uint32_t RESERVED0  : 20;
    } bit;
  } PWMLD;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000009C) Half Cycle Register                                      */

    struct {
      __IOM uint32_t HCV        : 16;           /* [15..0] Half Cycle Value                                                */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } HC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000A0) Pair x Deadtime Configure Register                       */

    struct {
      __IOM uint32_t DVSEL      : 6;            /* [5..0] Deadtime Value Select                                            */
      __IOM uint32_t PSCCFG     : 2;            /* [7..6] Deadtime Prescaler Factor Configure                              */
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t EDTV       : 4;            /* [19..16] Extended Deadtime Value                                        */
      __IM  uint32_t RESERVED1  : 12;
    } bit;
  } P0DCFG;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000A8) Pair x Deadtime Configure Register                       */

    struct {
      __IOM uint32_t DVSEL      : 6;            /* [5..0] Deadtime Value Select                                            */
      __IOM uint32_t PSCCFG     : 2;            /* [7..6] Deadtime Prescaler Factor Configure                              */
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t EDTV       : 4;            /* [19..16] Extended Deadtime Value                                        */
      __IM  uint32_t RESERVED1  : 12;
    } bit;
  } P1DCFG;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000B0) Pair x Deadtime Configure Register                       */

    struct {
      __IOM uint32_t DVSEL      : 6;            /* [5..0] Deadtime Value Select                                            */
      __IOM uint32_t PSCCFG     : 2;            /* [7..6] Deadtime Prescaler Factor Configure                              */
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t EDTV       : 4;            /* [19..16] Extended Deadtime Value                                        */
      __IM  uint32_t RESERVED1  : 12;
    } bit;
  } P2DCFG;
  __IM  uint32_t  RESERVED2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000B8) Pair x Deadtime Configure Register                       */

    struct {
      __IOM uint32_t DVSEL      : 6;            /* [5..0] Deadtime Value Select                                            */
      __IOM uint32_t PSCCFG     : 2;            /* [7..6] Deadtime Prescaler Factor Configure                              */
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t EDTV       : 4;            /* [19..16] Extended Deadtime Value                                        */
      __IM  uint32_t RESERVED1  : 12;
    } bit;
  } P3DCFG;

  __IM  uint32_t  RESERVED3[81];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000200) Mirror of Modulo Value Register                          */

    struct {
      __IM  uint32_t RESERVED0  : 11;
      __IOM uint32_t MFV        : 5;            /* [15..11] Modulo Fractional Value                                        */
      __IOM uint32_t MMIV       : 16;           /* [31..16] Mirror of Modulo Integer Value                                 */
    } bit;
  } MMV;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000204) Mirror of Channel (n) Match Value Register               */

    struct {
      __IM  uint32_t RESERVED0  : 11;
      __IOM uint32_t MFCHV      : 5;            /* [15..11] Channel (n) Match Fractional Value                             */
      __IOM uint32_t MMICHV     : 16;           /* [31..16] Mirror of the Channel (n) Match Integer Value                  */
    } bit;
  } MCHM[8];

} CFGTMR_T;                                   /* Size = 548 (0x224)                                                            */



/* =========================================================================================================================== */
/* ================                                           ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Analog-to-Digital Converter (ADC)
  */
/** ADC - Size of Registers Arrays */
#define ADC_DATARESULT_COUNT                       16U
#define ADC_CSTS1_COUNT                            16U
#define ADC_DATA_COUNT                             16U
#define ADC_ACSTS1_COUNT                           24U
#define ADC_ADATA_COUNT                            24U
#define ADC_COMPVAL_COUNT                          2U

typedef struct {                                /*  ADC Structure  (@ 0x4003B000)ADC0 (@ 0x40027000)ADC1                     */
  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Control and Status Register 1x                             */

    struct {
      __IOM uint32_t ICHSEL     : 6;            /* [5..0] Input Channel Select                                               */
      __IOM uint32_t CCIEN      : 1;            /* [6..6] Conversion Complete Interrupt Enable                               */
      __IM  uint32_t CCFLG      : 1;            /* [7..7] Input Clock Source Select                                          */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } CSTS1[ADC_CSTS1_COUNT];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000040) Configure Register 1                                       */

    struct {
      __IOM uint32_t ICLKSSEL   : 2;            /* [1..0] Input Clock Source Select                                          */
      __IOM uint32_t CMODSEL    : 2;            /* [3..2] Conversion Mode Select                                             */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t CLKDIVCFG  : 2;            /* [6..5] Clock Divider Factor Configure                                     */
      __IM  uint32_t RESERVED1  : 1;
      __OM  uint32_t LTRGCLR    : 1;            /* [8..8] Latch Triggers Clear                                               */
      __IM  uint32_t RESERVED2  : 23;
    } bit;
  } CFG1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000044) Configure Register 2                                       */

    struct {
      __IOM uint32_t SMPTCFG    : 8;            /* [7..0] Sample Time Configure                                              */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } CFG2;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000048) Data Result Registers x                                    */

    struct {
      __IM  uint32_t DATA       : 12;           /* [11..0] Conversion Data                                                   */
      __IM  uint32_t RESERVED0  : 20;
    } bit;
  } DATA[ADC_DATARESULT_COUNT];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000088) Compare Value Registers x                                  */

    struct {
      __IOM uint32_t COMPVAL    : 16;           /* [15..0] Compare Value                                                     */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } COMPVAL[ADC_COMPVAL_COUNT];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000090) Status and Control Register 2                              */

    struct {
      __IOM uint32_t VREFSEL    : 2;            /* [1..0] Voltage Reference Source Select                                    */
      __IOM uint32_t DMAEN      : 1;            /* [2..2] DMA Mode Enable                                                    */
      __IOM uint32_t RCOMPEN    : 1;            /* [3..3] Range Compare Function Enable                                      */
      __IOM uint32_t GTCOMPEN   : 1;            /* [4..4] Greater Than Compare Function Enable                               */
      __IOM uint32_t COMPEN     : 1;            /* [5..5] Compare Function Enable                                            */
      __IOM uint32_t CTRGSEL    : 1;            /* [6..6] Software/Hardware Conversion Trigger Select                        */
      __IM  uint32_t CFLAG      : 1;            /* [7..7] Conversion Flag                                                    */
      __IM  uint32_t RESERVED0  : 5;
      __IM  uint32_t TRGNUM     : 2;            /* [14..13] Trigger Number                                                   */
      __IM  uint32_t RESERVED1  : 1;
      __IM  uint32_t TRGSTS     : 4;            /* [19..16] Trigger Status                                                   */
      __IM  uint32_t RESERVED2  : 4;
      __IM  uint32_t TRGEFLG    : 4;            /* [27..24] Trigger Error Occur Flag                                         */
      __IM  uint32_t RESERVED3  : 4;
    } bit;
  } CSTS2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000094) Status and Control Register 3                              */

    struct {
      __IOM uint32_t HAVGCFG    : 2;            /* [1..0] Hardware Averaged Samples Configure                                */
      __IOM uint32_t HAVGEN     : 1;            /* [2..2] Hardware Average Function Enable                                   */
      __IOM uint32_t CONTCEN    : 1;            /* [3..3] Continuous Conversion Mode Enable                                  */
      __IM  uint32_t RESERVED0  : 3;
      __IOM uint32_t CAL        : 1;            /* [7..7] Calibration                                                        */
      __IM  uint32_t RESERVED1  : 24;
    } bit;
  } CSTS3;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000098) Base Offset Error Correction Register                      */

    struct {
      __IOM uint32_t BOECVAL    : 8;            /* [7..0] Base Offset Error Correction Value                                 */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } BOEC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000009C) Offset Error Correction Register                           */

    struct {
      __IOM uint32_t OECVAL     : 16;           /* [15..0] Offset Error Correction Value                                     */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } OEC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000A0) User defined Offset Error Correction Value Register        */

    struct {
      __IOM uint32_t UOECVAL    : 8;            /* [7..0] User Defined Offset Error Correction Value                         */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } UOEC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000A4) X Offset Error Correction Register                         */

    struct {
      __IOM uint32_t XOECVAL    : 6;            /* [5..0] X Offset Error Correction Value                                    */
      __IM  uint32_t RESERVED0  : 26;
    } bit;
  } XOEC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000A8) Y Offset Error Correction Register                         */

    struct {
      __IOM uint32_t YOECVAL    : 8;            /* [7..0] Y Offset Error Correction Value                                    */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } YOEC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000AC) ADC Gain Error Adjustment Factor Register                  */

    struct {
      __IOM uint32_t GEAF       : 11;           /* [10..0] Gain Error Adjustment Factor                                      */
      __IM  uint32_t RESERVED0  : 21;
    } bit;
  } GEAF;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000B0) User defined Gain Error Correction Register                */

    struct {
      __IOM uint32_t UGECVAL    : 10;           /* [9..0] User defined Gain Error Correction Value                           */
      __IM  uint32_t RESERVED0  : 22;
    } bit;
  } UGEC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000B4) General Calibration Register S                             */

    struct {
      __IOM uint32_t CALVAL     : 7;            /* [6..0] Calibration Value                                                  */
      __IM  uint32_t RESERVED0  : 25;
    } bit;
  } GCALS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000B8) Plus-Side General Calibration Value Register
                                                                    x                                                          */

    struct {
      __IOM uint32_t CALVAL     : 10;           /* [9..0] Calibration Value                                                  */
      __IM  uint32_t RESERVED0  : 22;
    } bit;
  } PSGCAL3;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000BC) Plus-Side General Calibration Value Register
                                                                    x                                                          */

    struct {
      __IOM uint32_t CALVAL     : 10;           /* [9..0] Calibration Value                                                  */
      __IM  uint32_t RESERVED0  : 22;
    } bit;
  } PSGCAL2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000C0) Plus-Side General Calibration Value Register
                                                                    x                                                          */

    struct {
      __IOM uint32_t CALVAL     : 10;           /* [9..0] Calibration Value                                                  */
      __IM  uint32_t RESERVED0  : 22;
    } bit;
  } PSGCAL1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000C4) Plus-Side General Calibration Value Register
                                                                    x                                                          */

    struct {
      __IOM uint32_t CALVAL     : 10;           /* [9..0] Calibration Value                                                  */
      __IM  uint32_t RESERVED0  : 22;
    } bit;
  } PSGCAL0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000C8) Plus-Side General Calibration Value Register
                                                                    X                                                          */

    struct {
      __IOM uint32_t CALVAL     : 7;            /* [6..0] Calibration Value                                                  */
      __IM  uint32_t RESERVED0  : 25;
    } bit;
  } PSGCALX;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000CC) Plus-Side General Calibration Value Register
                                                                    9                                                          */

    struct {
      __IOM uint32_t CALVAL     : 7;            /* [6..0] CAL9                                                               */
      __IM  uint32_t RESERVED0  : 25;
    } bit;
  } PSGCAL9;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000D0) General Calibration Offset Value Register S                */

    struct {
      __IOM uint32_t COCVAL     : 4;            /* [3..0] Capacitor Offset Correction Value                                  */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } GCALOS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000D4) Plus-Side General Calibration Offset Value Register
                                                                    x                                                          */

    struct {
      __IOM uint32_t COCVAL     : 4;            /* [3..0] Capacitor Offset Correction Value                                  */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } PSGCALOV3;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000D8) Plus-Side General Calibration Offset Value Register
                                                                    x                                                          */

    struct {
      __IOM uint32_t COCVAL     : 4;            /* [3..0] Capacitor Offset Correction Value                                  */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } PSGCALOV2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000DC) Plus-Side General Calibration Offset Value Register
                                                                    x                                                          */

    struct {
      __IOM uint32_t COCVAL     : 4;            /* [3..0] Capacitor Offset Correction Value                                  */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } PSGCALOV1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000E0) Plus-Side General Calibration Offset Value Register
                                                                    x                                                          */

    struct {
      __IOM uint32_t COCVAL     : 4;            /* [3..0] Capacitor Offset Correction Value                                  */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } PSGCALOV0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000E4) Plus-Side General Calibration Offset Value Register
                                                                    x                                                          */

    struct {
      __IOM uint32_t COCVAL     : 12;           /* [11..0] Capacitor Offset Correction Value                                 */
      __IM  uint32_t RESERVED0  : 20;
    } bit;
  } PSGCALOVX;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000E8) Plus-Side General Calibration Offset Value Register
                                                                    x                                                          */

    struct {
      __IOM uint32_t COCVAL     : 12;           /* [11..0] Capacitor Offset Correction Value                                 */
      __IM  uint32_t RESERVED0  : 20;
    } bit;
  } PSGCALOV9;

  __IM  uint32_t  RESERVED0[7];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000108) Control and Status Register 1x                             */

    struct {
      __IOM uint32_t ICHSEL     : 6;            /* [5..0] Input Channel Select                                               */
      __IOM uint32_t CCIEN      : 1;            /* [6..6] Conversion Complete Interrupt Enable                               */
      __IM  uint32_t CCFLG      : 1;            /* [7..7] Input Clock Source Select                                          */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } ACSTS1[ADC_ACSTS1_COUNT];
  __IM  uint32_t  RESERVED1[8];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000188) Plus-Side General Calibration Offset Value Register x      */

    struct {
      __IOM uint32_t DATA       : 12;           /* [11..0] Data result                                 */
      __IM  uint32_t RESERVED0  : 20;
    } bit;
  } ADATA[ADC_ADATA_COUNT];

} ADC_T;                                    /*                                                          */


/* =========================================================================================================================== */
/* ================                                          LPSPI                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief The LPSPI Memory Map/Register Definition can be found here. (LPSPI)
  */

typedef struct {                                /*  LPSPI Structure
                                                   (@ 0x4002C000)LPSPI0 (@ 0x4002D000)LPSPI1 (@ 0x4002E000)LPSPI2            */

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000000) Version ID Register                                        */

    struct {
      __IM  uint32_t FEATURE    : 16;           /* [15..0] Feature Number                                                    */
      __IM  uint32_t MINOR      : 8;            /* [23..16] Minor Version Number                                             */
      __IM  uint32_t MAJOR      : 8;            /* [31..24] Major Version Number                                             */
    } bit;
  } VERID;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000004) Parameter Register                                         */

    struct {
      __IM  uint32_t TXFSSET    : 8;            /* [7..0] Transmit FIFO Size Set                                             */
      __IM  uint32_t RXFSSET    : 8;            /* [15..8] Receive FIFO Size Set                                             */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } PARA;
  __IM  uint32_t  RESERVED[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) Control Register                                           */

    struct {
      __IOM uint32_t MEN        : 1;            /* [0..0] Module Enable                                                      */
      __IOM uint32_t SWRST      : 1;            /* [1..1] Software Reset                                                     */
      __IOM uint32_t DOZEDIS    : 1;            /* [2..2] Disable LPSPI in Doze Mode                                         */
      __IOM uint32_t DBGEN      : 1;            /* [3..3] Enable LPSPI in Debug Mode                                         */
      __IM  uint32_t RESERVED0  : 4;
      __OM  uint32_t TXFRST     : 1;            /* [8..8] Transmit FIFO Reset                                                */
      __OM  uint32_t RXFRST     : 1;            /* [9..9] Receive FIFO Reset                                                 */
      __IM  uint32_t RESERVED1  : 22;
    } bit;
  } CTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000014) Status Register                                            */

    struct {
      __IM  uint32_t TXDATAFLG  : 1;            /* [0..0] Transmit Data Flag                                                 */
      __IM  uint32_t RXDATAFLG  : 1;            /* [1..1] Receive Data Flag                                                  */
      __IM  uint32_t RESERVED0  : 6;
      __IOM uint32_t RXWCFLG    : 1;            /* [8..8] Received Word Complete Flag                                        */
      __IOM uint32_t FTXCFLG    : 1;            /* [9..9] Frame Complete Flag                                                */
      __IOM uint32_t TXCFLG     : 1;            /* [10..10] Transfer Complete Flag                                           */
      __IOM uint32_t TXEFLG     : 1;            /* [11..11] Transmit Error Flag                                              */
      __IOM uint32_t RXEFLG     : 1;            /* [12..12] Receive Error Flag                                               */
      __IOM uint32_t RXMFLG     : 1;            /* [13..13] Receive Data Match Flag                                          */
      __IM  uint32_t RESERVED1  : 10;
      __IM  uint32_t BSYFLG     : 1;            /* [24..24] LPSPI Busy Flag                                                  */
      __IM  uint32_t RESERVED2  : 7;
    } bit;
  } STS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) Interrupt Enable Register                                  */

    struct {
      __IOM uint32_t TXIEN      : 1;            /* [0..0] Transmit Data Interrupt Enable                                     */
      __IOM uint32_t RXIEN      : 1;            /* [1..1] Receive Data Interrupt Enable                                      */
      __IM  uint32_t RESERVED0  : 6;
      __IOM uint32_t RXWCIEN    : 1;            /* [8..8] Receive Word Complete Interrupt Enable                             */
      __IOM uint32_t FTCIEN     : 1;            /* [9..9] Frame Transfer Complete Interrupt Enable                           */
      __IOM uint32_t TXCIEN     : 1;            /* [10..10] Transfer Complete Interrupt Enable                               */
      __IOM uint32_t TXEIEN     : 1;            /* [11..11] Transmit Error Interrupt Enable                                  */
      __IOM uint32_t RXEIEN     : 1;            /* [12..12] Receive Error Interrupt Enable                                   */
      __IOM uint32_t RXMIEN     : 1;            /* [13..13] Receive Data Match Interrupt Enable                              */
      __IM  uint32_t RESERVED1  : 18;
    } bit;
  } IEN;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000001C) DMA Enable Register                                        */

    struct {
      __IOM uint32_t TXDMAEN    : 1;            /* [0..0] Transmit Data DMA Enable                                           */
      __IOM uint32_t RXDMAEN    : 1;            /* [1..1] Receive Data DMA Enable                                            */
      __IM  uint32_t RESERVED0  : 30;
    } bit;
  } DMAEN;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000020) Configure Register 0                                       */

    struct {
      __IOM uint32_t HREQEN     : 1;            /* [0..0] Host Request Enable                                                */
      __IOM uint32_t HREQPCFG   : 1;            /* [1..1] Host Request Polarity Configure                                    */
      __IOM uint32_t HREQISEL   : 1;            /* [2..2] Host Request Input Select                                          */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t CIRFEN     : 1;            /* [8..8] Circular FIFO Enable                                               */
      __IOM uint32_t RXMOEN     : 1;            /* [9..9] Receive Data Match Only Enable                                     */
      __IM  uint32_t RESERVED1  : 22;
    } bit;
  } CFG0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000024) Configure Register 1                                       */

    struct {
      __IOM uint32_t MSCFG      : 1;            /* [0..0] Master/Slave Mode Configure                                        */
      __IOM uint32_t IDSPCFG    : 1;            /* [1..1] Input Data Sample Point Configure                                  */
      __IOM uint32_t APCSEN     : 1;            /* [2..2] Automatic PCS Enable                                               */
      __IOM uint32_t DISTXS     : 1;            /* [3..3] Disable Transmit Stop                                              */
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t PCSPPCFG   : 4;            /* [11..8] Peripheral Chip Select Pin Polarity Configure                     */
      __IM  uint32_t RESERVED1  : 4;
      __IOM uint32_t MCFG       : 3;            /* [18..16] Match Configure                                                  */
      __IM  uint32_t RESERVED2  : 5;
      __IOM uint32_t IOPCFG     : 2;            /* [25..24] Input/Output Pin Configure                                       */
      __IOM uint32_t ODCFG      : 1;            /* [26..26] Output Data Configure                                            */
      __IOM uint32_t PCSELCFG   : 1;            /* [27..27] Peripheral Chip Select Configure                                 */
      __IM  uint32_t RESERVED3  : 4;
    } bit;
  } CFG1;
  __IM  uint32_t  RESERVED1[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000030) Data Match Register 0                                      */

    struct {
      __IOM uint32_t COMPVAL0   : 32;           /* [31..0] Match 0 Value                                                     */
    } bit;
  } DATAM0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000034) Data Match Register 1                                      */

    struct {
      __IOM uint32_t COMPVAL1   : 32;           /* [31..0] Compare Match 1 Value                                             */
    } bit;
  } DATAM1;
  __IM  uint32_t  RESERVED2[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000040) Clock Configure Register                                   */

    struct {
      __IOM uint32_t SCKDRCFG   : 8;            /* [7..0] SCK Divide Ratio Configure                                         */
      __IOM uint32_t TXDCFG     : 8;            /* [15..8] Transfers Delay Configure                                         */
      __IOM uint32_t PSDCFG     : 8;            /* [23..16] PCS-to-SCK Delay Configure                                       */
      __IOM uint32_t SPDCFG     : 8;            /* [31..24] SCK-to-PCS Delay Configure                                       */
    } bit;
  } CLKCFG;
  __IM  uint32_t  RESERVED3[5];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000058) FIFO Control Register                                      */

    struct {
      __IOM uint32_t TXFW       : 2;            /* [1..0] Transmit FIFO Watermark                                            */
      __IM  uint32_t RESERVED0  : 14;
      __IOM uint32_t RXFW       : 2;            /* [17..16] Receive FIFO Watermark                                           */
      __IM  uint32_t RESERVED1  : 14;
    } bit;
  } FCTRL;

  union {
    __IM  uint32_t reg;                         /* (@ 0x0000005C) FIFO Status Register                                       */

    struct {
      __IM  uint32_t TXFCNT     : 3;            /* [2..0] Transmit FIFO Count                                                */
      __IM  uint32_t RESERVED0  : 13;
      __IM  uint32_t RXFCNT     : 3;            /* [18..16] Receive FIFO Count                                               */
      __IM  uint32_t RESERVED1  : 13;
    } bit;
  } FSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000060) Transmit Command Register                                  */

    struct {
      __IOM uint32_t FSCFG      : 12;           /* [11..0] Frame Size Configure                                              */
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t TXWIDCFG   : 2;            /* [17..16] Transfer Width Configure                                         */
      __IOM uint32_t TXDATAMASK : 1;            /* [18..18] Transmit Data Mask                                               */
      __IOM uint32_t RXDATAMASK : 1;            /* [19..19] Receive Data Mask                                                */
      __IOM uint32_t CTXCMDW    : 1;            /* [20..20] Continuing Transfer Command Word                                 */
      __IOM uint32_t CTXEN      : 1;            /* [21..21] Continuous Transfer Enable                                       */
      __IOM uint32_t BSEN       : 1;            /* [22..22] Byte Swap Enable                                                 */
      __IOM uint32_t DATAFSEL   : 1;            /* [23..23] Data First Select                                                */
      __IOM uint32_t PCSEL      : 2;            /* [25..24] Peripheral Chip Select                                           */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t PVALCFG    : 3;            /* [29..27] Prescaler Value Configure                                        */
      __IOM uint32_t CLKPHA     : 1;            /* [30..30] Clock Phase Configure                                            */
      __IOM uint32_t CLKPOL     : 1;            /* [31..31] Clock Polarity Configure                                         */
    } bit;
  } TXCMD;

  union {
    __OM  uint32_t reg;                         /* (@ 0x00000064) Transmit Data Register                                     */

    struct {
      __OM  uint32_t TXDATA     : 32;           /* [31..0] Transmit Data                                                     */
    } bit;
  } TXDATA;
  __IM  uint32_t  RESERVED4[2];

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000070) Receive Status Register                                    */

    struct {
      __IM  uint32_t FDATAWCFG  : 1;            /* [0..0] First Data Word Configure                                          */
      __IM  uint32_t RXFE       : 1;            /* [1..1] Receive FIFO Empty                                                 */
      __IM  uint32_t RESERVED0  : 30;
    } bit;
  } RXSTS;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000074) Receive Data Register                                      */

    struct {
      __IM  uint32_t RXDATA     : 32;           /* [31..0] Receive Data                                                      */
    } bit;
  } RXDATA;
} LPSPI_T;                                  /* Size = 120 (0x78)                                                             */



/* =========================================================================================================================== */
/* ================                                           PDU                                            ================ */
/* =========================================================================================================================== */

/** PDU - Size of Registers Arrays */
#define PDU_CH_COUNT                            3u
#define PDU_CH_DELAY_COUNT                      8u
#define PDU_PODLY_COUNT                         1u

/**
  * @brief Programmable Delay Unit (PDU)
  */

typedef struct {                                /*  PDU Structure  (@ 0x40036000)PDU0 (@ 0x40031000)PDU1                     */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Control and Status register                                */

    struct {
      __IOM uint32_t LDSUS      : 1;            /* [0..0] Load Success                                                       */
      __IOM uint32_t CMODEN     : 1;            /* [1..1] PDU in Continuous Mode Enable                                      */
      __IOM uint32_t MULPSCCFG  : 2;            /* [3..2] Multiplication Factor Prescaler Configure                          */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t IEN        : 1;            /* [5..5] Interrupt Enable                                                   */
      __IOM uint32_t IFLG       : 1;            /* [6..6] Interrupt Flag                                                     */
      __IOM uint32_t PDUEN      : 1;            /* [7..7] PDU Enable                                                         */
      __IOM uint32_t TRGINTSEL  : 4;            /* [11..8] Trigger Input Source Select                                       */
      __IOM uint32_t PSCDIVCFG  : 3;            /* [14..12] Prescaler Divider Configure                                      */
      __IOM uint32_t DMAEN      : 1;            /* [15..15] DMA Enable                                                       */
      __OM  uint32_t SWTRGSEL   : 1;            /* [16..16] Software Trigger Select                                          */
      __IOM uint32_t SEQEIEN    : 1;            /* [17..17] Sequence Error Interrupt Enable                                  */
      __IOM uint32_t LDMODSEL   : 2;            /* [19..18] Load Mode Select                                                 */
      __IM  uint32_t RESERVED1  : 12;
    } bit;
  } CSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) Counter Period register                                    */

    struct {
      __IOM uint32_t CNTPRD     : 16;           /* [15..0] Counter Period                                                    */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } CNTPRD;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000008) Counter Contains Current Value register                    */

    struct {
      __IM  uint32_t CNTCUR     : 16;           /* [15..0] Counter Contains Current Value                                    */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } CNTCUR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) Scheduling Interrupt Delay Value register                  */

    struct {
      __IOM uint32_t SINTDLY    : 16;           /* [15..0] Scheduling Interrupt Delay Value                                  */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } SINTDLY;

  struct {
    union {
      __IOM uint32_t reg;                         /* (@ 0x00000010) Channel n Control register 1                             */

      struct {
        __IOM uint32_t CHPTOEN    : 8;            /* [7..0] Channel Pre-Trigger Output Enable                                */
        __IOM uint32_t CHPTOSEL   : 8;            /* [15..8] Channel Pre-Trigger Output Select                               */
        __IOM uint32_t PTBBEN     : 8;            /* [23..16] Pre-Trigger Back-to-Back Operation Enable                      */
        __IM  uint32_t RESERVED0  : 8;
      } bit;
    } CTRL1;

    union {
      __IOM uint32_t reg;                         /* (@ 0x00000014) Channel n Status register                                */

      struct {
        __IOM uint32_t CHPTEFLG   : 8;            /* [7..0] Channel Pre-trigger Sequence Error Flags                         */
        __IM  uint32_t RESERVED0  : 8;
        __IOM uint32_t CHFLG      : 8;            /* [23..16] Channel Flags                                                  */
        __IM  uint32_t RESERVED1  : 8;
      } bit;
    } STS;

    union {
      __IOM uint32_t reg;                         /* (@ 0x00000018) Channel n Delay 0 register                               */

      struct {
        __IOM uint32_t CHPTDLY    : 16;           /* [15..0] Channel Pre-trigger Delay Value                                 */
        __IM  uint32_t RESERVED0  : 16;
      } bit;
    } D[PDU_CH_DELAY_COUNT];
  } CH[PDU_CH_COUNT];

  __IM  uint32_t  RESERVED[66];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000190) Pulse-Out Enable register                                  */

    struct {
      __IOM uint32_t POEN       : 8;            /* [7..0] Pulse Output Enble                                                 */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } POEN;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000194) Pulse-Out Delay register                                   */

    struct {
      __IOM uint32_t PODLY2     : 16;           /* [15..0] Pulse Output Delay 2 Value                                        */
      __IOM uint32_t PODLY1     : 16;           /* [31..16] Pulse Output Delay 1 Value                                       */
    } bit;
  } PODLY[PDU_PODLY_COUNT];
} PDU_T;                                    /* Size = 408 (0x198)                                                            */



/* =========================================================================================================================== */
/* ================                                            CRC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Cyclic Redundancy Check (CRC)
  */

typedef struct {                                /* (@ 0x40032000) CRC Structure                                              */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Data register                                              */

    struct {
      __IOM uint32_t LBLB       : 8;            /* [7..0] CRC Low 16Bit Lower Byte                                           */
      __IOM uint32_t LBHB       : 8;            /* [15..8] Low 16 Bit Higher Byte                                            */
      __IOM uint32_t HBLB       : 8;            /* [23..16] High 16Bit Lower Byte                                            */
      __IOM uint32_t HBUB       : 8;            /* [31..24] High 16 Bit Higher Byte                                          */
    } bit;
  } DATA;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) Polynomial register                                        */

    struct {
      __IOM uint32_t LOWPOL     : 16;           /* [15..0] Low 16 Bit Polynominal                                            */
      __IOM uint32_t HIGHPOL    : 16;           /* [31..16] High 16 Bit Polynominal                                          */
    } bit;
  } POLY;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) Control register                                           */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t WIDCRCP    : 1;            /* [24..24] Width of CRC Protocol                                            */
      __IOM uint32_t WASVAL     : 1;            /* [25..25] Write CRC Data Register As Seed Value                            */
      __IOM uint32_t XOR_RDATA  : 1;            /* [26..26] Invert/Complement Read of CRC Data Register                      */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TTRSEL     : 2;            /* [29..28] Type of Transpose For Read Select                                */
      __IOM uint32_t TTWSEL     : 2;            /* [31..30] Type of Transpose For Writes Select                              */
    } bit;
  } CTRL;
} CRC_T;                                     /* Size = 12 (0xc)                                                              */



/* =========================================================================================================================== */
/* ================                                          LPITMR                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Low Power Periodic Interrupt Timer (LPITMR)
  */

/** LPITMR - Size of Registers Arrays */
#define LPITMR_TMR_COUNT                           4U

/** LPITMR - Register Layout Typedef */
typedef struct {                                /*  (@ 0x40037000) LPITMR Structure                                          */
  union {
    __IM  uint32_t reg;                         /* (@ 0x00000000) Version ID Register                                        */

    struct {
      __IM  uint32_t FEATURE    : 16;           /* [15..0] Feature Support Number                                            */
      __IM  uint32_t MINOR      : 8;            /* [23..16] Minor Version Number                                             */
      __IM  uint32_t MAJOR      : 8;            /* [31..24] Major Version Number                                             */
    } bit;
  } VERID;
  union {
    __IM  uint32_t reg;                         /* (@ 0x00000004) Parameter Register                                         */

    struct {
      __IM  uint32_t NUMTMRCH   : 8;            /* [7..0] Number of Timer Channels                                           */
      __IM  uint32_t NUMETRG    : 8;            /* [15..8] Number of External Triggers                                       */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } PARA;
  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) Module Control Register                                    */

    struct {
      __IOM uint32_t PCLKTMREN  : 1;            /* [0..0] Peripheral Clock Timer Enable                                      */
      __IOM uint32_t SWRET      : 1;            /* [1..1] Software Reset                                                     */
      __IOM uint32_t DOZEEN     : 1;            /* [2..2] Enable timer channels run in doze mode                             */
      __IOM uint32_t DBGEN      : 1;            /* [3..3] Enable timer channels run in Debug Mode                            */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } MCTRL;
  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) Module Status Register                                     */

    struct {
      __IOM uint32_t TITFLG0    : 1;            /* [0..0] Channel 0 Timer Interrupt Timeout Flag                             */
      __IOM uint32_t TITFLG1    : 1;            /* [1..1] Channel 1 Timer Interrupt Timeout Flag                             */
      __IOM uint32_t TITFLG2    : 1;            /* [2..2] Channel 2 Timer Interrupt Timeout Flag                             */
      __IOM uint32_t TITFLG3    : 1;            /* [3..3] Channel 3 Timer Interrupt Timeout Flag                             */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } MSTS;
  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) Module Interrupt Enable Register                           */

    struct {
      __IOM uint32_t TIEN0      : 1;            /* [0..0] Channel 0 Timer Interrupt Enable                                   */
      __IOM uint32_t TIEN1      : 1;            /* [1..1] Channel 1 Timer Interrupt Enable                                   */
      __IOM uint32_t TIEN2      : 1;            /* [2..2] Channel 2 Timer Interrupt Enable                                   */
      __IOM uint32_t TIEN3      : 1;            /* [3..3] Channel 3 Timer Interrupt Enable                                   */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } MIEN;
  union {
    __IOM uint32_t reg;                         /* (@ 0x00000014) Set Timer Enable Register                                  */

    struct {
      __IOM uint32_t TENCH0     : 1;            /* [0..0] Timer Channel 0 Enable                                             */
      __IOM uint32_t TENCH1     : 1;            /* [1..1] Timer Channel 1 Enable                                             */
      __IOM uint32_t TENCH2     : 1;            /* [2..2] Timer Channel 2 Enable                                             */
      __IOM uint32_t TENCH3     : 1;            /* [3..3] Timer Channel 3 Enable                                             */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } STMREN;
  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) Clear Timer Enable Register                                */

    struct {
      __OM  uint32_t CLRTMREN0  : 1;            /* [0..0] Clear Timer Channel 0 Enable                                       */
      __OM  uint32_t CLRTMREN1  : 1;            /* [1..1] Clear Timer Channel 1 Enable                                       */
      __OM  uint32_t CLRTMREN2  : 1;            /* [2..2] Clear Timer Channel 2 Enable                                       */
      __OM  uint32_t CLRTMREN3  : 1;            /* [3..3] Clear Timer Channel 3 Enable                                       */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } CLRTMREN;

   uint8_t RESERVED_0[4];

  struct {                                         /* offset: 0x20, array step: 0x10 */
      union {
        __IOM uint32_t reg;                         /* (@ 0x00000020) Timer Value Register 0                                     */

        struct {
          __IOM uint32_t TMRV       : 32;           /* [31..0] Timer Value                                                       */
        } bit;
      } TMRV;

      union {
        __IM  uint32_t reg;                         /* (@ 0x00000024) Current Timer Value 0                                      */

        struct {
          __IM  uint32_t CTMRV      : 32;           /* [31..0] Current Timer Value                                               */
        } bit;
      } CTMRV;

      union {
        __IOM uint32_t reg;                         /* (@ 0x00000028) Timer Control Register 0                                   */

        struct {
          __IOM uint32_t TMREN      : 1;            /* [0..0] Timer Channel Enable                                               */
          __IOM uint32_t CHAINEN    : 1;            /* [1..1] Channel Chain Enable                                               */
          __IOM uint32_t TMROMCFG   : 2;            /* [3..2] Timer Operation Mode Configure                                     */
          __IM  uint32_t RESERVED0  : 12;
          __IOM uint32_t TMRDCTRL   : 1;            /* [16..16] Timer Decrement Control                                          */
          __IOM uint32_t TMRTOSCTRL : 1;            /* [17..17] Timer Timeout Stop Control                                       */
          __IOM uint32_t TMRRCTRL   : 1;            /* [18..18] Timer Reload Control                                             */
          __IM  uint32_t RESERVED1  : 4;
          __IOM uint32_t TRGSSEL    : 1;            /* [23..23] Trigger Source Select                                            */
          __IOM uint32_t TRGSEL     : 4;            /* [27..24] Trigger Select                                                   */
          __IM  uint32_t RESERVED2  : 4;
        } bit;
      } TMRCTRL;
      uint8_t RESERVED_0[4];
  } TMR[LPITMR_TMR_COUNT];

} LPITMR_T;


/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Real-time clock (RTC)
  */

typedef struct {                                /* (@ 0x4003D000) RTC Structure                                              */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) RTC Time Seconds Register                                  */

    struct {
      __IOM uint32_t TIMSEC     : 32;           /* [31..0] Time Seconds bit                                                  */
    } bit;
  } TIMSEC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) RTC Time Prescaler Register                                */

    struct {
      __IOM uint32_t TIMPSC     : 16;           /* [15..0] Time Prescaler                                                    */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } TIMPSC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) RTC Time Alarm Register                                    */

    struct {
      __IOM uint32_t TIMALR     : 32;           /* [31..0] Time Alarm bit                                                    */
    } bit;
  } TIMALR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) RTC Time Compensation Register                             */

    struct {
      __IOM uint32_t TIMCCFG    : 8;            /* [7..0] Time Compensation Configure                                        */
      __IOM uint32_t CICFG      : 8;            /* [15..8] Compensation Interval Configure                                   */
      __IM  uint32_t TIMCVSET   : 8;            /* [23..16] Time Compensation Value set                                      */
      __IM  uint32_t CICNT      : 8;            /* [31..24] Compensation Interval Counter                                    */
    } bit;
  } TIMC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) RTC Control Register                                       */

    struct {
      __IOM uint32_t SWREN      : 1;            /* [0..0] Software Reset Enable                                              */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t SACCCTRL   : 1;            /* [2..2] Supervisor Access Control                                          */
      __IOM uint32_t UMEN       : 1;            /* [3..3] Update Mode Enable                                                 */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t CLKPOSEL   : 1;            /* [5..5] Clock Pin Output Select                                            */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t LPOCSEL    : 1;            /* [7..7] LPO Clock Sclect                                                   */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t CLKOOUTEN  : 1;            /* [9..9] Clock Output Enable                                                */
      __IM  uint32_t RESERVED4  : 14;
      __IOM uint32_t CLKPEN     : 1;            /* [24..24] Clock Pin Enable                                                 */
      __IM  uint32_t RESERVED5  : 7;
    } bit;
  } CTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000014) RTC Status Register                                        */

    struct {
      __IM  uint32_t TIMINVFLG  : 1;            /* [0..0] Time Invalid Flag                                                  */
      __IM  uint32_t TIMOVRFLG  : 1;            /* [1..1] Time Overflow Flag                                                 */
      __IM  uint32_t TIMALRFLG  : 1;            /* [2..2] Time Alarm Flag                                                    */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t TIMCNTEN   : 1;            /* [4..4] Time Counter Enable                                                */
      __IM  uint32_t RESERVED1  : 27;
    } bit;
  } STS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) RTC Lock Register                                          */

    struct {
      __IM  uint32_t RESERVED0  : 3;
      __IOM uint32_t TIMCPRO    : 1;            /* [3..3] Time Compensation Protect                                          */
      __IOM uint32_t CTRLPRO    : 1;            /* [4..4] Control Register Protect                                           */
      __IOM uint32_t STSPRO     : 1;            /* [5..5] Status Register Protect                                            */
      __IOM uint32_t LOCKPRO    : 1;            /* [6..6] Lock Register Protect                                              */
      __IM  uint32_t RESERVED1  : 25;
    } bit;
  } LOCK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000001C) RTC Interrupt Enable Register                              */

    struct {
      __IOM uint32_t INVIEN     : 1;            /* [0..0] Invalid Interrupt Enable                                           */
      __IOM uint32_t OVRIEN     : 1;            /* [1..1] Overflow Interrupt Enable                                          */
      __IOM uint32_t ALRIEN     : 1;            /* [2..2] Alarm Interrupt Enable                                             */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t SECIEN     : 1;            /* [4..4] Second Interrupt Enable                                            */
      __IM  uint32_t RESERVED1  : 11;
      __IOM uint32_t TSECICFG   : 3;            /* [18..16] Timer Seconds Interrupt Frequency Configure                      */
      __IM  uint32_t RESERVED2  : 13;
    } bit;
  } IEN;
} RTC_T;                                     /* Size = 32 (0x20)                                                             */



/* =========================================================================================================================== */
/* ================                                           LPTMR                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Low Power Timer (LPTMR)
  */

typedef struct {                                /* (@ 0x40040000) LPTMR Structure                                            */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Control Status Register                                    */

    struct {
      __IOM uint32_t LPTMREN    : 1;            /* [0..0] LPTMR Enable                                                       */
      __IOM uint32_t TMRMCFG    : 1;            /* [1..1] Timer Mode Configure                                               */
      __IOM uint32_t FRCNT      : 1;            /* [2..2] Free-Running Counter                                               */
      __IOM uint32_t TPIMSEL    : 1;            /* [3..3] Timer Pin Input Mode Select                                        */
      __IOM uint32_t TPISEL     : 2;            /* [5..4] Timer Pin Input Select                                             */
      __IOM uint32_t IEN        : 1;            /* [6..6] Interrupt Enable                                                   */
      __IOM uint32_t COMFLG     : 1;            /* [7..7] Compare Flag                                                       */
      __IOM uint32_t DMAREN     : 1;            /* [8..8] DMA Request Enable                                                 */
      __IM  uint32_t RESERVED0  : 23;
    } bit;
  } CSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) Prescaler/Glitch Filter Register                          */

    struct {
      __IOM uint32_t PCLKSEL    : 2;            /* [1..0] Prescaler/Glitch Filter Clock Select                               */
      __IOM uint32_t PBYPEN     : 1;            /* [2..2] Prescaler/Glitch Filter Bypass Enable                              */
      __IOM uint32_t PVCFG      : 4;            /* [6..3] Prescaler/Glitch Filter Value Configure                            */
      __IM  uint32_t RESERVED0  : 25;
    } bit;
  } PSC;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) Compare Register                                           */

    struct {
      __IOM uint32_t COMVAL     : 16;           /* [15..0] Compare Value                                                     */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } COM;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) Counter Register                                           */

    struct {
      __IOM uint32_t CNTVAL     : 16;           /* [15..0] Counter Value                                                     */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } CNT;
} LPTMR_T;                                   /* Size = 16 (0x10)                                                             */



/* =========================================================================================================================== */
/* ================                                            SIM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief System Integration Management (SIM)
  */

typedef struct {                                /* (@ 0x40048000) SIM Structure                                              */
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) Chip Control register                                      */

    struct {
      __IOM uint32_t ADCIPSEL   : 4;            /* [3..0] ADC Interleave Pins Select                                         */
      __IOM uint32_t CLKOUTSEL  : 4;            /* [7..4] Clock Output Select                                                */
      __IOM uint32_t CLKOUTDIVCFG : 3;          /* [10..8] Clock Output Divide Ratio Configure                               */
      __IOM uint32_t CLKOUTEN   : 1;            /* [11..11] Clock Output Enable                                              */
      __IOM uint32_t TRACECLKSEL : 1;           /* [12..12] Trace Clock Source Select                                        */
      __IOM uint32_t PDUBBMSEL  : 1;            /* [13..13] PDU Back-to-Back Mode Select                                     */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t ADCSSEL    : 3;            /* [18..16] ADC Supply Select                                                */
      __IOM uint32_t ADCISMEN   : 1;            /* [19..19] ADC Internal Supply Monitoring Enable                            */
      __IOM uint32_t SRAMHREN   : 1;            /* [20..20] SRAMU Retention Enable                                           */
      __IOM uint32_t SRAMLREN   : 1;            /* [21..21] SRAML Retention Enable                                           */
      __IM  uint32_t RESERVED1  : 10;
    } bit;
  } CHIPCTRL;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) CFGTMR Option Register 0                                     */
    struct {
      __IOM uint32_t CFGTMR0FSxSEL : 3;            /* [2..0] CFGTMR0 Fault Source x Select                                       */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t CFGTMR1FSxSEL : 3;            /* [6..4] CFGTMR1 Fault Source x Select                                       */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t CFGTMR2FSxSEL : 3;            /* [10..8] CFGTMR2 Fault Source x Select                                      */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t CFGTMR3FSxSEL : 3;            /* [14..12] CFGTMR3 Fault Source x Select                                     */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t CFGTMR4EXCLKPINSEL : 2;       /* [17..16] CFGTMR4 External Clock Pin Select                               */
      __IOM uint32_t CFGTMR5EXCLKPINSEL : 2;       /* [19..18] CFGTMR5 External Clock Pin Select                               */
      __IM  uint32_t RESERVED4  : 4;
      __IOM uint32_t CFGTMR0EXCLKPINSEL : 2;      /* [25..24] CFGTMR0 External Clock Pin Select                                  */
      __IOM uint32_t CFGTMR1EXCLKPINSEL : 2;      /* [27..26] CFGTMR1 External Clock Pin Select                                  */
      __IOM uint32_t CFGTMR2EXCLKPINSEL : 2;      /* [29..28] CFGTMR2 External Clock Pin Select                                  */
      __IOM uint32_t CFGTMR3EXCLKPINSEL : 2;      /* [31..30] CFGTMR3 External Clock Pin Select                                  */
    } bit;
  } CFGTMROPT0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) LPO Clock Select Register                                  */

    struct {
      __IOM uint32_t LPO1KCLKOEN : 1;           /* [0..0] 1 kHz LPOCLK Output Enable                                        */
      __IOM uint32_t LPO32KCLKOEN : 1;          /* [1..1] 32 kHz LPOCLK Output Enable                                       */
      __IOM uint32_t CLKLPOSSEL : 2;            /* [3..2] Peripherals LPO Clock Source Select                                */
      __IOM uint32_t CLK32KSSEL : 2;            /* [5..4] Peripherals 32 kHz Clock Source Select                             */
      __IM  uint32_t RESERVED0  : 26;
    } bit;
  } LPOCLKSEL;
  __IM  uint32_t  RESERVED2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) ADC Options Register                                       */

    struct {
      __IOM uint32_t ADC0TRGSSEL : 1;           /* [0..0] ADC0 Trigger Source Select                                         */
      __IOM uint32_t ADC0SWPTSEL : 3;           /* [3..1] ADC0 Software Pretrigger Sources Select                            */
      __IOM uint32_t ADC0PTSSEL : 2;            /* [5..4] ADC0 Pretrigger Source Select                                      */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t ADC1TRGSSEL : 1;           /* [8..8] ADC1 Trigger Source Select                                         */
      __IOM uint32_t ADC1SWPTSEL : 3;           /* [11..9] ADC1 Software Pretrigger Sources Select                           */
      __IOM uint32_t ADC1PTSSEL : 2;            /* [13..12] ADC1 Pretrigger Source Select                                    */
      __IM  uint32_t RESERVED1  : 18;
    } bit;
  } ADCOPT;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000001C) CFGTMR Option Register 1                                     */

    struct {
      __IOM uint32_t CFGTMR0SYNC  : 1;            /* [0..0] CFGTMR0 Synchronization                                              */
      __IOM uint32_t CFGTMR1SYNC  : 1;            /* [1..1] CFGTMR1 Synchronization                                              */
      __IOM uint32_t CFGTMR2SYNC  : 1;            /* [2..2] CFGTMR2 Synchronization                                              */
      __IOM uint32_t CFGTMR3SYNC  : 1;            /* [3..3] CFGTMR3 Synchronization                                              */
      __IOM uint32_t CFGTMR1CH0ISEL : 2;          /* [5..4] CFGTMR1 CH0 Input Select                                             */
      __IOM uint32_t CFGTMR2CH0ISEL : 2;          /* [7..6] CFGTMR2 CH1 Input Select                                             */
      __IOM uint32_t CFGTMR2CH1ISEL : 1;          /* [8..8] CFGTMR2 CH1 Input Select                                             */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t CFGTMR4SYNC  : 1;          /* [11..11] CFGTMR4 Synchronization                                              */
      __IOM uint32_t CFGTMR5SYNC  : 1;          /* [12..12] CFGTMR5 Synchronization                                              */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t CFGTMRGLDMEN : 1;            /* [15..15] CFGTMR Global Load Mechanism Enable                                */
      __IOM uint32_t CFGTMR0MEN   : 8;            /* [23..16] CFGTMR0 Modulation with CFGTMR1_CH1 Enable                           */
      __IOM uint32_t CFGTMR3MEN   : 8;            /* [31..24] CFGTMR3 Modulation with CFGTMR2_CH1 Enable                           */
    } bit;
  } CFGTMROPT1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000020) Miscellaneous control register 0                           */

    struct {
      __IM  uint32_t RESERVED0  : 9;
      __IOM uint32_t STOP1MON   : 1;            /* [9..9] STOP1 Monitor                                                      */
      __IOM uint32_t STOP2MON   : 1;            /* [10..10] STOP2 Monitor                                                    */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t CFGTMRSTBEN_D : 1;           /* [14..14] CFGTMR Split Time Base Enable/Disable                              */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t CFGTMR0OBECTRL : 1;          /* [16..16] CFGTMR0 OBE Control                                                */
      __IOM uint32_t CFGTMR1OBECTRL : 1;          /* [17..17] CFGTMR1 OBE Control                                                */
      __IOM uint32_t CFGTMR2OBECTRL : 1;          /* [18..18] CFGTMR2 OBE Control                                                */
      __IOM uint32_t CFGTMR3OBECTRL : 1;          /* [19..19] CFGTMR3 OBE Control                                                */
      __IOM uint32_t CFGTMR4OBECTRL : 1;          /* [20..20] CFGTMR4 OBE Control                                                */
      __IOM uint32_t CFGTMR5OBECTRL : 1;          /* [21..21] CFGTMR5 OBE Control                                                */
      __IM  uint32_t RESERVED3  : 10;
    } bit;
  } MCTRL0;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000024) System Device Identification Register                      */

    struct {
      __IM  uint32_t CFEA       : 8;            /* [7..0] Chip Features                                                      */
      __IM  uint32_t APOC       : 4;            /* [11..8] Available Package Options for Chips                               */
      __IM  uint32_t CSIPNUM    : 4;            /* [15..12] Chip Silicon Implementation Number                               */
      __IM  uint32_t TASYSRAM   : 4;            /* [19..16] Total Available System RAM                                       */
      __IM  uint32_t CDER       : 4;            /* [23..20] Chip Derivate                                                    */
      __IM  uint32_t CSUB       : 4;            /* [27..24] Chip Subseries                                                   */
      __IM  uint32_t CPSG       : 4;            /* [31..28] Chip Product Series Generation                                   */
    } bit;
  } SYSDEVID;
  __IM  uint32_t  RESERVED3[6];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000040) Platform Clock Gating Control Register                     */

    struct {
      __IOM uint32_t MSCCLKEN   : 1;            /* [0..0] MSC Clock Enable                                                   */
      __IOM uint32_t MPUCLKEN   : 1;            /* [1..1] MPU Clock Enable                                                   */
      __IOM uint32_t DMACLKEN   : 1;            /* [2..2] DMA Clock Gating Control                                           */
      __IOM uint32_t EREPCLKEN  : 1;            /* [3..3] EREP Clock Enable                                                  */
      __IOM uint32_t EINJCLKEN  : 1;            /* [4..4] EINJ Clock Enable                                                  */
      __IM  uint32_t RESERVED0  : 27;
    } bit;
  } PCLKGCTRL;
  __IM  uint32_t  RESERVED4[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000004C) Flash Configure Register 1                                 */

    struct {
      __IM  uint32_t RESERVED0  : 12;
      __IM  uint32_t CFGNVMP    : 4;            /* [15..12] Configurable NVM Partition                                       */
      __IM  uint32_t ERAMDS     : 4;            /* [19..16] EEPROM SRAM Data Size                                            */
      __IM  uint32_t RESERVED1  : 12;
    } bit;
  } FLASHCFG1;
  __IM  uint32_t  RESERVED5;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000054) Unique Identification127_96 Register                       */

    struct {
      __IM  uint32_t CUID96TO127 : 32;          /* [31..0] Chip Unique Identification127_96                                  */
    } bit;
  } UID127_96;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000058) Unique Identification95_64Register                         */

    struct {
      __IM  uint32_t CUID64TO95 : 32;           /* [31..0] Chip Unique Identification95_64                                   */
    } bit;
  } UID95_64;

  union {
    __IM  uint32_t reg;                         /* (@ 0x0000005C) Unique Identification63_32Register                         */

    struct {
      __IM  uint32_t CUID32TO63 : 32;           /* [31..0] Chip Unique Identification63_32                                   */
    } bit;
  } UID63_32;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000060) Unique Identification31_0Register                          */

    struct {
      __IM  uint32_t CUID0TO31  : 32;           /* [31..0] Chip Unique Identification31_0                                    */
    } bit;
  } UID31_0;
  __IM  uint32_t  RESERVED6;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000068) System Clock Divider Register 4                            */

    struct {
      __IOM uint32_t TCLKDIVNCFG : 1;           /* [0..0] Trace Fractional Clock Division Numerator Factor Configure         */
      __IOM uint32_t TCLKDIVDCFG : 3;           /* [3..1] Trace Fractional Clock Division Denominator Factor Configure       */
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t DTRACEDEN  : 1;            /* [28..28] Debug Trace Divider Enable                                       */
      __IM  uint32_t RESERVED1  : 3;
    } bit;
  } SYSCLKDIV4;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000006C) Miscellaneous Control register 1                           */

    struct {
      __IOM uint32_t TMC_PSWTR      : 1;            /* [0..0] TMC Peripheral Software Trigger                                    */
      __IM  uint32_t RESERVED0  : 31;
    } bit;
  } MCTRL1;
} SIM_T;                                     /* Size = 112 (0x70)                                                            */



/* =========================================================================================================================== */
/* ================                                            PM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Port Management (PM)
  */

typedef struct {                                /*  PM Structure
                                     (@ 0x40049000)PMA (@ 0x4004A000)PMB (@ 0x4004B000)PMC (@ 0x4004C000)PMD (@ 0x4004D000)PME */

  union {
    __IOM uint32_t reg;                     /* (@ 0x00000000) Pin Control Register x                                          */

    struct {
      __IOM uint32_t RSEL       : 1;            /* [0..0] Pullup or Pulldown Resistor Select                                 */
      __IOM uint32_t IREN       : 1;            /* [1..1] Internal Pullup or Pulldown Resistor Enable                        */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t PIFEN      : 1;            /* [4..4] Passive Input Filter Enable                                        */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t DSCFG      : 1;            /* [6..6] Drive Strength Configure                                           */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t MUXCTRL    : 3;            /* [10..8] Pin Mux Control                                                   */
      __IM  uint32_t RESERVED3  : 4;
      __IOM uint32_t LOCKCTRL   : 1;            /* [15..15] Control Register Lock                                            */
      __IOM uint32_t INTREQCFG  : 4;            /* [19..16] Interrupt Request Configure                                      */
      __IM  uint32_t RESERVED4  : 4;
      __IOM uint32_t INTFLG     : 1;            /* [24..24] Interrupt Flag                                                   */
      __IM  uint32_t RESERVED5  : 7;
    } bit;
  } PINCTRL[18];
  __IM  uint32_t  RESERVED[14];

  union {
    __OM  uint32_t reg;                         /* (@ 0x00000080) Global Pin Control Low Register                            */

    struct {
      __OM  uint32_t PINW       : 16;           /* [15..0] Global Pin Value Write                                            */
      __OM  uint32_t PINEN      : 16;           /* [31..16] Global Pin Enable                                                */
    } bit;
  } GPINCTRLL;

  union {
    __OM  uint32_t reg;                         /* (@ 0x00000084) Global Pin Control High Register                           */

    struct {
      __OM  uint32_t PINW       : 16;           /* [15..0] Global Pin Value Write                                            */
      __OM  uint32_t PINEN      : 16;           /* [31..16] Global Interrupt Enable                                          */
    } bit;
  } GPINCTRLH;

  union {
    __OM  uint32_t reg;                         /* (@ 0x00000088) Global Interrupt Control Low Register                      */

    struct {
      __OM  uint32_t INTEN     : 16;           /* [15..0] Global Interrupt Enable                                           */
      __OM  uint32_t INTW      : 16;           /* [31..16] Global Interrupt Value Write                                     */
    } bit;
  } GINTCTRLL;

  union {
    __OM  uint32_t reg;                         /* (@ 0x0000008C) Global Interrupt Control High Register                     */

    struct {
      __OM  uint32_t INTEN      : 16;           /* [15..0] Global Interrupt Enable                                           */
      __OM  uint32_t INTW       : 16;           /* [31..16] Global Interrupt Value Write                                     */
    } bit;
  } GINTCTRLH;
  __IM  uint32_t  RESERVED1[4];

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000A0) Interrupt Status Register                                  */

    struct {
      __IOM uint32_t INTFLG    : 32;           /* [31..0] Interrupt Flag                                                    */
    } bit;
  } INTSTS;
  __IM  uint32_t  RESERVED2[7];

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000C0) Digital Filter Enable Register                             */

    struct {
      __IOM uint32_t DOFEN      : 32;           /* [31..0] Digital Output Filter Enable                                      */
    } bit;
  } DFEN;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000C4) Digital Filter Clock Source Register                       */

    struct {
      __IOM uint32_t DFCLKS     : 1;            /* [0..0] Digital Filter Clock Source                                        */
      __IM  uint32_t RESERVED0  : 31;
    } bit;
  } DFCLKS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000C8) Digital Filter Length Register                             */

    struct {
      __IOM uint32_t DFWID      : 5;            /* [4..0] Digital Filter Width                                               */
      __IM  uint32_t RESERVED0  : 27;
    } bit;
  } DFWID;
} PM_T;                                     /* Size = 204 (0xcc)                                                            */



/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Software Watchdog Timer (WDT)
  */

typedef struct {                                /* (@ 0x40052000) WDT Structure                                              */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Control and Status Register                                */

    struct {
      __IOM uint32_t STOPEN     : 1;            /* [0..0] Watchdog in Stop Mode Enable                                       */
      __IOM uint32_t WEN        : 1;            /* [1..1] Watchdog in Wait Mode Enable                                       */
      __IOM uint32_t DBGEN      : 1;            /* [2..2] Watchdog in Debug Mode Enable                                      */
      __IOM uint32_t FTEN       : 2;            /* [4..3] Fast Test Enable                                                   */
      __IOM uint32_t RECFGEN    : 1;            /* [5..5] Watchdog Reconfigure Enable                                        */
      __IOM uint32_t WDTIEN     : 1;            /* [6..6] Watchdog Interrupt Enable                                          */
      __IOM uint32_t CNTEN      : 1;            /* [7..7] Watchdog Count Enable                                              */
      __IOM uint32_t CLKSRCSEL  : 2;            /* [9..8] Watchdog Clock Source Select                                       */
      __IM  uint32_t RCSUSFLG   : 1;            /* [10..10] Reconfigure Success Flag                                         */
      __IM  uint32_t ULFLG      : 1;            /* [11..11] Unlock Flag                                                      */
      __IOM uint32_t PSCEN      : 1;            /* [12..12] Prescaler Enable                                                 */
      __IOM uint32_t CMDEN32    : 1;            /* [13..13] 32-bit Refresh / UnlockCommand Write Word Enable                 */
      __IOM uint32_t WDTIFLG    : 1;            /* [14..14] Watchdog Interrupt Flag                                          */
      __IOM uint32_t WINMEN     : 1;            /* [15..15] Window Mode Enable                                               */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } CSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) Counter Register                                           */

    struct {
      __IOM uint32_t LOWCNT     : 8;            /* [7..0] Low Byte of Counter                                                */
      __IOM uint32_t HIGHCNT    : 8;            /* [15..8] High Byte of Counter                                              */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } CNT;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) Timeout Value Register                                     */

    struct {
      __IOM uint32_t LOWTOVAL   : 8;            /* [7..0] Low Byte of Timeout Value                                          */
      __IOM uint32_t HIGHTOVAL  : 8;            /* [15..8] High Byte of Timeout Value                                        */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } TOVAL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) Window Register                                            */

    struct {
      __IOM uint32_t LOWWIN     : 8;            /* [7..0] Low Byte of Window                                                 */
      __IOM uint32_t HIGHWIN    : 8;            /* [15..8] High Byte of Window                                               */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } WIN;
} WDT_T;                                     /* Size = 16 (0x10)                                                             */



/* =========================================================================================================================== */
/* ================                                            CFGIO                                        ================ */
/* =========================================================================================================================== */


/**
  * @brief I/O (CFGIO)
  */

typedef struct {                                /* (@ 0x4005A000) CFGIO Structure                                          */

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000000) Version ID Register                                        */

    struct {
      __IM  uint32_t FEATURE    : 16;           /* [15..0] Feature Number                                                    */
      __IM  uint32_t MINOR      : 8;            /* [23..16] Minor Version Number                                             */
      __IM  uint32_t MAJOR      : 8;            /* [31..24] Major Version Number                                             */
    } bit;
  } VERID;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000004) Parameter Register                                         */

    struct {
      __IM  uint32_t SHINUMI    : 8;            /* [7..0] Shifter Number Implemented                                         */
      __IM  uint32_t TMRNUMI    : 8;            /* [15..8] Timer Number Implemented                                          */
      __IM  uint32_t PNUMI      : 8;            /* [23..16] Pin Number Implemented                                           */
      __IM  uint32_t TRGNUMI    : 8;            /* [31..24] Trigger Number Implemented                                       */
    } bit;
  } PARA;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) Control Register                                           */

    struct {
      __IOM uint32_t CFGIOEN       : 1;         /* [0..0] CFGIO Module Enable                                              */
      __IOM uint32_t SWRSTEN    : 1;            /* [1..1] Software Reset Enable                                              */
      __IOM uint32_t FRACCEN    : 1;            /* [2..2] Fast Register Access Enable                                        */
      __IM  uint32_t RESERVED0  : 27;
      __IOM uint32_t DBGEN      : 1;            /* [30..30] In Debug Mode CFGIO Enable                                     */
      __IOM uint32_t DOZEEN     : 1;            /* [31..31] In Doze Mode CFGIO Enable                                      */
    } bit;
  } CTRL;

  union {
    __IM  uint32_t reg;                         /* (@ 0x0000000C) Pin Input Data Register                                    */

    struct {
      __IM  uint32_t PIDATA     : 8;            /* [7..0] Pin Input Data                                                     */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } PIDATA;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) Shifter Status Register                                    */

    struct {
      __IOM uint32_t SSTS       : 4;            /* [3..0] Shifter Status                                                     */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } SSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000014) Shifter Error Flags Register                               */

    struct {
      __IOM uint32_t SERRFLG    : 4;            /* [3..0] Shifter Error Flag                                                 */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } SERRFLG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) Timer Status Register                                      */

    struct {
      __IOM uint32_t TMRSTS     : 4;            /* [3..0] Timer Status                                                       */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } TMRSTS;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000020) Shifter Status Interrupt Enable Register                   */

    struct {
      __IOM uint32_t SSTSIEN    : 4;            /* [3..0] Shifter Status Interrupt Enable                                    */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } SSTSIEN;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000024) Shifter Error Flag Interrupt Enable Register               */

    struct {
      __IOM uint32_t SEFIEN     : 4;            /* [3..0] Shifter Error Flag Interrupt Enable                                */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } SEFIEN;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000028) Timer Status Interrupt Enable Register                     */

    struct {
      __IOM uint32_t TMRSTSIEN  : 4;            /* [3..0] Timer Status Interrupt Enable                                      */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } TMRSTSIEN;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000030) Shifter Status DMA request Enable Register                 */

    struct {
      __IOM uint32_t DMAREQEN   : 4;            /* [3..0] Shifter Status DMA Request Enable                                  */
      __IM  uint32_t RESERVED0  : 28;
    } bit;
  } DMAREQEN;
  __IM  uint32_t  RESERVED2[19];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000080) Shifter Control Register 0                                 */

    struct {
      __IOM uint32_t SMCFG      : 3;            /* [2..0] Shifter Mode Configure                                             */
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t SPPOLCFG   : 1;            /* [7..7] Shifter Pin Polarity Configure                                     */
      __IOM uint32_t SUPSEL     : 3;            /* [10..8] Shifter Use Pin Select                                            */
      __IM  uint32_t RESERVED1  : 5;
      __IOM uint32_t SOPCFG     : 2;            /* [17..16] Shifter Output Pin Configure                                     */
      __IM  uint32_t RESERVED2  : 5;
      __IOM uint32_t SCLKLCFG   : 1;            /* [23..23] Shift clock location Configure                                   */
      __IOM uint32_t TMRSEL     : 2;            /* [25..24] (Timer Select)                                                   */
      __IM  uint32_t RESERVED3  : 6;
    } bit;
  } SCTRL[4];

  __IM  uint32_t  RESERVED3[28];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000100) Shifter Configure Register 0                               */

    struct {
      __IOM uint32_t SSTAFSEL   : 2;            /* [1..0] Shifter Start Bit Function Select                                  */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t SSTOPFSEL  : 2;            /* [5..4] Shifter Stop Bit Function Select                                   */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t ISRCSEL    : 1;            /* [8..8] Input Source Select                                                */
      __IM  uint32_t RESERVED2  : 23;
    } bit;
  } SCFG[4];

  __IM  uint32_t  RESERVED4[60];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000200) Shifter Buffer Register 0                                  */

    struct {
      __IOM uint32_t SBUFDATA   : 32;           /* [31..0] Shift Buffer Data                                                 */
    } bit;
  } SBUF[4];

  __IM  uint32_t  RESERVED5[28];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000280) Shifter Buffer 0 Bit Swapped Register                      */

    struct {
      __IOM uint32_t BITSWA     : 32;           /* [31..0] Bit Swap                                                          */
    } bit;
  } SBUFBITSWA[4];

  __IM  uint32_t  RESERVED6[28];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000300) Shifter Buffer0 Byte Swapped Register                      */

    struct {
      __IOM uint32_t BYTSWA     : 32;           /* [31..0] Byte Swap                                                         */
    } bit;
  } SBUFBYTSWA[4];

  __IM  uint32_t  RESERVED7[28];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000380) Shifter Buffer0 Bit Byte Swapped Register                  */

    struct {
      __IOM uint32_t BSWAWEB    : 32;           /* [31..0] Bit Swapped Within Each Byte                                      */
    } bit;
  } SBUFBSWA[4];

  __IM  uint32_t  RESERVED8[28];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000400) Timer Control Register 0                                   */

    struct {
      __IOM uint32_t TMRMCFG    : 2;            /* [1..0] Timer Mode Configure                                               */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t TMRPPOLCFG : 1;            /* [7..7] Timer Pin Polarity Configure                                       */
      __IOM uint32_t TMRUPSEL   : 3;            /* [10..8] Timer Use Pin Select                                              */
      __IM  uint32_t RESERVED1  : 5;
      __IOM uint32_t TMROPCFG   : 2;            /* [17..16] Timer output Pin Configure                                       */
      __IM  uint32_t RESERVED2  : 4;
      __IOM uint32_t TRGSSEL    : 1;            /* [22..22] Trigger Source Select                                            */
      __IOM uint32_t TRGPOLCFG  : 1;            /* [23..23] Trigger Polarity Configure                                       */
      __IOM uint32_t TRGVSEL    : 4;            /* [27..24] Trigger Valid Value Select                                       */
      __IM  uint32_t RESERVED3  : 4;
    } bit;
  } TMRCTRL[4];

  __IM  uint32_t  RESERVED9[28];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000480) Timer Configure Register 0                                 */

    struct {
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t TMRSTAEN   : 1;            /* [1..1] Timer Start Bit Enable                                             */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t TMRSTOPFSEL : 2;           /* [5..4] Timer Stop Bit function select                                     */
      __IM  uint32_t RESERVED2  : 2;
      __IOM uint32_t TMRENCFG   : 3;            /* [10..8] Timer Enable Condition Configure                                  */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t TMRDISCFG  : 3;            /* [14..12] Timer Disable Condition Configure                                */
      __IM  uint32_t RESERVED4  : 1;
      __IOM uint32_t TMRRSTCFG  : 3;            /* [18..16] Timer Reset Condition Configure                                  */
      __IM  uint32_t RESERVED5  : 1;
      __IOM uint32_t TMRDCFG    : 2;            /* [21..20] Timer Decrement Configure                                        */
      __IM  uint32_t RESERVED6  : 2;
      __IOM uint32_t TMROCFG    : 2;            /* [25..24] Timer Output Configure                                           */
      __IM  uint32_t RESERVED7  : 6;
    } bit;
  } TMRCFG[4];

  __IM  uint32_t  RESERVED10[28];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000500) Timer Compare Register 0                                   */

    struct {
      __IOM uint32_t TMRCOMPV   : 16;           /* [15..0] Timer Compare Value                                               */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } TMRCOMP[4];
} CFGIO_T;                                      /* Size = 1296 (0x510)                                                       */



/* =========================================================================================================================== */
/* ================                                           EWDT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief External Watchdog (EWDT)
  */

typedef struct {                                /* (@ 0x40061000) EWDT Structure                                             */

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000000) Control Register                                           */

    struct {
      __OM  uint8_t EWDTEN      : 1;            /* [0..0] EWDT Module Enable                                                 */
      __OM  uint8_t INSIGSEL    : 1;            /* [1..1] EWDT_in Signal Assertion State Select                              */
      __OM  uint8_t INPEN       : 1;            /* [2..2] Input Port Enable                                                  */
      __IOM uint8_t INTREQEN    : 1;            /* [3..3] Interrupt Request Enable                                           */
            uint8_t             : 4;
    } bit;
  } CTRL;

  union {
    __OM  uint8_t reg;                          /* (@ 0x00000001) Service Register                                           */

    struct {
      __OM  uint8_t SEQDATA     : 8;            /* [7..0] Sequence Data Area                                                 */
    } bit;
  } SEQ;

  union {
    __OM  uint8_t reg;                          /* (@ 0x00000002) Compare Low Register                                       */

    struct {
      __OM  uint8_t COMPL       : 8;            /* [7..0] Compare Low                                                        */
    } bit;
  } COMPL;

  union {
    __OM  uint8_t reg;                          /* (@ 0x00000003) Compare High Register                                      */

    struct {
      __OM  uint8_t COMPH       : 8;            /* [7..0] Compare High                                                       */
    } bit;
  } COMPH;
  __IM  uint8_t   RESERVED;

  union {
    __OM  uint8_t reg;                          /* (@ 0x00000005) Clock Prescaler Register                                   */

    struct {
      __OM  uint8_t CLKPSC      : 8;            /* [7..0] Clock Prescaler                                                    */
    } bit;
  } CLKPSC;
} EWDT_T;                                    /* Size = 6 (0x6)                                                               */



/* =========================================================================================================================== */
/* ================                                            TMC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Trigger MUX Control (TMC)
  */

/** TMC - Size of Registers Arrays */
#define TMC_TMCn_COUNT                     30U

typedef struct {                                /* (@ 0x40063000) TMC Structure                                                */
  __IO uint32_t TMCn[TMC_TMCn_COUNT];     /* Array offset: 0x0, array step: 0x4                                                */
} TMC_T;


/* =========================================================================================================================== */
/* ================                                            SCG                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief System Clock Generator (SCG)
  */

typedef struct {                                /* (@ 0x40064000) SCG Structure                                              */

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000000) Version ID Register                                        */

    struct {
      __IM  uint32_t VERID      : 32;           /* [31..0] Version Number                                                    */
    } bit;
  } VERID;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000004) Parameter Register                                         */

    struct {
      __IM  uint32_t CLKS       : 8;            /* [7..0] Clock Sources                                                      */
      __IM  uint32_t RESERVED0  : 19;
      __IM  uint32_t SYSCLKDIVCFG : 5;          /* [31..27] System Clock Divider Configure                                   */
    } bit;
  } PARA;
  __IM  uint32_t  RESERVED[2];

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000010) Clock Configure Register                                   */

    struct {
      __IM  uint32_t SCLKDIVRCFG : 4;           /* [3..0] Slow Clock Division Ratio Configure                                */
      __IM  uint32_t BCLKDIVRCFG : 4;           /* [7..4] Bus Clock Divide Ratio Configure                                   */
      __IM  uint32_t RESERVED1  : 8;
      __IM  uint32_t CCLKDIVRCFG : 4;           /* [19..16] Core Clock Divide Ratio Configure                                */
      __IM  uint32_t RESERVED2  : 4;
      __IM  uint32_t SYSCLKSSEL : 4;            /* [27..24] System Clock Source Select                                       */
      __IM  uint32_t RESERVED3  : 4;
    } bit;
  } CLKCFG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000014) Run Clock Control Register                                 */

    struct {
      __IOM uint32_t SCLKDIVRCFG : 4;           /* [3..0] Slow Clock Division Ratio Configure                                */
      __IOM uint32_t BCLKDIVRCFG : 4;           /* [7..4] Bus Clock Divide Ratio Configure                                   */
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t CCLKDIVRCFG : 4;           /* [19..16] Core Clock Divide Ratio Configure                                */
      __IM  uint32_t RESERVED1  : 4;
      __IOM uint32_t SYSCLKSSEL : 4;            /* [27..24] System Clock Source Select                                       */
      __IM  uint32_t RESERVED2  : 4;
    } bit;
  } RUNCLKCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) VLPR Clock Control Register                                */

    struct {
      __IOM uint32_t SCLKDIVRCFG : 4;           /* [3..0] Slow Clock Division Ratio Configure                                */
      __IOM uint32_t BCLKDIVRCFG : 4;           /* [7..4] Bus Clock Divide Ratio Configure                                   */
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t CCLKDIVRCFG : 4;           /* [19..16] Core Clock Divide Ratio Configure                                */
      __IM  uint32_t RESERVED1  : 4;
      __IOM uint32_t SYSCLKSSEL : 4;            /* [27..24] System Clock Source Select                                       */
      __IM  uint32_t RESERVED2  : 4;
    } bit;
  } VLPRCLKCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000001C) HSRUN Clock Control Register                               */

    struct {
      __IOM uint32_t SCLKDIVRCFG : 4;           /* [3..0] Slow Clock Division Ratio Configure                                */
      __IOM uint32_t BCLKDIVRCFG : 4;           /* [7..4] Bus Clock Divide Ratio Configure                                   */
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t CCLKDIVRCFG : 4;           /* [19..16] Core Clock Divide Ratio Configure                                */
      __IM  uint32_t RESERVED1  : 4;
      __IOM uint32_t SYSCLKSSEL : 4;            /* [27..24] System Clock Source Select                                       */
      __IM  uint32_t RESERVED2  : 4;
    } bit;
  } HSRUNCLKCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000020) System Clock Output Select Register                        */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t SYSCLKOSEL : 4;            /* [27..24] System Clock Output Select                                       */
      __IM  uint32_t RESERVED1  : 4;
    } bit;
  } SYSCLKOSEL;
  __IM  uint32_t  RESERVED1[55];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000100) System OSC Control Status Register                         */

    struct {
      __IOM uint32_t SYSOSCEN   : 1;            /* [0..0] System OSC Enable                                                  */
      __IM  uint32_t RESERVED0  : 15;
      __IOM uint32_t SYSOSCMEN  : 1;            /* [16..16] System OSC Clock Monitor Enable                                  */
      __IOM uint32_t SYSOSCMRSTEN : 1;          /* [17..17] System OSC Clock Monitor Reset Enable                            */
      __IM  uint32_t RESERVED1  : 5;
      __IOM uint32_t LOCK       : 1;            /* [23..23] Register Lock                                                    */
      __IM  uint32_t SYSOSCVLDFLG : 1;          /* [24..24] System OSC Valid Flag                                            */
      __IM  uint32_t SYSOSCSEL  : 1;            /* [25..25] System OSC Select                                                */
      __IOM uint32_t SYSOSCCLKEFLG : 1;         /* [26..26] System OSC Clock Error Flag                                      */
      __IM  uint32_t RESERVED2  : 5;
    } bit;
  } SYSOSCCSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000104) System OSC Divide Configure Register                       */

    struct {
      __IOM uint32_t SYSOSCDCFG1 : 3;           /* [2..0] System Clock Divide 1 Configure                                    */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t SYSOSCDCFG2 : 3;           /* [10..8] System OSC Clock Divide 2 Configure                               */
      __IM  uint32_t RESERVED1  : 21;
    } bit;
  } SYSOSCDIVCFG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000108) System Oscillator Configure Register                       */

    struct {
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t ERCLKSEL   : 1;            /* [2..2] External Reference Clock Select                                    */
      __IOM uint32_t GOSCSEL    : 1;            /* [3..3] Gain Oscillator Select                                             */
      __IOM uint32_t SYSOSCFSEL : 2;            /* [5..4] System OSC Frequency Select                                        */
      __IM  uint32_t RESERVED1  : 26;
    } bit;
  } SYSOSCCFG;
  __IM  uint32_t  RESERVED2[61];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000200) LSI Control Status Register                                */

    struct {
      __IOM uint32_t LSIEN      : 1;            /* [0..0] LSI Enable                                                         */
      __IOM uint32_t LSIEN_STOP : 1;            /* [1..1] LSI in STOP Mode Enable                                            */
      __IOM uint32_t LSIEN_LP   : 1;            /* [2..2] LSI Low Power Enable                                               */
      __IM  uint32_t RESERVED0  : 20;
      __IOM uint32_t LOCK       : 1;            /* [23..23] Register Lock                                                    */
      __IM  uint32_t LSIVLDFLG  : 1;            /* [24..24] LSI Valid Flag                                                   */
      __IM  uint32_t LSISEL     : 1;            /* [25..25] LSI Select                                                       */
      __IM  uint32_t RESERVED1  : 6;
    } bit;
  } LSICSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000204) LSICLK Divide Register                                     */

    struct {
      __IOM uint32_t LSIDIVCFG1 : 3;            /* [2..0] LSI Divide 1 Configure                                             */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t LSIDIVCFG2 : 3;            /* [10..8] LSI Divide 2 Configure                                            */
      __IM  uint32_t RESERVED1  : 21;
    } bit;
  } LSIDIV;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000208) LSICLK Frequency Select Register                           */

    struct {
      __IOM uint32_t LSIFSEL    : 1;            /* [0..0] LSICLK Frequency Select                                            */
      __IM  uint32_t RESERVED0  : 31;
    } bit;
  } LSIFSEL;
  __IM  uint32_t  RESERVED3[61];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000300) HSI Control Status Register                                */

    struct {
      __IOM uint32_t HSIEN      : 1;            /* [0..0] HSI Enable                                                         */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t HSIREN     : 1;            /* [3..3] HSI Regulator Enable                                               */
      __IM  uint32_t RESERVED1  : 19;
      __IOM uint32_t LOCK       : 1;            /* [23..23] Register Lock                                                    */
      __IM  uint32_t HSIVLDFLG  : 1;            /* [24..24] HSI Valid Flag                                                   */
      __IM  uint32_t HSISEL     : 1;            /* [25..25] HSI Select                                                       */
      __IOM uint32_t HSIEFLG    : 1;            /* [26..26] HSI Error Flag                                                   */
      __IM  uint32_t RESERVED2  : 5;
    } bit;
  } HSICSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000304) HSI Divide Register                                        */

    struct {
      __IOM uint32_t HSIDIVCFG1 : 3;            /* [2..0] HSI Divide 1 Configure                                             */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t HSIDIVCFG2 : 3;            /* [10..8] HSI Divide 2 Configure                                            */
      __IM  uint32_t RESERVED1  : 21;
    } bit;
  } HSIDIV;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000308) HSI Frequency Select Register                              */

    struct {
      __IOM uint32_t HSIFSEL    : 2;            /* [1..0] HSI Frequency Select                                               */
      __IM  uint32_t RESERVED0  : 30;
    } bit;
  } HSIFSEL;
  __IM  uint32_t  RESERVED4[189];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000600) System PLL Control Status Register                         */

    struct {
      __IOM uint32_t SYSPLLEN   : 1;            /* [0..0] System PLL Enable                                                  */
      __IM  uint32_t RESERVED0  : 15;
      __IOM uint32_t SYSPLLMEN  : 1;            /* [16..16] System PLL Clock Monitor Enable                                  */
      __IOM uint32_t SYSPLLMRSTEN : 1;          /* [17..17] System PLL Clock Monitor Reset Enable                            */
      __IM  uint32_t RESERVED1  : 5;
      __IOM uint32_t LOCK       : 1;            /* [23..23] Register Lock                                                    */
      __IM  uint32_t SYSPLLVLDFLG : 1;          /* [24..24] System PLL Valid Flag                                            */
      __IM  uint32_t SYSPLLSEL  : 1;            /* [25..25] System PLL Select                                                */
      __IOM uint32_t SYSPLLCLKEFLG : 1;         /* [26..26] System PLL Clock Error Flag                                      */
      __IM  uint32_t RESERVED2  : 5;
    } bit;
  } SYSPLLCSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000604) System PLL Divide Register                                 */

    struct {
      __IOM uint32_t SYSPLLDIVCFG1 : 3;         /* [2..0] System PLL Clock Divide 1 Configuration                            */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t SYSPLLDIVCFG2 : 3;         /* [10..8] System PLL Clock Divide 2 Configuration                           */
      __IM  uint32_t RESERVED1  : 21;
    } bit;
  } SYSPLLDIV;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000608) System PLL Configuration Register                          */

    struct {
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t PLLRDIVCFG : 3;            /* [10..8] PLL Reference Clock Divider Configure                             */
      __IM  uint32_t RESERVED1  : 5;
      __IOM uint32_t SYSPLLMULCFG : 5;          /* [20..16] System PLL Multiply Factor Configuration                         */
      __IM  uint32_t RESERVED2  : 11;
    } bit;
  } SYSPLLCFG;
} SCG_T;                                     /* Size = 1548 (0x60c)                                                          */



/* =========================================================================================================================== */
/* ================                                            PCM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Peripheral Clock management (PCM)
  */

typedef struct {                                /* (@ 0x40065000) PCM Structure                                              */
  __IM  uint32_t  RESERVED[32];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000080) FLASH Clock Register                                       */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t FLASHEN    : 1;            /* [30..30] Flash Clock Enable                                               */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } FLASHCLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000084) DMACHM Clock Register                                      */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t DMACHMEN   : 1;            /* [30..30] DMACHM Clock Enable                                              */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } DMACHMCLK;
  __IM  uint32_t  RESERVED1[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000090) CAN0 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t CAN0EN     : 1;            /* [30..30] CAN0 Clock Enable                                                */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } CAN0CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000094) CAN1 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t CAN1EN     : 1;            /* [30..30] CAN1 Clock Enable                                                */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } CAN1CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000098) CFGTMR3 Clock Register                                       */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t CFGTMR3CSSEL : 3;            /* [26..24] CFGTMR3 Clock Source Select                                        */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t CFGTMR3EN    : 1;            /* [30..30] CFGTMR3 Clock Enable                                               */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } CFGTMR3CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000009C) ADC1 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t ADC1CSSEL  : 3;            /* [26..24] ADC1 Clock Source Select                                         */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t ADC1EN     : 1;            /* [30..30] ADC1 Clock Enable                                                */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } ADC1CLK;
  __IM  uint32_t  RESERVED2[3];

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000AC) CAN2 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t CAN2EN     : 1;            /* [30..30] CAN2 Clock Enable                                                */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } CAN2CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000B0) LPSPI0 Clock Register                                      */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t SPI0CSSEL  : 3;            /* [26..24] LPSPI0 Clock Source Select                                       */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t LPSPI0EN   : 1;            /* [30..30] LPSPI0 Clock Enable                                              */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } LPSPI0CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000B4) LPSPI1 Clock Register                                      */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t SPI1CSSEL  : 3;            /* [26..24] LPSPI1 Clock Source Select                                       */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t LPSPI1EN   : 1;            /* [30..30] LPSPI1 Clock Enable                                              */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } LPSPI1CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000B8) LPSPI2 Clock Register                                      */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t SPI2CSSEL  : 3;            /* [26..24] LPSPI2 Clock Source Select                                       */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t LPSPI2EN   : 1;            /* [30..30] LPSPI2 Clock Enable                                              */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } LPSPI2CLK;
  __IM  uint32_t  RESERVED3[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000C4) PDU1 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t PDU1EN     : 1;            /* [30..30] PDU1 Clock Enable                                                */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } PDU1CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000C8) CRC Clock Register                                         */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t CRCEN      : 1;            /* [30..30] CRC Clock Enable                                                 */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } CRCCLK;
  __IM  uint32_t  RESERVED4[3];

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000D8) PDU0 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t PDU0EN     : 1;            /* [30..30] PDU0 Clock Enable                                                */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } PDU0CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000DC) PCC LPIT Clock Register                                    */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t LPITMRCSSEL : 3;           /* [26..24] LPITMR Clock Source Select                                       */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t LPITMREN   : 1;            /* [30..30] LPITMR Clock Enable                                              */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } LPITMRCLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000E0) CFGTMR0 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t CFGTMR0CSSEL : 3;            /* [26..24] CFGTMR0 Clock Source Select                                        */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t CFGTMR0EN    : 1;            /* [30..30] CFGTMR0 Clock Enable                                               */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } CFGTMR0CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000E4) CFGTMR1 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t CFGTMR1CSSEL : 3;            /* [26..24] CFGTMR1 Clock Source Select                                        */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t CFGTMR1EN    : 1;            /* [30..30] CFGTMR1 Clock Enable                                               */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } CFGTMR1CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000E8) CFGTMR2 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t CFGTMR2CSSEL : 3;            /* [26..24] CFGTMR2 Clock Source Select                                        */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t CFGTMR2EN    : 1;            /* [30..30] CFGTMR2 Clock Enable                                               */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } CFGTMR2CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000EC) ADC0 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t ADC0CSSEL  : 3;            /* [26..24] ADC0 Clock Source Select                                         */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t ADC0EN     : 1;            /* [30..30] ADC0 Clock Enable                                                */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } ADC0CLK;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000000F4) RTC Clock Register                                      */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t RTCEN      : 1;            /* [30..30] RTC Clock Enable                                                 */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } RTCCLK;
  __IM  uint32_t  RESERVED6[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000100) LPTMR Clock Register                                  */

    struct {
      __IOM uint32_t LPTMRDIVDCFG : 3;         /* [2..0] LPTMR Clock Divide Denominator Factor Configure                   */
      __IOM uint32_t LPTMRDIVNCFG : 1;         /* [3..3] LPTMR Clock Divide Numerator Factor Configure                     */
      __IM  uint32_t RESERVED0  : 20;
      __IOM uint32_t LPTMRCSSEL : 3;           /* [26..24] LPTMR Clock Source Select                                       */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t LPTMREN   : 1;            /* [30..30] LPTMR Clock Enable                                              */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } LPTMRCLK;
  __IM  uint32_t  RESERVED7[8];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000124) PMA Clock Register                                         */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t PMAEN      : 1;            /* [30..30] PMA Clock Enable                                                 */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } PMACLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000128) PMB Clock Register                                         */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t PMBEN      : 1;            /* [30..30] PMB Clock Enable                                                 */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } PMBCLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000012C) PMC Clock Register                                         */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t PMCEN      : 1;            /* [30..30] PMC Clock Enable                                                 */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } PMCCLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000130) PMD Clock Register                                         */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t PMDEN      : 1;            /* [30..30] PMD Clock Enable                                                 */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } PMDCLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000134) PME Clock Register                                         */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t PMEEN      : 1;            /* [30..30] PME Clock Enable                                                 */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } PMECLK;
  __IM  uint32_t  RESERVED8[12];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000168) CFGIO Clock Register                                     */

    struct {
      __IM  uint32_t RESERVED0       : 24;
      __IOM uint32_t CFGIOCSSEL    : 3;            /* [26..24] CFGIO Clock Source Select                                 */
      __IM  uint32_t RESERVED1       : 3;
      __IOM uint32_t CFGIOEN       : 1;            /* [30..30] CFGIO Clock Enable                                        */
      __IM  uint32_t PSTFLG          : 1;            /* [31..31] Peripheral Present Flag                                     */
    } bit;
  } CFGIOCLK;
  __IM  uint32_t  RESERVED9[6];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000184) EWDT Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t EWDTEN     : 1;            /* [30..30] EWDT Clock Enable                                                */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } EWDTCLK;
  __IM  uint32_t  RESERVED10[4];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000198) LPI2C0 Clock Register                                      */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t LPI2CCSSEL : 3;           /* [26..24] LPI2C0 Clock Source Select                                       */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t LPI2CEN   : 1;            /* [30..30] LPI2C0 Clock Enable                                              */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } LPI2CCLK;
  __IM  uint32_t  RESERVED11[3];

  union {
    __IOM uint32_t reg;                         /* (@ 0x000001A8) LPUART0 Clock Register                                     */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t LPUART0CSSEL : 3;          /* [26..24] LPUART0 Clock Source Select                                      */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t LPUART0EN  : 1;            /* [30..30] LPUART0 Clock Enable                                             */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } LPUART0CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000001AC) LPUART1 Clock Register                                     */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t LPUART1CSSEL : 3;          /* [26..24] LPUART1 Clock Source Select                                      */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t LPUART1EN  : 1;            /* [30..30] LPUART1 Clock Enable                                             */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } LPUART1CLK;

  union {
    __IOM uint32_t reg;                         /* (@ 0x000001B0) LPUART2 Clock Register                                     */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t LPUART2CSSEL : 3;          /* [26..24] LPUART2 Clock Source Select                                      */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t LPUART2EN  : 1;            /* [30..30] LPUART2 Clock Enable                                             */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } LPUART2CLK;

  __IM  uint32_t  RESERVED12[1];
    union {
    __IOM uint32_t reg;                         /* (@ 0x000001B8) CFGTMR4 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t CFGTMR4CSSEL : 3;            /* [26..24] CFGTMR4 Clock Source Select                                        */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t CFGTMR4EN    : 1;            /* [30..30] CFGTMR4 Clock Enable                                               */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } CFGTMR4CLK;

    union {
    __IOM uint32_t reg;                         /* (@ 0x000001BC) CFGTMR5 Clock Register                                        */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t CFGTMR5CSSEL : 3;            /* [26..24] CFGTMR5 Clock Source Select                                        */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t CFGTMR5EN    : 1;            /* [30..30] CFGTMR5 Clock Enable                                               */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } CFGTMR5CLK;
  __IM  uint32_t  RESERVED13[3];

  union {
    __IOM uint32_t reg;                         /* (@ 0x000001CC) COMP0 Clock Register                                       */

    struct {
      __IM  uint32_t RESERVED0  : 30;
      __IOM uint32_t COMP0EN    : 1;            /* [30..30] COMP0 Clock Enable                                               */
      __IM  uint32_t PSTFLG     : 1;            /* [31..31] Peripheral Present Flag                                          */
    } bit;
  } COMP0CLK;
} PCM_T;                                     /* Size = 464 (0x1d0)                                                           */



/* =========================================================================================================================== */
/* ================                                           LPI2C                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief The LPI2C Memory Map/Register Definition can be found here. (LPI2C)
  */

typedef struct {                                /* (@ 0x40066000) LPI2C Structure                                            */

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000000) Version ID Register                                        */

    struct {
      __IM  uint32_t FEATURE    : 16;           /* [15..0] Feature Number                                                    */
      __IM  uint32_t MINOR      : 8;            /* [23..16] Minor Version Number                                             */
      __IM  uint32_t MAJOR      : 8;            /* [31..24] Major Version Number                                             */
    } bit;
  } VERID;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000004) Parameter Register                                         */

    struct {
      __IM  uint32_t MTXFS      : 4;            /* [3..0] Master Transmit FIFO Size                                          */
      __IM  uint32_t RESERVED0  : 4;
      __IM  uint32_t MRXFS      : 4;            /* [11..8] Master Receive FIFO Size                                          */
      __IM  uint32_t RESERVED1  : 20;
    } bit;
  } PARA;
  __IM  uint32_t  RESERVED[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) Master Control Register                                    */

    struct {
      __IOM uint32_t MMEN       : 1;            /* [0..0] Master Mode Enable                                                 */
      __IOM uint32_t MRST       : 1;            /* [1..1] Master Logic Software Reset                                        */
      __IOM uint32_t DOZEDIS    : 1;            /* [2..2] Master Disabled in Doze Mode                                       */
      __IOM uint32_t DBGEN      : 1;            /* [3..3] Master Enabled in Debug Mode                                       */
      __IM  uint32_t RESERVED0  : 4;
      __OM  uint32_t TXFRST     : 1;            /* [8..8] Transmit FIFO Reset                                                */
      __OM  uint32_t RXFRST     : 1;            /* [9..9] Receive FIFO Reset                                                 */
      __IM  uint32_t RESERVED1  : 22;
    } bit;
  } MCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000014) Master Status Register                                     */

    struct {
      __IM  uint32_t TXFLG      : 1;            /* [0..0] Transmit Data Flag                                                 */
      __IM  uint32_t RXFLG      : 1;            /* [1..1] Receive Data Flag                                                  */
      __IM  uint32_t RESERVED0  : 6;
      __IOM uint32_t ENDFLG     : 1;            /* [8..8] End Flag                                                           */
      __IOM uint32_t STOPFLG    : 1;            /* [9..9] STOP Flag                                                          */
      __IOM uint32_t NACKFLG    : 1;            /* [10..10] Unexpected NACK Detect Flag                                      */
      __IOM uint32_t MALFLG     : 1;            /* [11..11] Master Arbitration Lost Flag                                     */
      __IOM uint32_t FEFLG      : 1;            /* [12..12] FIFO Error Flag                                                  */
      __IOM uint32_t PLTFLG     : 1;            /* [13..13] Pin Low Timeout Flag                                             */
      __IOM uint32_t RXMFLG     : 1;            /* [14..14] Received Data Match Flag                                         */
      __IM  uint32_t RESERVED1  : 9;
      __IM  uint32_t MBSYFLG    : 1;            /* [24..24] LPI2C Master Busy Flag                                             */
      __IM  uint32_t BBSYFLG    : 1;            /* [25..25] LPI2C Bus Busy Flag                                                */
      __IM  uint32_t RESERVED2  : 6;
    } bit;
  } MSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) Master Interrupt Enable Register                           */

    struct {
      __IOM uint32_t TXDIEN     : 1;            /* [0..0] Transmit Data Interrupt Enable                                     */
      __IOM uint32_t RXDIEN     : 1;            /* [1..1] Receive Data Interrupt Enable                                      */
      __IM  uint32_t RESERVED0  : 6;
      __IOM uint32_t ENDIEN     : 1;            /* [8..8] End Packet Interrupt Enable                                        */
      __IOM uint32_t STOPIEN    : 1;            /* [9..9] STOP Detect Interrupt Enable                                       */
      __IOM uint32_t NACKIEN    : 1;            /* [10..10] Unexpected NACK Detect Interrupt Enable                          */
      __IOM uint32_t MALIEN     : 1;            /* [11..11] Master Arbitration Lost Interrupt Enable                         */
      __IOM uint32_t FEIEN      : 1;            /* [12..12] FIFO Error Interrupt Enable                                      */
      __IOM uint32_t PLTIEN     : 1;            /* [13..13] Pin Low Timeout Interrupt Enable                                 */
      __IOM uint32_t RXMIEN     : 1;            /* [14..14] Received Data Match Interrupt Enable                             */
      __IM  uint32_t RESERVED1  : 17;
    } bit;
  } MINTEN;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000001C) Master DMA Enable Register                                 */

    struct {
      __IOM uint32_t TXDMAEN    : 1;            /* [0..0] Transmit Data DMA Enable                                           */
      __IOM uint32_t RXDMAEN    : 1;            /* [1..1] Receive Data DMA Enable                                            */
      __IM  uint32_t RESERVED0  : 30;
    } bit;
  } MDMAEN;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000020) Master Configure Register 0                                */

    struct {
      __IOM uint32_t HRIEN      : 1;            /* [0..0] Host Request Input Enable                                          */
      __IOM uint32_t HRPCFG     : 1;            /* [1..1] Host Request Polarity Configure                                    */
      __IOM uint32_t HRISRC     : 1;            /* [2..2] Host Request Input Source Select                                   */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t CFEN       : 1;            /* [8..8] Circular FIFO Enable                                               */
      __IOM uint32_t RXMEN      : 1;            /* [9..9] Receive Data Match Enable                                          */
      __IM  uint32_t RESERVED1  : 22;
    } bit;
  } MCFG0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000024) Master Configure Register 1                                */

    struct {
      __IOM uint32_t CLKPS      : 3;            /* [2..0] Clock Prescaler Configure                                          */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t ASGEN      : 1;            /* [8..8] Automatic STOP Condition Generation                                */
      __IOM uint32_t INACK      : 1;            /* [9..9] Ignore NACK                                                        */
      __IOM uint32_t PINLTOCFG  : 1;            /* [10..10] Pin Low Timeout Configure                                        */
      __IM  uint32_t RESERVED1  : 5;
      __IOM uint32_t MCCFG      : 3;            /* [18..16] Match Condition Configure                                        */
      __IM  uint32_t RESERVED2  : 5;
      __IOM uint32_t PINMCFG    : 3;            /* [26..24] Pin Mode Configure                                               */
      __IM  uint32_t RESERVED3  : 5;
    } bit;
  } MCFG1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000028) Master Configure Register 2                                */

    struct {
      __IOM uint32_t BITO       : 12;           /* [11..0] Bus Idle Timeout Value                                            */
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t FILSCLCFG  : 4;            /* [19..16] Filter SCL Configure                                             */
      __IM  uint32_t RESERVED1  : 4;
      __IOM uint32_t FILSDACFG  : 4;            /* [27..24] Filter SDA Configure                                             */
      __IM  uint32_t RESERVED2  : 4;
    } bit;
  } MCFG2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000002C) Master Configure Register 3                                */

    struct {
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t PLTO       : 12;           /* [19..8] Pin Low Timeout Flag Configure                                    */
      __IM  uint32_t RESERVED1  : 12;
    } bit;
  } MCFG3;
  __IM  uint32_t  RESERVED1[4];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000040) Master Data Match Register                                 */

    struct {
      __IOM uint32_t VAL0       : 8;            /* [7..0] Compare Match 0 Value                                              */
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t VAL1       : 8;            /* [23..16] Compare Match 1 Value                                            */
      __IM  uint32_t RESERVED1  : 8;
    } bit;
  } MDATAM;
  __IM  uint32_t  RESERVED2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000048) Master Clock Configure Register 0                          */

    struct {
      __IOM uint32_t SCLLC      : 6;            /* [5..0] SCL Low Cycles                                                     */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t SCLHC      : 6;            /* [13..8] SCL High Cycles                                                   */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t SETUPT     : 6;            /* [21..16] Minimum Number of Cycles of Setup Time                           */
      __IM  uint32_t RESERVED2  : 2;
      __IOM uint32_t SDAHT      : 6;            /* [29..24] Minimum Cycle of SDA Hold Time                                   */
      __IM  uint32_t RESERVED3  : 2;
    } bit;
  } MCLKCFG0;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000050) Master Clock Configure Register 1                          */

    struct {
      __IOM uint32_t SCLLC      : 6;            /* [5..0] SCL Low Cycles                                                     */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t SCLHC      : 6;            /* [13..8] SCL High Cycles                                                   */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t SETUPT     : 6;            /* [21..16] Minimum Number of Cycles of Setup Time                           */
      __IM  uint32_t RESERVED2  : 2;
      __IOM uint32_t SDAHT      : 6;            /* [29..24] Minimum Cycle of SDA Hold Time                                   */
      __IM  uint32_t RESERVED3  : 2;
    } bit;
  } MCLKCFG1;
  __IM  uint32_t  RESERVED4;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000058) Master FIFO Control Register                               */

    struct {
      __IOM uint32_t TXFW       : 2;            /* [1..0] Transmit FIFO Watermark                                            */
      __IM  uint32_t RESERVED0  : 14;
      __IOM uint32_t RXFW       : 2;            /* [17..16] Receive FIFO Watermark                                           */
      __IM  uint32_t RESERVED1  : 14;
    } bit;
  } MFCTRL;

  union {
    __IM  uint32_t reg;                         /* (@ 0x0000005C) Master FIFO Status Register                                */

    struct {
      __IM  uint32_t TXCNT      : 3;            /* [2..0] Transmit FIFO Count                                                */
      __IM  uint32_t RESERVED0  : 13;
      __IM  uint32_t RXCNT      : 3;            /* [18..16] Receive FIFO Count                                               */
      __IM  uint32_t RESERVED1  : 13;
    } bit;
  } MFSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000060) Master Transmit Data Register                              */

    struct {
      __OM  uint32_t TXDATA     : 8;            /* [7..0] Transmit Data                                                      */
      __OM  uint32_t CMD        : 3;            /* [10..8] Command                                                           */
      __IM  uint32_t RESERVED0  : 21;
    } bit;
  } MTXDATA;
  __IM  uint32_t  RESERVED5[3];

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000070) Master Receive Data Register                               */

    struct {
      __IM  uint32_t RXDATA     : 8;            /* [7..0] Read Undiscarded Received Data                                     */
      __IM  uint32_t RESERVED0  : 6;
      __IM  uint32_t RXFE       : 1;            /* [14..14] Receive FIFO Empty                                               */
      __IM  uint32_t RESERVED1  : 17;
    } bit;
  } MRXDATA;
  __IM  uint32_t  RESERVED6[39];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000110) Slave Control Register                                     */

    struct {
      __IOM uint32_t SMEN       : 1;            /* [0..0] Slave Mode Enable                                                  */
      __IOM uint32_t SRST       : 1;            /* [1..1] Slave Logic Software Reset                                         */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t SMFEN      : 1;            /* [4..4] Slave Mode Filter Enable                                           */
      __IOM uint32_t FDDM       : 1;            /* [5..5] Filter Disabled in Doze Mode                                       */
      __IM  uint32_t RESERVED1  : 2;
      __OM  uint32_t TXFRST     : 1;            /* [8..8] Transmit FIFO Reset                                                */
      __OM  uint32_t RXFRST     : 1;            /* [9..9] Receive FIFO Reset                                                 */
      __IM  uint32_t RESERVED2  : 22;
    } bit;
  } SCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000114) Slave Status Register                                      */

    struct {
      __IM  uint32_t TXFLG      : 1;            /* [0..0] Transmit Data Flag                                                 */
      __IM  uint32_t RXFLG      : 1;            /* [1..1] Receive Data Flag                                                  */
      __IM  uint32_t AVFLG      : 1;            /* [2..2] Address Status Register Valid Flag                                 */
      __IM  uint32_t TAFLG      : 1;            /* [3..3] Transmit ACK/NACK Flag                                             */
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t RSFLG      : 1;            /* [8..8] Repeated Start Flag                                                */
      __IOM uint32_t STOPFLG    : 1;            /* [9..9] STOP Detect Flag                                                   */
      __IOM uint32_t BEFLG      : 1;            /* [10..10] Bit Error Flag                                                   */
      __IOM uint32_t FEFLG      : 1;            /* [11..11] FIFO Error Flag                                                  */
      __IM  uint32_t A0MFLG     : 1;            /* [12..12] Address 0 Match Address Flag                                     */
      __IM  uint32_t A1MFLG     : 1;            /* [13..13] Address 1 Match Address Flag                                     */
      __IM  uint32_t GCAFLG     : 1;            /* [14..14] General Call Address Flag                                        */
      __IM  uint32_t SARFLG     : 1;            /* [15..15] SMBus Alert Response Flag                                        */
      __IM  uint32_t RESERVED1  : 8;
      __IM  uint32_t SBSYFLG    : 1;            /* [24..24] LPI2C Slave Busy Flag                                              */
      __IM  uint32_t BBSYFLG    : 1;            /* [25..25] LPI2C Bus Busy Flag                                                */
      __IM  uint32_t RESERVED2  : 6;
    } bit;
  } SSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000118) Slave Interrupt Enable Register                            */

    struct {
      __IOM uint32_t TXIEN      : 1;            /* [0..0] Transmit Data Interrupt Enable                                     */
      __IOM uint32_t RXIEN      : 1;            /* [1..1] Receive Data Interrupt Enable                                      */
      __IOM uint32_t AVIEN      : 1;            /* [2..2] Address Valid Interrupt Enable                                     */
      __IOM uint32_t TAIEN      : 1;            /* [3..3] Transmit ACK/NACK Interrupt Enable                                 */
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t RSIEN      : 1;            /* [8..8] Slave Repeated Start Interrupt Enable                              */
      __IOM uint32_t STOPIEN    : 1;            /* [9..9] Slave STOP Detect Interrupt Enable                                 */
      __IOM uint32_t BEIEN      : 1;            /* [10..10] Slave Bit Error Interrupt En                                     */
      __IOM uint32_t FEIEN      : 1;            /* [11..11] FIFO Error Enable                                                */
      __IOM uint32_t A0MIEN     : 1;            /* [12..12] Address 0 Match Address Interrupt Enable                         */
      __IOM uint32_t A1MIEN     : 1;            /* [13..13] Address 1 Match Address Interrupt Enable                         */
      __IOM uint32_t GCAIEN     : 1;            /* [14..14] General Call Interrupt Enable                                    */
      __IOM uint32_t SARIEN     : 1;            /* [15..15] SMBus Alert Interrupt Enable                                     */
      __IM  uint32_t RESERVED1  : 16;
    } bit;
  } SINTEN;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000011C) Slave DMA Enable Register                                  */

    struct {
      __IOM uint32_t TXDMAEN    : 1;            /* [0..0] Transmit Data DMA Enable                                           */
      __IOM uint32_t RXDMAEN    : 1;            /* [1..1] Receive Data DMA Enable                                            */
      __IOM uint32_t AVDMAEN    : 1;            /* [2..2] Address Valid DMA Enable                                           */
      __IM  uint32_t RESERVED0  : 29;
    } bit;
  } SDMAEN;
  __IM  uint32_t  RESERVED7;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000124) Slave Configure Register 1                                 */

    struct {
      __IOM uint32_t ADDRSEN    : 1;            /* [0..0] Address SCL Stall Enable                                           */
      __IOM uint32_t RXDSEN     : 1;            /* [1..1] Receive Data SCL Stall Enable                                      */
      __IOM uint32_t TXDSEN     : 1;            /* [2..2] Transmit Data SCL Stall Enable                                     */
      __IOM uint32_t ACKSEN     : 1;            /* [3..3] ACK SCL Stall Enable                                               */
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t GCAEN      : 1;            /* [8..8] General Call Address Enable                                        */
      __IOM uint32_t SAMEN      : 1;            /* [9..9] SMBus Alert Match Enable                                           */
      __IOM uint32_t TXFCFG     : 1;            /* [10..10] Transmit Data Flag Configure                                     */
      __IOM uint32_t RXFCFG     : 1;            /* [11..11] Receive Data Flag Configure                                      */
      __IOM uint32_t INACK      : 1;            /* [12..12] Ignore NACK                                                      */
      __IOM uint32_t HSMDEN     : 1;            /* [13..13] High Speed Mode Detection Enable                                 */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t ADDRMCFG   : 3;            /* [18..16] Address Match Configure                                          */
      __IM  uint32_t RESERVED2  : 13;
    } bit;
  } SCFG1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000128) Slave Configure Register 2                                 */

    struct {
      __IOM uint32_t CLKHLDCFG  : 4;            /* [3..0] Clock Hold Time Configure                                          */
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t DVDCFG     : 6;            /* [13..8] Data Valid Delay Configure                                        */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t SCLFCFG    : 4;            /* [19..16] SCL Glitch Fliter Configure                                      */
      __IM  uint32_t RESERVED2  : 4;
      __IOM uint32_t SDAFCFG    : 4;            /* [27..24] SDA Glitch Filter Configure                                      */
      __IM  uint32_t RESERVED3  : 4;
    } bit;
  } SCFG2;
  __IM  uint32_t  RESERVED8[5];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000140) Slave Address Match Register                               */

    struct {
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t A0CV       : 10;           /* [10..1] Address0 Compare 0 Value                                          */
      __IM  uint32_t RESERVED1  : 6;
      __IOM uint32_t A1CV       : 10;           /* [26..17] Address1 Compare 1 Value                                         */
      __IM  uint32_t RESERVED2  : 5;
    } bit;
  } SADDRM;
  __IM  uint32_t  RESERVED9[3];

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000150) Slave Address Status Register                              */

    struct {
      __IM  uint32_t RXADDR     : 11;           /* [10..0] Received Address                                                  */
      __IM  uint32_t RESERVED0  : 3;
      __IM  uint32_t RXADDRNV   : 1;            /* [14..14] Received Address Not Vaild                                       */
      __IM  uint32_t RESERVED1  : 17;
    } bit;
  } SADDRSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000154) Slave Transmit ACK Register                                */

    struct {
      __IOM uint32_t TXNACK     : 1;            /* [0..0] Write a Transmit NACK                                              */
      __IM  uint32_t RESERVED0  : 31;
    } bit;
  } STXACK;
  __IM  uint32_t  RESERVED10[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000160) Slave Transmit Data Register                               */

    struct {
      __OM  uint32_t TXDATA     : 8;            /* [7..0] Slave Transmit Data                                                */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } STXDATA;
  __IM  uint32_t  RESERVED11[3];

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000170) Slave Receive Data Register                                */

    struct {
      __IM  uint32_t RXDATA     : 8;            /* [7..0] Slave Received Data                                                */
      __IM  uint32_t RESERVED0  : 6;
      __IM  uint32_t RXDE       : 1;            /* [14..14] Receive Data Register Empty                                      */
      __IM  uint32_t FDW        : 1;            /* [15..15] First Data Word                                                  */
      __IM  uint32_t RESERVED1  : 16;
    } bit;
  } SRXDATA;
} LPI2C_T;                                   /* Size = 372 (0x174)                                                        */



/* =========================================================================================================================== */
/* ================                                          LPUART                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Low-power Universal asynchronous receiver/transmitters (LPUART)
  */

typedef struct {                                /*  LPUART Structure
                                                    (@ 0x4006A000)LPUART0 (@ 0x4006B000)LPUART1 (@ 0x4006C000)LPUART2        */

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000000) Version ID Register                                        */

    struct {
      __IM  uint32_t FEATURE    : 16;           /* [15..0] Feature Number                                                    */
      __IM  uint32_t MINOR      : 8;            /* [23..16] Minor Version Number                                             */
      __IM  uint32_t MAJOR      : 8;            /* [31..24] Major Version Number                                             */
    } bit;
  } VERID;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000004) Parameter Register                                         */

    struct {
      __IM  uint32_t TXFSSET    : 8;            /* [7..0] Transmit FIFO Size Set                                             */
      __IM  uint32_t RXFSSET    : 8;            /* [15..8] Receive FIFO Size Set                                             */
      __IM  uint32_t RESERVED0  : 16;
    } bit;
  } PARA;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) LPUART Software Reset Register                             */

    struct {
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t SWRSTEN    : 1;            /* [1..1] Software Reset Enable                                              */
      __IM  uint32_t RESERVED1  : 30;
    } bit;
  } SWRST;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) LPUART Pin Configuration Register                          */

    struct {
      __IOM uint32_t ITRGCFG    : 2;            /* [1..0] Input Trigger Configure                                            */
      __IM  uint32_t RESERVED0  : 30;
    } bit;
  } PCFG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) LPUART Baud Rate Register                                  */

    struct {
      __IOM uint32_t BRMD       : 13;           /* [12..0] Baud Rate Modulo Divisor                                          */
      __IOM uint32_t STOPBSEL   : 1;            /* [13..13] Stop Bit Select                                                  */
      __IOM uint32_t RXIAEIEN   : 1;            /* [14..14] Receive Input Active Edge Interrupt Enable                       */
      __IOM uint32_t LBDFIEN    : 1;            /* [15..15] LIN Break Detect Flag Interrupt Enable                           */
      __IOM uint32_t RXDWRDIS   : 1;            /* [16..16] Received Data Word Resynchronization Disable                     */
      __IOM uint32_t BEDSMPSEL  : 1;            /* [17..17] Both Edge Sampling Mode Select                                   */
      __IOM uint32_t MADDRMCFG  : 2;            /* [19..18] Match Addressing Mode Configure                                  */
      __IOM uint32_t RXIDMAREN  : 1;            /* [20..20] Receiver Idle DMA Request Enable                                 */
      __IOM uint32_t RXFDMAREN  : 1;            /* [21..21] Receiver Full DMA Request Enable                                 */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t TXDMAREN   : 1;            /* [23..23] Transmitter DMA Request Enable                                   */
      __IOM uint32_t OSRCFG     : 5;            /* [28..24] Oversampling Ratio Configure                                     */
      __IOM uint32_t SELM10     : 1;            /* [29..29] 10-bit Mode Select                                               */
      __IOM uint32_t MADDREN2   : 1;            /* [30..30] Match Address 2 Mode Enable                                      */
      __IOM uint32_t MADDREN1   : 1;            /* [31..31] Match Address 1 Mode Enable                                      */
    } bit;
  } BR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000014) LPUART Status Register                                     */

    struct {
      __IM  uint32_t RESERVED0  : 14;
      __IOM uint32_t RXDMFLG2   : 1;            /* [14..14] Received Data Match 2 Flag                                       */
      __IOM uint32_t RXDMFLG1   : 1;            /* [15..15] Received Data Match 1 Flag                                       */
      __IOM uint32_t PEFLG      : 1;            /* [16..16] Parity Error Flag                                                */
      __IOM uint32_t FEFLG      : 1;            /* [17..17] Fram Error Flag                                                  */
      __IOM uint32_t NEFLG      : 1;            /* [18..18] Noise Flag                                                       */
      __IOM uint32_t OVREFLG    : 1;            /* [19..19] Overrun Error Flag                                               */
      __IOM uint32_t IDLEFLG    : 1;            /* [20..20] Idle Line Detected Flag                                          */
      __IM  uint32_t RXBFFLG    : 1;            /* [21..21] Receive Data Buffer full Flag                                    */
      __IM  uint32_t TXCFLG     : 1;            /* [22..22] Transmission data Complete Flag                                  */
      __IM  uint32_t TXBEFLG    : 1;            /* [23..23] Transmit Data Buffer Empty Flag                                  */
      __IM  uint32_t RXDINIFLG  : 1;            /* [24..24] RXD Input Not Idle Flag                                          */
      __IOM uint32_t LBDEN      : 1;            /* [25..25] LIN Break Detection Enable                                       */
      __IOM uint32_t BCTXLEN    : 1;            /* [26..26] Break Character Transmission Length                              */
      __IOM uint32_t RXWUPID    : 1;            /* [27..27] Receive Wake Up Idle Detect                                      */
      __IOM uint32_t RXDIPINV   : 1;            /* [28..28] Received Data Input Polarity Inversion                           */
      __IOM uint32_t MSBFSET    : 1;            /* [29..29] MSB First Set                                                    */
      __IOM uint32_t AERXPFLG   : 1;            /* [30..30] Active Edge on Receive Pin Flag                                  */
      __IOM uint32_t LBDFLG     : 1;            /* [31..31] LIN Break Detected Flag                                          */
    } bit;
  } STS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) LPUART Control Register                                    */

    struct {
      __IOM uint32_t PTCFG      : 1;            /* [0..0] Parity Type Configure                                              */
      __IOM uint32_t PENCFG      : 1;            /* [1..1] Parity Enable Configure                                            */
      __IOM uint32_t ITSEL      : 1;            /* [2..2] Idle Type Select                                                   */
      __IOM uint32_t RXWAKESEL  : 1;            /* [3..3] Receiver Wakeup Method Select                                      */
      __IOM uint32_t RXTXCSEL   : 1;            /* [4..4] Receiver and Transmit Character Select                             */
      __IOM uint32_t RXISRCSEL  : 1;            /* [5..5] Receiver Input Source Select                                       */
      __IOM uint32_t DOZEMODEEN : 1;            /* [6..6] Doze Mode Enable                                                   */
      __IOM uint32_t LSWSEL     : 1;            /* [7..7] Loop Mode or Single-wire Mode Select                               */
      __IOM uint32_t IDLECCFG   : 3;            /* [10..8] Idle Character Configure                                          */
      __IOM uint32_t RXTXSELM7  : 1;            /* [11..11] Receiver and Transmit Select 7-bit Mode                          */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t FIENM2     : 1;            /* [14..14] Match 2 Flag Interrupt Enable                                    */
      __IOM uint32_t FIENM1     : 1;            /* [15..15] Match 1 Flag Interrupt Enable                                    */
      __IOM uint32_t TXBK       : 1;            /* [16..16] Transmit Break                                                   */
      __IOM uint32_t RXWUPCTRL  : 1;            /* [17..17] Receiver Wakeup Control                                          */
      __IOM uint32_t RXEN       : 1;            /* [18..18] LPUART Receiver Enable                                           */
      __IOM uint32_t TXEN       : 1;            /* [19..19] LPUART Transmitter Enable                                        */
      __IOM uint32_t IDLEIEN    : 1;            /* [20..20] Idle Line Interrupt Enable                                       */
      __IOM uint32_t RXIEN      : 1;            /* [21..21] Receiver Interrupt Enable                                        */
      __IOM uint32_t TXCIEN     : 1;            /* [22..22] Transmission Complete Interrupt Enable                           */
      __IOM uint32_t TXIEN      : 1;            /* [23..23] Transmit Interrupt Enable                                        */
      __IOM uint32_t PEIEN      : 1;            /* [24..24] Parity Error Interrupt Enable                                    */
      __IOM uint32_t FEIEN      : 1;            /* [25..25] Framing Error Interrupt Enable                                   */
      __IOM uint32_t NEIEN      : 1;            /* [26..26] Noise Error Interrupt Enable                                     */
      __IOM uint32_t OVRIEN     : 1;            /* [27..27] Overrun Interrupt Enable                                         */
      __IOM uint32_t TXDOPINV   : 1;            /* [28..28] Transmit Data Output Polarity Inversion                          */
      __IOM uint32_t TXDPDIRSEL : 1;            /* [29..29] TXD Pin Direction in Single-Wire Mode Select                     */
      __IOM uint32_t RX9TX8     : 1;            /* [30..30] Receive Data Bit 9 / Transmit Data Bit 8                         */
      __IOM uint32_t RX8TX9     : 1;            /* [31..31] Receive Data Bit 8 / Transmit Data Bit 9                         */
    } bit;
  } CTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000001C) LPUART Data Register                                       */

    struct {
      __IOM uint32_t RX0TX0     : 1;            /* [0..0] Rx Buffer 0 or Tx Buffer 0                                         */
      __IOM uint32_t RX1TX1     : 1;            /* [1..1] Rx Buffer 1 or Tx Buffer 1                                         */
      __IOM uint32_t RX2TX2     : 1;            /* [2..2] Rx Buffer 2 or Tx Buffer 2                                         */
      __IOM uint32_t RX3TX3     : 1;            /* [3..3] Rx Buffer 3 or Tx Buffer 3                                         */
      __IOM uint32_t RX4TX4     : 1;            /* [4..4] Rx Buffer 4 or Tx Buffer 4                                         */
      __IOM uint32_t RX5TX5     : 1;            /* [5..5] Rx Buffer 5 or Tx Buffer 5                                         */
      __IOM uint32_t RX6TX6     : 1;            /* [6..6] Rx Buffer 6 or Tx Buffer 6                                         */
      __IOM uint32_t RX7TX7     : 1;            /* [7..7] Rx Buffer 7 or Tx Buffer 7                                         */
      __IOM uint32_t RX8TX8     : 1;            /* [8..8] Rx Buffer 8 or Tx Buffer 8                                         */
      __IOM uint32_t RX9TX9     : 1;            /* [9..9] Rx Buffer 9 or Tx Buffer 9                                         */
      __IM  uint32_t RESERVED0  : 1;
      __IM  uint32_t RXIDLE     : 1;            /* [11..11] Receiver Idle Line                                               */
      __IM  uint32_t RXBE       : 1;            /* [12..12] Receive Buffer Empty                                             */
      __IOM uint32_t FETXSC     : 1;            /* [13..13] Frame Error or Transmit Special Character                        */
      __IM  uint32_t PE         : 1;            /* [14..14] Parity Error                                                     */
      __IM  uint32_t NE         : 1;            /* [15..15] Noise Error                                                      */
      __IM  uint32_t RESERVED1  : 16;
    } bit;
  } DATA;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000020) LPUART Match Address Register                              */

    struct {
      __IOM uint32_t MADDR1     : 10;           /* [9..0] Match Address 1                                                    */
      __IM  uint32_t RESERVED0  : 6;
      __IOM uint32_t MADDR2     : 10;           /* [25..16] Match Address 2                                                  */
      __IM  uint32_t RESERVED1  : 6;
    } bit;
  } MADDR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000024) LPUART Modem IrDA Register                                 */

    struct {
      __IOM uint32_t TXCSEN     : 1;            /* [0..0] Transmitter Clear-to-Send Enable                                   */
      __IOM uint32_t TXRSEN     : 1;            /* [1..1] Transmitter Request-to-Send Enable                                 */
      __IOM uint32_t TXRSPCFG   : 1;            /* [2..2] Transmitter Request-to-Send Polarity Configure                     */
      __IOM uint32_t RXRSEN     : 1;            /* [3..3] Receiver Request-to-Send Enable                                    */
      __IOM uint32_t TXCSCFG    : 1;            /* [4..4] Transmit CTS Sample Configure                                      */
      __IOM uint32_t TXCSRCSEL  : 1;            /* [5..5] Transmit CTS Source Select                                         */
      __IM  uint32_t RESERVED0  : 2;
      __IOM uint32_t RXROCFG    : 2;            /* [9..8] Receive RTS Output Configure                                       */
      __IM  uint32_t RESERVED1  : 6;
      __IOM uint32_t TXNPCFG    : 2;            /* [17..16] Transmitter Narrow Pulse Configure                               */
      __IOM uint32_t IRMODEEN   : 1;            /* [18..18] Infrared Modulation/Demodulation Enable                          */
      __IM  uint32_t RESERVED2  : 13;
    } bit;
  } MIR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000028) LPUART FIFO Register                                       */

    struct {
      __IM  uint32_t RXFBDCFG   : 3;            /* [2..0] Receive FIFO Buffer Depth Configure                                */
      __IOM uint32_t RXBFEN     : 1;            /* [3..3] Receive Buffer FIFO Enable                                         */
      __IM  uint32_t TXFBDCFG   : 3;            /* [6..4] Transmit FIFO Buffer Depth Configure                               */
      __IOM uint32_t TXBFEN     : 1;            /* [7..7] Transmit Buffer FIFO Enable                                        */
      __IOM uint32_t RXUFGINT   : 1;            /* [8..8] RX Buffer Underflow Flag Generate Interrupt                        */
      __IOM uint32_t TXOFGINT   : 1;            /* [9..9] TX Buffer Overflow Flag Generate Interrupt                         */
      __IOM uint32_t CFGRXIEEN  : 3;            /* [12..10] Configures when the Receiver is Idle Empty Enable                */
      __IM  uint32_t RESERVED0  : 1;
      __OM  uint32_t RXFBDFLU   : 1;            /* [14..14] Receive FIFO/Buffer Data Flush                                   */
      __OM  uint32_t TXFBDFLU   : 1;            /* [15..15] Transmit FIFO/Buffer Data Flush                                  */
      __IOM uint32_t RXBUFLG    : 1;            /* [16..16] Receiver Buffer Underflow Occured Flag                           */
      __IOM uint32_t TXBOFLG    : 1;            /* [17..17] Transmitter Buffer Overflow Occured Flag                         */
      __IM  uint32_t RESERVED1  : 4;
      __IM  uint32_t RXBE       : 1;            /* [22..22] Receive Buffer Empty                                             */
      __IM  uint32_t TXBE       : 1;            /* [23..23] Transmit Buffer Empty                                            */
      __IM  uint32_t RESERVED2  : 8;
    } bit;
  } FIFO;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000002C) LPUART Watermark Register                                  */

    struct {
      __IOM uint32_t TXWAT      : 2;            /* [1..0] Transmit Watermark                                                 */
      __IM  uint32_t RESERVED0  : 6;
      __IM  uint32_t TXFBUFCNT  : 3;            /* [10..8] Transmit FIFO/Buffer Counter                                      */
      __IM  uint32_t RESERVED1  : 5;
      __IOM uint32_t RXWAT      : 2;            /* [17..16] Receive Watermark                                                */
      __IM  uint32_t RESERVED2  : 6;
      __IM  uint32_t RXFBUFCNT  : 3;            /* [26..24] Receive FIFO/Buffer Counter                                      */
      __IM  uint32_t RESERVED3  : 5;
    } bit;
  } WMKR;
} LPUART_T;                                 /* Size = 48 (0x30)                                                              */



/* =========================================================================================================================== */
/* ================                                           COMP                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Analog Comparators (COMP)
  */

typedef struct {                                /* (@ 0x40073000) COMP Structure                                             */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) COMP Control Register 0                                    */

    struct {
      __IOM uint32_t HBHLSEL    : 2;            /* [1..0] Hard Block Hysteresis Level Select                                 */
      __IOM uint32_t HBOLSEL    : 1;            /* [2..2] Hard Block Offset Level Select                                     */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t FOSMPCNT   : 3;            /* [6..4] Filter Output Sample Count                                         */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t ACEN       : 1;            /* [8..8] Analog Comparator Enable                                           */
      __IOM uint32_t COPCFG     : 1;            /* [9..9] Comparator Output Pin Configure                                    */
      __IOM uint32_t COCFG      : 1;            /* [10..10] Comparator Output Configure                                      */
      __IOM uint32_t INVEN      : 1;            /* [11..11] Invert Enable                                                    */
      __IOM uint32_t PMSEL      : 1;            /* [12..12] Power Mode Select                                                */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t WINMEN     : 1;            /* [14..14] Windowing Mode Enable                                            */
      __IOM uint32_t SMPMEN     : 1;            /* [15..15] Sample Mode Enable                                               */
      __IOM uint32_t FSMPPCFG   : 8;            /* [23..16] Filter Sample Period Configure                                   */
      __IM  uint32_t ACO        : 1;            /* [24..24] Analog Comparator Output                                         */
      __IOM uint32_t ACFFLG     : 1;            /* [25..25] Analog Comparator Falling Flag                                   */
      __IOM uint32_t ACRFLG     : 1;            /* [26..26] Analog Comparator Rising Flag                                    */
      __IOM uint32_t ACFIEN     : 1;            /* [27..27] Analog Comparator Falling Interrupt Enable                       */
      __IOM uint32_t ACRIEN     : 1;            /* [28..28] Analog Comparator Rising Interrupt Enable                        */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t DMAEN      : 1;            /* [30..30] DMA Enable                                                       */
      __IM  uint32_t RESERVED4  : 1;
    } bit;
  } CTRL0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) COMP Control Register 1                                    */

    struct {
      __IOM uint32_t DACOVCFG   : 8;            /* [7..0] DAC Output Voltage Configure                                       */
      __IOM uint32_t MUXMICSEL  : 3;            /* [10..8] Minus Input MUX Select                                            */
      __IOM uint32_t MUXPICSEL  : 3;            /* [13..11] Plus Input MUX Select                                            */
      __IOM uint32_t SVRSSEL    : 1;            /* [14..14] Supply Voltage Reference Source Select                           */
      __IOM uint32_t DACEN      : 1;            /* [15..15] DAC Enable                                                       */
      __IOM uint32_t INENCH0    : 1;            /* [16..16] Channel 0 input enable                                           */
      __IOM uint32_t INENCH1    : 1;            /* [17..17] Channel 1 input enable                                           */
      __IOM uint32_t INENCH2    : 1;            /* [18..18] Channel 2 input enable                                           */
      __IOM uint32_t INENCH3    : 1;            /* [19..19] Channel 3 input enable                                           */
      __IOM uint32_t INENCH4    : 1;            /* [20..20] Channel 4 input enable                                           */
      __IOM uint32_t INENCH5    : 1;            /* [21..21] Channel 5 input enable                                           */
      __IOM uint32_t INENCH6    : 1;            /* [22..22] Channel 6 input enable                                           */
      __IOM uint32_t INENCH7    : 1;            /* [23..23] Channel 7 input enable                                           */
      __IOM uint32_t CNISEL     : 2;            /* [25..24] Comparator Negative Input Select                                 */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t CPISEL     : 2;            /* [28..27] Comparator Positive Input Select                                 */
      __IM  uint32_t RESERVED1  : 3;
    } bit;
  } CTRL1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) COMP Control Register 2                                    */

    struct {
      __IOM uint32_t CRETCHn    : 8;            /* [7..0] Input Comparison Result of Channel n                               */
      __IOM uint32_t IDCLKCFG   : 6;            /* [13..8] Initialization Delay Clock Configure                              */
      __IOM uint32_t NSCFG      : 2;            /* [15..14] Number of Sample Clocks Configure                                */
      __IOM uint32_t ICFLGCH0   : 1;            /* [16..16] Channel 0 input changed flag                                     */
      __IOM uint32_t ICFLGCH1   : 1;            /* [17..17] Channel 1 input changed flag                                     */
      __IOM uint32_t ICFLGCH2   : 1;            /* [18..18] Channel 2 input changed flag                                     */
      __IOM uint32_t ICFLGCH3   : 1;            /* [19..19] Channel 3 input changed flag                                     */
      __IOM uint32_t ICFLGCH4   : 1;            /* [20..20] Channel 4 input changed flag                                     */
      __IOM uint32_t ICFLGCH5   : 1;            /* [21..21] Channel 5 input changed flag                                     */
      __IOM uint32_t ICFLGCH6   : 1;            /* [22..22] Channel 6 input changed flag                                     */
      __IOM uint32_t ICFLGCH7   : 1;            /* [23..23] Channel 7 input changed flag                                     */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t MUXFCHSEL  : 3;            /* [27..25] Fixed MUX Channel Select                                         */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t MUXFPSEL   : 1;            /* [29..29] Fixed MUX Port Select                                            */
      __IOM uint32_t RRIEN      : 1;            /* [30..30] Round-Robin Interrupt Enable                                     */
      __IOM uint32_t RRSEL      : 1;            /* [31..31] Round-Robin Select                                               */
    } bit;
  } CTRL2;
} COMP_T;                                    /* Size = 12 (0xc)                                                              */



/* =========================================================================================================================== */
/* ================                                            PMU                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Power management unit (PMU)
  */

typedef struct {                                /* (@ 0x4007D000) PMU Structure                                              */

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000000) Low Voltage Detect Control and Status1 Register            */

    struct {
            uint8_t             : 4;
      __IOM uint8_t LVDEGSYSREN : 1;            /* [4..4] Low-Voltage Detect Event Generation System Reset Enable            */
      __OM  uint8_t LVDHWINTREN : 1;            /* [5..5] Low-Voltage Warning Error Acknowledge                              */
      __OM  uint8_t LVDERRACK   : 1;            /* [6..6] Low-Voltage Warning Error Acknowledge                              */
      __IM  uint8_t LVDEFLG     : 1;            /* [7..7] Low-Voltage Warning Event Flag                                     */
    } bit;
  } LVDCSTS1;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000001) Low Voltage Detect Control and Status2 Register            */

    struct {
            uint8_t             : 5;
      __IOM uint8_t LVWHWINTREN : 1;            /* [5..5] Low-Voltage Warning Hardware Interrupt Enable                      */
      __OM  uint8_t LVWERRACK   : 1;            /* [6..6] Low-Voltage Warning Error Acknowledge                              */
      __IM  uint8_t LVWEFLG     : 1;            /* [7..7] Low-Voltage Warning Event Flag                                     */
    } bit;
  } LVDCSTS2;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000002) Regulator Control and Status Register                      */

    struct {
      __IOM uint8_t BEN         : 1;            /* [0..0] Bias Enable                                                        */
      __IOM uint8_t CLKBDIS     : 1;            /* [1..1] Clock Bias Disable                                                 */
      __IM  uint8_t RFPMSTS     : 1;            /* [2..2] Regulator in Full Performance Mode Status                          */
            uint8_t             : 3;
      __IM  uint8_t LPOCLKSTS   : 1;            /* [6..6] LPO Clock Status                                                   */
      __IOM uint8_t LPODIS      : 1;            /* [7..7] LPO Disable                                                        */
    } bit;
  } REGCSTS;
  __IM  uint8_t   RESERVED;

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000004) Low Power Oscillator Trim Register                         */

    struct {
      __IOM uint8_t TLPOF     : 5;            /* [4..0] Trimming Low Power Oscillator Frequency                            */
            uint8_t             : 3;
    } bit;
  } LPOSCTRIM;
} PMU_T;                                     /* Size = 5 (0x5)                                                               */



/* =========================================================================================================================== */
/* ================                                           SYSMC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief System Mode Controller (SYSMC)
  */

typedef struct {                                /* (@ 0x4007E000) SYSMC Structure                                            */

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000000) Version ID Register                                        */

    struct {
      __IM  uint32_t FEATURE    : 16;           /* [15..0] Feature Number                                                    */
      __IM  uint32_t MINOR      : 8;            /* [23..16] Minor Version Number                                             */
      __IM  uint32_t MAJOR      : 8;            /* [31..24] Major Version Number                                             */
    } bit;
  } VERID;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000004) Feature Register                                           */

    struct {
      __IM  uint32_t HSRUNAVA   : 1;            /* [0..0] HSRUN Feature Available                                            */
      __IM  uint32_t RESERVED0  : 2;
      __IM  uint32_t LLSAVA     : 1;            /* [3..3] LLS Feature Available                                              */
      __IM  uint32_t RESERVED1  : 1;
      __IM  uint32_t LLS2AVA    : 1;            /* [5..5] LLS2 Feature Available                                             */
      __IM  uint32_t VLLS0AVA   : 1;            /* [6..6] VLLS0 Feature Available                                            */
      __IM  uint32_t RESERVED2  : 25;
    } bit;
  } FEATURE;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) Power Mode Protection register                             */

    struct {
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t ALLOWLP    : 1;            /* [5..5] Allow MCU Enter Very Low Power Mode                                */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t ALLOWHS    : 1;            /* [7..7] Allow MCU Enter High-Speed Run Mode                                */
      __IM  uint32_t RESERVED2  : 24;
    } bit;
  } PMPRO;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) Power Mode Control register                                */

    struct {
      __IOM uint32_t STOPCTRL   : 3;            /* [2..0] Stop Mode Control                                                  */
      __IM  uint32_t VLPSEA     : 1;            /* [3..3] Very Low Power Stop Mode Entry Aborted                             */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t RUNCTRL    : 2;            /* [6..5] Run Mode Control                                                   */
      __IM  uint32_t RESERVED1  : 25;
    } bit;
  } PMCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) Stop Operation Select Register                             */

    struct {
      __IM  uint32_t RESERVED0  : 6;
      __IOM uint32_t STOPOSEL   : 2;            /* [7..6] Stop Operation Select                                              */
      __IM  uint32_t RESERVED1  : 24;
    } bit;
  } STOPOSEL;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000014) Power Mode Status register                                 */

    struct {
      __IM  uint32_t PMSTS      : 8;            /* [7..0] Power Mode Status                                                  */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } PMSTS;
} SYSMC_T;                                   /* Size = 24 (0x18)                                                             */



/* =========================================================================================================================== */
/* ================                                            RMU                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Reset Management unit (RMU)
  */

typedef struct {                                /* (@ 0x4007F000) RMU Structure                                              */

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000000) Version ID Register                                        */

    struct {
      __IM  uint32_t FEATURE    : 16;           /* [15..0] Feature ID                                                        */
      __IM  uint32_t MINOR      : 8;            /* [23..16] Minor Version ID                                                 */
      __IM  uint32_t MAJOR      : 8;            /* [31..24] Major Version ID                                                 */
    } bit;
  } VERID;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000004) Parameter Register                                         */

    struct {
      __IM  uint32_t RESERVED0  : 1;
      __IM  uint32_t LVDRSTSTS  : 1;            /* [1..1] Low Voltage Detection Reset Function Status                        */
      __IM  uint32_t CLKLRSTSTS : 1;            /* [2..2] Clock Loss Reset Function Status                                   */
      __IM  uint32_t LOCKLRSTSTS : 1;           /* [3..3] Lock Loss Reset Function Status                                    */
      __IM  uint32_t RESERVED1  : 1;
      __IM  uint32_t WDTRSTSTS  : 1;            /* [5..5] Watchdog Timer Reset Function Status                               */
      __IM  uint32_t ERSTSTS    : 1;            /* [6..6] External Pin Reset Function Status                                 */
      __IM  uint32_t PORRSTSTS  : 1;            /* [7..7] POR Reset Function Status                                          */
      __IM  uint32_t JTAGRSTSTS : 1;            /* [8..8] JTAG Reset Function Status                                         */
      __IM  uint32_t CLOCKRSTSTS : 1;           /* [9..9] Core Lockup Reset Function Status                                  */
      __IM  uint32_t SWRSTSTS   : 1;            /* [10..10] Software Reset Function Status                                   */
      __IM  uint32_t SRSTSTS    : 1;            /* [11..11] System Reset Function Status                                     */
      __IM  uint32_t RESERVED2  : 1;
      __IM  uint32_t STOPACKERSTSTS : 1;        /* [13..13] Stop Acknowledge Error Reset Function Status                     */
      __IM  uint32_t RESERVED3  : 18;
    } bit;
  } PARA;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000008) Reset Status Register                                      */

    struct {
      __IM  uint32_t RESERVED0  : 1;
      __IM  uint32_t LVDRSTFLG  : 1;            /* [1..1] Low Voltage Detection Reset Flag                                   */
      __IM  uint32_t CLKLRSTFLG : 1;            /* [2..2] Clock Loss Reset Flag                                              */
      __IM  uint32_t LOCKLRSTFLG : 1;           /* [3..3] Lock Loss Reset Flag                                               */
      __IM  uint32_t RESERVED1  : 1;
      __IM  uint32_t WDTTOFFLG  : 1;            /* [5..5] Watchdog Timer Timeout Flag                                        */
      __IM  uint32_t ERSTPFLG   : 1;            /* [6..6] External Reset Pin Flag                                            */
      __IM  uint32_t PORFLG     : 1;            /* [7..7] POR Flag                                                           */
      __IM  uint32_t JTAGRSTFLG : 1;            /* [8..8] JTAG Reset Flag                                                    */
      __IM  uint32_t CLOCKEFLG  : 1;            /* [9..9] Core Lockup Event Flag                                             */
      __IM  uint32_t SWSETFLG   : 1;            /* [10..10] Software Set Flag                                                */
      __IM  uint32_t SRSTREQFLG : 1;            /* [11..11] System Reset Request Flag                                        */
      __IM  uint32_t RESERVED2  : 1;
      __IM  uint32_t STOPACKEFLG : 1;           /* [13..13] Stop Acknowledge Error Flag                                      */
      __IM  uint32_t RESERVED3  : 18;
    } bit;
  } RSTFLG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) Reset Pin Control register                                 */

    struct {
      __IOM uint32_t RSTPFSEL   : 2;            /* [1..0] Reset Pin Filter Select in Run and Wait Modes                      */
      __IOM uint32_t RSTPFEN    : 1;            /* [2..2] Reset Pin Filter Enable in Stop Mode                               */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t RSTPBCLKWSEL : 5;          /* [12..8] Reset Pin Bus Clock Filter Width Select                           */
      __IM  uint32_t RESERVED1  : 19;
    } bit;
  } RSTPCTRL;
  __IM  uint32_t  RESERVED[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) Sticky Reset Flag Register                                 */

    struct {
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t LVDRSTRCD  : 1;            /* [1..1] LVD Reset Record                                                   */
      __IOM uint32_t ECLKLRSTRCD : 1;           /* [2..2] Clock Loss Reset Record                                            */
      __IOM uint32_t LOCKLRSTRCD : 1;           /* [3..3] Lock Loss Reset Record                                             */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t WDTRSTRCD  : 1;            /* [5..5] Watchdog Timer Reset Record                                        */
      __IOM uint32_t EPRSTRCD   : 1;            /* [6..6] External Pin Reset Record                                          */
      __IOM uint32_t PORRCD     : 1;            /* [7..7] Power-On Reset Record                                              */
      __IOM uint32_t JTAGRSTRCD : 1;            /* [8..8] JTAG Reset Record                                                  */
      __IOM uint32_t CLOCKRCD   : 1;            /* [9..9] Core Lockup Reset Record                                           */
      __IOM uint32_t SWRSTRCD   : 1;            /* [10..10] Software Reset Record                                            */
      __IOM uint32_t SRSTREGRCD : 1;            /* [11..11] System Reset Request Record                                      */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t STOPACKERSTRCD : 1;        /* [13..13] Stop Acknowledge Error Reset Record                              */
      __IM  uint32_t RESERVED3  : 18;
    } bit;
  } SRSTFLG;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000001C) Reset Interrupt Enable Register                            */

    struct {
      __IOM uint32_t RSTDTIMCFG : 2;            /* [1..0] Reset Delay Time Configure                                         */
      __IOM uint32_t CLKLIEN    : 1;            /* [2..2] Clock Loss Interrupt Enable                                        */
      __IOM uint32_t LOCKLIEN   : 1;            /* [3..3] Lock Loss Interrupt Enable                                         */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t WDTIEN     : 1;            /* [5..5] Watchdog Timer Interrupt Enable                                    */
      __IOM uint32_t EXTPIEN    : 1;            /* [6..6] External Reset Pin Interrupt Enable                                */
      __IOM uint32_t GIEN       : 1;            /* [7..7] Global Interrupt Enable                                            */
      __IOM uint32_t JTAGIEN    : 1;            /* [8..8] JTAG Interrupt Enable                                              */
      __IOM uint32_t CLOCKIEN   : 1;            /* [9..9] Core Lockup Interrupt Enable                                       */
      __IOM uint32_t SWIEN      : 1;            /* [10..10] Software Interrupt Enable                                        */
      __IOM uint32_t SRSTREQEN  : 1;            /* [11..11] System Reset Request Enable                                      */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t SACKEIEN   : 1;            /* [13..13] Stop Acknowledge Error Interrupt Enable                          */
      __IM  uint32_t RESERVED2  : 18;
    } bit;
  } RSTIEN;
} RMU_T;                                     /* Size = 32 (0x20)                                                          */



/* =========================================================================================================================== */
/* ================                                           GPIO                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose Input/Output (GPIO)
  */

typedef struct {                                /*  GPIO Structure  (@ 0x400FF000)GPIOA (@ 0x400FF040)GPIOB (@ 0x400FF080)GPIOC (@ 0x400FF0C0)GPIOD (@ 0x400FF100)GPIOE */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Port Logic Level Output Register                           */

    struct {
      __IOM uint32_t PLLO       : 32;           /* [31..0] Port Logic Level Output                                           */
    } bit;
  } PLLO;

  union {
    __OM  uint32_t reg;                         /* (@ 0x00000004) Port Logic Level Output Set Register                       */

    struct {
      __OM  uint32_t PLLOS      : 32;           /* [31..0] Port Logic Level Output Set                                       */
    } bit;
  } PLLOS;

  union {
    __OM  uint32_t reg;                         /* (@ 0x00000008) Port Logic Level Output Clear Register                     */

    struct {
      __OM  uint32_t PLLOC      : 32;           /* [31..0] Port Logic Level Output Clear                                     */
    } bit;
  } PLLOC;

  union {
    __OM  uint32_t reg;                         /* (@ 0x0000000C) Port Logic Level Output Toggle Register                    */

    struct {
      __OM  uint32_t PLLOT      : 32;           /* [31..0] Port Logic Level Output Toggle                                    */
    } bit;
  } PLLOT;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000010) Port Logic Level Input Register                            */

    struct {
      __IM  uint32_t PLLI       : 32;           /* [31..0] Port Logic Level Input                                            */
    } bit;
  } PLLI;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000014) Port Logic Level Transfer Direction Select Register        */

    struct {
      __IOM uint32_t PLLTDS     : 32;           /* [31..0] Port Logic Level Transfer Direction Select                        */
    } bit;
  } PLLTDS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000018) Port Logic Level Input Disable Register                    */

    struct {
      __IOM uint32_t PLLID      : 32;           /* [31..0] Port Logic Level Input Disable                                    */
    } bit;
  } PLLID;
} GPIO_T;                                   /* Size = 28 (0x1c)                                                              */



/* =========================================================================================================================== */
/* ================                                          APM32_SCB                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief System Control Registers (APM32_SCB)
  */

typedef struct {                                /* (@ 0xE000E000) APM32_SCB Structure                                          */
  __IM  uint32_t  RESERVED[2];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) Auxiliary Control Register,                                */

    struct {
      __IOM uint32_t DISMCYCINT : 1;            /* [0..0] Disables interruption of multi-cycle instructions.                 */
      __IOM uint32_t DISDEFWBUF : 1;            /* [1..1] Disables write buffer use during default memory map accesses.      */
      __IOM uint32_t DISFOLD    : 1;            /* [2..2] Disables folding of IT instructions.                               */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t DISFPCA    : 1;            /* [8..8] SBZP / Disables automatic update of CONTROL.FPCA.                  */
      __IOM uint32_t DISOOFP    : 1;            /* [9..9] Disables floating point instructions completing out of
                                                     order with respect to integer instructions.                             */
      __IM  uint32_t RESERVED1  : 22;
    } bit;
  } ACTLR;
  __IM  uint32_t  RESERVED1[829];

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000D00) CPUID Base Register                                        */

    struct {
      __IM  uint32_t REVISION   : 4;            /* [3..0] Indicates patch release: 0x0 = Patch 0                             */
      __IM  uint32_t PARTNO     : 12;           /* [15..4] Indicates part number                                             */
      __IM  uint32_t RESERVED2  : 4;
      __IM  uint32_t VARIANT    : 4;            /* [23..20] Indicates processor revision: 0x2 = Revision 2                   */
      __IM  uint32_t IMPLEMENTER : 8;           /* [31..24] Implementer code                                                 */
    } bit;
  } CPUID;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D04) Interrupt Control and State Register                       */

    struct {
      __IM  uint32_t VECTACTIVE : 9;            /* [8..0] Active exception number                                            */
      __IM  uint32_t RESERVED0  : 2;
      __IM  uint32_t RETTOBASE  : 1;            /* [11..11] Indicates whether there are preempted active exceptions          */
      __IM  uint32_t VECTPENDING : 6;           /* [17..12] Exception number of the highest priority pending enabled
                                                     exception                                                               */
      __IM  uint32_t RESERVED1  : 4;
      __IM  uint32_t ISRPENDING : 1;            /* [22..22] Interrupt pending flag, excluding NMI and Faults                 */
      __IM  uint32_t ISRPREEMPT : 1;            /* [23..23] You must only use this at debug time. It indicates
                                                     that a pending interrupt becomes active in the next running
                                                     cycle. If C_MASKINTS is clear in the Debug Halting Control
                                                     and Status Register, the interrupt is serviced                          */
      __IM  uint32_t RESERVED2  : 1;
      __OM  uint32_t PENDSTCLR  : 1;            /* [25..25] SysTick exception clear-pending bit                              */
      __IOM uint32_t PENDSTSET  : 1;            /* [26..26] SysTick exception set-pending bit                                */
      __OM  uint32_t PENDSVCLR  : 1;            /* [27..27] PendSV clear-pending bit                                         */
      __IOM uint32_t PENDSVSET  : 1;            /* [28..28] PendSV set-pending bit                                           */
      __IM  uint32_t RESERVED3  : 2;
      __IOM uint32_t NMIPENDSET : 1;            /* [31..31] NMI set-pending bit                                              */
    } bit;
  } ICSR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D08) Vector Table Offset Register                               */

    struct {
      __IM  uint32_t RESERVED0  : 7;
      __IOM uint32_t TBLOFF     : 25;           /* [31..7] Vector table base offset                                          */
    } bit;
  } VTOR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D0C) Application Interrupt and Reset Control Register           */

    struct {
      __OM  uint32_t VECTRESET  : 1;            /* [0..0] Reserved for Debug use. This bit reads as 0. When writing
                                                     to the register you must write 0 to this bit, otherwise
                                                     behavior is Unpredictable.                                              */
      __OM  uint32_t VECTCLRACTIVE : 1;         /* [1..1] Reserved for Debug use. This bit reads as 0. When writing
                                                     to the register you must write 0 to this bit, otherwise
                                                     behavior is Unpredictable.                                              */
      __OM  uint32_t SYSRESETREQ : 1;           /* [2..2] System reset request bit is implementation defined                 */
      __IM  uint32_t RESERVED0  : 5;
      __IOM uint32_t PRIGROUP   : 3;            /* [10..8] Interrupt priority grouping field. This field determines
                                                     the split of group priority from subpriority.                           */
      __IM  uint32_t RESERVED1  : 4;
      __IM  uint32_t ENDIANNESS : 1;            /* [15..15] Data endianness bit is implementation defined                    */
      __IOM uint32_t VECTKEY    : 16;           /* [31..16] Register key                                                     */
    } bit;
  } AIRCR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D10) System Control Register                                    */

    struct {
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t SLEEPONEXIT : 1;           /* [1..1] Indicates sleep-on-exit when returning from Handler mode
                                                     to Thread mode                                                          */
      __IOM uint32_t SLEEPDEEP  : 1;            /* [2..2] Controls whether the processor uses sleep or deep sleep
                                                     as its low power mode                                                   */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t SEVONPEND  : 1;            /* [4..4] Send Event on Pending bit                                          */
      __IM  uint32_t RESERVED2  : 27;
    } bit;
  } SCR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D14) Configuration and Control Register                         */

    struct {
      __IOM uint32_t NONBASETHRDENA : 1;        /* [0..0] Indicates how the processor enters Thread mode                     */
      __IOM uint32_t USERSETMPEND : 1;          /* [1..1] Enables unprivileged software access to the STIR                   */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t UNALIGN_TRP : 1;           /* [3..3] Enables unaligned access traps                                     */
      __IOM uint32_t DIV_0_TRP  : 1;            /* [4..4] Enables faulting or halting when the processor executes
                                                     an SDIV or UDIV instruction with a divisor of 0                         */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t BFHFNMIGN  : 1;            /* [8..8] Enables handlers with priority -1 or -2 to ignore data
                                                     BusFaults caused by load and store instructions.                        */
      __IOM uint32_t STKALIGN   : 1;            /* [9..9] Indicates stack alignment on exception entry                       */
      __IM  uint32_t RESERVED2  : 22;
    } bit;
  } CCR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D18) System Handler Priority Register 1                         */

    struct {
      __IOM uint32_t PRI_4      : 8;            /* [7..0] Priority of system handler 4, MemManage                            */
      __IOM uint32_t PRI_5      : 8;            /* [15..8] Priority of system handler 5, BusFault                            */
      __IOM uint32_t PRI_6      : 8;            /* [23..16] Priority of system handler 6, UsageFault                         */
      __IM  uint32_t RESERVED0  : 8;
    } bit;
  } SHPR1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D1C) System Handler Priority Register 2                         */

    struct {
      __IM  uint32_t RESERVED0  : 24;
      __IOM uint32_t PRI_11     : 8;            /* [31..24] Priority of system handler 11, SVCall                            */
    } bit;
  } SHPR2;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D20) System Handler Priority Register 3                         */

    struct {
      __IOM uint32_t PRI_12     : 8;            /* [7..0] Priority of system handler 12, DebugMonitor                        */
      __IM  uint32_t RESERVED0  : 8;
      __IOM uint32_t PRI_14     : 8;            /* [23..16] Priority of system handler 14, PendSV                            */
      __IOM uint32_t PRI_15     : 8;            /* [31..24] Priority of system handler 15, SysTick exception                 */
    } bit;
  } SHPR3;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D24) System Handler Control and State Register                  */

    struct {
      __IOM uint32_t MEMFAULTACT : 1;           /* [0..0] MemManage exception active bit, reads as 1 if exception
                                                     is active                                                               */
      __IOM uint32_t BUSFAULTACT : 1;           /* [1..1] BusFault exception active bit, reads as 1 if exception
                                                     is active                                                               */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t USGFAULTACT : 1;           /* [3..3] UsageFault exception active bit, reads as 1 if exception
                                                     is active                                                               */
      __IM  uint32_t RESERVED1  : 3;
      __IOM uint32_t SVCALLACT  : 1;            /* [7..7] SVCall active bit, reads as 1 if SVC call is active                */
      __IOM uint32_t MONITORACT : 1;            /* [8..8] Debug monitor active bit, reads as 1 if Debug monitor
                                                     is active                                                               */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t PENDSVACT  : 1;            /* [10..10] PendSV exception active bit, reads as 1 if exception
                                                     is active                                                               */
      __IOM uint32_t SYSTICKACT : 1;            /* [11..11] SysTick exception active bit, reads as 1 if exception
                                                     is active                                                               */
      __IOM uint32_t USGFAULTPENDED : 1;        /* [12..12] UsageFault exception pending bit, reads as 1 if exception
                                                     is pending                                                              */
      __IOM uint32_t MEMFAULTPENDED : 1;        /* [13..13] MemManage exception pending bit, reads as 1 if exception
                                                     is pending                                                              */
      __IOM uint32_t BUSFAULTPENDED : 1;        /* [14..14] BusFault exception pending bit, reads as 1 if exception
                                                     is pending                                                              */
      __IOM uint32_t SVCALLPENDED : 1;          /* [15..15] SVCall pending bit, reads as 1 if exception is pending           */
      __IOM uint32_t MEMFAULTENA : 1;           /* [16..16] MemManage enable bit, set to 1 to enable                         */
      __IOM uint32_t BUSFAULTENA : 1;           /* [17..17] BusFault enable bit, set to 1 to enable                          */
      __IOM uint32_t USGFAULTENA : 1;           /* [18..18] UsageFault enable bit, set to 1 to enable                        */
      __IM  uint32_t RESERVED3  : 13;
    } bit;
  } SHCSR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D28) Configurable Fault Status Registers                        */

    struct {
      __IOM uint32_t IACCVIOL   : 1;            /* [0..0] Instruction access violation flag                                  */
      __IOM uint32_t DACCVIOL   : 1;            /* [1..1] Data access violation flag                                         */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t MUNSTKERR  : 1;            /* [3..3] MemManage fault on unstacking for a return from exception          */
      __IOM uint32_t MSTKERR    : 1;            /* [4..4] MemManage fault on stacking for exception entry                    */
      __IOM uint32_t MLSPERR    : 1;            /* [5..5] Indicates whether MemManage fault occured during floating-point
                                                     lazy state preservation                                                   */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t MMARVALID  : 1;            /* [7..7] MemManage Fault Address Register (MMFAR) valid flag                */
      __IOM uint32_t IBUSERR    : 1;            /* [8..8] Instruction bus error                                              */
      __IOM uint32_t PRECISERR  : 1;            /* [9..9] Precise data bus error                                             */
      __IOM uint32_t IMPRECISERR : 1;           /* [10..10] Imprecise data bus error                                         */
      __IOM uint32_t UNSTKERR   : 1;            /* [11..11] BusFault on unstacking for a return from exception               */
      __IOM uint32_t STKERR     : 1;            /* [12..12] BusFault on stacking for exception entry                         */
      __IOM uint32_t LSPERR     : 1;            /* [13..13] Indicates whether bus fault fault occured during floating-point
                                                     lazy state preservation                                                   */
      __IM  uint32_t RESERVED2  : 1;
      __IOM uint32_t BFARVALID  : 1;            /* [15..15] BusFault Address Register (BFAR) valid flag                      */
      __IOM uint32_t UNDEFINSTR : 1;            /* [16..16] Undefined instruction UsageFault                                 */
      __IOM uint32_t INVSTATE   : 1;            /* [17..17] Invalid state UsageFault                                         */
      __IOM uint32_t INVPC      : 1;            /* [18..18] Invalid PC load UsageFault, caused by an invalid PC
                                                     load by EXC_RETURN                                                        */
      __IOM uint32_t NOCP       : 1;            /* [19..19] No coprocessor UsageFault. The processor does not support
                                                     coprocessor instructions                                                  */
      __IM  uint32_t RESERVED3  : 4;
      __IOM uint32_t UNALIGNED  : 1;            /* [24..24] Unaligned access UsageFault                                      */
      __IOM uint32_t DIVBYZERO  : 1;            /* [25..25] Divide by zero UsageFault                                        */
      __IM  uint32_t RESERVED4  : 6;
    } bit;
  } CFSR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D2C) HardFault Status register                                  */

    struct {
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t VECTTBL    : 1;            /* [1..1] Indicates a BusFault on a vector table read during exception
                                                     processing                                                              */
      __IM  uint32_t RESERVED1  : 28;
      __IOM uint32_t FORCED     : 1;            /* [30..30] Indicates a forced hard fault, generated by escalation
                                                     of a fault with configurable priority that cannot be handles,
                                                     either because of priority or because it is disabled                    */
      __IOM uint32_t DEBUGEVT   : 1;            /* [31..31] Reserved for Debug use. When writing to the register
                                                     you must write 0 to this bit, otherwise behavior is Unpredictable.      */
    } bit;
  } HFSR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D30) Debug Fault Status Register                                */

    struct {
      __IOM uint32_t HALTED     : 1;            /* [0..0] HALTED                                                             */
      __IOM uint32_t BKPT       : 1;            /* [1..1] BKPT                                                               */
      __IOM uint32_t DWTTRAP    : 1;            /* [2..2] DWTTRAP                                                            */
      __IOM uint32_t VCATCH     : 1;            /* [3..3] VCATCH                                                             */
      __IOM uint32_t EXTERNAL   : 1;            /* [4..4] EXTERNAL                                                           */
      __IM  uint32_t RESERVED0  : 27;
    } bit;
  } DFSR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D34) MemManage Address Register                                 */

    struct {
      __IOM uint32_t ADDRESS    : 32;           /* [31..0] Address of MemManage fault location                               */
    } bit;
  } MMFAR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D38) BusFault Address Register                                  */

    struct {
      __IOM uint32_t ADDRESS    : 32;           /* [31..0] Address of the BusFault location                                  */
    } bit;
  } BFAR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D3C) Auxiliary Fault Status Register                            */

    struct {
      __IOM uint32_t AUXFAULT   : 32;           /* [31..0] Latched version of the AUXFAULT inputs                            */
    } bit;
  } AFSR;
  __IM  uint32_t  RESERVED2[18];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000D88) Coprocessor Access Control Register                        */

    struct {
      __IM  uint32_t RESERVED0  : 20;
      __IOM uint32_t CP10       : 2;            /* [21..20] Access privileges for coprocessor 10.                            */
      __IOM uint32_t CP11       : 2;            /* [23..22] Access privileges for coprocessor 11.                            */
      __IM  uint32_t RESERVED1  : 8;
    } bit;
  } CPACR;
  __IM  uint32_t  RESERVED3[106];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000F34) Floating-point Context Control Register                    */

    struct {
      __IOM uint32_t LSPACT     : 1;            /* [0..0] Lazy state preservation.                                           */
      __IOM uint32_t USER       : 1;            /* [1..1] Privilege level when the floating-point stack frame was
                                                     allocated.                                                              */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t THREAD     : 1;            /* [3..3] Mode when the floating-point stack frame was allocated.            */
      __IOM uint32_t HFRDY      : 1;            /* [4..4] Permission to set the HardFault handler to the pending
                                                     state when the floating-point stack frame was allocated.                */
      __IOM uint32_t MMRDY      : 1;            /* [5..5] Permission to set the MemManage handler to the pending
                                                     state when the floating-point stack frame was allocated.                */
      __IOM uint32_t BFRDY      : 1;            /* [6..6] Permission to set the BusFault handler to the pending
                                                     state when the floating-point stack frame was allocated.                */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t MONRDY     : 1;            /* [8..8] Permission to set the MON_PEND when the floating-point
                                                     stack frame was allocated.                                              */
      __IM  uint32_t RESERVED2  : 21;
      __IOM uint32_t LSPEN      : 1;            /* [30..30] Lazy state preservation for floating-point context.              */
      __IOM uint32_t ASPEN      : 1;            /* [31..31] Enables CONTROL2 setting on execution of a floating-point
                                                     instruction. This results in automatic hardware state preservation
                                                     and restoration, for floating-point context, on exception
                                                     entry and exit.                                                         */
    } bit;
  } FPCCR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000F38) Floating-point Context Address Register                    */

    struct {
      __IM  uint32_t RESERVED0  : 3;
      __IOM uint32_t ADDRESS    : 29;           /* [31..3] The location of the unpopulated floating-point register
                                                     space allocated on an exception stack frame.                            */
    } bit;
  } FPCAR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000F3C) Floating-point Default Status Control Register             */

    struct {
      __IM  uint32_t RESERVED0  : 22;
      __IOM uint32_t RMode      : 2;            /* [23..22] Default value for FPSCR.RMode (Rounding Mode control
                                                     field).                                                                 */
      __IOM uint32_t FZ         : 1;            /* [24..24] Default value for FPSCR.FZ (Flush-to-zero mode control
                                                     bit).                                                                   */
      __IOM uint32_t DN         : 1;            /* [25..25] Default value for FPSCR.DN (Default NaN mode control
                                                     bit).                                                                   */
      __IOM uint32_t AHP        : 1;            /* [26..26] Default value for FPSCR.AHP (Alternative half-precision
                                                     control bit).                                                           */
      __IM  uint32_t RESERVED1  : 5;
    } bit;
  } FPDSCR;
} APM32_SCB_T;                                 /* Size = 3904 (0xf40)                                                          */



/* =========================================================================================================================== */
/* ================                                        APM32_SysTick                                        ================ */
/* =========================================================================================================================== */


/**
  * @brief System timer (APM32_SysTick)
  */

typedef struct {                                /* (@ 0xE000E010) APM32_SysTick Structure                                      */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) SysTick Control and Status Register                        */

    struct {
      __IOM uint32_t ENABLE     : 1;            /* [0..0] Enables the counter                                                */
      __IOM uint32_t TICKINT    : 1;            /* [1..1] Enables SysTick exception request                                  */
      __IOM uint32_t CLKSOURCE  : 1;            /* [2..2] Indicates the clock source                                         */
      __IM  uint32_t RESERVED0  : 13;
      __IOM uint32_t COUNTFLAG  : 1;            /* [16..16] Returns 1 if timer counted to 0 since last time this
                                                     was read                                                                */
      __IM  uint32_t RESERVED1  : 15;
    } bit;
  } CSR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) SysTick Reload Value Register                              */

    struct {
      __IOM uint32_t RELOAD     : 24;           /* [23..0] Value to load into the SysTick Current Value Register
                                                     when the counter reaches 0                                              */
      __IM  uint32_t RESERVED0  : 8;
    } bit;
  } RVR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) SysTick Current Value Register                             */

    struct {
      __IOM uint32_t CURRENT    : 24;           /* [23..0] Current value at the time the register is accessed                */
      __IM  uint32_t RESERVED0  : 8;
    } bit;
  } CVR;

  union {
    __IM  uint32_t reg;                         /* (@ 0x0000000C) SysTick Calibration Value Register                         */

    struct {
      __IM  uint32_t TENMS      : 24;           /* [23..0] Reload value to use for 10ms timing                               */
      __IM  uint32_t RESERVED0  : 6;
      __IM  uint32_t SKEW       : 1;            /* [30..30] Indicates whether the TENMS value is exact                       */
      __IM  uint32_t NOREF      : 1;            /* [31..31] Indicates whether the device provides a reference clock
                                                     to the processor                                                        */
    } bit;
  } CALIB;
} APM32_SysTick_T;                             /* Size = 16 (0x10)                                                             */



/* =========================================================================================================================== */
/* ================                                         APM32_NVIC                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Nested Vectored Interrupt Controller (APM32_NVIC)
  */

typedef struct {                                /* (@ 0xE000E100) APM32_NVIC Structure                                         */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Interrupt Set Enable Register n                            */

    struct {
      __IOM uint32_t SETENA     : 32;           /* [31..0] Interrupt set enable bits                                         */
    } bit;
  } NVICISER[8];

  __IM  uint32_t  RESERVED[24];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000080) Interrupt Clear Enable Register n                          */

    struct {
      __IOM uint32_t CLRENA     : 32;           /* [31..0] Interrupt clear-enable bits                                       */
    } bit;
  } NVICICER[8];

  __IM  uint32_t  RESERVED1[24];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000100) Interrupt Set Pending Register n                           */

    struct {
      __IOM uint32_t SETPEND    : 32;           /* [31..0] Interrupt set-pending bits                                        */
    } bit;
  } NVICISPR[8];

  __IM  uint32_t  RESERVED2[24];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000180) Interrupt Clear Pending Register n                         */

    struct {
      __IOM uint32_t CLRPEND    : 32;           /* [31..0] Interrupt clear-pending bits                                      */
    } bit;
  } NVICICPR[8];

  __IM  uint32_t  RESERVED3[24];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000200) Interrupt Active bit Register n                            */

    struct {
      __IOM uint32_t ACTIVE     : 32;           /* [31..0] Interrupt active flags                                            */
    } bit;
  } NVICIABR[8];

  __IM  uint32_t  RESERVED4[56];

  union {
    __IOM uint8_t reg;                          /* (@ 0x00000300) Interrupt Priority Register n                              */

    struct {
      __IOM uint8_t PRI        : 8;            /* [7..0] Priority of interrupt 0                                             */
    } bit;
  } NVICIP[240];

  __IM  uint32_t  RESERVED5[644];

  union {
    __OM  uint32_t reg;                         /* (@ 0x00000E00) Software Trigger Interrupt Register                        */

    struct {
      __OM  uint32_t INTID      : 9;            /* [8..0] Interrupt ID of the interrupt to trigger, in the range
                                                     0-239. For example, a value of 0x03 specifies interrupt
                                                     IRQ3.                                                                   */
      __IM  uint32_t RESERVED0  : 23;
    } bit;
  } NVICSTIR;
} APM32_NVIC_T;                                /* Size = 3588 (0xe04)                                                          */



/* =========================================================================================================================== */
/* ================                                            MC                                             ================ */
/* =========================================================================================================================== */


/**
  * @brief Core Platform Miscellaneous Control Module (MC)
  */

typedef struct {                                /* (@ 0xE0080000) MC Structure                                               */
  __IM  uint32_t  RESERVED[2];

  union {
    __IM  uint16_t reg;                         /* (@ 0x00000008) XBARSW Slave Input Port Connection Status                  */

    struct {
      __IM  uint16_t SINCFLG    : 8;            /* [7..0] XBARSW Slave Input Port Connection Flag                            */
            uint16_t            : 8;
    } bit;
  } SINCSTS;

  union {
    __IM  uint16_t reg;                         /* (@ 0x0000000A) XBARSW Master Input Port Connection Status                 */

    struct {
      __IM  uint16_t MINCFLG    : 8;            /* [7..0] XBARSW Master Input Port Connection Flag                           */
            uint16_t            : 8;
    } bit;
  } MINCSTS;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) Core Platform Control Register                             */

    struct {
      __IM  uint32_t HMSTS      : 2;            /* [1..0] XBARSW Halt Machine Status                                         */
      __IM  uint32_t RXHREQFLG  : 1;            /* [2..2] XBARSW Receive Halt Request Flag                                   */
      __IM  uint32_t HSTS       : 1;            /* [3..3] XBARSW Halt Status                                                 */
      __IM  uint32_t FMCPGISTS  : 1;            /* [4..4] Flash Memory Controller Program Idle Status                        */
      __IM  uint32_t RESERVED0  : 1;
      __IM  uint32_t ACISTS     : 1;            /* [6..6] AC Idle Status                                                     */
      __IM  uint32_t RESERVED1  : 2;
      __IOM uint32_t CASEL      : 1;            /* [9..9] Crossbar Arbitration Select                                        */
      __IM  uint32_t RESERVED2  : 14;
      __IOM uint32_t SHAPCFG    : 2;            /* [25..24] SRAM_H Arbitration Priority Configure                            */
      __IOM uint32_t SHWPRO     : 1;            /* [26..26] SRAM_H Write Protect                                             */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t SLAPCFG    : 2;            /* [29..28] SRAM_L Arbitration Priority Configure                            */
      __IOM uint32_t SLWPRO     : 1;            /* [30..30] SRAM_L Write Protect                                             */
      __IM  uint32_t RESERVED4  : 1;
    } bit;
  } CPCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000010) FPU Interrupt Control and Status Register                  */

    struct {
      __IM  uint32_t RESERVED0  : 8;
      __IM  uint32_t INVALIDIFLG : 1;           /* [8..8] FPU Invalid Operation Interrupt Flag                               */
      __IM  uint32_t ZEROIFLG   : 1;            /* [9..9] FPU Divide-by-Zero Interrupt Flag                                  */
      __IM  uint32_t OVRIFLG    : 1;            /* [10..10] FPU Overflow Interrupt Flag                                      */
      __IM  uint32_t UDRIFLG    : 1;            /* [11..11] FPU Underflow Interrupt Flag                                     */
      __IM  uint32_t INEXACTIFLG : 1;           /* [12..12] FPU Inexact Interrupt Flag                                       */
      __IM  uint32_t RESERVED1  : 2;
      __IM  uint32_t INDIFLG    : 1;            /* [15..15] FPU Input Denormal Interrupt Flag                                */
      __IM  uint32_t RESERVED2  : 8;
      __IOM uint32_t INVALIDEN  : 1;            /* [24..24] FPU Invalid Operation Enable                                     */
      __IOM uint32_t ZEROEN     : 1;            /* [25..25] FPU Divide-by-Zero Enable                                        */
      __IOM uint32_t OVRIEN     : 1;            /* [26..26] FPU Overflow Enable                                              */
      __IOM uint32_t UDRIEN     : 1;            /* [27..27] FPU Underflow Enable                                             */
      __IOM uint32_t INEXACTIEN : 1;            /* [28..28] FPU Inexact Enable                                               */
      __IM  uint32_t RESERVED3  : 2;
      __IOM uint32_t INDIEN     : 1;            /* [31..31] FPU Input Denormal Enable                                        */
    } bit;
  } FPU_INTCSTS;
  __IM  uint32_t  RESERVED1[7];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000030) Process ID Register                                        */

    struct {
      __IOM uint32_t PID        : 8;            /* [7..0] M0_PID and M1_PID Values in the MPU Drive                          */
      __IM  uint32_t RESERVED0  : 24;
    } bit;
  } PID;
  __IM  uint32_t  RESERVED2[3];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000040) Compute Operation Control Register                         */

    struct {
      __IOM uint32_t COREQ      : 1;            /* [0..0] Compute Operation Request                                          */
      __IM  uint32_t COACK      : 1;            /* [1..1] Compute Operation Acknowledge                                      */
      __IOM uint32_t COWBI      : 1;            /* [2..2] Compute Operation Wakeup By Interrupt                              */
      __IM  uint32_t RESERVED0  : 29;
    } bit;
  } COCTRL;
  __IM  uint32_t  RESERVED3[239];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000400) Local Memory Descriptor Register0                          */

    struct {
      __IOM uint32_t ECCCTRL    : 4;            /* [3..0] TCM ECC Control                                                    */
      __IM  uint32_t RESERVED0  : 9;
      __IM  uint32_t TSEL       : 3;            /* [15..13] Local Memory Type Select                                         */
      __IOM uint32_t LOCK       : 1;            /* [16..16] LOCK                                                             */
      __IM  uint32_t DPWSEL     : 3;            /* [19..17] LMC Data Path Width Select                                       */
      __IM  uint32_t CWCFG      : 4;            /* [23..20] Level 1 Cache Ways Configure                                     */
      __IM  uint32_t SIZE       : 4;            /* [27..24] LMC Size                                                         */
      __IM  uint32_t SIZEH      : 1;            /* [28..28] LMC Size Hole                                                    */
      __IM  uint32_t RESERVED1  : 2;
      __IM  uint32_t VALID      : 1;            /* [31..31] Local Memory Valid                                               */
    } bit;
  } LMDES0;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000404) Local Memory Descriptor Register1                          */

    struct {
      __IOM uint32_t ECCCTRL    : 4;            /* [3..0] TCM ECC Control                                                    */
      __IM  uint32_t RESERVED0  : 9;
      __IM  uint32_t TSEL       : 3;            /* [15..13] Local Memory Type Select                                         */
      __IOM uint32_t LOCK       : 1;            /* [16..16] LOCK                                                             */
      __IM  uint32_t DPWSEL     : 3;            /* [19..17] LMC Data Path Width Select                                       */
      __IM  uint32_t CWCFG      : 4;            /* [23..20] Level 1 Cache Ways Configure                                     */
      __IM  uint32_t SIZE       : 4;            /* [27..24] LMC Size                                                         */
      __IM  uint32_t SIZEH      : 1;            /* [28..28] LMC Size Hole                                                    */
      __IM  uint32_t RESERVED1  : 2;
      __IM  uint32_t VALID      : 1;            /* [31..31] Local Memory Valid                                               */
    } bit;
  } LMDES1;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000408) Local Memory Descriptor Register2                          */

    struct {
      __IM  uint32_t RESERVED0  : 4;
      __IOM uint32_t CPFCTRL    : 4;            /* [7..4] Cache Parity Functions Control                                     */
      __IM  uint32_t RESERVED1  : 5;
      __IM  uint32_t TSEL       : 3;            /* [15..13] Local Memory Type Select                                         */
      __IOM uint32_t LOCK       : 1;            /* [16..16] LOCK                                                             */
      __IM  uint32_t DPWSEL     : 3;            /* [19..17] LMC Data Path Width Select                                       */
      __IM  uint32_t CWCFG      : 4;            /* [23..20] Level 1 Cache Ways Configure                                     */
      __IM  uint32_t SIZE       : 4;            /* [27..24] LMC Size                                                         */
      __IM  uint32_t SIZEH      : 1;            /* [28..28] LMC Size Hole                                                    */
      __IM  uint32_t RESERVED2  : 2;
      __IM  uint32_t VALID      : 1;            /* [31..31] Local Memory Valid                                               */
    } bit;
  } LMDES2;
  __IM  uint32_t  RESERVED4[29];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000480) LMC Parity and ECC Control Register                        */

    struct {
      __IOM uint32_t NCREN      : 1;            /* [0..0] RAM ECC Noncorrectable Reporting Enable                            */
      __IM  uint32_t RESERVED0  : 7;
      __IOM uint32_t R1BREN     : 1;            /* [8..8] RAM ECC 1 Bit Reporting Enable                                     */
      __IM  uint32_t RESERVED1  : 11;
      __IOM uint32_t CPREN      : 1;            /* [20..20] Cache Parity Reporting Enable                                    */
      __IM  uint32_t RESERVED2  : 11;
    } bit;
  } LMPECTRL;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000488) LMC Parity and ECC Interrupt Register                      */

    struct {
      __IOM uint32_t NCERRFLG   : 8;            /* [7..0] ECC Noncorrectable Error Flag                                      */
      __IOM uint32_t E1BERRFLG  : 8;            /* [15..8] ECC 1-bit Error Flag                                              */
      __IOM uint32_t CPERR      : 8;            /* [23..16] Cache Parity Error                                               */
      __IM  uint32_t PEERRL     : 5;            /* [28..24] Parity or ECC Error Location                                     */
      __IM  uint32_t RESERVED0  : 2;
      __IM  uint32_t VALID      : 1;            /* [31..31] Valid                                                            */
    } bit;
  } LMPEINT;
  __IM  uint32_t  RESERVED6;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000490) LMC Fault Address Register                                 */

    struct {
      __IM  uint32_t EFADDR     : 32;           /* [31..0] ECC Fault Address                                                 */
    } bit;
  } LMFADDR;

  union {
    __IM  uint32_t reg;                         /* (@ 0x00000494) LMC Fault Attribute Register                               */

    struct {
      __IM  uint32_t PEFPRO     : 4;            /* [3..0] Parity/ECC Fault Master Size                                        */
      __IM  uint32_t PEFMSIZE   : 3;            /* [6..4] Parity/ECC Fault Protection                                        */
      __IM  uint32_t PEFW       : 1;            /* [7..7] Parity/ECC Fault Write                                             */
      __IM  uint32_t PEFMNUM    : 8;            /* [15..8] Parity/ECC Fault Master Number                                    */
      __IM  uint32_t RESERVED0  : 15;
      __IM  uint32_t OVR        : 1;            /* [31..31] Overrun                                                          */
    } bit;
  } LMFAT;
  __IM  uint32_t  RESERVED7[2];

  union {
    __IM  uint32_t reg;                         /* (@ 0x000004A0) LMC Fault Data High Register                               */

    struct {
      __IM  uint32_t PEFH       : 32;           /* [31..0] Parity/ ECC Fault Data High                                       */
    } bit;
  } LMFDATAH;

  union {
    __IM  uint32_t reg;                         /* (@ 0x000004A4) LMC Fault Data Low Register                                */

    struct {
      __IM  uint32_t PEFL       : 32;           /* [31..0] Parity/ ECC Fault Data Low                                        */
    } bit;
  } LMFDATAL;
} MC_T;                                      /* Size = 1192 (0x4a8)                                                       */



/* =========================================================================================================================== */
/* ================                                            LMC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Local Memory Controller (LMC)
  */

typedef struct {                                /* (@ 0xE0082000) LMC Structure                                              */

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000000) Cache Control Register                                     */

    struct {
      __IOM uint32_t CEN        : 1;            /* [0..0] Cache Enable                                                       */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t FWCS       : 1;            /* [2..2] Force Write to Cacheable Space                                     */
      __IOM uint32_t FCHA       : 1;            /* [3..3] Force Cache Hit Allocation                                         */
      __IM  uint32_t RESERVED1  : 20;
      __IOM uint32_t IW0        : 1;            /* [24..24] Invalidate Way 0                                                 */
      __IOM uint32_t PW0        : 1;            /* [25..25] Push Way 0                                                       */
      __IOM uint32_t IW1        : 1;            /* [26..26] Invalidate Way 1                                                 */
      __IOM uint32_t PW1        : 1;            /* [27..27] Push Way 1                                                       */
      __IM  uint32_t RESERVED2  : 3;
      __IOM uint32_t ICCMD      : 1;            /* [31..31] Initiate Cache Command                                           */
    } bit;
  } CCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000004) Cache Line Control Register                                */

    struct {
      __IOM uint32_t ICLCMD     : 1;            /* [0..0] Initiate Cache Line Command                                        */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t CADDR      : 12;           /* [13..2] Cache Address                                                     */
      __IOM uint32_t LCMDWSEL   : 1;            /* [14..14] Line Command Way Select                                          */
      __IM  uint32_t RESERVED1  : 1;
      __IOM uint32_t TAG_DATASEL : 1;           /* [16..16] Tag/Data Select                                                  */
      __IM  uint32_t RESERVED2  : 3;
      __IOM uint32_t LCMDVISTS  : 1;            /* [20..20] Line Command Valid Bit Initial State                             */
      __IOM uint32_t LCMDMISTS  : 1;            /* [21..21] Line Command Modified Bit Initial State                          */
      __IOM uint32_t LCWSTS     : 1;            /* [22..22] Line Command Way Statue                                          */
      __IM  uint32_t RESERVED3  : 1;
      __IOM uint32_t LCMDCFG    : 2;            /* [25..24] Line Command Configure                                           */
      __IOM uint32_t LADDRSEL   : 1;            /* [26..26] Line Address Select                                              */
      __IOM uint32_t LACCTSEL   : 1;            /* [27..27] Line Access Type Select                                          */
      __IM  uint32_t RESERVED4  : 4;
    } bit;
  } CLCTRL;

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000008) Cache Search Address Register                              */

    struct {
      __IOM uint32_t CLCMDI     : 1;            /* [0..0] Cache Line Command Initiate                                        */
      __IM  uint32_t RESERVED0  : 1;
      __IOM uint32_t PHYADDR    : 30;           /* [31..2] Physical Address                                                  */
    } bit;
  } CSADDR;

  union {
    __IOM uint32_t reg;                         /* (@ 0x0000000C) Cache Data Register                                        */

    struct {
      __IOM uint32_t CDATA      : 32;           /* [31..0] Cache Data                                                        */
    } bit;
  } CDATA;
  __IM  uint32_t  RESERVED[4];

  union {
    __IOM uint32_t reg;                         /* (@ 0x00000020) Region Cache Mode Configure Register                       */

    struct {
      __IOM uint32_t CMCFGR15   : 2;            /* [1..0] Region 0-15 mode                                                   */
      __IOM uint32_t CMCFGR14   : 2;            /* [3..2] Region 0-15 mode                                                   */
      __IOM uint32_t CMCFGR13   : 2;            /* [5..4] Region 0-15 mode                                                   */
      __IOM uint32_t CMCFGR12   : 2;            /* [7..6] Region 0-15 mode                                                   */
      __IOM uint32_t CMCFGR11   : 2;            /* [9..8] Region 0-15 mode                                                   */
      __IOM uint32_t CMCFGR10   : 2;            /* [11..10] Region 0-15 mode                                                 */
      __IOM uint32_t CMCFGR9    : 2;            /* [13..12] Region 0-15 mode                                                 */
      __IOM uint32_t CMCFGR8    : 2;            /* [15..14] Region 0-15 mode                                                 */
      __IOM uint32_t CMCFGR7    : 2;            /* [17..16] Region 0-15 mode                                                 */
      __IOM uint32_t CMCFGR6    : 2;            /* [19..18] Region 0-15 mode                                                 */
      __IOM uint32_t CMCFGR5    : 2;            /* [21..20] Region 0-15 mode                                                 */
      __IOM uint32_t CMCFGR4    : 2;            /* [23..22] Region 0-15 mode                                                 */
      __IOM uint32_t CMCFGR3    : 2;            /* [25..24] Region 0-15 mode                                                 */
      __IOM uint32_t CMCFGR2    : 2;            /* [27..26] Region 0-15 mode                                                 */
      __IOM uint32_t CMCFGR1    : 2;            /* [29..28] Region 0-15 mode                                                 */
      __IOM uint32_t CMCFGR0    : 2;            /* [31..30] Region 0-15 mode                                                 */
    } bit;
  } RCMCFG;
} LMC_T;                                     /* Size = 36 (0x24)                                                             */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define CSE_PRAM_BASE               0x14001000UL
#define AC_BASE                     0x40000000UL
#define MSC_BASE                    0x40001000UL
#define DMA_BASE                    0x40008000UL
#define MPU_BASE                    0x4000D000UL
#define EREP_BASE                   0x40018000UL
#define EINJ_BASE                   0x40019000UL
#define FLASH_BASE                  0x40020000UL
#define DMACHM_BASE                 0x40021000UL
#define CAN0_BASE               0x40024000UL
#define CAN1_BASE               0x40025000UL
#define CAN2_BASE               0x4002B000UL
#define CFGTMR0_BASE                  0x40038000UL
#define CFGTMR1_BASE                  0x40039000UL
#define CFGTMR2_BASE                  0x4003A000UL
#define CFGTMR3_BASE                  0x40026000UL
#define CFGTMR4_BASE                  0x4006E000UL
#define CFGTMR5_BASE                  0x4006F000UL
#define ADC0_BASE                   0x4003B000UL
#define ADC1_BASE                   0x40027000UL
#define LPSPI0_BASE                 0x4002C000UL
#define LPSPI1_BASE                 0x4002D000UL
#define LPSPI2_BASE                 0x4002E000UL
#define PDU0_BASE                   0x40036000UL
#define PDU1_BASE                   0x40031000UL
#define CRC_BASE                    0x40032000UL
#define LPITMR_BASE                 0x40037000UL
#define RTC_BASE                    0x4003D000UL
#define LPTMR_BASE                  0x40040000UL
#define SIM_BASE                    0x40048000UL
#define PMA_BASE                    0x40049000UL
#define PMB_BASE                    0x4004A000UL
#define PMC_BASE                    0x4004B000UL
#define PMD_BASE                    0x4004C000UL
#define PME_BASE                    0x4004D000UL
#define WDT_BASE                    0x40052000UL
#define CFGIO_BASE                0x4005A000UL
#define EWDT_BASE                   0x40061000UL
#define TMC_BASE                    0x40063000UL
#define SCG_BASE                    0x40064000UL
#define PCM_BASE                    0x40065000UL
#define LPI2C_BASE                  0x40066000UL
#define LPUART0_BASE                0x4006A000UL
#define LPUART1_BASE                0x4006B000UL
#define LPUART2_BASE                0x4006C000UL
#define COMP_BASE                   0x40073000UL
#define PMU_BASE                    0x4007D000UL
#define SYSMC_BASE                  0x4007E000UL
#define RMU_BASE                    0x4007F000UL
#define GPIOA_BASE                  0x400FF000UL
#define GPIOB_BASE                  0x400FF040UL
#define GPIOC_BASE                  0x400FF080UL
#define GPIOD_BASE                  0x400FF0C0UL
#define GPIOE_BASE                  0x400FF100UL
#define APM32_SCB_BASE                0xE000E000UL
#define APM32_SysTick_BASE            0xE000E010UL
#define APM32_NVIC_BASE               0xE000E100UL
#define MC_BASE                     0xE0080000UL
#define LMC_BASE                    0xE0082000UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define CSE_PRAM                    ((CSE_PRAM_T*)          CSE_PRAM_BASE)
#define AC                          ((AC_T*)                AC_BASE)
#define MSC                         ((MSC_T*)               MSC_BASE)
#define DMA                         ((DMA_T*)               DMA_BASE)
#define MPU                         ((MPU_T*)               MPU_BASE)
#define EREP                        ((EREP_T*)              EREP_BASE)
#define EINJ                        ((EINJ_T*)              EINJ_BASE)
#define FLASH                       ((FLASH_T*)             FLASH_BASE)
#define DMACHM                      ((DMACHM_T*)            DMACHM_BASE)
#define CAN0                    ((CAN_T*)           CAN0_BASE)
#define CAN1                    ((CAN_T*)           CAN1_BASE)
#define CAN2                    ((CAN_T*)           CAN2_BASE)
#define CFGTMR0                       ((CFGTMR_T*)              CFGTMR0_BASE)
#define CFGTMR1                       ((CFGTMR_T*)              CFGTMR1_BASE)
#define CFGTMR2                       ((CFGTMR_T*)              CFGTMR2_BASE)
#define CFGTMR3                       ((CFGTMR_T*)              CFGTMR3_BASE)
#define CFGTMR4                       ((CFGTMR_T*)              CFGTMR4_BASE)
#define CFGTMR5                       ((CFGTMR_T*)              CFGTMR5_BASE)
#define ADC0                        ((ADC_T*)               ADC0_BASE)
#define ADC1                        ((ADC_T*)               ADC1_BASE)
#define LPSPI0                      ((LPSPI_T*)             LPSPI0_BASE)
#define LPSPI1                      ((LPSPI_T*)             LPSPI1_BASE)
#define LPSPI2                      ((LPSPI_T*)             LPSPI2_BASE)
#define PDU0                        ((PDU_T*)               PDU0_BASE)
#define PDU1                        ((PDU_T*)               PDU1_BASE)
#define CRC                         ((CRC_T*)               CRC_BASE)
#define LPITMR                      ((LPITMR_T*)            LPITMR_BASE)
#define RTC                         ((RTC_T*)               RTC_BASE)
#define LPTMR                       ((LPTMR_T*)             LPTMR_BASE)
#define SIM                         ((SIM_T*)               SIM_BASE)
#define PMA                         ((PM_T*)                PMA_BASE)
#define PMB                         ((PM_T*)                PMB_BASE)
#define PMC                         ((PM_T*)                PMC_BASE)
#define PMD                         ((PM_T*)                PMD_BASE)
#define PME                         ((PM_T*)                PME_BASE)
#define WDT                         ((WDT_T*)               WDT_BASE)
#define CFGIO                       ((CFGIO_T*)             CFGIO_BASE)
#define EWDT                        ((EWDT_T*)              EWDT_BASE)
#define TMC                         ((TMC_T*)               TMC_BASE)
#define SCG                         ((SCG_T*)               SCG_BASE)
#define PCM                         ((PCM_T*)               PCM_BASE)
#define LPI2C                       ((LPI2C_T*)             LPI2C_BASE)
#define LPUART0                     ((LPUART_T*)            LPUART0_BASE)
#define LPUART1                     ((LPUART_T*)            LPUART1_BASE)
#define LPUART2                     ((LPUART_T*)            LPUART2_BASE)
#define COMP                        ((COMP_T*)              COMP_BASE)
#define PMU                         ((PMU_T*)               PMU_BASE)
#define SYSMC                       ((SYSMC_T*)             SYSMC_BASE)
#define RMU                         ((RMU_T*)               RMU_BASE)
#define GPIOA                       ((GPIO_T*)              GPIOA_BASE)
#define GPIOB                       ((GPIO_T*)              GPIOB_BASE)
#define GPIOC                       ((GPIO_T*)              GPIOC_BASE)
#define GPIOD                       ((GPIO_T*)              GPIOD_BASE)
#define GPIOE                       ((GPIO_T*)              GPIOE_BASE)
#define APM32_SCB                     ((APM32_SCB_T*)           APM32_SCB_BASE)
#define APM32_SysTick                 ((APM32_SysTick_T*)       APM32_SysTick_BASE)
#define APM32_NVIC                    ((APM32_NVIC_T*)          APM32_NVIC_BASE)
#define MC                          ((MC_T*)                MC_BASE)
#define LMC                         ((LMC_T*)               LMC_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


/* =========================================================================================================================== */
/* ================                           defined Values Peripheral Section                            ================ */
/* =========================================================================================================================== */


/** @addtogroup Macros_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                         CSE_PRAM                                          ================ */
/* =========================================================================================================================== */



/* =========================================================================================================================== */
/* ================                                            AC                                             ================ */
/* =========================================================================================================================== */

/* =========================================================  MPRIA  ========================================================= */
/* ===============================================  AC MPRIA MPLCFG3 [16..16]  =============================================== */
/* AC_MPRIA_MPLCFG2 */
  #define    AC_MPRIA_MPLCFG3_0                     0U      /* 0 : Accesses from this master are forced to user-mode.          */
  #define    AC_MPRIA_MPLCFG3_1                     1U      /* 1 : Accesses from this master are not forced to user-mode.      */


/* ================================================  AC MPRIA MTWA3 [17..17]  ================================================ */
/* AC_MPRIA_MTWA2 */
 #define    AC_MPRIA_MTWA3_0                       0U    /* 0 : This master is not trusted for write accesses.                 */
 #define    AC_MPRIA_MTWA3_1                       1U     /* 1 : This master is trusted for write accesses.                    */


/* ================================================  AC MPRIA MTRA3 [18..18]  ================================================ */
/* AC_MPRIA_MTRA2 */
#define  AC_MPRIA_MTRA3_0                            0U      /* 0 : This master is not trusted for read accesses.              */
#define  AC_MPRIA_MTRA3_1                            1U      /* 1 : This master is trusted for read accesses.                  */


/* ===============================================  AC MPRIA MPLCFG2 [20..20]  =============================================== */
/* AC_MPRIA_MPLCFG2 */
  #define    AC_MPRIA_MPLCFG2_0                     0U      /* 0 : Accesses from this master are forced to user-mode.          */
  #define    AC_MPRIA_MPLCFG2_1                     1U      /* 1 : Accesses from this master are not forced to user-mode.      */


/* ================================================  AC MPRIA MTWA2 [21..21]  ================================================ */
/* AC_MPRIA_MTWA2 */
 #define    AC_MPRIA_MTWA2_0                       0U    /* 0 : This master is not trusted for write accesses.                 */
 #define    AC_MPRIA_MTWA2_1                       1U     /* 1 : This master is trusted for write accesses.                    */


/* ================================================  AC MPRIA MTRA2 [22..22]  ================================================ */
/* AC_MPRIA_MTRA2 */
#define  AC_MPRIA_MTRA2_0                            0U      /* 0 : This master is not trusted for read accesses.              */
#define  AC_MPRIA_MTRA2_1                            1U      /* 1 : This master is trusted for read accesses.                  */


/* ===============================================  AC MPRIA MPLCFG1 [24..24]  =============================================== */
/* AC_MPRIA_MPLCFG1 */
#define  AC_MPRIA_MPLCFG1_0                            0U     /* 0 : Accesses from this master are forced to user-mode.        */
#define  AC_MPRIA_MPLCFG1_1                            1U     /* 1 : Accesses from this master are not forced to user-mode.    */


/* ================================================  AC MPRIA MTWA1 [25..25]  ================================================ */
/* AC_MPRIA_MTWA1 */
#define  AC_MPRIA_MTWA1_0                            0U      /* 0 : This master is not trusted for write accesses.             */
#define  AC_MPRIA_MTWA1_1                            1U      /* 1 : This master is trusted for write accesses.                 */


/* ================================================  AC MPRIA MTRA1 [26..26]  ================================================ */
/* AC_MPRIA_MTRA1 */
#define  AC_MPRIA_MTRA1_0                            0U     /* 0 : This master is not trusted for read accesses.                */
#define  AC_MPRIA_MTRA1_1                            1U     /* 1 : This master is trusted for read accesses.                    */


/*                                                  AC MPRIA MPLCFG0 [28..28]                                                  */
/* AC_MPRIA_MPLCFG0 */
#define  AC_MPRIA_MPLCFG0_0                            0U     /* 0 : Accesses from this master are forced to user-mode.         */
#define  AC_MPRIA_MPLCFG0_1                            1U     /* 1 : Accesses from this master are not forced to user-mode.     */


/*                                                   AC MPRIA MTWA0 [29..29]                                                   */
                                /* AC_MPRIA_MTWA0                                                            */
#define  AC_MPRIA_MTWA0_0                            0U     /* 0 : This master is not trusted for write accesses.             */
#define  AC_MPRIA_MTWA0_1                            1U     /* 1 : This master is trusted for write accesses.                 */


/*                                                   AC MPRIA MTRA0 [30..30]                                                   */
/* AC_MPRIA_MTRA0  */
#define  AC_MPRIA_MTRA0_0                            0U     /* 0 : This master is not trusted for read accesses.               */
#define  AC_MPRIA_MTRA0_1                            1U     /* 1 : This master is trusted for read accesses.                   */


/*                                                          PACCTRLA                                                           */
/*                                                 AC PACCTRLA TPCFG1 [24..24]                                                 */
/* AC_PACCTRLA_TPCFG1 */
#define  AC_PACCTRLA_TPCFG1_0                        0U     /* 0 : Accesses from an untrusted master are allowed.             */
#define  AC_PACCTRLA_TPCFG1_1                        1U     /* 1 : Accesses from an untrusted master are not allowed.         */


/*                                                 AC PACCTRLA WPCFG1 [25..25]                                                 */
/* AC_PACCTRLA_WPCFG1 */
 #define AC_PACCTRLA_WPCFG1_0                        0U     /* 0 : This peripheral allows write accesses.                     */
 #define AC_PACCTRLA_WPCFG1_1                        1U     /* 1 : This peripheral is write protected.                        */


/*                                                 AC PACCTRLA SPCFG1 [26..26]                                                 */
/* AC_PACCTRLA_SPCFG1 */
 #define AC_PACCTRLA_SPCFG1_0                        0U     /* 0 : This peripheral does not require supervisor privilege level
                                                                 for accesses.                                              */
 #define AC_PACCTRLA_SPCFG1_1                        1U     /* 1 : This peripheral requires supervisor privilege level for
                                                                 accesses.                                                   */


/*                                                 AC PACCTRLA TPCFG0 [28..28]                                                 */
/* AC_PACCTRLA_TPCFG0*/
#define  AC_PACCTRLA_TPCFG0_0                        0U     /* 0 : Accesses from an untrusted master are allowed.               */
#define  AC_PACCTRLA_TPCFG0_1                        1U     /* 1 : Accesses from an untrusted master are not allowed.           */


/*                                                 AC PACCTRLA WPCFG0 [29..29]                                                 */
/* AC_PACCTRLA_WPCFG0 */
#define  AC_PACCTRLA_WPCFG0_0                        0U     /* 0 : This peripheral allows write accesses.                      */
#define  AC_PACCTRLA_WPCFG0_1                        1U     /* 1 : This peripheral is write protected.                         */


/*                                                 AC PACCTRLA SPCFG0 [30..30]                                                 */
/* AC_PACCTRLA_SPCFG0*/
#define  AC_PACCTRLA_SPCFG0_0                        0U     /* 0 : This peripheral does not require supervisor privilege level
                                                            for accesses.                                                      */
#define AC_PACCTRLA_SPCFG0_1                        1U     /* 1 : This peripheral requires supervisor privilege level for
                                                            accesses.                                                          */


/*                                                          PACCTRLB                                                           */
/*                                                  AC PACCTRLB TPCFG5 [8..8]                                                  */
/* AC_PACCTRLB_TPCFG5*/
#define  AC_PACCTRLB_TPCFG5_0                        0U     /* 0 : Accesses from an untrusted master are allowed.               */
#define  AC_PACCTRLB_TPCFG5_1                        1U     /* 1 : Accesses from an untrusted master are not allowed.          */


/*                                                  AC PACCTRLB WPCFG5 [9..9]                                                  */
/* AC_PACCTRLB_WPCFG5*/
#define  AC_PACCTRLB_WPCFG5_0                        0U     /* 0 : This peripheral allows write accesses.                      */
#define  AC_PACCTRLB_WPCFG5_1                        1U     /* 1 : This peripheral is write protected.                         */


/*                                                 AC PACCTRLB SPCFG5 [10..10]                                                 */
/* AC_PACCTRLB_SPCFG5  */
#define  AC_PACCTRLB_SPCFG5_0                        0U     /* 0 : This peripheral does not require supervisor privilege level
                                                    for accesses.       */
#define  AC_PACCTRLB_SPCFG5_1                        1U     /* 1 : This peripheral requires supervisor privilege level for
                                                     accesses.           */


/*                                                 AC PACCTRLB TPCFG1 [24..24]                                                 */
/* AC_PACCTRLB_TPCFG1  */
#define  AC_PACCTRLB_TPCFG1_0                        0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_PACCTRLB_TPCFG1_1                        1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC PACCTRLB WPCFG1 [25..25]                                                 */
/* AC_PACCTRLB_WPCFG1  */
#define  AC_PACCTRLB_WPCFG1_0                        0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_PACCTRLB_WPCFG1_1                        1U     /* 1 : This peripheral is write protected.                                   */


/*                                                 AC PACCTRLB SPCFG1 [26..26]                                                 */
 /* AC_PACCTRLB_SPCFG1  */
#define  AC_PACCTRLB_SPCFG1_0                        0U     /* 0 : This peripheral does not require supervisor privilege level
                                                    for accesses.       */
#define  AC_PACCTRLB_SPCFG1_1                        1U     /* 1 : This peripheral requires supervisor privilege level for
                                                     accesses.           */


/*                                                 AC PACCTRLB TPCFG0 [28..28]                                                 */
/* AC_PACCTRLB_TPCFG0  */
#define  AC_PACCTRLB_TPCFG0_0                        0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_PACCTRLB_TPCFG0_1                        1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC PACCTRLB WPCFG0 [29..29]                                                 */
/* AC_PACCTRLB_WPCFG0  */
#define  AC_PACCTRLB_WPCFG0_0                        0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_PACCTRLB_WPCFG0_1                        1U     /* 1 : This peripheral is write protected.                                   */


/*                                                 AC PACCTRLB SPCFG0 [30..30]                                                 */
/* AC_PACCTRLB_SPCFG0  */
#define  AC_PACCTRLB_SPCFG0_0                        0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_PACCTRLB_SPCFG0_1                        1U     /* 1 : This peripheral requires supervisor privilege level for
                                                         accesses.           */


/*                                                          PACCTRLD     */
/*                                                 AC PACCTRLD TPCFG1 [24..24]                                                 */
 /* AC_PACCTRLD_TPCFG1  */
#define  AC_PACCTRLD_TPCFG1_0                   0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_PACCTRLD_TPCFG1_1                   1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC PACCTRLD WPCFG1 [25..25]                                                 */
/* AC_PACCTRLD_WPCFG1  */
#define  AC_PACCTRLD_WPCFG1_0                   0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_PACCTRLD_WPCFG1_1                   1U     /* 1 : This peripheral is write protected.                                   */


/*                                                 AC PACCTRLD SPCFG1 [26..26]                                                 */
/* AC_PACCTRLD_SPCFG1  */
#define  AC_PACCTRLD_SPCFG1_0                   0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_PACCTRLD_SPCFG1_1                   1U     /* 1 : This peripheral requires supervisor privilege level for
                                                         accesses.           */


/*                                                 AC PACCTRLD TPCFG0 [28..28]                                                 */
/* AC_PACCTRLD_TPCFG0  */
#define  AC_PACCTRLD_TPCFG0_0                   0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_PACCTRLD_TPCFG0_1                   1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC PACCTRLD WPCFG0 [29..29]                                                 */
/* AC_PACCTRLD_WPCFG0  */
#define  AC_PACCTRLD_WPCFG0_0                   0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_PACCTRLD_WPCFG0_1                   1U     /* 1 : This peripheral is write protected.                                   */


/*                                                 AC PACCTRLD SPCFG0 [30..30]                                                 */
/* AC_PACCTRLD_SPCFG0  */
 #define AC_PACCTRLD_SPCFG0_0                   0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.       */
 #define AC_PACCTRLD_SPCFG0_1                   1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                          OPACCTRLA    */
/*                                                 AC OPACCTRLA TPCFG7 [0..0]                                                  */
/* AC_OPACCTRLA_TPCFG7 */
#define  AC_OPACCTRLA_TPCFG7_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLA_TPCFG7_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC OPACCTRLA WPCFG7 [1..1]                                                  */
/* AC_OPACCTRLA_WPCFG7 */
#define  AC_OPACCTRLA_WPCFG7_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLA_WPCFG7_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                 AC OPACCTRLA SPCFG7 [2..2]                                                  */
/* AC_OPACCTRLA_SPCFG7 */
 #define AC_OPACCTRLA_SPCFG7_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.       */
 #define AC_OPACCTRLA_SPCFG7_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */


/*                                                 AC OPACCTRLA TPCFG6 [4..4]                                                  */
/* AC_OPACCTRLA_TPCFG6 */
#define  AC_OPACCTRLA_TPCFG6_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLA_TPCFG6_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC OPACCTRLA WPCFG6 [5..5]                                                  */
/* AC_OPACCTRLA_WPCFG6 */
#define  AC_OPACCTRLA_WPCFG6_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLA_WPCFG6_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                 AC OPACCTRLA SPCFG6 [6..6]                                                  */
/* AC_OPACCTRLA_SPCFG6 */
 #define AC_OPACCTRLA_SPCFG6_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
 #define AC_OPACCTRLA_SPCFG6_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                 AC OPACCTRLA TPCFG5 [8..8]                                                  */
 /* AC_OPACCTRLA_TPCFG5 */
 #define AC_OPACCTRLA_TPCFG5_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
 #define AC_OPACCTRLA_TPCFG5_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC OPACCTRLA WPCFG5 [9..9]                                                  */
/* AC_OPACCTRLA_WPCFG5 */
 #define AC_OPACCTRLA_WPCFG5_0                  0U     /* 0 : This peripheral allows write accesses.                                */
 #define AC_OPACCTRLA_WPCFG5_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLA SPCFG5 [10..10]                                                 */
/* AC_OPACCTRLA_SPCFG5 */
 #define AC_OPACCTRLA_SPCFG5_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
 #define AC_OPACCTRLA_SPCFG5_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                AC OPACCTRLA TPCFG4 [12..12]                                                 */
   /* AC_OPACCTRLA_TPCFG4 */
#define  AC_OPACCTRLA_TPCFG4_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLA_TPCFG4_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                AC OPACCTRLA WPCFG4 [13..13]                                                 */
 /* AC_OPACCTRLA_WPCFG4 */
#define  AC_OPACCTRLA_WPCFG4_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLA_WPCFG4_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLA SPCFG4 [14..14]                                                 */
   /* AC_OPACCTRLA_SPCFG4 */
 #define AC_OPACCTRLA_SPCFG4_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
 #define AC_OPACCTRLA_SPCFG4_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                AC OPACCTRLA TPCFG1 [24..24]                                                 */
/* AC_OPACCTRLA_TPCFG1 */
 #define AC_OPACCTRLA_TPCFG1_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
 #define AC_OPACCTRLA_TPCFG1_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                AC OPACCTRLA WPCFG1 [25..25]                                                 */
   /* AC_OPACCTRLA_WPCFG1 */
 #define AC_OPACCTRLA_WPCFG1_0                  0U     /* 0 : This peripheral allows write accesses.                                */
 #define AC_OPACCTRLA_WPCFG1_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLA SPCFG1 [26..26]                                                 */
  /* AC_OPACCTRLA_SPCFG1 */
 #define AC_OPACCTRLA_SPCFG1_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLA_SPCFG1_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
#define                                                     accesses.           */


/*                                                AC OPACCTRLA TPCFG0 [28..28]                                                 */
   /* AC_OPACCTRLA_TPCFG0 */
#define  AC_OPACCTRLA_TPCFG0_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLA_TPCFG0_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                AC OPACCTRLA WPCFG0 [29..29]                                                 */
  /* AC_OPACCTRLA_WPCFG0 */
#define  AC_OPACCTRLA_WPCFG0_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLA_WPCFG0_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLA SPCFG0 [30..30]                                                 */
/* AC_OPACCTRLA_SPCFG0 */
 #define AC_OPACCTRLA_SPCFG0_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLA_SPCFG0_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */


/*                                                          OPACCTRLB    */
/*                                                 AC OPACCTRLB TPCFG6 [4..4]                                                  */
 /* AC_OPACCTRLB_TPCFG6 */
#define  AC_OPACCTRLB_TPCFG6_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLB_TPCFG6_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC OPACCTRLB WPCFG6 [5..5]                                                  */
/* AC_OPACCTRLB_WPCFG6 */
#define  AC_OPACCTRLB_WPCFG6_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLB_WPCFG6_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                 AC OPACCTRLB SPCFG6 [6..6]                                                  */
/* AC_OPACCTRLB_SPCFG6 */
 #define AC_OPACCTRLB_SPCFG6_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                      for accesses.       */
 #define AC_OPACCTRLB_SPCFG6_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */


/*                                                 AC OPACCTRLB TPCFG5 [8..8]                                                  */
  /* AC_OPACCTRLB_TPCFG5 */
 #define AC_OPACCTRLB_TPCFG5_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
 #define AC_OPACCTRLB_TPCFG5_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC OPACCTRLB WPCFG5 [9..9]                                                  */
 /* AC_OPACCTRLB_WPCFG5 */
 #define AC_OPACCTRLB_WPCFG5_0                  0U     /* 0 : This peripheral allows write accesses.                                */
 #define AC_OPACCTRLB_WPCFG5_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLB SPCFG5 [10..10]                                                 */
/* AC_OPACCTRLB_SPCFG5 */
#define  AC_OPACCTRLB_SPCFG5_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define AC_OPACCTRLB_SPCFG5_1                   1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                AC OPACCTRLB TPCFG4 [12..12]                                                 */
   /* AC_OPACCTRLB_TPCFG4 */
#define  AC_OPACCTRLB_TPCFG4_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLB_TPCFG4_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                AC OPACCTRLB WPCFG4 [13..13]                                                 */
 /* AC_OPACCTRLB_WPCFG4 */
#define  AC_OPACCTRLB_WPCFG4_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLB_WPCFG4_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLB SPCFG4 [14..14]                                                 */
 /* AC_OPACCTRLB_SPCFG4 */
#define  AC_OPACCTRLB_SPCFG4_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLB_SPCFG4_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                AC OPACCTRLB TPCFG3 [16..16]                                                 */
   /* AC_OPACCTRLB_TPCFG3 */
#define  AC_OPACCTRLB_TPCFG3_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLB_TPCFG3_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                AC OPACCTRLB WPCFG3 [17..17]                                                 */
/* AC_OPACCTRLB_WPCFG3 */
#define  AC_OPACCTRLB_WPCFG3_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLB_WPCFG3_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLB SPCFG3 [18..18]                                                 */
 /* AC_OPACCTRLB_SPCFG3 */
#define  AC_OPACCTRLB_SPCFG3_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLB_SPCFG3_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */


/*                                                          OPACCTRLC    */
/*                                                 AC OPACCTRLC TPCFG7 [0..0]                                                  */
/* AC_OPACCTRLC_TPCFG7 */
#define  AC_OPACCTRLC_TPCFG7_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLC_TPCFG7_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC OPACCTRLC WPCFG7 [1..1]                                                  */
 /* AC_OPACCTRLC_WPCFG7 */
 #define AC_OPACCTRLC_WPCFG7_0                  0U     /* 0 : This peripheral allows write accesses.                                */
 #define AC_OPACCTRLC_WPCFG7_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                 AC OPACCTRLC SPCFG7 [2..2]                                                  */
 /* AC_OPACCTRLC_SPCFG7 */
#define  AC_OPACCTRLC_SPCFG7_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define AC_OPACCTRLC_SPCFG7_1                   1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.           */


/*                                                 AC OPACCTRLC TPCFG6 [4..4]                                                  */
/* AC_OPACCTRLC_TPCFG6 */
#define  AC_OPACCTRLC_TPCFG6_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLC_TPCFG6_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC OPACCTRLC WPCFG6 [5..5]                                                  */
 /* AC_OPACCTRLC_WPCFG6 */
#define  AC_OPACCTRLC_WPCFG6_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLC_WPCFG6_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                 AC OPACCTRLC SPCFG6 [6..6]                                                  */
 /* AC_OPACCTRLC_SPCFG6 */
#define  AC_OPACCTRLC_SPCFG6_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                         for accesses.       */
#define  AC_OPACCTRLC_SPCFG6_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                AC OPACCTRLC TPCFG2 [20..20]                                                 */
  /* AC_OPACCTRLC_TPCFG2 */
#define  AC_OPACCTRLC_TPCFG2_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLC_TPCFG2_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                AC OPACCTRLC WPCFG2 [21..21]                                                 */
   /* AC_OPACCTRLC_WPCFG2 */
#define  AC_OPACCTRLC_WPCFG2_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLC_WPCFG2_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLC SPCFG2 [22..22]                                                 */
   /* AC_OPACCTRLC_SPCFG2 */
 #define AC_OPACCTRLC_SPCFG2_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.       */
 #define AC_OPACCTRLC_SPCFG2_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */


/*                                                AC OPACCTRLC TPCFG1 [24..24]                                                 */
   /* AC_OPACCTRLC_TPCFG1 */
#define  AC_OPACCTRLC_TPCFG1_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLC_TPCFG1_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                AC OPACCTRLC WPCFG1 [25..25]                                                 */
   /* AC_OPACCTRLC_WPCFG1 */
#define  AC_OPACCTRLC_WPCFG1_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLC_WPCFG1_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLC SPCFG1 [26..26]                                                 */
  /* AC_OPACCTRLC_SPCFG1 */
#define  AC_OPACCTRLC_SPCFG1_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                         for accesses.       */
#define  AC_OPACCTRLC_SPCFG1_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                          OPACCTRLD    */
/*                                                 AC OPACCTRLD TPCFG5 [8..8]                                                  */
  /* AC_OPACCTRLD_TPCFG5 */
 #define AC_OPACCTRLD_TPCFG5_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
 #define AC_OPACCTRLD_TPCFG5_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                 AC OPACCTRLD WPCFG5 [9..9]                                                  */
  /* AC_OPACCTRLD_WPCFG5 */
#define  AC_OPACCTRLD_WPCFG5_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLD_WPCFG5_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLD SPCFG5 [10..10]                                                 */
  /* AC_OPACCTRLD_SPCFG5 */
#define  AC_OPACCTRLD_SPCFG5_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                      for accesses.       */
#define  AC_OPACCTRLD_SPCFG5_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                AC OPACCTRLD TPCFG3 [16..16]                                                 */
  /* AC_OPACCTRLD_TPCFG3 */
 #define AC_OPACCTRLD_TPCFG3_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
 #define AC_OPACCTRLD_TPCFG3_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                AC OPACCTRLD WPCFG3 [17..17]                                                 */
 /* AC_OPACCTRLD_WPCFG3 */
#define  AC_OPACCTRLD_WPCFG3_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLD_WPCFG3_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLD SPCFG3 [18..18]                                                 */
 /* AC_OPACCTRLD_SPCFG3 */
#define  AC_OPACCTRLD_SPCFG3_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.       */
#define  AC_OPACCTRLD_SPCFG3_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                AC OPACCTRLD TPCFG2 [20..20]                                                 */
   /* AC_OPACCTRLD_TPCFG2 */
#define  AC_OPACCTRLD_TPCFG2_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLD_TPCFG2_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                AC OPACCTRLD WPCFG2 [21..21]                                                 */
   /* AC_OPACCTRLD_WPCFG2 */
#define  AC_OPACCTRLD_WPCFG2_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLD_WPCFG2_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLD SPCFG2 [22..22]                                                 */
   /* AC_OPACCTRLD_SPCFG2 */
#define  AC_OPACCTRLD_SPCFG2_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                         for accesses.       */
#define  AC_OPACCTRLD_SPCFG2_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                AC OPACCTRLD TPCFG1 [24..24]                                                 */
   /* AC_OPACCTRLD_TPCFG1 */
#define  AC_OPACCTRLD_TPCFG1_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                        */
#define  AC_OPACCTRLD_TPCFG1_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                    */


/*                                                AC OPACCTRLD WPCFG1 [25..25]                                                 */
   /* AC_OPACCTRLD_WPCFG1 */
#define  AC_OPACCTRLD_WPCFG1_0                  0U     /* 0 : This peripheral allows write accesses.                                */
#define  AC_OPACCTRLD_WPCFG1_1                  1U     /* 1 : This peripheral is write protected.                                   */


/*                                                AC OPACCTRLD SPCFG1 [26..26]                                                 */
  /* AC_OPACCTRLD_SPCFG1 */
#define  AC_OPACCTRLD_SPCFG1_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLD_SPCFG1_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                AC OPACCTRLD TPCFG0 [28..28]                                                 */
  /* AC_OPACCTRLD_TPCFG0 */
#define  AC_OPACCTRLD_TPCFG0_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLD_TPCFG0_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.              */


/*                                                AC OPACCTRLD WPCFG0 [29..29]                                                 */
/* AC_OPACCTRLD_WPCFG0 */
#define  AC_OPACCTRLD_WPCFG0_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLD_WPCFG0_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLD SPCFG0 [30..30]                                                 */
  /* AC_OPACCTRLD_SPCFG0 */
 #define AC_OPACCTRLD_SPCFG0_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                      for accesses.       */
 #define AC_OPACCTRLD_SPCFG0_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */


/*                                                          OPACCTRLE    */
/*                                                 AC OPACCTRLE TPCFG6 [4..4]                                                  */
 /* AC_OPACCTRLE_TPCFG6 */
#define  AC_OPACCTRLE_TPCFG6_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLE_TPCFG6_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                 AC OPACCTRLE WPCFG6 [5..5]                                                  */
  /* AC_OPACCTRLE_WPCFG6 */
#define  AC_OPACCTRLE_WPCFG6_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLE_WPCFG6_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                 AC OPACCTRLE SPCFG6 [6..6]                                                  */
 /* AC_OPACCTRLE_SPCFG6 */
#define  AC_OPACCTRLE_SPCFG6_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLE_SPCFG6_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.           */


/*                                                AC OPACCTRLE TPCFG0 [28..28]                                                 */
  /* AC_OPACCTRLE_TPCFG0 */
#define  AC_OPACCTRLE_TPCFG0_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLE_TPCFG0_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLE WPCFG0 [29..29]                                                 */
  /* AC_OPACCTRLE_WPCFG0 */
#define  AC_OPACCTRLE_WPCFG0_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLE_WPCFG0_1                  1U     /* 1 : This peripheral is write protected.                               */


/*                                                AC OPACCTRLE SPCFG0 [30..30]                                                 */
 /* AC_OPACCTRLE_SPCFG0 */
 #define AC_OPACCTRLE_SPCFG0_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.       */
 #define AC_OPACCTRLE_SPCFG0_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.           */


/*                                                          OPACCTRLF    */
/*                                                 AC OPACCTRLF TPCFG5 [8..8]                                                  */
  /* AC_OPACCTRLF_TPCFG5 */
#define  AC_OPACCTRLF_TPCFG5_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLF_TPCFG5_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                 AC OPACCTRLF WPCFG5 [9..9]                                                  */
  /* AC_OPACCTRLF_WPCFG5 */
#define  AC_OPACCTRLF_WPCFG5_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLF_WPCFG5_1                  1U     /* 1 : This peripheral is write protected.                             */


/*                                                AC OPACCTRLF SPCFG5 [10..10]                                                 */
/* AC_OPACCTRLF_SPCFG5 */
#define  AC_OPACCTRLF_SPCFG5_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.       */
#define AC_OPACCTRLF_SPCFG5_1                   1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.           */


/*                                                AC OPACCTRLF TPCFG4 [12..12]                                                 */
   /* AC_OPACCTRLF_TPCFG4 */
#define  AC_OPACCTRLF_TPCFG4_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                    */
#define  AC_OPACCTRLF_TPCFG4_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                */


/*                                                AC OPACCTRLF WPCFG4 [13..13]                                                 */
/* AC_OPACCTRLF_WPCFG4 */
#define  AC_OPACCTRLF_WPCFG4_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLF_WPCFG4_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLF SPCFG4 [14..14]                                                 */
  /* AC_OPACCTRLF_SPCFG4 */
#define  AC_OPACCTRLF_SPCFG4_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.       */
#define  AC_OPACCTRLF_SPCFG4_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.           */


/*                                                AC OPACCTRLF TPCFG3 [16..16]                                                 */
 /* AC_OPACCTRLF_TPCFG3 */
#define  AC_OPACCTRLF_TPCFG3_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLF_TPCFG3_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLF WPCFG3 [17..17]                                                 */
  /* AC_OPACCTRLF_WPCFG3 */
#define  AC_OPACCTRLF_WPCFG3_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLF_WPCFG3_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLF SPCFG3 [18..18]                                                 */
 /* AC_OPACCTRLF_SPCFG3 */
#define  AC_OPACCTRLF_SPCFG3_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                      for accesses.       */
#define  AC_OPACCTRLF_SPCFG3_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.           */


/*                                                AC OPACCTRLF TPCFG2 [20..20]                                                 */
 /* AC_OPACCTRLF_TPCFG2 */
#define  AC_OPACCTRLF_TPCFG2_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLF_TPCFG2_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLF WPCFG2 [21..21]                                                 */
 /* AC_OPACCTRLF_WPCFG2 */
#define  AC_OPACCTRLF_WPCFG2_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLF_WPCFG2_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLF SPCFG2 [22..22]                                                 */
  /* AC_OPACCTRLF_SPCFG2 */
#define  AC_OPACCTRLF_SPCFG2_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                               for accesses.       */
#define AC_OPACCTRLF_SPCFG2_1                   1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.           */


/*                                                AC OPACCTRLF TPCFG1 [24..24]                                                 */
/* AC_OPACCTRLF_TPCFG1 */
#define  AC_OPACCTRLF_TPCFG1_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                    */
#define  AC_OPACCTRLF_TPCFG1_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.                */


/*                                                AC OPACCTRLF WPCFG1 [25..25]                                                 */
 /* AC_OPACCTRLF_WPCFG1 */
 #define AC_OPACCTRLF_WPCFG1_0                  0U     /* 0 : This peripheral allows write accesses.                             */
 #define AC_OPACCTRLF_WPCFG1_1                  1U     /* 1 : This peripheral is write protected.                                */


/*                                                AC OPACCTRLF SPCFG1 [26..26]                                                 */
 /* AC_OPACCTRLF_SPCFG1 */
#define  AC_OPACCTRLF_SPCFG1_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLF_SPCFG1_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                     accesses.           */


/*                                                AC OPACCTRLF TPCFG0 [28..28]                                                 */
/* AC_OPACCTRLF_TPCFG0 */
#define  AC_OPACCTRLF_TPCFG0_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                  */
#define  AC_OPACCTRLF_TPCFG0_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.              */


/*                                                AC OPACCTRLF WPCFG0 [29..29]                                                 */
 /* AC_OPACCTRLF_WPCFG0 */
#define  AC_OPACCTRLF_WPCFG0_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLF_WPCFG0_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLF SPCFG0 [30..30]                                                 */
  /* AC_OPACCTRLF_SPCFG0 */
#define AC_OPACCTRLF_SPCFG0_0                   0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.       */
#define AC_OPACCTRLF_SPCFG0_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */


/*                                                          OPACCTRLG    */
/*                                                AC OPACCTRLG TPCFG5 [8..8]                                                 */
  /* AC_OPACCTRLG_TPCFG5 */
#define  AC_OPACCTRLG_TPCFG5_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                  */
#define  AC_OPACCTRLG_TPCFG5_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.              */


/*                                                AAC OPACCTRLG TPCFG5 [9..9]                                                 */
   /* AC_OPACCTRLG_WPCFG5 */
#define  AC_OPACCTRLG_WPCFG5_0                  0U     /* 0 : This peripheral allows write accesses.                          */
#define  AC_OPACCTRLG_WPCFG5_1                  1U     /* 1 : This peripheral is write protected.                             */


/*                                                AC OPACCTRLG TPCFG5 [10..10]                                                 */
  /* AC_OPACCTRLG_SPCFG5 */
#define  AC_OPACCTRLG_SPCFG5_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLG_SPCFG5_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */

/*                                                AC OPACCTRLG TPCFG4 [12..12]                                                 */
  /* AC_OPACCTRLG_TPCFG4 */
#define  AC_OPACCTRLG_TPCFG4_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLG_TPCFG4_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLG WPCFG2 [13..13]                                                 */
   /* AC_OPACCTRLG_WPCFG4 */
#define  AC_OPACCTRLG_WPCFG4_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLG_WPCFG4_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLG SPCFG4 [14..14]                                                 */
  /* AC_OPACCTRLG_SPCFG4 */
#define  AC_OPACCTRLG_SPCFG4_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLG_SPCFG4_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */

/*                                                AC OPACCTRLG TPCFG2 [20..20]                                                 */
  /* AC_OPACCTRLG_TPCFG2 */
#define  AC_OPACCTRLG_TPCFG2_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLG_TPCFG2_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLG WPCFG2 [21..21]                                                 */
   /* AC_OPACCTRLG_WPCFG2 */
#define  AC_OPACCTRLG_WPCFG2_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLG_WPCFG2_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLG SPCFG2 [22..22]                                                 */
  /* AC_OPACCTRLG_SPCFG2 */
#define  AC_OPACCTRLG_SPCFG2_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLG_SPCFG2_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */


/*                                                          OPACCTRLH    */
/*                                                AC OPACCTRLH TPCFG2 [20..20]                                                 */
  /* AC_OPACCTRLH_TPCFG2 */
#define  AC_OPACCTRLH_TPCFG2_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLH_TPCFG2_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLH WPCFG2 [21..21]                                                 */
 /* AC_OPACCTRLH_WPCFG2 */
#define  AC_OPACCTRLH_WPCFG2_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLH_WPCFG2_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLH SPCFG2 [22..22]                                                 */
 /* AC_OPACCTRLH_SPCFG2 */
#define  AC_OPACCTRLH_SPCFG2_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                         for accesses.       */
#define  AC_OPACCTRLH_SPCFG2_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */


/*                                                          OPACCTRLI    */
/*                                                 AC OPACCTRLI TPCFG7 [0..0]                                                  */
 /* AC_OPACCTRLI_TPCFG7 */
#define  AC_OPACCTRLI_TPCFG7_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLI_TPCFG7_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                 AC OPACCTRLI WPCFG6 [1..1]                                                  */
/* AC_OPACCTRLI_WPCFG7 */
#define  AC_OPACCTRLI_WPCFG7_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLI_WPCFG7_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                 AC OPACCTRLI SPCFG6 [2..2]                                                  */
/* AC_OPACCTRLI_SPCFG7 */
#define  AC_OPACCTRLI_SPCFG7_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.       */
#define  AC_OPACCTRLI_SPCFG7_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */

/*                                                 AC OPACCTRLI TPCFG6 [4..4]                                                  */
 /* AC_OPACCTRLI_TPCFG6 */
#define  AC_OPACCTRLI_TPCFG6_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLI_TPCFG6_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                 AC OPACCTRLI WPCFG6 [5..5]                                                  */
/* AC_OPACCTRLI_WPCFG6 */
#define  AC_OPACCTRLI_WPCFG6_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLI_WPCFG6_1                  1U     /* 1 : This peripheral is write protected.                               */


/*                                                 AC OPACCTRLI SPCFG6 [6..6]                                                  */
/* AC_OPACCTRLI_SPCFG6 */
#define  AC_OPACCTRLI_SPCFG6_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.       */
#define  AC_OPACCTRLI_SPCFG6_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.           */


/*                                                 AC OPACCTRLI TPCFG5 [8..8]                                                  */
/* AC_OPACCTRLI_TPCFG5 */
#define  AC_OPACCTRLI_TPCFG5_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLI_TPCFG5_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                 AC OPACCTRLI WPCFG5 [9..9]                                                  */
 /* AC_OPACCTRLI_WPCFG5 */
#define  AC_OPACCTRLI_WPCFG5_0                  0U     /* 0 : This peripheral allows write accesses.                          */
#define  AC_OPACCTRLI_WPCFG5_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLI SPCFG5 [10..10]                                                 */
/* AC_OPACCTRLI_SPCFG5 */
#define  AC_OPACCTRLI_SPCFG5_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                      for accesses.       */
#define  AC_OPACCTRLI_SPCFG5_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.           */


/*                                                AC OPACCTRLI TPCFG4 [12..12]                                                 */
 /* AC_OPACCTRLI_TPCFG4 */
#define  AC_OPACCTRLI_TPCFG4_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLI_TPCFG4_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLI WPCFG4 [13..13]                                                 */
 /* AC_OPACCTRLI_WPCFG4 */
#define  AC_OPACCTRLI_WPCFG4_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLI_WPCFG4_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLI SPCFG4 [14..14]                                                 */
   /* AC_OPACCTRLI_SPCFG4 */
#define  AC_OPACCTRLI_SPCFG4_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                      for accesses.       */
#define  AC_OPACCTRLI_SPCFG4_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.           */


/*                                                AC OPACCTRLI TPCFG3 [16..16]                                                 */
   /* AC_OPACCTRLI_TPCFG3 */
#define  AC_OPACCTRLI_TPCFG3_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLI_TPCFG3_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLI WPCFG3 [17..17]                                                 */
  /* AC_OPACCTRLI_WPCFG3 */
#define  AC_OPACCTRLI_WPCFG3_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLI_WPCFG3_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLI SPCFG3 [18..18]                                                 */
  /* AC_OPACCTRLI_SPCFG3 */
#define  AC_OPACCTRLI_SPCFG3_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.       */
#define  AC_OPACCTRLI_SPCFG3_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */


/*                                                AC OPACCTRLI TPCFG1 [24..24]                                                 */
 /* AC_OPACCTRLI_TPCFG1 */
#define  AC_OPACCTRLI_TPCFG1_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                  */
#define  AC_OPACCTRLI_TPCFG1_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.              */


/*                                                AC OPACCTRLI WPCFG1 [25..25]                                                 */
  /* AC_OPACCTRLI_WPCFG1 */
#define  AC_OPACCTRLI_WPCFG1_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLI_WPCFG1_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLI SPCFG1 [26..26]                                                 */
   /* AC_OPACCTRLI_SPCFG1 */
#define  AC_OPACCTRLI_SPCFG1_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                    for accesses.       */
#define  AC_OPACCTRLI_SPCFG1_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.           */


/*                                                          OPACCTRLJ    */
/*                                                AC OPACCTRLJ TPCFG7 [0..0]                                                 */
 /* AC_OPACCTRLJ_TPCFG7 */
#define  AC_OPACCTRLJ_TPCFG7_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                 */
#define  AC_OPACCTRLJ_TPCFG7_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.             */


/*                                                AC OPACCTRLJ WPCFG7 [1..1]                                                 */
 /* AC_OPACCTRLJ_WPCFG7 */
#define  AC_OPACCTRLJ_WPCFG7_0                  0U     /* 0 : This peripheral allows write accesses.                         */
#define  AC_OPACCTRLJ_WPCFG7_1                  1U     /* 1 : This peripheral is write protected.                            */


/*                                                AC OPACCTRLJ SPCFG7 [2..2]                                                 */
/* AC_OPACCTRLJ_SPCFG7 */
#define  AC_OPACCTRLJ_SPCFG7_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                    for accesses.       */
#define  AC_OPACCTRLJ_SPCFG7_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */

/*                                                AC OPACCTRLJ TPCFG6 [4..4]                                                 */
 /* AC_OPACCTRLJ_TPCFG6 */
#define  AC_OPACCTRLJ_TPCFG6_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                 */
#define  AC_OPACCTRLJ_TPCFG6_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.             */


/*                                                AC OPACCTRLJ WPCFG6 [5..5]                                                 */
 /* AC_OPACCTRLJ_WPCFG6 */
#define  AC_OPACCTRLJ_WPCFG6_0                  0U     /* 0 : This peripheral allows write accesses.                         */
#define  AC_OPACCTRLJ_WPCFG6_1                  1U     /* 1 : This peripheral is write protected.                            */


/*                                                AC OPACCTRLJ SPCFG6 [6..6]                                                 */
/* AC_OPACCTRLJ_SPCFG6 */
#define  AC_OPACCTRLJ_SPCFG6_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                    for accesses.       */
#define  AC_OPACCTRLJ_SPCFG6_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */

/*                                                AC OPACCTRLJ TPCFG4 [12..12]                                                 */
 /* AC_OPACCTRLJ_TPCFG4 */
#define  AC_OPACCTRLJ_TPCFG4_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLJ_TPCFG4_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLJ WPCFG4 [13..13]                                                 */
 /* AC_OPACCTRLJ_WPCFG4 */
#define  AC_OPACCTRLJ_WPCFG4_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLJ_WPCFG4_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLJ SPCFG4 [14..14]                                                 */
/* AC_OPACCTRLJ_SPCFG4 */
#define  AC_OPACCTRLJ_SPCFG4_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                    for accesses.       */
#define  AC_OPACCTRLJ_SPCFG4_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                       accesses.           */

/*                                                AC OPACCTRLJ TPCFG3 [16..16]                                                 */
/* AC_OPACCTRLJ_TPCFG3 */
#define  AC_OPACCTRLJ_TPCFG3_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLJ_TPCFG3_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLJ WPCFG3 [17..17]                                                 */
  /* AC_OPACCTRLJ_WPCFG3 */
#define  AC_OPACCTRLJ_WPCFG3_0                  0U     /* 0 : This peripheral allows write accesses.                            */
#define  AC_OPACCTRLJ_WPCFG3_1                  1U     /* 1 : This peripheral is write protected.                               */


/*                                                AC OPACCTRLJ SPCFG3 [18..18]                                                 */
/* AC_OPACCTRLJ_SPCFG3 */
 #define AC_OPACCTRLJ_SPCFG3_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.     */
 #define AC_OPACCTRLJ_SPCFG3_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.          */


/*                                                AC OPACCTRLJ TPCFG2 [20..20]                                                 */
  /* AC_OPACCTRLJ_TPCFG2 */
#define  AC_OPACCTRLJ_TPCFG2_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLJ_TPCFG2_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLJ WPCFG2 [21..21]                                                 */
  /* AC_OPACCTRLJ_WPCFG2 */
#define  AC_OPACCTRLJ_WPCFG2_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLJ_WPCFG2_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLJ SPCFG2 [22..22]                                                 */
  /* AC_OPACCTRLJ_SPCFG2 */
#define  AC_OPACCTRLJ_SPCFG2_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.    */
#define  AC_OPACCTRLJ_SPCFG2_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.        */


/*                                                AC OPACCTRLK TPCFG6 [4..4]                                                 */
/* AC_OPACCTRLK_TPCFG3 */
#define  AC_OPACCTRLK_TPCFG6_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                 */
#define  AC_OPACCTRLK_TPCFG6_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.             */

/*                                                AC OPACCTRLK WPCFG6 [5..5]                                                 */
/* AC_OPACCTRLK_WPCFG3 */
 #define AC_OPACCTRLK_WPCFG6_0                  0U     /* 0 : This peripheral allows write accesses.                         */
 #define AC_OPACCTRLK_WPCFG6_1                  1U     /* 1 : This peripheral is write protected.                            */

/*                                                AC OPACCTRLK SPCFG6 [6..6]                                                 */
/* AC_OPACCTRLK_SPCFG6 */
 #define AC_OPACCTRLK_SPCFG6_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                      for accesses.     */
 #define AC_OPACCTRLK_SPCFG6_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.         */


/*                                                AC OPACCTRLK TPCFG3 [16..16]                                                 */
/* AC_OPACCTRLK_TPCFG3  */
#define  AC_OPACCTRLK_TPCFG3_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLK_TPCFG3_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLK WPCFG3 [17..17]                                                 */
/* AC_OPACCTRLK_WPCFG3 */
 #define AC_OPACCTRLK_WPCFG3_0                  0U     /* 0 : This peripheral allows write accesses.                           */
 #define AC_OPACCTRLK_WPCFG3_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLK SPCFG3 [18..18]                                                 */
 /* AC_OPACCTRLK_SPCFG3 */
 #define AC_OPACCTRLK_SPCFG3_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                      for accesses.      */
 #define AC_OPACCTRLK_SPCFG3_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.          */


/*                                                AC OPACCTRLK TPCFG1 [24..24]                                                 */
/* AC_OPACCTRLK_TPCFG1 */
#define  AC_OPACCTRLK_TPCFG1_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLK_TPCFG1_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                AC OPACCTRLK WPCFG1 [25..25]                                                 */
/* AC_OPACCTRLK_WPCFG1 */
 #define AC_OPACCTRLK_WPCFG1_0                  0U     /* 0 : This peripheral allows write accesses.                           */
 #define AC_OPACCTRLK_WPCFG1_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLK SPCFG1 [26..26]                                               */
/* AC_OPACCTRLK_SPCFG1 */
 #define AC_OPACCTRLK_SPCFG1_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                      for accesses.    */
 #define AC_OPACCTRLK_SPCFG1_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.        */

/*                                                AC OPACCTRLK TPCFG0 [28..28]                                               */
/* AC_OPACCTRLK_TPCFG0 */
#define  AC_OPACCTRLK_TPCFG0_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                 */
#define  AC_OPACCTRLK_TPCFG0_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.             */


/*                                                AC OPACCTRLK WPCFG0 [29..29]                                               */
/* AC_OPACCTRLK_WPCFG0 */
 #define AC_OPACCTRLK_WPCFG0_0                  0U     /* 0 : This peripheral allows write accesses.                          */
 #define AC_OPACCTRLK_WPCFG0_1                  1U     /* 1 : This peripheral is write protected.                             */


/*                                                AC OPACCTRLK SPCFG0 [30..30]                                                */
 /* AC_OPACCTRLK_SPCFG0 */
 #define AC_OPACCTRLK_SPCFG0_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                      for accesses.     */
 #define AC_OPACCTRLK_SPCFG0_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.         */


/*                                                          OPACCTRLL    */
/*                                                 AC OPACCTRLL TPCFG7 [0..0]                                                  */
/* AC_OPACCTRLL_TPCFG7 */
#define  AC_OPACCTRLL_TPCFG7_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                   */
#define  AC_OPACCTRLL_TPCFG7_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.               */


/*                                                 AC OPACCTRLL WPCFG7 [1..1]                                                  */
/* AC_OPACCTRLL_WPCFG7 */
#define  AC_OPACCTRLL_WPCFG7_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLL_WPCFG7_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                 AC OPACCTRLL SPCFG7 [2..2]                                               */
/* AC_OPACCTRLL_SPCFG7 */
 #define AC_OPACCTRLL_SPCFG7_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                       for accesses.  */
 #define AC_OPACCTRLL_SPCFG7_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                      accesses.       */


/*                                                 AC OPACCTRLL TPCFG6 [4..4]                                              */
/* AC_OPACCTRLL_TPCFG6 */
 #define AC_OPACCTRLL_TPCFG6_0                  0U     /* 0 : Accesses from an untrusted master are allowed.               */
 #define AC_OPACCTRLL_TPCFG6_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.           */


/*                                                 AC OPACCTRLL WPCFG6 [5..5]                                               */
/* AC_OPACCTRLL_WPCFG6 */
#define  AC_OPACCTRLL_WPCFG6_0                  0U     /* 0 : This peripheral allows write accesses.                        */
#define  AC_OPACCTRLL_WPCFG6_1                  1U     /* 1 : This peripheral is write protected.                           */


/*                                                 AC OPACCTRLL SPCFG6 [6..6]                                               */
/* AC_OPACCTRLL_SPCFG6 */
 #define AC_OPACCTRLL_SPCFG6_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                        for accesses.  */
 #define AC_OPACCTRLL_SPCFG6_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.      */


/*                                                 AC OPACCTRLL TPCFG5 [8..8]                                                 */
/* AC_OPACCTRLL_TPCFG5*/
#define  AC_OPACCTRLL_TPCFG5_0                  0U     /* 0 : Accesses from an untrusted master are allowed.                  */
#define  AC_OPACCTRLL_TPCFG5_1                  1U     /* 1 : Accesses from an untrusted master are not allowed.              */


/*                                                 AC OPACCTRLL WPCFG5 [9..9]                                                  */
/* AC_OPACCTRLL_WPCFG5 */
#define  AC_OPACCTRLL_WPCFG5_0                  0U     /* 0 : This peripheral allows write accesses.                           */
#define  AC_OPACCTRLL_WPCFG5_1                  1U     /* 1 : This peripheral is write protected.                              */


/*                                                AC OPACCTRLL SPCFG5 [10..10]                                                 */
/* AC_OPACCTRLL_SPCFG5 */
#define  AC_OPACCTRLL_SPCFG5_0                  0U     /* 0 : This peripheral does not require supervisor privilege level
                                                         for accesses.    */
#define  AC_OPACCTRLL_SPCFG5_1                  1U     /* 1 : This peripheral requires supervisor privilege level for
                                                        accesses.         */




/* =========================================================================================================================== */
/* ================                                            MSC                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  PCxTYPE  ======================================================== */
/* =======================================================  CPUxLPNUM  ======================================================= */
/* ======================================================  CPUxPBMNUM  ======================================================= */
/* ========================================================  CPUxCNT  ======================================================== */
/* ========================================================  PCxINF0  ======================================================== */
/* ========================================================  PCxINF1  ======================================================== */
/* ========================================================  PCxINF2  ======================================================== */
/* ========================================================  PCxINF3  ======================================================== */
/* ===============================================  MSC PCxINF3 FPUFLG [0..0]  =============================================== */
                                   /* MSC_PCxINF3_FPUFLG                                                        */
#define  MSC_PCxINF3_FPUFLG_0                   0U     /* 0 : FPU support is not included.                                          */
#define  MSC_PCxINF3_FPUFLG_1                   1U     /* 1 : FPU support is included.                                              */


/*                                                  MSC PCxINF3 ISEFLG [1..1]                                                  */
                                      /* MSC_PCxINF3_ISEFLG                                                        */
#define  MSC_PCxINF3_ISEFLG_0                   0U     /* 0 : SIMD/NEON support is not included.                                    */
#define  MSC_PCxINF3_ISEFLG_1                   1U     /* 1 : SIMD/NEON support is included.                                        */


/*                                                  MSC PCxINF3 JHWFLG [2..2]                                                  */
                                    /* MSC_PCxINF3_JHWFLG                                                        */
#define  MSC_PCxINF3_JHWFLG_0                   0U     /* 0 : Jazelle support is not included.                                      */
#define  MSC_PCxINF3_JHWFLG_1                   1U     /* 1 : Jazelle support is included.                                          */


/*                                                  MSC PCxINF3 MMFLG [3..3]                                                   */
                                    /* MSC_PCxINF3_MMFLG                                                         */
#define  MSC_PCxINF3_MMFLG_0                    0U     /* 0 : MMU support is not included.                                          */
#define  MSC_PCxINF3_MMFLG_1                    1U     /* 1 : MMU support is included.                                              */


/*                                                  MSC PCxINF3 TZFFLG [4..4]                                                  */
                                    /* MSC_PCxINF3_TZFFLG                                                        */
#define  MSC_PCxINF3_TZFFLG_0                   0U     /* 0 : Trust Zone support is not included.                                   */
#define  MSC_PCxINF3_TZFFLG_1                   1U     /* 1 : Trust Zone support is included.                                       */


/*                                                 MSC PCxINF3 CMPHWFLG [5..5]                                                 */
                                      /* MSC_PCxINF3_CMPHWFLG                                                      */
#define  MSC_PCxINF3_CMPHWFLG_0                 0U     /* 0 : Core Memory Protection is not included.                               */
#define  MSC_PCxINF3_CMPHWFLG_1                 1U     /* 1 : Core Memory Protection is included.                                   */


/*                                                  MSC PCxINF3 BBFLG [6..6]                                                   */
                                   /* MSC_PCxINF3_BBFLG                                                         */
#define  MSC_PCxINF3_BBFLG_0                    0U     /* 0 : Bit Banding is not supported.                                         */
#define  MSC_PCxINF3_BBFLG_1                    1U     /* 1 : Bit Banding is supported.                                             */


/* ========================================================  PC0TYPE  ======================================================== */
/* =======================================================  CPU0LPNUM  ======================================================= */
/* =======================================================  CPU0PBNUM  ======================================================= */
/* ========================================================  CPU0CNT  ======================================================== */
/* ========================================================  PC0INF0  ======================================================== */
/* ========================================================  PC0INF1  ======================================================== */
/* ========================================================  PC0INF2  ======================================================== */
/* ========================================================  PC0INF3  ======================================================== */
/* ===============================================  MSC PC0INF3 FPUFLG [0..0]  =============================================== */
                                   /* MSC_PC0INF3_FPUFLG                                                        */
#define  MSC_PC0INF3_FPUFLG_0                   0U     /* 0 : FPU support is not included.                                          */
#define  MSC_PC0INF3_FPUFLG_1                   1U     /* 1 : FPU support is included.                                              */


/*                                                  MSC PC0INF3 ISEFLG [1..1]                                                  */
                                      /* MSC_PC0INF3_ISEFLG                                                        */
#define  MSC_PC0INF3_ISEFLG_0                   0U     /* 0 : SIMD/NEON support is not included.                                    */
#define  MSC_PC0INF3_ISEFLG_1                   1U     /* 1 : SIMD/NEON support is included.                                        */


/*                                                  MSC PC0INF3 JHWFLG [2..2]                                                  */
                                   /* MSC_PC0INF3_JHWFLG                                                        */
 #define MSC_PC0INF3_JHWFLG_0                   0U     /* 0 : Jazelle support is not included.                                      */
 #define MSC_PC0INF3_JHWFLG_1                   1U     /* 1 : Jazelle support is included.                                          */


/*                                                  MSC PC0INF3 MMFLG [3..3]                                                   */
                                     /* MSC_PC0INF3_MMFLG                                                         */
#define  MSC_PC0INF3_MMFLG_0                    0U     /* 0 : MMU support is not included.                                          */
#define  MSC_PC0INF3_MMFLG_1                    1U     /* 1 : MMU support is included.                                              */


/*                                                  MSC PC0INF3 TZFFLG [4..4]                                                  */
                                    /* MSC_PC0INF3_TZFFLG                                                        */
#define  MSC_PC0INF3_TZFFLG_0                   0U     /* 0 : Trust Zone support is not included.                                   */
#define  MSC_PC0INF3_TZFFLG_1                   1U     /* 1 : Trust Zone support is included.                                       */


/*                                                 MSC PC0INF3 CMPHWFLG [5..5]                                                 */
                                    /* MSC_PC0INF3_CMPHWFLG                                                      */
#define  MSC_PC0INF3_CMPHWFLG_0                 0U     /* 0 : Core Memory Protection is not included.                               */
#define  MSC_PC0INF3_CMPHWFLG_1                 1U     /* 1 : Core Memory Protection is included.                                   */


/*                                                  MSC PC0INF3 BBFLG [6..6]                                                   */
                                     /* MSC_PC0INF3_BBFLG                                                         */
#define  MSC_PC0INF3_BBFLG_0                    0U     /* 0 : Bit Banding is not supported.                                         */
#define  MSC_PC0INF3_BBFLG_1                    1U     /* 1 : Bit Banding is supported.                                             */


/*                                                            OCMD0                                                            */
/*                                                 MSC OCMD0 OCMTYPE [13..15]                                                  */
                                    /* MSC_OCMD0_OCMTYPE                                                         */
#define  MSC_OCMD0_OCMTYPE_100                  4U     /* 100 : OCMEMn is a Program Flash.                                          */
#define  MSC_OCMD0_OCMTYPE_101                  5U     /* 101 : OCMEMn is a Data Flash.                                             */
#define  MSC_OCMD0_OCMTYPE_110                  6U     /* 110 : OCMEMn is an EEE.                                                   */


/*                                                  MSC OCMD0 RONLY [16..16]                                                   */
                                     /* MSC_OCMD0_RONLY                                                           */
#define  MSC_OCMD0_RONLY_0                      0U     /* 0 : Writes to the OCMDRn[11:0] are allowed                                */
#define  MSC_OCMD0_RONLY_1                      1U     /* 1 : Writes to the OCMDRn[11:0] are ignored                                */


/*                                                 MSC OCMD0 OCMDPWID [17..19]                                                 */
                                  /* MSC_OCMD0_OCMDPWID                                                        */
#define  MSC_OCMD0_OCMDPWID_010                 2U     /* 010 : OCMEMn 32-bits wide                                                 */
#define  MSC_OCMD0_OCMDPWID_011                 3U     /* 011 : OCMEMn 64-bits wide                                                 */
#define  MSC_OCMD0_OCMDPWID_100                 4U     /* 100 : OCMEMn 128-bits wide                                                */
#define  MSC_OCMD0_OCMDPWID_101                 5U     /* 101 : OCMEMn 256-bits wide                                                */


/*                                                 MSC OCMD0 OCMSIZE [24..27]                                                  */
                                  /* MSC_OCMD0_OCMSIZE                                                         */
#define  MSC_OCMD0_OCMSIZE_0000                 0U     /* 0000 : no OCMEMn                                                          */
#define  MSC_OCMD0_OCMSIZE_0001                 1U     /* 0001 : 1KB OCMEMn                                                         */
#define  MSC_OCMD0_OCMSIZE_0010                 2U     /* 0010 : 2KB OCMEMn                                                         */
#define  MSC_OCMD0_OCMSIZE_0011                 3U     /* 0011 : 4KB OCMEMn                                                         */
#define  MSC_OCMD0_OCMSIZE_0100                 4U     /* 0100 : 8KB OCMEMn                                                         */
#define  MSC_OCMD0_OCMSIZE_0101                 5U     /* 0101 : 16KB OCMEMn                                                        */
#define  MSC_OCMD0_OCMSIZE_0110                 6U     /* 0110 : 32KB OCMEMn                                                        */
#define  MSC_OCMD0_OCMSIZE_0111                 7U     /* 0111 : 64KB OCMEMn                                                        */
#define  MSC_OCMD0_OCMSIZE_1000                 8U     /* 1000 : 128KB OCMEMn                                                       */
#define  MSC_OCMD0_OCMSIZE_1001                 9U     /* 1001 : 256KB OCMEMn                                                       */
#define  MSC_OCMD0_OCMSIZE_1010                 10U    /* 1010 : 512KB OCMEMn                                                       */
#define  MSC_OCMD0_OCMSIZE_1011                 11U    /* 1011 : 1MB OCMEMn                                                         */
#define  MSC_OCMD0_OCMSIZE_1100                 12U    /* 1100 : 2MB OCMEMn                                                         */
#define  MSC_OCMD0_OCMSIZE_1101                 13U    /* 1101 : 4MB OCMEMn                                                         */
#define  MSC_OCMD0_OCMSIZE_1110                 14U    /* 1110 : 8MB OCMEMn                                                         */
#define  MSC_OCMD0_OCMSIZE_1111                 15U    /* 1111 : 16MB OCMEMn                                                        */


/*                                                  MSC OCMD0 IFOCM [28..28]                                                   */
                                /* MSC_OCMD0_IFOCM                                                           */
#define  MSC_OCMD0_IFOCM_0                      0U     /* 0 : OCMEMn is a power-of-2 capacity.                                      */
#define  MSC_OCMD0_IFOCM_1                      1U     /* 1 : OCMEMn is not a power-of-2U with a capacity is 0.75 * OCMSZ.          */


/*                                                MSC OCMD0 OCMVLDFLG [31..31]                                                 */
                                   /* MSC_OCMD0_OCMVLDFLG                                                       */
#define  MSC_OCMD0_OCMVLDFLG_0                  0U     /* 0 : OCMEMn is not present.                                                */
#define  MSC_OCMD0_OCMVLDFLG_1                  1U     /* 1 : OCMEMn is present.                                                    */


/*                                                            OCMD1                                                            */
/*                                                 MSC OCMD1 OCMTYPE [13..15]                                                  */
                                    /* MSC_OCMD1_OCMTYPE                                                         */
#define  MSC_OCMD1_OCMTYPE_100                  4U     /* 100 : OCMEMn is a Program Flash.                                          */
#define  MSC_OCMD1_OCMTYPE_101                  5U     /* 101 : OCMEMn is a Data Flash.                                             */
#define  MSC_OCMD1_OCMTYPE_110                  6U     /* 110 : OCMEMn is an EEE.                                                   */


/*                                                  MSC OCMD1 RONLY [16..16]                                                   */
                                    /* MSC_OCMD1_RONLY                                                           */
#define  MSC_OCMD1_RONLY_0                      0U     /* 0 : Writes to the OCMDRn[11:0] are allowed                                */
#define  MSC_OCMD1_RONLY_1                      1U     /* 1 : Writes to the OCMDRn[11:0] are ignored                                */


/*                                                 MSC OCMD1 OCMDPWID [17..19]                                                 */
                                  /* MSC_OCMD1_OCMDPWID                                                        */
#define  MSC_OCMD1_OCMDPWID_010                 2U     /* 010 : OCMEMn 32-bits wide                                                 */
#define  MSC_OCMD1_OCMDPWID_011                 3U     /* 011 : OCMEMn 64-bits wide                                                 */
#define  MSC_OCMD1_OCMDPWID_100                 4U     /* 100 : OCMEMn 128-bits wide                                                */
#define  MSC_OCMD1_OCMDPWID_101                 5U     /* 101 : OCMEMn 256-bits wide                                                */


/*                                                 MSC OCMD1 OCMSIZE [24..27]                                                  */
                                   /* MSC_OCMD1_OCMSIZE                                                         */
#define  MSC_OCMD1_OCMSIZE_0000                 0U     /* 0000 : no OCMEMn                                                          */
#define  MSC_OCMD1_OCMSIZE_0001                 1U     /* 0001 : 1KB OCMEMn                                                         */
#define  MSC_OCMD1_OCMSIZE_0010                 2U     /* 0010 : 2KB OCMEMn                                                         */
#define  MSC_OCMD1_OCMSIZE_0011                 3U     /* 0011 : 4KB OCMEMn                                                         */
#define  MSC_OCMD1_OCMSIZE_0100                 4U     /* 0100 : 8KB OCMEMn                                                         */
#define  MSC_OCMD1_OCMSIZE_0101                 5U     /* 0101 : 16KB OCMEMn                                                        */
#define  MSC_OCMD1_OCMSIZE_0110                 6U     /* 0110 : 32KB OCMEMn                                                        */
#define  MSC_OCMD1_OCMSIZE_0111                 7U     /* 0111 : 64KB OCMEMn                                                        */
#define  MSC_OCMD1_OCMSIZE_1000                 8U     /* 1000 : 128KB OCMEMn                                                       */
#define  MSC_OCMD1_OCMSIZE_1001                 9U     /* 1001 : 256KB OCMEMn                                                       */
#define  MSC_OCMD1_OCMSIZE_1010                 10U    /* 1010 : 512KB OCMEMn                                                       */
#define  MSC_OCMD1_OCMSIZE_1011                 11U    /* 1011 : 1MB OCMEMn                                                         */
#define  MSC_OCMD1_OCMSIZE_1100                 12U    /* 1100 : 2MB OCMEMn                                                         */
#define  MSC_OCMD1_OCMSIZE_1101                 13U    /* 1101 : 4MB OCMEMn                                                         */
#define  MSC_OCMD1_OCMSIZE_1110                 14U    /* 1110 : 8MB OCMEMn                                                         */
#define  MSC_OCMD1_OCMSIZE_1111                 15U    /* 1111 : 16MB OCMEMn                                                        */


/*                                                  MSC OCMD1 IFOCM [28..28]                                                   */
                                 /* MSC_OCMD1_IFOCM                                                           */
#define  MSC_OCMD1_IFOCM_0                      0U     /* 0 : OCMEMn is a power-of-2 capacity.                                      */
#define  MSC_OCMD1_IFOCM_1                      1U     /* 1 : OCMEMn is not a power-of-2U with a capacity is 0.75 * OCMSZ.          */


/*                                                MSC OCMD1 OCMVLDFLG [31..31]                                                 */
                                  /* MSC_OCMD1_OCMVLDFLG                                                       */
#define  MSC_OCMD1_OCMVLDFLG_0                  0U     /* 0 : OCMEMn is not present.                                                */
#define  MSC_OCMD1_OCMVLDFLG_1                  1U     /* 1 : OCMEMn is present.                                                    */


/*                                                            OCMD2                                                            */
/*                                                 MSC OCMD2 OCMTYPE [13..15]                                                  */
                                     /* MSC_OCMD2_OCMTYPE                                                         */
#define  MSC_OCMD2_OCMTYPE_100                  4U     /* 100 : OCMEMn is a Program Flash.                                          */
#define  MSC_OCMD2_OCMTYPE_101                  5U     /* 101 : OCMEMn is a Data Flash.                                             */
#define  MSC_OCMD2_OCMTYPE_110                  6U     /* 110 : OCMEMn is an EEE.                                                   */


/*                                                  MSC OCMD2 RONLY [16..16]                                                   */
                                   /* MSC_OCMD2_RONLY                                                           */
#define  MSC_OCMD2_RONLY_0                      0U     /* 0 : Writes to the OCMDRn[11:0] are allowed                                */
#define  MSC_OCMD2_RONLY_1                      1U     /* 1 : Writes to the OCMDRn[11:0] are ignored                                */


/*                                                 MSC OCMD2 OCMDPWID [17..19]                                                 */
                                   /* MSC_OCMD2_OCMDPWID                                                        */
#define  MSC_OCMD2_OCMDPWID_010                 2U     /* 010 : OCMEMn 32-bits wide                                                 */
#define  MSC_OCMD2_OCMDPWID_011                 3U     /* 011 : OCMEMn 64-bits wide                                                 */
#define  MSC_OCMD2_OCMDPWID_100                 4U     /* 100 : OCMEMn 128-bits wide                                                */
#define  MSC_OCMD2_OCMDPWID_101                 5U     /* 101 : OCMEMn 256-bits wide                                                */


/*                                                 MSC OCMD2 OCMSIZE [24..27]                                                  */
                                    /* MSC_OCMD2_OCMSIZE                                                         */
#define  MSC_OCMD2_OCMSIZE_0000                 0U     /* 0000 : no OCMEMn                                                          */
#define  MSC_OCMD2_OCMSIZE_0001                 1U     /* 0001 : 1KB OCMEMn                                                         */
#define  MSC_OCMD2_OCMSIZE_0010                 2U     /* 0010 : 2KB OCMEMn                                                         */
#define  MSC_OCMD2_OCMSIZE_0011                 3U     /* 0011 : 4KB OCMEMn                                                         */
#define  MSC_OCMD2_OCMSIZE_0100                 4U     /* 0100 : 8KB OCMEMn                                                         */
#define  MSC_OCMD2_OCMSIZE_0101                 5U     /* 0101 : 16KB OCMEMn                                                        */
#define  MSC_OCMD2_OCMSIZE_0110                 6U     /* 0110 : 32KB OCMEMn                                                        */
#define  MSC_OCMD2_OCMSIZE_0111                 7U     /* 0111 : 64KB OCMEMn                                                        */
#define  MSC_OCMD2_OCMSIZE_1000                 8U     /* 1000 : 128KB OCMEMn                                                       */
#define  MSC_OCMD2_OCMSIZE_1001                 9U     /* 1001 : 256KB OCMEMn                                                       */
#define  MSC_OCMD2_OCMSIZE_1010                 10U    /* 1010 : 512KB OCMEMn                                                       */
#define  MSC_OCMD2_OCMSIZE_1011                 11U    /* 1011 : 1MB OCMEMn                                                         */
#define  MSC_OCMD2_OCMSIZE_1100                 12U    /* 1100 : 2MB OCMEMn                                                         */
#define  MSC_OCMD2_OCMSIZE_1101                 13U    /* 1101 : 4MB OCMEMn                                                         */
#define  MSC_OCMD2_OCMSIZE_1110                 14U    /* 1110 : 8MB OCMEMn                                                         */
#define  MSC_OCMD2_OCMSIZE_1111                 15U    /* 1111 : 16MB OCMEMn                                                        */


/*                                                  MSC OCMD2 IFOCM [28..28]                                                   */
                                  /* MSC_OCMD2_IFOCM                                                           */
#define  MSC_OCMD2_IFOCM_0                      0U     /* 0 : OCMEMn is a power-of-2 capacity.                                      */
#define  MSC_OCMD2_IFOCM_1                      1U     /* 1 : OCMEMn is not a power-of-2U with a capacity is 0.75 * OCMSZ.          */


/*                                                MSC OCMD2 OCMVLDFLG [31..31]                                                 */
                                  /* MSC_OCMD2_OCMVLDFLG                                                       */
 #define MSC_OCMD2_OCMVLDFLG_0                  0U     /* 0 : OCMEMn is not present.                                                */
 #define MSC_OCMD2_OCMVLDFLG_1                  1U     /* 1 : OCMEMn is present.                                                    */




/*                                                                                                                             */
/*                                                             DMA                                                             */
/*                                                                                                                             */

/*                                                            CTRL                                                             */
/*                                                  DMA CTRL HALTEFLG [4..4]                                                   */
                                /* DMA_CTRL_HALTEFLG                                                         */
#define  DMA_CTRL_HALTEFLG_0                    0U     /* 0 : Normal operation                                                      */
#define  DMA_CTRL_HALTEFLG_1                    1U     /* 1 : Any error causes the HALT bit to set. SubsequentlyU all
                                                     service requests are ignored until the HALT bit is cleared.               */


/*                                                    DMA CTRL HALT [5..5]                                                     */
                                 /* DMA_CTRL_HALT                                                             */
#define  DMA_CTRL_HALT_0                        0U     /* 0 : Normal operation                                                      */
#define  DMA_CTRL_HALT_1                        1U     /* 1 : Stall the start of any new channels. Executing channels
                                                     are allowed to complete. Channel execution resumes when
                                                     this bit is cleared.                                                      */


/*                                                    DMA CTRL CLMEN [6..6]                                                    */
                               /* DMA_CTRL_CLMEN                                                            */
#define  DMA_CTRL_CLMEN_0                       0U     /* 0 : A minor loop channel link made to itself goes through channel
                                                      arbitration before being activated again.                                 */
#define  DMA_CTRL_CLMEN_1                       1U     /* 1 : A minor loop channel link made to itself does not go through
                                                       channel arbitration before being activated again. Upon
                                                     minor loop completionU the channel activates again if that
                                                     channel has a minor loop channel link enabled and the link
                                                     channel is itself. This effectively applies the minor loop
                                                     offsets and restarts the next minor loop.                                 */


/*                                                   DMA CTRL MINLMEN [7..7]                                                   */
                                    /* DMA_CTRL_MINLMEN                                                          */
#define  DMA_CTRL_MINLMEN_0                     0U     /* 0 : Disabled. TCDn.word2 is defined as a 32-bit NBYTES field.             */
#define  DMA_CTRL_MINLMEN_1                     1U     /* 1 : Enabled. TCDn.word2 is redefined to include individual enable
                                                     fieldsU an offset fieldU and the NBYTES field. The individual
                                                     enable fields allow the minor loop offset to be applied
                                                     to the source addressU the destination addressU or both.
                                                     The NBYTES field is reduced when either offset is enabled.                */


/*                                                 DMA CTRL TXCNLERR [16..16]                                                  */
                                   /* DMA_CTRL_TXCNLERR                                                         */
#define  DMA_CTRL_TXCNLERR_0                    0U     /* 0 : Normal operation                                                      */
#define  DMA_CTRL_TXCNLERR_1                    1U     /* 1 : Cancel the remaining data transfer in the same fashion as
                                                     the CX bit. Stop the executing channel and force the minor
                                                     loop to finish. The cancel takes effect after the last
                                                     write of the current read/write sequence. The ECX bit clears
                                                     itself after the cancel is honored. In addition to cancelling
                                                     the transferU ECX treats the cancel as an error conditionU
                                                     thus updating the Error Status register (DMAx_ES) and generating
                                                     an optional error interrupt.                                              */


/*                                                   DMA CTRL TXCNL [17..17]                                                   */
                                     /* DMA_CTRL_TXCNL                                                            */
#define  DMA_CTRL_TXCNL_0                       0U     /* 0 : Normal operation                                                      */
#define  DMA_CTRL_TXCNL_1                       1U     /* 1 : Cancel the remaining data transfer. Stop the executing channel
                                                     and force the minor loop to finish. The cancel takes effect
                                                     after the last write of the current read/write sequence.
                                                     The CX bit clears itself after the cancel has been honored.
                                                     This cancel retires the channel normally as if the minor
                                                     loop was completed.                                                       */


/*                                                  DMA CTRL ACTFLG [31..31]                                                   */
                                     /* DMA_CTRL_ACTFLG                                                           */
#define  DMA_CTRL_ACTFLG_0                      0U     /* 0 : eDMA is idle.                                                         */
#define  DMA_CTRL_ACTFLG_1                      1U     /* 1 : eDMA is executing a channel.                                          */


/*                                                            ESTS                                                             */
/*                                                   DMA ESTS DBEFLG [0..0]                                                    */
                                   /* DMA_ESTS_DBEFLG                                                           */
#define  DMA_ESTS_DBEFLG_0                      0U     /* 0 : No destination bus error                                              */
#define  DMA_ESTS_DBEFLG_1                      1U     /* 1 : The last recorded error was a bus error on a destination
                                                     write                                                                     */


/*                                                   DMA ESTS SBEFLG [1..1]                                                    */
                                    /* DMA_ESTS_SBEFLG                                                           */
#define  DMA_ESTS_SBEFLG_0                      0U     /* 0 : No source bus error                                                   */
#define  DMA_ESTS_SBEFLG_1                      1U     /* 1 : The last recorded error was a bus error on a source read              */


/*                                                  DMA ESTS SGCFGEFLG [2..2]                                                  */
                                   /* DMA_ESTS_SGCFGEFLG                                                        */
#define  DMA_ESTS_SGCFGEFLG_0                   0U     /* 0 : No scatter/gather configuration error                                 */
#define  DMA_ESTS_SGCFGEFLG_1                   1U     /* 1 : The last recorded error was a configuration error detected
                                                     in the TCDn_DLASTSGA field. This field is checked at the
                                                     beginning of a scatter/gather operation after major loop
                                                     completion if TCDn_CSTS[SGFEN] is enabled. TCDn_DLASTSGA
                                                     is not on a 32 byte boundary.                                             */


/*                                                  DMA ESTS MCCFGEFLG [3..3]                                                  */
                                     /* DMA_ESTS_NCCFGEFLG                                                        */
#define  DMA_ESTS_NCCFGEFLG_0                   0U     /* 0 : No NBYTES/CITER configuration error                                   */


/*                                                 DMA ESTS DOFCFGEFLG [4..4]                                                  */
                                    /* DMA_ESTS_DOFCFGEFLG                                                       */
#define  DMA_ESTS_DOFCFGEFLG_0                  0U     /* 0 : No destination offset configuration error                             */
#define  DMA_ESTS_DOFCFGEFLG_1                  1U     /* 1 : The last recorded error was a configuration error detected
                                                     in the TCDn_DOFF field. TCDn_DOFF is inconsistent with
                                                     TCDn_ATTR[DSIZE].                                                         */


/*                                                DMA ESTS DADDRCFGEFLG [5..5]                                                 */
                               /* DMA_ESTS_DADDRCFGEFLG                                                     */
#define  DMA_ESTS_DADDRCFGEFLG_0                0U     /* 0 : No destination address configuration error                            */
#define  DMA_ESTS_DADDRCFGEFLG_1                1U     /* 1 : The last recorded error was a configuration error detected
                                                     in the TCDn_DADDR field. TCDn_DADDR is inconsistent with
                                                     TCDn_ATTR[DSIZE].                                                         */


/*                                                 DMA ESTS SOFCFGEFLG [6..6]                                                  */
                                   /* DMA_ESTS_SOFCFGEFLG                                                       */
#define  DMA_ESTS_SOFCFGEFLG_0                  0U     /* 0 : No source offset configuration error                                  */
#define  DMA_ESTS_SOFCFGEFLG_1                  1U     /* 1 : The last recorded error was a configuration error detected
                                                     in the TCDn_SOFF field. TCDn_SOFF is inconsistent with
                                                     TCDn_ATTR[SSIZE].                                                         */


/*                                                DMA ESTS SADDRCFGEFLG [7..7]                                                 */
                              /* DMA_ESTS_SADDRCFGEFLG                                                     */
#define  DMA_ESTS_SADDRCFGEFLG_0                0U     /* 0 : No source address configuration error.                                */
#define  DMA_ESTS_SADDRCFGEFLG_1                1U     /* 1 : The last recorded error was a configuration error detected
                                                     in the TCDn_SADDR field. TCDn_SADDR is inconsistent with
                                                     TCDn_ATTR[SSIZE].                                                         */


/*                                                 DMA ESTS CPCFGEFLG [14..14]                                                 */
                                   /* DMA_ESTS_CPCFGEFLG                                                        */
#define  DMA_ESTS_CPCFGEFLG_0                   0U     /* 0 : No channel priority error                                             */


/*                                                   DMA ESTS TCFLG [16..16]                                                   */
                                  /* DMA_ESTS_TCFLG                                                            */
#define  DMA_ESTS_TCFLG_0                       0U     /* 0 : No canceled transfers                                                 */
#define  DMA_ESTS_TCFLG_1                       1U     /* 1 : The last recorded entry was a canceled transfer by the error
                                                     cancel transfer input                                                     */


/*                                                  DMA ESTS EEFLG [31..31]                                                   */
                                     /* DMA_ESTS_EEFLG                                                           */
#define  DMA_ESTS_EEFLG_0                      0U     /* 0 : No ERR bits are set.                                                  */
#define  DMA_ESTS_EEFLG_1                      1U     /* 1 : At least one ERR bit is set indicating a valid error exists
                                                     that has not been cleared.                                                */


/*                                                            REQEN                                                            */
/*                                                   DMA REQEN REQEN0 [0..0]                                                   */
                                     /* DMA_REQEN_REQEN0                                                          */
#define  DMA_REQEN_REQEN0_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                      disabled                                                                  */
#define  DMA_REQEN_REQEN0_1                     1U     /* 1 : The DMA request signal for the corresponding channel is
                                                      enabled                                                                   */


/*                                                   DMA REQEN REQEN1 [1..1]                                                   */
                                    /* DMA_REQEN_REQEN1                                                          */
 #define DMA_REQEN_REQEN1_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                      disabled                                                                  */
 #define DMA_REQEN_REQEN1_1                     1U     /* 1 : The DMA request signal for the corresponding channel is
                                                       enabled                                                                   */


/*                                                   DMA REQEN REQEN2 [2..2]                                                   */
                                  /* DMA_REQEN_REQEN2                                                          */
#define  DMA_REQEN_REQEN2_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                             disabled                                                                  */
#define  DMA_REQEN_REQEN2_1                     1U     /* 1 : The DMA request signal for the corresponding channel is
                                                        enabled                                                                   */


/*                                                   DMA REQEN REQEN3 [3..3]                                                   */
                                     /* DMA_REQEN_REQEN3                                                          */
#define  DMA_REQEN_REQEN3_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                      disabled                                                                  */
#define  DMA_REQEN_REQEN3_1                     1U     /* 1 : The DMA request signal for the corresponding channel is
                                                        enabled                                                                   */


/*                                                   DMA REQEN REQEN4 [4..4]                                                   */
                                     /* DMA_REQEN_REQEN4                                                          */
#define  DMA_REQEN_REQEN4_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                       disabled                                                                  */
#define  DMA_REQEN_REQEN4_1                     1U     /* 1 : The DMA request signal for the corresponding channel is
                                                      enabled                                                                   */


/*                                                   DMA REQEN REQEN5 [5..5]                                                   */
                                   /* DMA_REQEN_REQEN5                                                          */
#define  DMA_REQEN_REQEN5_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                         disabled                                                                  */
#define  DMA_REQEN_REQEN5_1                     1U     /* 1 : The DMA request signal for the corresponding channel is
                                                       enabled                                                                   */


/*                                                   DMA REQEN REQEN6 [6..6]                                                   */
                                   /* DMA_REQEN_REQEN6                                                          */
#define  DMA_REQEN_REQEN6_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                        disabled                                                                  */
#define  DMA_REQEN_REQEN6_1                     1U     /* 1 : The DMA request signal for the corresponding channel is
                                                       enabled                                                                   */


/*                                                   DMA REQEN REQEN7 [7..7]                                                   */
                                   /* DMA_REQEN_REQEN7                                                          */
#define  DMA_REQEN_REQEN7_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                        disabled                                                                  */
#define  DMA_REQEN_REQEN7_1                     1U     /* 1 : The DMA request signal for the corresponding channel is
                                                        enabled                                                                   */


/*                                                   DMA REQEN REQEN8 [8..8]                                                   */
                                    /* DMA_REQEN_REQEN8                                                          */
#define  DMA_REQEN_REQEN8_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                        disabled                                                                  */
#define  DMA_REQEN_REQEN8_1                     1U     /* 1 : The DMA request signal for the corresponding channel is
                                                       enabled                                                                   */


/*                                                   DMA REQEN REQEN9 [9..9]                                                   */
                                 /* DMA_REQEN_REQEN9                                                          */
 #define DMA_REQEN_REQEN9_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                    disabled                                                                  */
 #define DMA_REQEN_REQEN9_1                     1U     /* 1 : The DMA request signal for the corresponding channel is
                                                     enabled                                                                   */


/*                                                 DMA REQEN REQEN10 [10..10]                                                  */
                                    /* DMA_REQEN_REQEN10                                                         */
#define  DMA_REQEN_REQEN10_0                    0U     /* 0 : The DMA request signal for the corresponding channel is
                                                        disabled                                                                  */
#define  DMA_REQEN_REQEN10_1                    1U     /* 1 : The DMA request signal for the corresponding channel is
                                                     enabled                                                                   */


/*                                                 DMA REQEN REQEN11 [11..11]                                                  */
                                   /* DMA_REQEN_REQEN11                                                         */
#define  DMA_REQEN_REQEN11_0                    0U     /* 0 : The DMA request signal for the corresponding channel is
                                                        disabled                                                                  */
#define  DMA_REQEN_REQEN11_1                    1U     /* 1 : The DMA request signal for the corresponding channel is
                                                    enabled                                                                   */


/*                                                 DMA REQEN REQEN12 [12..12]                                                  */
                                     /* DMA_REQEN_REQEN12                                                         */
#define  DMA_REQEN_REQEN12_0                    0U     /* 0 : The DMA request signal for the corresponding channel is
                                                      disabled                                                                  */
#define  DMA_REQEN_REQEN12_1                    1U     /* 1 : The DMA request signal for the corresponding channel is
                                                     enabled                                                                   */


/*                                                 DMA REQEN REQEN13 [13..13]                                                  */
                                    /* DMA_REQEN_REQEN13                                                         */
 #define DMA_REQEN_REQEN13_0                    0U     /* 0 : The DMA request signal for the corresponding channel is
                                                    disabled                                                                  */
 #define DMA_REQEN_REQEN13_1                    1U     /* 1 : The DMA request signal for the corresponding channel is
                                                      enabled                                                                   */


/*                                                 DMA REQEN REQEN14 [14..14]                                                  */
                                    /* DMA_REQEN_REQEN14                                                         */
#define DMA_REQEN_REQEN14_0                     0U     /* 0 : The DMA request signal for the corresponding channel is
                                                      disabled                                                                  */
#define  DMA_REQEN_REQEN14_1                    1U     /* 1 : The DMA request signal for the corresponding channel is
                                                     enabled                                                                   */


/*                                                 DMA REQEN REQEN15 [15..15]                                                  */
                                   /* DMA_REQEN_REQEN15                                                         */
 #define DMA_REQEN_REQEN15_0                    0U     /* 0 : The DMA request signal for the corresponding channel is
                                                       disabled                                                                  */
 #define DMA_REQEN_REQEN15_1                    1U     /* 1 : The DMA request signal for the corresponding channel is
                                                     enabled                                                                   */


/*                                                            EIEN                                                             */
/*                                                    DMA EIEN EIEN0 [0..0]                                                    */
                                   /* DMA_EIEN_EIEN0                                                            */
 #define DMA_EIEN_EIEN0_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                       an error interrupt                                                        */
 #define DMA_EIEN_EIEN0_1                       1U     /* 1 : The assertion of the error signal for corresponding channel
                                                      generates an error interrupt request                                      */


/*                                                    DMA EIEN EIEN1 [1..1]                                                    */
                                   /* DMA_EIEN_EIEN1                                                            */
#define  DMA_EIEN_EIEN1_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                        an error interrupt                                                        */
#define  DMA_EIEN_EIEN1_1                       1U     /* 1 : The assertion of the error signal for corresponding channel
                                                      generates an error interrupt request                                      */


/*                                                    DMA EIEN EIEN2 [2..2]                                                    */
                                    /* DMA_EIEN_EIEN2                                                            */
 #define DMA_EIEN_EIEN2_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                       an error interrupt                                                        */
 #define DMA_EIEN_EIEN2_1                       1U     /* 1 : The assertion of the error signal for corresponding channel
                                                      generates an error interrupt request                                      */


/*                                                    DMA EIEN EIEN3 [3..3]                                                    */
                                     /* DMA_EIEN_EIEN3                                                            */
#define  DMA_EIEN_EIEN3_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                        an error interrupt                                                        */
#define  DMA_EIEN_EIEN3_1                       1U     /* 1 : The assertion of the error signal for corresponding channel
                                                      generates an error interrupt request                                      */


/*                                                    DMA EIEN EIEN4 [4..4]                                                    */
                                     /* DMA_EIEN_EIEN4                                                            */
#define  DMA_EIEN_EIEN4_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                       an error interrupt                                                        */
#define  DMA_EIEN_EIEN4_1                       1U     /* 1 : The assertion of the error signal for corresponding channel
                                                       generates an error interrupt request                                      */


/*                                                    DMA EIEN EIEN5 [5..5]                                                    */
                                     /* DMA_EIEN_EIEN5                                                            */
#define  DMA_EIEN_EIEN5_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                        an error interrupt                                                        */
#define  DMA_EIEN_EIEN5_1                       1U     /* 1 : The assertion of the error signal for corresponding channel
                                                        generates an error interrupt request                                      */


/*                                                    DMA EIEN EIEN6 [6..6]                                                    */
                                     /* DMA_EIEN_EIEN6                                                            */
#define  DMA_EIEN_EIEN6_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                       an error interrupt                                                        */
#define  DMA_EIEN_EIEN6_1                       1U     /* 1 : The assertion of the error signal for corresponding channel
#define                                                     generates an error interrupt request                                      */


/*                                                    DMA EIEN EIEN7 [7..7]                                                    */
                                 /* DMA_EIEN_EIEN7                                                            */
#define  DMA_EIEN_EIEN7_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                        an error interrupt                                                        */
#define  DMA_EIEN_EIEN7_1                       1U     /* 1 : The assertion of the error signal for corresponding channel
                                                      generates an error interrupt request                                      */


/*                                                    DMA EIEN EIEN8 [8..8]                                                    */
                                     /* DMA_EIEN_EIEN8                                                            */
 #define DMA_EIEN_EIEN8_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                       an error interrupt                                                        */
 #define DMA_EIEN_EIEN8_1                       1U     /* 1 : The assertion of the error signal for corresponding channel
                                                    generates an error interrupt request                                      */


/*                                                    DMA EIEN EIEN9 [9..9]                                                    */
                                     /* DMA_EIEN_EIEN9                                                            */
#define  DMA_EIEN_EIEN9_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                       an error interrupt                                                        */
#define  DMA_EIEN_EIEN9_1                       1U     /* 1 : The assertion of the error signal for corresponding channel
                                                        generates an error interrupt request                                      */


/*                                                  DMA EIEN EIEN10 [10..10]                                                   */
                                    /* DMA_EIEN_EIEN10                                                           */
#define DMA_EIEN_EIEN10_0                       0U     /* 0 : The error signal for corresponding channel does not generate
                                                       an error interrupt                                                        */
#define  DMA_EIEN_EIEN10_1                      1U     /* 1 : The assertion of the error signal for corresponding channel
                                                       generates an error interrupt request                                      */


/*                                                  DMA EIEN EIEN11 [11..11]                                                   */
                                 /* DMA_EIEN_EIEN11                                                           */
#define  DMA_EIEN_EIEN11_0                      0U     /* 0 : The error signal for corresponding channel does not generate
                                                       an error interrupt                                                        */
#define  DMA_EIEN_EIEN11_1                      1U     /* 1 : The assertion of the error signal for corresponding channel
                                                      generates an error interrupt request                                      */


/*                                                  DMA EIEN EIEN12 [12..12]                                                   */
                                     /* DMA_EIEN_EIEN12                                                           */
 #define DMA_EIEN_EIEN12_0                      0U     /* 0 : The error signal for corresponding channel does not generate
                                                    an error interrupt                                                        */
 #define DMA_EIEN_EIEN12_1                      1U     /* 1 : The assertion of the error signal for corresponding channel
                                                       generates an error interrupt request                                      */


/*                                                  DMA EIEN EIEN13 [13..13]                                                   */
                                   /* DMA_EIEN_EIEN13                                                           */
#define  DMA_EIEN_EIEN13_0                      0U     /* 0 : The error signal for corresponding channel does not generate
                                                       an error interrupt                                                        */
#define  DMA_EIEN_EIEN13_1                      1U     /* 1 : The assertion of the error signal for corresponding channel
                                                 generates an error interrupt request                                      */


/*                                                  DMA EIEN EIEN14 [14..14]                                                   */
                                  /* DMA_EIEN_EIEN14                                                           */
#define  DMA_EIEN_EIEN14_0                      0U     /* 0 : The error signal for corresponding channel does not generate
                                                       an error interrupt                                                        */
#define  DMA_EIEN_EIEN14_1                      1U     /* 1 : The assertion of the error signal for corresponding channel
                                                     generates an error interrupt request                                      */


/*                                                  DMA EIEN EIEN15 [15..15]                                                   */
                                     /* DMA_EIEN_EIEN15                                                           */
#define  DMA_EIEN_EIEN15_0                      0U     /* 0 : The error signal for corresponding channel does not generate
                                                        an error interrupt                                                        */
#define  DMA_EIEN_EIEN15_1                      1U     /* 1 : The assertion of the error signal for corresponding channel
                                                    generates an error interrupt request                                      */


/*                                                           EIENCLR                                                           */
/*                                                   DMA EIENCLR NOOP [7..7]                                                   */
                                    /* DMA_EIENCLR_NOOP                                                          */
#define  DMA_EIENCLR_NOOP_0                     0U     /* 0 : Normal operation                                                      */
#define  DMA_EIENCLR_NOOP_1                     1U     /* 1 : No operationU ignore the other bits in this register                  */


/*                                                           EIENSET                                                           */
/*                                                   DMA EIENSET NOOP [7..7]                                                   */
                                  /* DMA_EIENSET_NOOP                                                          */
#define  DMA_EIENSET_NOOP_0                     0U     /* 0 : Normal operation                                                      */
#define  DMA_EIENSET_NOOP_1                     1U     /* 1 : No operationU ignore the other bits in this register                  */


/*                                                          REQENCLR                                                           */
/*                                                  DMA REQENCLR NOOP [7..7]                                                   */
                                 /* DMA_REQENCLR_NOOP                                                         */
#define  DMA_REQENCLR_NOOP_0                    0U     /* 0 : Normal operation                                                      */
#define  DMA_REQENCLR_NOOP_1                    1U     /* 1 : No operationU ignore the other bits in this register                  */


/*                                                          REQENSET                                                           */
/*                                                  DMA REQENSET NOOP [7..7]                                                   */
                                 /* DMA_REQENSET_NOOP                                                         */
#define  DMA_REQENSET_NOOP_0                    0U     /* 0 : Normal operation                                                      */
#define  DMA_REQENSET_NOOP_1                    1U     /* 1 : No operationU ignore the other bits in this register                  */


/*                                                          DNESTSCLR                                                          */
/*                                                DMA DNESTSCLR ADNECLR [6..6]                                                 */
                                      /* DMA_DNESTSCLR_ADNECLR                                                     */
#define  DMA_DNESTSCLR_ADNECLR_0                0U     /* 0 : Clears only the TCDn_CSTS[DONE] bit specified in the CDNE
                                                       field                                                                     */
#define  DMA_DNESTSCLR_ADNECLR_1                1U     /* 1 : Clears all bits in TCDn_CSTS[DONE]                                    */


/*                                                  DMA DNESTSCLR NOOP [7..7]                                                  */
                                  /* DMA_DNESTSCLR_NOOP                                                        */
#define  DMA_DNESTSCLR_NOOP_0                   0U     /* 0 : Normal operation                                                      */
#define  DMA_DNESTSCLR_NOOP_1                   1U     /* 1 : No operationU ignore the other bits in this register                  */


/*                                                           STATSET                                                            */
/*                                                 DMA STATSET ASTATSET [6..6]                                                 */
                                      /* DMA_SRTSET_ASTATSET                                                      */
 #define DMA_STATSET_ASTATSET_0                 0U     /* 0 : Set only the TCDn_CSTS[START] bit specified in the SSRT
                                                        field                                                                     */
 #define DMA_STATSET_ASTATSET_1                 1U     /* 1 : Set all bits in TCDn_CSTS[START]                                      */


/*                                                   DMA STATSET NOOP [7..7]                                                    */
                                     /* DMA_SRTSET_NOOP                                                           */
#define  DMA_STATSET_NOOP_0                      0U     /* 0 : Normal operation                                                      */
#define  DMA_STATSET_NOOP_1                      1U     /* 1 : No operationU ignore the other bits in this register                  */


/*                                                            ESTSCLR                                                             */
/*                                                    DMA ESTSCLR NOOP [7..7]                                                     */
                                    /* DMA_ESTSCLR_NOOP                                                             */
#define  DMA_ESTSCLR_NOOP_0                        0U     /* 0 : Normal operation                                                      */
#define  DMA_ESTSCLR_NOOP_1                        1U     /* 1 : No operationU ignore the other bits in this register                  */


/*                                                          INTREQCLR                                                          */
/*                                                  DMA INTREQCLR NOOP [7..7]                                                  */
                                /* DMA_INTREQCLR_NOOP                                                        */
#define  DMA_INTREQCLR_NOOP_0                   0U     /* 0 : Normal operation                                                      */
#define  DMA_INTREQCLR_NOOP_1                   1U     /* 1 : No operationU ignore the other bits in this register                  */


/*                                                           INTREQ                                                            */
/*                                                DMA INTREQ INTREQSTS0 [0..0]                                                 */
                                   /* DMA_INTREQ_INTREQSTS0                                                     */
#define  DMA_INTREQ_INTREQSTS0_0                0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS0_1                1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                                DMA INTREQ INTREQSTS1 [1..1]                                                 */
                                    /* DMA_INTREQ_INTREQSTS1                                                     */
#define  DMA_INTREQ_INTREQSTS1_0                0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS1_1                1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                                DMA INTREQ INTREQSTS2 [2..2]                                                 */
                                    /* DMA_INTREQ_INTREQSTS2                                                     */
#define  DMA_INTREQ_INTREQSTS2_0                0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS2_1                1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                                DMA INTREQ INTREQSTS3 [3..3]                                                 */
                                    /* DMA_INTREQ_INTREQSTS3                                                     */
#define  DMA_INTREQ_INTREQSTS3_0                0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS3_1                1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                                DMA INTREQ INTREQSTS4 [4..4]                                                 */
                                    /* DMA_INTREQ_INTREQSTS4                                                     */
#define  DMA_INTREQ_INTREQSTS4_0                0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS4_1                1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                                DMA INTREQ INTREQSTS5 [5..5]                                                 */
                                     /* DMA_INTREQ_INTREQSTS5                                                     */
#define  DMA_INTREQ_INTREQSTS5_0                0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS5_1                1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                                DMA INTREQ INTREQSTS6 [6..6]                                                 */
                                    /* DMA_INTREQ_INTREQSTS6                                                     */
#define  DMA_INTREQ_INTREQSTS6_0                0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS6_1                1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                                DMA INTREQ INTREQSTS7 [7..7]                                                 */
                                     /* DMA_INTREQ_INTREQSTS7                                                     */
#define  DMA_INTREQ_INTREQSTS7_0                0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS7_1                1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                                DMA INTREQ INTREQSTS8 [8..8]                                                 */
                                    /* DMA_INTREQ_INTREQSTS8                                                     */
#define  DMA_INTREQ_INTREQSTS8_0                0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS8_1                1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                                DMA INTREQ INTREQSTS9 [9..9]                                                 */
                                    /* DMA_INTREQ_INTREQSTS9                                                     */
#define  DMA_INTREQ_INTREQSTS9_0                0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS9_1                1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                               DMA INTREQ INTREQSTS10 [10..10]                                               */
                                    /* DMA_INTREQ_INTREQSTS10                                                    */
#define  DMA_INTREQ_INTREQSTS10_0               0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS10_1               1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                               DMA INTREQ INTREQSTS11 [11..11]                                               */
                                    /* DMA_INTREQ_INTREQSTS11                                                    */
#define  DMA_INTREQ_INTREQSTS11_0               0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS11_1               1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                               DMA INTREQ INTREQSTS12 [12..12]                                               */
                                    /* DMA_INTREQ_INTREQSTS12                                                    */
#define  DMA_INTREQ_INTREQSTS12_0               0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS12_1               1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                               DMA INTREQ INTREQSTS13 [13..13]                                               */
                                    /* DMA_INTREQ_INTREQSTS13                                                    */
#define  DMA_INTREQ_INTREQSTS13_0               0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS13_1               1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                               DMA INTREQ INTREQSTS14 [14..14]                                               */
                                    /* DMA_INTREQ_INTREQSTS14                                                    */
#define  DMA_INTREQ_INTREQSTS14_0               0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS14_1               1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                               DMA INTREQ INTREQSTS15 [15..15]                                               */
                                     /* DMA_INTREQ_INTREQSTS15                                                    */
#define  DMA_INTREQ_INTREQSTS15_0               0U     /* 0 : The interrupt request for corresponding channel is cleared            */
#define  DMA_INTREQ_INTREQSTS15_1               1U     /* 1 : The interrupt request for corresponding channel is active             */


/*                                                            CHESTS                                                             */
/*                                                    DMA CHESTS EFLG0 [0..0]                                                    */
                                     /* DMA_CHESTS_EFLG0                                                            */
#define  DMA_CHESTS_EFLG0_0                       0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG0_1                       1U     /* 1 : An error in this channel has occurred                                 */


/*                                                    DMA CHESTS EFLG1 [1..1]                                                    */
                                     /* DMA_CHESTS_EFLG1                                                            */
#define  DMA_CHESTS_EFLG1_0                       0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG1_1                       1U     /* 1 : An error in this channel has occurred                                 */


/*                                                    DMA CHESTS EFLG2 [2..2]                                                    */
                                    /* DMA_CHESTS_EFLG2                                                            */
#define  DMA_CHESTS_EFLG2_0                       0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG2_1                       1U     /* 1 : An error in this channel has occurred                                 */


/*                                                    DMA CHESTS EFLG3 [3..3]                                                    */
                                    /* DMA_CHESTS_EFLG3                                                            */
#define  DMA_CHESTS_EFLG3_0                       0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG3_1                       1U     /* 1 : An error in this channel has occurred                                 */


/*                                                    DMA CHESTS EFLG4 [4..4]                                                    */
                                     /* DMA_CHESTS_EFLG4                                                            */
#define  DMA_CHESTS_EFLG4_0                       0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG4_1                       1U     /* 1 : An error in this channel has occurred                                 */


/*                                                    DMA CHESTS EFLG5 [5..5]                                                    */
                                     /* DMA_CHESTS_EFLG5                                                            */
#define  DMA_CHESTS_EFLG5_0                       0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG5_1                       1U     /* 1 : An error in this channel has occurred                                 */


/*                                                    DMA CHESTS EFLG6 [6..6]                                                    */
                                        /* DMA_CHESTS_EFLG6                                                            */
#define  DMA_CHESTS_EFLG6_0                       0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG6_1                       1U     /* 1 : An error in this channel has occurred                                 */


/*                                                    DMA CHESTS EFLG7 [7..7]                                                    */
                                         /* DMA_CHESTS_EFLG7                                                            */
#define  DMA_CHESTS_EFLG7_0                       0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG7_1                       1U     /* 1 : An error in this channel has occurred                                 */


/*                                                    DMA CHESTS EFLG8 [8..8]                                                    */
                                        /* DMA_CHESTS_EFLG8                                                            */
#define  DMA_CHESTS_EFLG8_0                       0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG8_1                       1U     /* 1 : An error in this channel has occurred                                 */


/*                                                    DMA CHESTS EFLG9 [9..9]                                                    */
                                        /* DMA_CHESTS_EFLG9                                                            */
#define  DMA_CHESTS_EFLG9_0                       0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG9_1                       1U     /* 1 : An error in this channel has occurred                                 */


/*                                                  DMA CHESTS EFLG10 [10..10]                                                   */
                                        /* DMA_CHESTS_EFLG10                                                           */
#define  DMA_CHESTS_EFLG10_0                      0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG10_1                      1U     /* 1 : An error in this channel has occurred                                 */


/*                                                  DMA CHESTS EFLG11 [11..11]                                                   */
                                        /* DMA_CHESTS_EFLG11                                                           */
#define  DMA_CHESTS_EFLG11_0                      0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG11_1                      1U     /* 1 : An error in this channel has occurred                                 */


/*                                                  DMA CHESTS EFLG12 [12..12]                                                   */
                                        /* DMA_CHESTS_EFLG12                                                           */
#define  DMA_CHESTS_EFLG12_0                      0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG12_1                      1U     /* 1 : An error in this channel has occurred                                 */


/*                                                  DMA CHESTS EFLG13 [13..13]                                                   */
                                        /* DMA_CHESTS_EFLG13                                                           */
#define  DMA_CHESTS_EFLG13_0                      0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG13_1                      1U     /* 1 : An error in this channel has occurred                                 */


/*                                                  DMA CHESTS EFLG14 [14..14]                                                   */
                                        /* DMA_CHESTS_EFLG14                                                           */
#define  DMA_CHESTS_EFLG14_0                      0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG14_1                      1U     /* 1 : An error in this channel has occurred                                 */


/*                                                  DMA CHESTS EFLG15 [15..15]                                                   */
                                        /* DMA_CHESTS_EFLG15                                                           */
#define  DMA_CHESTS_EFLG15_0                      0U     /* 0 : An error in this channel has not occurred                             */
#define  DMA_CHESTS_EFLG15_1                      1U     /* 1 : An error in this channel has occurred                                 */


/*                                                           HWREQSTS                                                           */
/*                                                 DMA HWREQSTS HREQSTS0 [0..0]                                                 */
                                        /* DMA_HWREQSTS_HREQSTS0                                                      */
#define  DMA_HWREQSTS_HREQSTS0_0                 0U     /* 0 : A hardware service request for channel 0 is not present               */
#define  DMA_HWREQSTS_HREQSTS0_1                 1U     /* 1 : A hardware service request for channel 0 is present                   */


/*                                                 DMA HWREQSTS HREQSTS1 [1..1]                                                 */
                                        /* DMA_HWREQSTS_HREQSTS1                                                      */
#define  DMA_HWREQSTS_HREQSTS1_0                 0U     /* 0 : A hardware service request for channel 1 is not present               */
#define  DMA_HWREQSTS_HREQSTS1_1                 1U     /* 1 : A hardware service request for channel 1 is present                   */


/*                                                 DMA HWREQSTS HREQSTS2 [2..2]                                                 */
                                        /* DMA_HWREQSTS_HREQSTS2                                                      */
#define  DMA_HWREQSTS_HREQSTS2_0                 0U     /* 0 : A hardware service request for channel 2 is not present               */
#define  DMA_HWREQSTS_HREQSTS2_1                 1U     /* 1 : A hardware service request for channel 2 is present                   */


/*                                                 DMA HWREQSTS HREQSTS3 [3..3]                                                 */
                                        /* DMA_HWREQSTS_HREQSTS3                                                      */
#define  DMA_HWREQSTS_HREQSTS3_0                 0U     /* 0 : A hardware service request for channel 3 is not present               */
#define  DMA_HWREQSTS_HREQSTS3_1                 1U     /* 1 : A hardware service request for channel 3 is present                   */


/*                                                 DMA HWREQSTS HREQSTS4 [4..4]                                                 */
                                        /* DMA_HWREQSTS_HREQSTS4                                                      */
#define  DMA_HWREQSTS_HREQSTS4_0                 0U     /* 0 : A hardware service request for channel 4 is not present               */
#define  DMA_HWREQSTS_HREQSTS4_1                 1U     /* 1 : A hardware service request for channel 4 is present                   */


/*                                                 DMA HWREQSTS HREQSTS5 [5..5]                                                 */
                                        /* DMA_HWREQSTS_HREQSTS5                                                      */
#define  DMA_HWREQSTS_HREQSTS5_0                 0U     /* 0 : A hardware service request for channel 5 is not present               */
#define  DMA_HWREQSTS_HREQSTS5_1                 1U     /* 1 : A hardware service request for channel 5 is present                   */


/*                                                 DMA HWREQSTS HREQSTS6 [6..6]                                                 */
                                        /* DMA_HWREQSTS_HREQSTS6                                                      */
#define  DMA_HWREQSTS_HREQSTS6_0                 0U     /* 0 : A hardware service request for channel 6 is not present               */
#define  DMA_HWREQSTS_HREQSTS6_1                 1U     /* 1 : A hardware service request for channel 6 is present                   */


/*                                                 DMA HWREQSTS HREQSTS7 [7..7]                                                 */
                                    /* DMA_HWREQSTS_HREQSTS7                                                      */
#define  DMA_HWREQSTS_HREQSTS7_0                 0U     /* 0 : A hardware service request for channel 7 is not present               */
#define  DMA_HWREQSTS_HREQSTS7_1                 1U     /* 1 : A hardware service request for channel 7 is present                   */


/*                                                 DMA HWREQSTS HREQSTS8 [8..8]                                                 */
                                    /* DMA_HWREQSTS_HREQSTS8                                                      */
#define  DMA_HWREQSTS_HREQSTS8_0                 0U     /* 0 : A hardware service request for channel 8 is not present               */
#define  DMA_HWREQSTS_HREQSTS8_1                 1U     /* 1 : A hardware service request for channel 8 is present                   */


/*                                                 DMA HWREQSTS HREQSTS9 [9..9]                                                 */
                                    /* DMA_HWREQSTS_HREQSTS9                                                      */
#define  DMA_HWREQSTS_HREQSTS9_0                 0U     /* 0 : A hardware service request for channel 9 is not present               */
#define  DMA_HWREQSTS_HREQSTS9_1                 1U     /* 1 : A hardware service request for channel 9 is present                   */


/*                                               DMA HWREQSTS HREQSTS10 [10..10]                                                */
                                   /* DMA_HWREQSTS_HREQSTS10                                                     */
#define  DMA_HWREQSTS_HREQSTS10_0                0U     /* 0 : A hardware service request for channel 10 is not present              */
#define  DMA_HWREQSTS_HREQSTS10_1                1U     /* 1 : A hardware service request for channel 10 is present                  */


/*                                               DMA HWREQSTS HREQSTS11 [11..11]                                                */
                                     /* DMA_HWREQSTS_HREQSTS11                                                     */
#define  DMA_HWREQSTS_HREQSTS11_0                0U     /* 0 : A hardware service request for channel 11 is not present              */
#define  DMA_HWREQSTS_HREQSTS11_1                1U     /* 1 : A hardware service request for channel 11 is present                  */


/*                                               DMA HWREQSTS HREQSTS12 [12..12]                                                */
                                 /* DMA_HWREQSTS_HREQSTS12                                                     */
#define  DMA_HWREQSTS_HREQSTS12_0                0U     /* 0 : A hardware service request for channel 12 is not present              */
#define  DMA_HWREQSTS_HREQSTS12_1                1U     /* 1 : A hardware service request for channel 12 is present                  */


/*                                               DMA HWREQSTS HREQSTS13 [13..13]                                                */
                                     /* DMA_HWREQSTS_HREQSTS13                                                     */
#define  DMA_HWREQSTS_HREQSTS13_0                0U     /* 0 : A hardware service request for channel 13 is not present              */
#define  DMA_HWREQSTS_HREQSTS13_1                1U     /* 1 : A hardware service request for channel 13 is present                  */


/*                                               DMA HWREQSTS HREQSTS14 [14..14]                                                */
                                    /* DMA_HWREQSTS_HREQSTS14                                                     */
#define  DMA_HWREQSTS_HREQSTS14_0                0U     /* 0 : A hardware service request for channel 14 is not present              */
#define  DMA_HWREQSTS_HREQSTS14_1                1U     /* 1 : A hardware service request for channel 14 is present                  */


/*                                               DMA HWREQSTS HREQSTS15 [15..15]                                                */
                                    /* DMA_HWREQSTS_HREQSTS15                                                     */
#define  DMA_HWREQSTS_HREQSTS15_0                0U     /* 0 : A hardware service request for channel 15 is not present              */
#define  DMA_HWREQSTS_HREQSTS15_1                1U     /* 1 : A hardware service request for channel 15 is present                  */


/*                                                           AREQSEN                                                            */
/*                                                 DMA AREQSEN AREQSEN0 [0..0]                                                  */
                                    /* DMA_AREQSEN_AREQSEN0                                                       */
#define  DMA_AREQSEN_AREQSEN0_0                  0U     /* 0 : Disable asynchronous DMA request for channel 0.                       */
#define  DMA_AREQSEN_AREQSEN0_1                  1U     /* 1 : Enable asynchronous DMA request for channel 0.                        */


/*                                                 DMA AREQSEN AREQSEN1 [1..1]                                                  */
                                     /* DMA_AREQSEN_AREQSEN1                                                       */
#define  DMA_AREQSEN_AREQSEN1_0                  0U     /* 0 : Disable asynchronous DMA request for channel 1                        */
#define  DMA_AREQSEN_AREQSEN1_1                  1U     /* 1 : Enable asynchronous DMA request for channel 1.                        */


/*                                                 DMA AREQSEN AREQSEN2 [2..2]                                                  */
                                    /* DMA_AREQSEN_AREQSEN2                                                       */
#define  DMA_AREQSEN_AREQSEN2_0                  0U     /* 0 : Disable asynchronous DMA request for channel 2.                       */
#define  DMA_AREQSEN_AREQSEN2_1                  1U     /* 1 : Enable asynchronous DMA request for channel 2.                        */


/*                                                 DMA AREQSEN AREQSEN3 [3..3]                                                  */
                            /* DMA_AREQSEN_AREQSEN3                                                       */
#define  DMA_AREQSEN_AREQSEN3_0                  0U     /* 0 : Disable asynchronous DMA request for channel 3.                       */
#define  DMA_AREQSEN_AREQSEN3_1                  1U     /* 1 : Enable asynchronous DMA request for channel 3.                        */


/*                                                 DMA AREQSEN AREQSEN4 [4..4]                                                  */
                              /* DMA_AREQSEN_AREQSEN4                                                       */
#define  DMA_AREQSEN_AREQSEN4_0                  0U     /* 0 : Disable asynchronous DMA request for channel 4.                       */
#define  DMA_AREQSEN_AREQSEN4_1                  1U     /* 1 : Enable asynchronous DMA request for channel 4.                        */


/*                                                 DMA AREQSEN AREQSEN5 [5..5]                                                  */
                              /* DMA_AREQSEN_AREQSEN5                                                       */
#define  DMA_AREQSEN_AREQSEN5_0                  0U     /* 0 : Disable asynchronous DMA request for channel 5.                       */
#define  DMA_AREQSEN_AREQSEN5_1                  1U     /* 1 : Enable asynchronous DMA request for channel 5.                        */


/*                                                 DMA AREQSEN AREQSEN6 [6..6]                                                  */
                            /* DMA_AREQSEN_AREQSEN6                                                       */
#define  DMA_AREQSEN_AREQSEN6_0                  0U     /* 0 : Disable asynchronous DMA request for channel 6.                       */
#define  DMA_AREQSEN_AREQSEN6_1                  1U     /* 1 : Enable asynchronous DMA request for channel 6.                        */


/*                                                 DMA AREQSEN AREQSEN7 [7..7]                                                  */
                            /* DMA_AREQSEN_AREQSEN7                                                       */
#define  DMA_AREQSEN_AREQSEN7_0                  0U     /* 0 : Disable asynchronous DMA request for channel 7.                       */
#define  DMA_AREQSEN_AREQSEN7_1                  1U     /* 1 : Enable asynchronous DMA request for channel 7.                        */


/*                                                 DMA AREQSEN AREQSEN8 [8..8]                                                  */
                            /* DMA_AREQSEN_AREQSEN8                                                       */
#define  DMA_AREQSEN_AREQSEN8_0                  0U     /* 0 : Disable asynchronous DMA request for channel 8.                       */
#define  DMA_AREQSEN_AREQSEN8_1                  1U     /* 1 : Enable asynchronous DMA request for channel 8.                        */


/*                                                 DMA AREQSEN AREQSEN9 [9..9]                                                  */
                                   /* DMA_AREQSEN_AREQSEN9                                                       */
#define  DMA_AREQSEN_AREQSEN9_0                  0U     /* 0 : Disable asynchronous DMA request for channel 9.                       */
#define  DMA_AREQSEN_AREQSEN9_1                  1U     /* 1 : Enable asynchronous DMA request for channel 9.                        */


/*                                                DMA AREQSEN AREQSEN10 [10..10]                                                */
                                 /* DMA_AREQSEN_AREQSEN10                                                      */
#define  DMA_AREQSEN_AREQSEN10_0                 0U     /* 0 : Disable asynchronous DMA request for channel 10.                      */
#define  DMA_AREQSEN_AREQSEN10_1                 1U     /* 1 : Enable asynchronous DMA request for channel 10.                       */


/*                                                DMA AREQSEN AREQSEN11 [11..11]                                                */
                                /* DMA_AREQSEN_AREQSEN11                                                      */
#define  DMA_AREQSEN_AREQSEN11_0                 0U     /* 0 : Disable asynchronous DMA request for channel 11.                      */
#define  DMA_AREQSEN_AREQSEN11_1                 1U     /* 1 : Enable asynchronous DMA request for channel 11.                       */


/*                                                DMA AREQSEN AREQSEN12 [12..12]                                                */
                                   /* DMA_AREQSEN_AREQSEN12                                                      */
#define  DMA_AREQSEN_AREQSEN12_0                 0U     /* 0 : Disable asynchronous DMA request for channel 12.                      */
#define  DMA_AREQSEN_AREQSEN12_1                 1U     /* 1 : Enable asynchronous DMA request for channel 12.                       */


/*                                                DMA AREQSEN AREQSEN13 [13..13]                                                */
                              /* DMA_AREQSEN_AREQSEN13                                                      */
#define  DMA_AREQSEN_AREQSEN13_0                 0U     /* 0 : Disable asynchronous DMA request for channel 13.                      */
#define  DMA_AREQSEN_AREQSEN13_1                 1U     /* 1 : Enable asynchronous DMA request for channel 13.                       */


/*                                                DMA AREQSEN AREQSEN14 [14..14]                                                */
                               /* DMA_AREQSEN_AREQSEN14                                                      */
#define  DMA_AREQSEN_AREQSEN14_0                 0U     /* 0 : Disable asynchronous DMA request for channel 14.                      */
#define  DMA_AREQSEN_AREQSEN14_1                 1U     /* 1 : Enable asynchronous DMA request for channel 14.                       */


/*                                               DMA EAREQS AREQSEN15 [15..15]                                                */
                                    /* DMA_EAREQS_EAREQSEN15                                                     */
#define  DMA_EAREQS_EAREQSEN15_0                0U     /* 0 : Disable asynchronous DMA request for channel 15.                      */
#define  DMA_EAREQS_EAREQSEN15_1                1U     /* 1 : Enable asynchronous DMA request for channel 15.                       */


/*                                                           CHPRI3                                                            */
/*                                                 DMA CHPRI3 PLPRICHD [6..6]                                                  */
                                 /* DMA_CHPRI3_PLPRICHD                                                       */
#define  DMA_CHPRI3_PLPRICHD_0                  0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI3_PLPRICHD_1                  1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI3 BPHPRICHEN [7..7]                                                 */
                                      /* DMA_CHPRI3_BPHPRICHEN                                                     */
#define  DMA_CHPRI3_BPHPRICHEN_0                0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                      service request.                                                          */
#define  DMA_CHPRI3_BPHPRICHEN_1                1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                    of a higher priority channel.                                             */


/*                                                           CHPRI2                                                            */
/*                                                 DMA CHPRI2 PLPRICHD [6..6]                                                  */
                                    /* DMA_CHPRI2_PLPRICHD                                                       */
#define  DMA_CHPRI2_PLPRICHD_0                  0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI2_PLPRICHD_1                  1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI2 BPHPRICHEN [7..7]                                                 */
    /* DMA_CHPRI2_BPHPRICHEN                                                     */
 #define DMA_CHPRI2_BPHPRICHEN_0                0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                     service request.                                                          */
 #define DMA_CHPRI2_BPHPRICHEN_1                1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                     of a higher priority channel.                                             */


/*                                                           CHPRI1                                                            */
/*                                                 DMA CHPRI1 PLPRICHD [6..6]                                                  */
                                    /* DMA_CHPRI1_PLPRICHD                                                       */
#define  DMA_CHPRI1_PLPRICHD_0                  0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI1_PLPRICHD_1                  1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI1 BPHPRICHEN [7..7]                                                 */
                                    /* DMA_CHPRI1_BPHPRICHEN                                                     */
 #define DMA_CHPRI1_BPHPRICHEN_0                0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                      service request.                                                          */
 #define DMA_CHPRI1_BPHPRICHEN_1                1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                       of a higher priority channel.                                             */


/*                                                           CHPRI0                                                            */
/*                                                 DMA CHPRI0 PLPRICHD [6..6]                                                  */
                                    /* DMA_CHPRI0_PLPRICHD                                                       */
#define  DMA_CHPRI0_PLPRICHD_0                  0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI0_PLPRICHD_1                  1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI0 BPHPRICHEN [7..7]                                                 */
                                   /* DMA_CHPRI0_BPHPRICHEN                                                     */
#define  DMA_CHPRI0_BPHPRICHEN_0                0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                        service request.                                                          */
#define  DMA_CHPRI0_BPHPRICHEN_1                1U     /* 1 : Channel n can be temporarily suspended by the service request
                                            of a higher priority channel.                                             */


/*                                                           CHPRI7                                                            */
/*                                                 DMA CHPRI7 PLPRICHD [6..6]                                                  */
                             /* DMA_CHPRI7_PLPRICHD                                                       */
#define  DMA_CHPRI7_PLPRICHD_0                  0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI7_PLPRICHD_1                  1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI7 BPHPRICHEN [7..7]                                                 */
                              /* DMA_CHPRI7_BPHPRICHEN                                                     */
#define  DMA_CHPRI7_BPHPRICHEN_0                0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                    service request.                                                          */
#define  DMA_CHPRI7_BPHPRICHEN_1                1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                       of a higher priority channel.                                             */


/*                                                           CHPRI6                                                            */
/*                                                 DMA CHPRI6 PLPRICHD [6..6]                                                  */
                                     /* DMA_CHPRI6_PLPRICHD                                                       */
#define  DMA_CHPRI6_PLPRICHD_0                  0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI6_PLPRICHD_1                  1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI6 BPHPRICHEN [7..7]                                                 */
                                     /* DMA_CHPRI6_BPHPRICHEN                                                     */
 #define DMA_CHPRI6_BPHPRICHEN_0                0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                 service request.                                                          */
 #define DMA_CHPRI6_BPHPRICHEN_1                1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                   of a higher priority channel.                                             */


/*                                                           CHPRI5                                                            */
/*                                                 DMA CHPRI5 PLPRICHD [6..6]                                                  */
                                     /* DMA_CHPRI5_PLPRICHD                                                       */
 #define DMA_CHPRI5_PLPRICHD_0                  0U     /* 0 : Channel n can suspend a lower priority channel.                       */
 #define DMA_CHPRI5_PLPRICHD_1                  1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI5 BPHPRICHEN [7..7]                                                 */
                                  /* DMA_CHPRI5_BPHPRICHEN                                                     */
#define  DMA_CHPRI5_BPHPRICHEN_0                0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                   service request.                                                          */
#define  DMA_CHPRI5_BPHPRICHEN_1                1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                       of a higher priority channel.                                             */


/*                                                           CHPRI4                                                            */
/*                                                 DMA CHPRI4 PLPRICHD [6..6]                                                  */
                                   /* DMA_CHPRI4_PLPRICHD                                                       */
#define  DMA_CHPRI4_PLPRICHD_0                  0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI4_PLPRICHD_1                  1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI4 BPHPRICHEN [7..7]                                                 */
                                    /* DMA_CHPRI4_BPHPRICHEN                                                     */
#define  DMA_CHPRI4_BPHPRICHEN_0                0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                       service request.                                                          */
#define  DMA_CHPRI4_BPHPRICHEN_1                1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                      of a higher priority channel.                                             */


/*                                                           CHPRI11                                                           */
/*                                                 DMA CHPRI11 PLPRICHD [6..6]                                                 */
                                      /* DMA_CHPRI11_PLPRICHD                                                      */
#define  DMA_CHPRI11_PLPRICHD_0                 0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI11_PLPRICHD_1                 1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI11 BPHPRICHEN [7..7]                                                */
                                     /* DMA_CHPRI11_BPHPRICHEN                                                    */
#define  DMA_CHPRI11_BPHPRICHEN_0               0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                    service request.                                                          */
#define  DMA_CHPRI11_BPHPRICHEN_1               1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                    of a higher priority channel.                                             */


/*                                                           CHPRI10                                                           */
/*                                                 DMA CHPRI10 PLPRICHD [6..6]                                                 */
                                      /* DMA_CHPRI10_PLPRICHD                                                      */
#define  DMA_CHPRI10_PLPRICHD_0                 0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI10_PLPRICHD_1                 1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                        priority.                                                                 */


/*                                                DMA CHPRI10 BPHPRICHEN [7..7]                                                */
                                      /* DMA_CHPRI10_BPHPRICHEN                                                    */
#define  DMA_CHPRI10_BPHPRICHEN_0               0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                         service request.                                                          */
#define  DMA_CHPRI10_BPHPRICHEN_1               1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                       of a higher priority channel.                                             */


/*                                                           CHPRI9                                                            */
/*                                                 DMA CHPRI9 PLPRICHD [6..6]                                                  */
                                  /* DMA_CHPRI9_PLPRICHD                                                       */
#define  DMA_CHPRI9_PLPRICHD_0                  0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI9_PLPRICHD_1                  1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                        priority.                                                                 */


/*                                                DMA CHPRI9 BPHPRICHEN [7..7]                                                 */
                                     /* DMA_CHPRI9_BPHPRICHEN                                                     */
#define  DMA_CHPRI9_BPHPRICHEN_0                0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                        service request.                                                          */
#define  DMA_CHPRI9_BPHPRICHEN_1                1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                        of a higher priority channel.                                             */


/*                                                           CHPRI8                                                            */
/*                                                 DMA CHPRI8 PLPRICHD [6..6]                                                  */
                                     /* DMA_CHPRI8_PLPRICHD                                                       */
#define  DMA_CHPRI8_PLPRICHD_0                  0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI8_PLPRICHD_1                  1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI8 BPHPRICHEN [7..7]                                                 */
                             /* DMA_CHPRI8_BPHPRICHEN                                                     */
#define  DMA_CHPRI8_BPHPRICHEN_0                0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                         service request.                                                          */
#define  DMA_CHPRI8_BPHPRICHEN_1                1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                        of a higher priority channel.                                             */


/*                                                           CHPRI15                                                           */
/*                                                 DMA CHPRI15 PLPRICHD [6..6]                                                 */
                              /* DMA_CHPRI15_PLPRICHD                                                      */
#define  DMA_CHPRI15_PLPRICHD_0                 0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI15_PLPRICHD_1                 1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI15 BPHPRICHEN [7..7]                                                */
                               /* DMA_CHPRI15_BPHPRICHEN                                                    */
#define  DMA_CHPRI15_BPHPRICHEN_0               0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                        service request.                                                          */
#define  DMA_CHPRI15_BPHPRICHEN_1               1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                      of a higher priority channel.                                             */


/*                                                           CHPRI14                                                           */
/*                                                 DMA CHPRI14 PLPRICHD [6..6]                                                 */
                                    /* DMA_CHPRI14_PLPRICHD                                                      */
#define  DMA_CHPRI14_PLPRICHD_0                 0U     /* 0 : Channel n can suspend a lower priority channel.                       */
#define  DMA_CHPRI14_PLPRICHD_1                 1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI14 BPHPRICHEN [7..7]                                                */
                                /* DMA_CHPRI14_BPHPRICHEN                                                    */
 #define DMA_CHPRI14_BPHPRICHEN_0               0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                               service request.                                                          */
 #define DMA_CHPRI14_BPHPRICHEN_1               1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                       of a higher priority channel.                                             */


/*                                                           CHPRI13                                                           */
/*                                                 DMA CHPRI13 PLPRICHD [6..6]                                                 */
                                   /* DMA_CHPRI13_PLPRICHD                                                      */
 #define DMA_CHPRI13_PLPRICHD_0                 0U     /* 0 : Channel n can suspend a lower priority channel.                       */
 #define DMA_CHPRI13_PLPRICHD_1                 1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                         priority.                                                                 */


/*                                                DMA CHPRI13 BPHPRICHEN [7..7]                                                */
                                  /* DMA_CHPRI13_BPHPRICHEN                                                    */
#define  DMA_CHPRI13_BPHPRICHEN_0               0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                        service request.                                                          */
#define  DMA_CHPRI13_BPHPRICHEN_1               1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                        of a higher priority channel.                                             */


/*                                                           CHPRI12                                                           */
/*                                                 DMA CHPRI12 PLPRICHD [6..6]                                                 */
                                   /* DMA_CHPRI12_PLPRICHD                                                      */
 #define DMA_CHPRI12_PLPRICHD_0                 0U     /* 0 : Channel n can suspend a lower priority channel.                       */
 #define DMA_CHPRI12_PLPRICHD_1                 1U     /* 1 : Channel n cannot suspend any channelU regardless of channel
                                                     priority.                                                                 */


/*                                                DMA CHPRI12 BPHPRICHEN [7..7]                                                */
                                /* DMA_CHPRI12_BPHPRICHEN                                                    */
 #define DMA_CHPRI12_BPHPRICHEN_0               0U     /* 0 : Channel n cannot be suspended by a higher priority channels
                                                        service request.                                                          */
 #define DMA_CHPRI12_BPHPRICHEN_1               1U     /* 1 : Channel n can be temporarily suspended by the service request
                                                        of a higher priority channel.                                             */


/*                                                         TCD_SADDR                                                          */
/*                                                        TCD_SADDROF                                                         */
/*                                                          TCD_TATT                                                          */
/*                                                DMA TCD_TATT STSIZE [8..10]                                                 */
                                      /* DMA_TCD_TATT_STSIZE                                                      */
#define  DMA_TCD_TATT_STSIZE_0                 0U     /* 0 : 8-bit                                                                 */
#define  DMA_TCD_TATT_STSIZE_1                 1U     /* 1 : 16-bit                                                                */
#define  DMA_TCD_TATT_STSIZE_10                2U     /* 10 : 32-bit                                                               */

/*                                               DMA TCD_TATT SADDRMV [11..15]                                                */
                                      /* DMA_TCD_TATT_SADDRMV                                                     */
#define  DMA_TCD_TATT_SADDRMV_0                0U     /* 0 : Source address modulo feature is disabled                             */


/*                                                     TCD_MINBCNT_MINLMD_DMA                                                     */
/*                                                   TCD_SMLOF_MINLMENOFD_DMA                                                   */
/*                                       DMA TCD_SMLOF_MINLMENOFD_DMA DMINLOFEN [30..30]                                        */
                                     /* DMA_TCD_SMLOF_MINLMENOFD_DMA_DMINLOFEN                                     */
#define  DMA_TCD_SMLOF_MINLMENOFD_DMA_DMINLOFEN_0   0U  /* 0 : The minor loop offset is not applied to the DADDR                     */
#define  DMA_TCD_SMLOF_MINLMENOFD_DMA_DMINLOFEN_1   1U  /* 1 : The minor loop offset is applied to the DADDR                         */


/*                                       DMA TCD_SMLOF_MINLMENOFD_DMA SMINLOFEN [31..31]                                        */
                               /* DMA_TCD_SMLOF_MINLMENOFD_DMA_SMINLOFEN                                     */
#define  DMA_TCD_SMLOF_MINLMENOFD_DMA_SMINLOFEN_0   0U  /* 0 : The minor loop offset is not applied to the SADDR                     */
#define  DMA_TCD_SMLOF_MINLMENOFD_DMA_SMINLOFEN_1   1U  /* 1 : The minor loop offset is applied to the SADDR                         */


/*                                                   TCD_SMINLOF_MINLMOFEN_DMA                                                    */
/*                                        DMA TCD_SMINLOF_MINLMOFEN_DMA DMINLOFEN [30..30]                                        */
    /* DMA_TCD_SMINLOF_MINLMOFEN_DMA_DMINLOFEN                                      */
#define  DMA_TCD_SMINLOF_MINLMOFEN_DMA_DMINLOFEN_0   0U   /* 0 : The minor loop offset is not applied to the DADDR                     */
#define  DMA_TCD_SMINLOF_MINLMOFEN_DMA_DMINLOFEN_1   1U   /* 1 : The minor loop offset is applied to the DADDR                         */


/*                                        DMA TCD_SMINLOF_MINLMOFEN_DMA SMINLOFEN [31..31]                                        */
                  /* DMA_TCD_SMINLOF_MINLMOFEN_DMA_SMINLOFEN                                      */
#define  DMA_TCD_SMINLOF_MINLMOFEN_DMA_SMINLOFEN_0   0U   /* 0 : The minor loop offset is not applied to the SADDR                     */
#define  DMA_TCD_SMINLOF_MINLMOFEN_DMA_SMINLOFEN_1   1U   /* 1 : The minor loop offset is applied to the SADDR                         */


/*                                                        TCD_SADDRAV                                                         */
/*                                                         TCD_DADDR                                                          */
/*                                                        TCD_DADDRSOF                                                        */
/*                                                   TCD_CMAJICNT_LINKD_DMA                                                   */
/*                                       DMA TCD_CMAJICNT_LINKD_DMA MINLINKEN [15..15]                                        */
                                  /* DMA_TCD_CMAJICNT_LINKD_DMA_MINLINKEN                                     */
 #define DMA_TCD_CMAJICNT_LINKD_DMA_LINKEN_0   0U  /* 0 : The channel-to-channel linking is disabled                            */
 #define DMA_TCD_CMAJICNT_LINKD_DMA_LINKEN_1   1U  /* 1 : The channel-to-channel linking is enabled                             */


/*                                                 TCD_CMAJICNT_CHLINKEN_DMA                                                  */
/*                                      DMA TCD_CMAJICNT_CHLINKEN_DMA MINLINKEN [15..15]                                      */
                                  /* DMA_TCD_CMAJICNT_CHLINKEN_DMA_MINLINKEN                                  */
#define  DMA_TCD_CMAJICNT_LINKEN_DMA_LINKEN_0   0U/* 0 : The channel-to-channel linking is disabled                           */
#define  DMA_TCD_CMAJICNT_LINKEN_DMA_LINKEN_1   1U/* 1 : The channel-to-channel linking is enabled                            */


/*                                                       TCD_DADDRAVSGA                                                       */
/*                                                          TCD_CSTS                                                          */
/*                                                 DMA TCD_CSTS START [0..0]                                                  */
                                  /* DMA_TCD_CSTS_START                                                       */
#define  DMA_TCD_CSTS_START_0                  0U     /* 0 : The channel is not explicitly started.                                */
#define  DMA_TCD_CSTS_START_1                  1U     /* 1 : The channel is explicitly started via a software initiated
                                                     service request.                                                          */


/*                                                DMA TCD_CSTS MAJICMPIEN [1..1]                                                */
                                  /* DMA_TCD_CSTS_MAJICMPIEN                                                    */
#define  DMA_TCD_CSTS_MAJICMPIEN_0               0U     /* 0 : The end-of-major loop interrupt is disabled.                          */
#define  DMA_TCD_CSTS_MAJICMPIEN_1               1U     /* 1 : The end-of-major loop interrupt is enabled.                           */


/*                                               DMA TCD_CSTS MAJIHCMPIEN [2..2]                                                */
                                  /* DMA_TCD_CSTS_MAJIHCMPIEN                                                   */
#define  DMA_TCD_CSTS_MAJIHCMPIEN_0              0U     /* 0 : The half-point interrupt is disabled.                                 */
#define  DMA_TCD_CSTS_MAJIHCMPIEN_1              1U     /* 1 : The half-point interrupt is enabled.                                  */

/*                                               DMA TCD_CSTS DMAREQD [3..3]                                                */
                                  /* DMA_TCD_CSTS_DMAREQD                                                   */
#define  DMA_TCD_CSTS_DMAREQD_0              0U     /* 0 : The channel's ERQ bit is not affected.                                 */
#define  DMA_TCD_CSTS_DMAREQD_1              1U     /* 1 : The channel's ERQ bit is cleared when the major loop is complete.                                  */

/*                                                 DMA TCD_CSTS SGFEN [4..4]                                                  */
                                      /* DMA_TCD_CSTS_SGFEN                                                       */
#define  DMA_TCD_CSTS_SGFEN_0                  0U     /* 0 : The current channels TCD is normal format.                            */
#define  DMA_TCD_CSTS_SGFEN_1                  1U     /* 1 : The current channels TCD specifies a scatter gather format.
                                                     The DLASTSGA field provides a memory pointer to the next
                                                     TCD to be loaded into this channel after the major loop
                                                     completes its execution.                                                  */

/*                                               DMA TCD_CSTS MAJILINKEN [5..5]                                                */
                                    /* DMA_TCD_CSTS_MAJILINKEN                                                   */
#define  DMA_TCD_CSTS_MAJILINKEN_0              0U     /* 0 : The channel-to-channel linking is disabled.                           */
#define  DMA_TCD_CSTS_MAJILINKEN_1              1U     /* 1 : The channel-to-channel linking is enabled.                            */

/*                                               DMA TCD_CSTS MAJLCMPFLG [7..7]                                                */
                                    /* DMA_TCD_CSTS_MAJLCMPFLG                                                   */
#define  DMA_TCD_CSTS_MAJLCMPFLG_0              0U     /* 0 : Indicates the DMA has not completed the major loop.
                                                       This bit must be cleared to write the MAJILINKEN or SGFEN bits.*/
#define  DMA_TCD_CSTS_MAJLCMPFLG_1              1U     /* 1 : Indicates the DMA has completed the major loop.                            */

/*                                                DMA TCD_CSTS BWCTRL [14..15]                                                */
                                     /* DMA_TCD_CSTS_BWCTRL                                                      */
#define  DMA_TCD_CSTS_BWCTRL_0                 0U     /* 0 : No eDMA engine stalls.                                                */
#define  DMA_TCD_CSTS_BWCTRL_10                2U     /* 10 : eDMA engine stalls for 4 cycles after each R/W.                      */
#define  DMA_TCD_CSTS_BWCTRL_11                3U     /* 11 : eDMA engine stalls for 8 cycles after each R/W.                      */


/*                                                 TCD_MAJICNTSTAT_LINKD_DMA                                                  */
/*                                       DMA TCD_MAJICNTSTAT_LINKD_DMA LINKEN [15..15]                                        */
                                  /* DMA_TCD_MAJICNTSTAT_LINKD_DMA_LINKEN                                     */
#define  DMA_TCD_MAJICNTSTAT_LINKD_DMA_LINKEN_0   0U  /* 0 : The channel-to-channel linking is disabled                            */
#define  DMA_TCD_MAJICNTSTAT_LINKD_DMA_LINKEN_1   1U  /* 1 : The channel-to-channel linking is enabled                             */


/*                                                 TCD_MAJICNTSTAT_LINKEN_DMA                                                 */
/*                                     DMA TCD_MAJICNTSTAT_LINKEN_DMA LINKEN [15..15]                                      */
                                    /* DMA_TCD_MAJICNTSTAT_LINKEN_DMA_LINKEN                                 */
#define  DMA_TCD_MAJICNTSTAT_LINKEN_DMA_LINKEN_0   0U/* 0 : The channel-to-channel linking is disabled                          */
#define  DMA_TCD_MAJICNTSTAT_LINKEN_DMA_LINKEN_1   1U/* 1 : The channel-to-channel linking is enabled                           */


/*                                                                                                                             */
/*                                                             MPU                                                              */
/*                                                                                                                             */

/*                                                            CESTS                                                            */
/*                                                    MPU CESTS MPUEN [0..0]                                                     */
                                 /* MPU_CESTS_MPUEN                                                             */
#define  MPU_CESTS_MPUEN_0                        0U     /* 0 : MPU is disabled. All accesses from all bus masters are allowed.       */
#define  MPU_CESTS_MPUEN_1                        1U     /* 1 : MPU is enabled                                                        */


/*                                                   MPU CESTS RDINUM [8..11]                                                   */
                                 /* MPU_CESTS_RDINUM                                                           */
#define  MPU_CESTS_RDINUM_0000                   0U     /* 0000 : 8 region descriptors                                               */
#define  MPU_CESTS_RDINUM_0001                   1U     /* 0001 : 12 region descriptors                                              */
#define  MPU_CESTS_RDINUM_0010                   2U     /* 0010 : 16 region descriptors                                              */


/*                                                  MPU CESTS SPEFLG3 [28..28]                                                  */
                                 /* MPU_CESTS_SPEFLG3                                                          */
#define  MPU_CESTS_SPEFLG3_0                     0U     /* 0 : No error has occurred for slave port 3.                               */
#define  MPU_CESTS_SPEFLG3_1                     1U     /* 1 : An error has occurred for slave port 3.                               */


/*                                                  MPU CESTS SPEFLG2 [29..29]                                                  */
                                 /* MPU_CESTS_SPEFLG2                                                          */
#define  MPU_CESTS_SPEFLG2_0                     0U     /* 0 : No error has occurred for slave port 2.                               */
#define  MPU_CESTS_SPEFLG2_1                     1U     /* 1 : An error has occurred for slave port 2.                               */


/*                                                  MPU CESTS SPEFLG1 [30..30]                                                  */
                                 /* MPU_CESTS_SPEFLG1                                                          */
#define  MPU_CESTS_SPEFLG1_0                     0U     /* 0 : No error has occurred for slave port 1.                               */
#define  MPU_CESTS_SPEFLG1_1                     1U     /* 1 : An error has occurred for slave port 1.                               */


/*                                                  MPU CESTS SPEFLG0 [31..31]                                                  */
                                 /* MPU_CESTS_SPEFLG0                                                          */
#define  MPU_CESTS_SPEFLG0_0                     0U     /* 0 : No error has occurred for slave port 0.                               */
#define  MPU_CESTS_SPEFLG0_1                     1U     /* 1 : An error has occurred for slave port 0.                               */


/*                                                           EADDR0                                                            */
/*                                                          EDETAIL0                                                           */
/*                                                   MPU EDETAIL0 RWE [0..0]                                                    */
                                 /* MPU_EDETAIL0_RWE                                                           */
#define  MPU_EDETAIL0_RWE_0                      0U     /* 0 : Read                                                                  */
#define  MPU_EDETAIL0_RWE_1                      1U     /* 1 : Write                                                                 */


/*                                                  MPU EDETAIL0 AINFOE [1..3]                                                  */
                                 /* MPU_EDETAIL0_AINFOE                                                        */
#define  MPU_EDETAIL0_AINFOE_000                 0U     /* 000 : User modeU instruction access                                       */
#define  MPU_EDETAIL0_AINFOE_001                 1U     /* 001 : User modeU data access                                              */
#define  MPU_EDETAIL0_AINFOE_010                 2U     /* 010 : Supervisor modeU instruction access                                 */
#define  MPU_EDETAIL0_AINFOE_011                 3U     /* 011 : Supervisor modeU data access                                        */


/*                                                           EADDR1                                                            */
/*                                                          EDETAIL1                                                           */
/*                                                   MPU EDETAIL1 RWE [0..0]                                                    */
                                 /* MPU_EDETAIL1_RWE                                                           */
 #define MPU_EDETAIL1_RWE_0                      0U     /* 0 : Read                                                                  */
 #define MPU_EDETAIL1_RWE_1                      1U     /* 1 : Write                                                                 */


/*                                                  MPU EDETAIL1 AINFOE [1..3]                                                  */
                                 /* MPU_EDETAIL1_AINFOE                                                        */
 #define MPU_EDETAIL1_AINFOE_000                 0U     /* 000 : User modeU instruction access                                       */
 #define MPU_EDETAIL1_AINFOE_001                 1U     /* 001 : User modeU data access                                              */
 #define MPU_EDETAIL1_AINFOE_010                 2U     /* 010 : Supervisor modeU instruction access                                 */
 #define MPU_EDETAIL1_AINFOE_011                 3U     /* 011 : Supervisor modeU data access                                        */


/*                                                           EADDR2                                                            */
/*                                                          EDETAIL2                                                           */
/*                                                   MPU EDETAIL2 RWE [0..0]                                                    */
                                 /* MPU_EDETAIL2_RWE                                                           */
#define  MPU_EDETAIL2_RWE_0                      0U     /* 0 : Read                                                                  */
#define  MPU_EDETAIL2_RWE_1                      1U     /* 1 : Write                                                                 */


/*                                                  MPU EDETAIL2 AINFOE [1..3]                                                  */
                                 /* MPU_EDETAIL2_AINFOE                                                        */
#define  MPU_EDETAIL2_AINFOE_000                 0U     /* 000 : User modeU instruction access                                       */
#define  MPU_EDETAIL2_AINFOE_001                 1U     /* 001 : User modeU data access                                              */
#define  MPU_EDETAIL2_AINFOE_010                 2U     /* 010 : Supervisor modeU instruction access                                 */
#define  MPU_EDETAIL2_AINFOE_011                 3U     /* 011 : Supervisor modeU data access                                        */


/*                                                           EADDR3                                                            */
/*                                                          EDETAIL3                                                           */
/*                                                   MPU EDETAIL3 RWE [0..0]                                                    */
                                 /* MPU_EDETAIL3_RWE                                                           */
 #define MPU_EDETAIL3_RWE_0                      0U     /* 0 : Read                                                                  */
 #define MPU_EDETAIL3_RWE_1                      1U     /* 1 : Write                                                                 */


/*                                                  MPU EDETAIL3 AINFOE [1..3]                                                  */
                                 /* MPU_EDETAIL3_AINFOE                                                        */
#define  MPU_EDETAIL3_AINFOE_000                 0U     /* 000 : User modeU instruction access                                       */
#define  MPU_EDETAIL3_AINFOE_001                 1U     /* 001 : User modeU data access                                              */
#define  MPU_EDETAIL3_AINFOE_010                 2U     /* 010 : Supervisor modeU instruction access                                 */
#define  MPU_EDETAIL3_AINFOE_011                 3U     /* 011 : Supervisor modeU data access                                        */


/*                                                         REGD0_WORD0                                                         */
/*                                                         REGD0_WORD1                                                         */
/*                                                         REGD0_WORD2                                                         */
/*                                               MPU REGD0_WORD2 SMCTRLM0 [3..4]                                                */
                                 /* MPU_REGD0_WORD2_SMCTRLM0                                                   */
#define  MPU_REGD0_WORD2_SMCTRLM0_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD0_WORD2_SMCTRLM0_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD0_WORD2_SMCTRLM0_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD0_WORD2_SMCTRLM0_11             3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                MPU REGD0_WORD2 PIDENM0 [5..5]                                                */
                                 /* MPU_REGD0_WORD2_PIDENM0                                                    */
#define  MPU_REGD0_WORD2_PIDENM0_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD0_WORD2_PIDENM0_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                               MPU REGD0_WORD2 SMCTRLM1 [9..10]                                               */
                                 /* MPU_REGD0_WORD2_SMCTRLM1                                                   */
#define  MPU_REGD0_WORD2_SMCTRLM1_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD0_WORD2_SMCTRLM1_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD0_WORD2_SMCTRLM1_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD0_WORD2_SMCTRLM1_11             3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                               MPU REGD0_WORD2 PIDENM1 [11..11]                                               */
                                 /* MPU_REGD0_WORD2_PIDENM1                                                    */
 #define MPU_REGD0_WORD2_PIDENM1_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
 #define MPU_REGD0_WORD2_PIDENM1_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                              MPU REGD0_WORD2 SMCTRLM2 [15..16]                                               */
                                 /* MPU_REGD0_WORD2_SMCTRLM2                                                   */
#define  MPU_REGD0_WORD2_SMCTRLM2_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD0_WORD2_SMCTRLM2_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD0_WORD2_SMCTRLM2_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD0_WORD2_SMCTRLM2_11             3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                              MPU REGD0_WORD2 SMCTRLM3 [21..22]                                               */
                                 /* MPU_REGD0_WORD2_SMCTRLM3                                                   */
#define  MPU_REGD0_WORD2_SMCTRLM3_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD0_WORD2_SMCTRLM3_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD0_WORD2_SMCTRLM3_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD0_WORD2_SMCTRLM3_11             3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                MPU REGD0_WORD2 WENM4 [24..24]                                                */
                                 /* MPU_REGD0_WORD2_WENM4                                                      */
#define  MPU_REGD0_WORD2_WENM4_0                 0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                     write is not performed                                                    */
#define  MPU_REGD0_WORD2_WENM4_1                 1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                MPU REGD0_WORD2 RENM4 [25..25]                                                */
                                 /* MPU_REGD0_WORD2_RENM4                                                      */
#define  MPU_REGD0_WORD2_RENM4_0                 0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_REGD0_WORD2_RENM4_1                 1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                MPU REGD0_WORD2 WENM5 [26..26]                                                */
                                 /* MPU_REGD0_WORD2_WENM5                                                      */
#define  MPU_REGD0_WORD2_WENM5_0                 0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                     write is not performed                                                    */
#define  MPU_REGD0_WORD2_WENM5_1                 1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                MPU REGD0_WORD2 RENM5 [27..27]                                                */
                                 /* MPU_REGD0_WORD2_RENM5                                                      */
#define  MPU_REGD0_WORD2_RENM5_0                 0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                        read is not performed                                                     */
#define  MPU_REGD0_WORD2_RENM5_1                 1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                MPU REGD0_WORD2 WENM6 [28..28]                                                */
                                 /* MPU_REGD0_WORD2_WENM6                                                      */
#define  MPU_REGD0_WORD2_WENM6_0                 0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                        write is not performed                                                    */
#define  MPU_REGD0_WORD2_WENM6_1                 1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                MPU REGD0_WORD2 RENM6 [29..29]                                                */
                                 /* MPU_REGD0_WORD2_RENM6                                                      */
#define  MPU_REGD0_WORD2_RENM6_0                 0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                         read is not performed                                                     */
#define  MPU_REGD0_WORD2_RENM6_1                 1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                MPU REGD0_WORD2 WENM7 [30..30]                                                */
                                 /* MPU_REGD0_WORD2_WENM7                                                      */
#define MPU_REGD0_WORD2_WENM7_0                  0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                      write is not performed                                                    */
#define  MPU_REGD0_WORD2_WENM7_1                 1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                MPU REGD0_WORD2 RENM7 [31..31]                                                */
                                 /* MPU_REGD0_WORD2_RENM7                                                      */
#define  MPU_REGD0_WORD2_RENM7_0                 0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_REGD0_WORD2_RENM7_1                 1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                         REGD0_WORD3                                                         */
/*                                                MPU REGD0_WORD3 RDVALID [0..0]                                                */
                                 /* MPU_REGD0_WORD3_RDVALID                                                    */
#define  MPU_REGD0_WORD3_RDVALID_0               0U     /* 0 : Region descriptor is invalid                                          */
#define  MPU_REGD0_WORD3_RDVALID_1               1U     /* 1 : Region descriptor is valid                                            */


/*                                                         REGD1_WORD0                                                         */
/*                                                         REGD1_WORD1                                                         */
/*                                                         REGD1_WORD2                                                         */
/*                                               MPU REGD1_WORD2 SMCTRLM0 [3..4]                                                */
                                 /* MPU_REGD1_WORD2_SMCTRLM0                                                   */
#define  MPU_REGD1_WORD2_SMCTRLM0_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD1_WORD2_SMCTRLM0_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD1_WORD2_SMCTRLM0_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD1_WORD2_SMCTRLM0_11             3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                MPU REGD1_WORD2 PIDENM0 [5..5]                                                */
                                 /* MPU_REGD1_WORD2_PIDENM0                                                    */
#define  MPU_REGD1_WORD2_PIDENM0_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD1_WORD2_PIDENM0_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                               MPU REGD1_WORD2 SMCTRLM1 [9..10]                                               */
                                 /* MPU_REGD1_WORD2_SMCTRLM1                                                   */
#define  MPU_REGD1_WORD2_SMCTRLM1_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD1_WORD2_SMCTRLM1_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD1_WORD2_SMCTRLM1_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD1_WORD2_SMCTRLM1_11             3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                               MPU REGD1_WORD2 PIDENM1 [11..11]                                               */
                                 /* MPU_REGD1_WORD2_PIDENM1                                                    */
#define  MPU_REGD1_WORD2_PIDENM1_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD1_WORD2_PIDENM1_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                              MPU REGD1_WORD2 SMCTRLM2 [15..16]                                               */
                                 /* MPU_REGD1_WORD2_SMCTRLM2                                                   */
#define  MPU_REGD1_WORD2_SMCTRLM2_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD1_WORD2_SMCTRLM2_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD1_WORD2_SMCTRLM2_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD1_WORD2_SMCTRLM2_11             3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                              MPU REGD1_WORD2 SMCTRLM3 [21..22]                                               */
                                 /* MPU_REGD1_WORD2_SMCTRLM3                                                   */
#define  MPU_REGD1_WORD2_SMCTRLM3_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD1_WORD2_SMCTRLM3_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD1_WORD2_SMCTRLM3_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD1_WORD2_SMCTRLM3_11             3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                MPU REGD1_WORD2 WENM4 [24..24]                                                */
                                 /* MPU_REGD1_WORD2_WENM4                                                      */
#define MPU_REGD1_WORD2_WENM4_0                    0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                       write is not performed                                                    */
#define MPU_REGD1_WORD2_WENM4_1                  1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                MPU REGD1_WORD2 RENM4 [25..25]                                                */
                                 /* MPU_REGD1_WORD2_RENM4                                                      */
#define  MPU_REGD1_WORD2_RENM4_0                 0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                    read is not performed                                                     */
#define  MPU_REGD1_WORD2_RENM4_1                 1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                MPU REGD1_WORD2 WENM5 [26..26]                                                */
                                 /* MPU_REGD1_WORD2_WENM5                                                      */
#define  MPU_REGD1_WORD2_WENM5_0                 0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_REGD1_WORD2_WENM5_1                 1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                MPU REGD1_WORD2 RENM5 [27..27]                                                */
                                 /* MPU_REGD1_WORD2_RENM5                                                      */
#define  MPU_REGD1_WORD2_RENM5_0                 0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_REGD1_WORD2_RENM5_1                 1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                MPU REGD1_WORD2 WENM6 [28..28]                                                */
                                 /* MPU_REGD1_WORD2_WENM6                                                      */
#define  MPU_REGD1_WORD2_WENM6_0                 0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                       write is not performed                                                    */
#define  MPU_REGD1_WORD2_WENM6_1                 1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                MPU REGD1_WORD2 RENM6 [29..29]                                                */
                                 /* MPU_REGD1_WORD2_RENM6                                                      */
#define  MPU_REGD1_WORD2_RENM6_0                 0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_REGD1_WORD2_RENM6_1                 1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                MPU REGD1_WORD2 WENM7 [30..30]                                                */
                                 /* MPU_REGD1_WORD2_WENM7                                                      */
#define  MPU_REGD1_WORD2_WENM7_0                 0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_REGD1_WORD2_WENM7_1                 1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                MPU REGD1_WORD2 RENM7 [31..31]                                                */
                                 /* MPU_REGD1_WORD2_RENM7                                                      */
#define  MPU_REGD1_WORD2_RENM7_0                 0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                     read is not performed                                                     */
#define  MPU_REGD1_WORD2_RENM7_1                 1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                         REGD1_WORD3                                                         */
/*                                                MPU REGD1_WORD3 RDVALID [0..0]                                                */
                                 /* MPU_REGD1_WORD3_RDVALID                                                    */
#define  MPU_REGD1_WORD3_RDVALID_0               0U     /* 0 : Region descriptor is invalid                                          */
#define  MPU_REGD1_WORD3_RDVALID_1               1U     /* 1 : Region descriptor is valid                                            */


/*                                                         REGD2_WORD0                                                         */
/*                                                         REGD2_WORD1                                                         */
/*                                                         REGD2_WORD2                                                         */
/*                                               MPU REGD2_WORD2 SMCTRLM0 [3..4]                                                */
                                 /* MPU_REGD2_WORD2_SMCTRLM0                                                   */
#define  MPU_REGD2_WORD2_SMCTRLM0_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD2_WORD2_SMCTRLM0_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD2_WORD2_SMCTRLM0_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD2_WORD2_SMCTRLM0_11             3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                MPU REGD2_WORD2 PIDENM0 [5..5]                                                */
                                 /* MPU_REGD2_WORD2_PIDENM0                                                    */
#define  MPU_REGD2_WORD2_PIDENM0_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD2_WORD2_PIDENM0_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                               MPU REGD2_WORD2 SMCTRLM1 [9..10]                                               */
                                 /* MPU_REGD2_WORD2_SMCTRLM1                                                   */
#define  MPU_REGD2_WORD2_SMCTRLM1_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD2_WORD2_SMCTRLM1_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD2_WORD2_SMCTRLM1_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD2_WORD2_SMCTRLM1_11             3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                               MPU REGD2_WORD2 PIDENM1 [11..11]                                               */
                                 /* MPU_REGD2_WORD2_PIDENM1                                                    */
#define  MPU_REGD2_WORD2_PIDENM1_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD2_WORD2_PIDENM1_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                              MPU REGD2_WORD2 SMCTRLM2 [15..16]                                               */
                                 /* MPU_REGD2_WORD2_SMCTRLM2                                                   */
#define  MPU_REGD2_WORD2_SMCTRLM2_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD2_WORD2_SMCTRLM2_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD2_WORD2_SMCTRLM2_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD2_WORD2_SMCTRLM2_11             3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                              MPU REGD2_WORD2 SMCTRLM3 [21..22]                                               */
                                 /* MPU_REGD2_WORD2_SMCTRLM3                                                   */
#define  MPU_REGD2_WORD2_SMCTRLM3_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD2_WORD2_SMCTRLM3_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD2_WORD2_SMCTRLM3_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD2_WORD2_SMCTRLM3_11             3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                MPU REGD2_WORD2 WENM4 [24..24]                                                */
                                 /* MPU_REGD2_WORD2_WENM4                                                      */
#define  MPU_REGD2_WORD2_WENM4_0                 0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                     write is not performed                                                    */
#define  MPU_REGD2_WORD2_WENM4_1                 1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                MPU REGD2_WORD2 RENM4 [25..25]                                                */
                                 /* MPU_REGD2_WORD2_RENM4                                                      */
#define  MPU_REGD2_WORD2_RENM4_0                 0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                  read is not performed                                                     */
#define  MPU_REGD2_WORD2_RENM4_1                 1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                MPU REGD2_WORD2 WENM5 [26..26]                                                */
                                 /* MPU_REGD2_WORD2_WENM5                                                      */
#define  MPU_REGD2_WORD2_WENM5_0                 0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                    write is not performed                                                    */
#define  MPU_REGD2_WORD2_WENM5_1                 1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                MPU REGD2_WORD2 RENM5 [27..27]                                                */
                                 /* MPU_REGD2_WORD2_RENM5                                                      */
#define  MPU_REGD2_WORD2_RENM5_0                 0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                    read is not performed                                                     */
#define  MPU_REGD2_WORD2_RENM5_1                 1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                MPU REGD2_WORD2 WENM6 [28..28]                                                */
                                 /* MPU_REGD2_WORD2_WENM6                                                      */
#define  MPU_REGD2_WORD2_WENM6_0                 0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_REGD2_WORD2_WENM6_1                 1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                MPU REGD2_WORD2 RENM6 [29..29]                                                */
                                 /* MPU_REGD2_WORD2_RENM6                                                      */
#define  MPU_REGD2_WORD2_RENM6_0                 0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                   read is not performed                                                     */
#define  MPU_REGD2_WORD2_RENM6_1                 1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                MPU REGD2_WORD2 WENM7 [30..30]                                                */
                                 /* MPU_REGD2_WORD2_WENM7                                                      */
#define  MPU_REGD2_WORD2_WENM7_0                 0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                        write is not performed                                                    */
#define  MPU_REGD2_WORD2_WENM7_1                 1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                MPU REGD2_WORD2 RENM7 [31..31]                                                */
                                 /* MPU_REGD2_WORD2_RENM7                                                      */
#define  MPU_REGD2_WORD2_RENM7_0                 0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                    read is not performed                                                     */
#define  MPU_REGD2_WORD2_RENM7_1                 1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                         REGD2_WORD3                                                         */
/*                                                MPU REGD2_WORD3 RDVALID [0..0]                                                */
                                 /* MPU_REGD2_WORD3_RDVALID                                                    */
#define  MPU_REGD2_WORD3_RDVALID_0               0U     /* 0 : Region descriptor is invalid                                          */
#define  MPU_REGD2_WORD3_RDVALID_1               1U     /* 1 : Region descriptor is valid                                            */


/*                                                         REGD3_WORD0                                                         */
/*                                                         REGD3_WORD1                                                         */
/*                                                         REGD3_WORD2                                                         */
/*                                               MPU REGD3_WORD2 SMCTRLM0 [3..4]                                                */
                                 /* MPU_REGD3_WORD2_SMCTRLM0                                                   */
#define  MPU_REGD3_WORD2_SMCTRLM0_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD3_WORD2_SMCTRLM0_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD3_WORD2_SMCTRLM0_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD3_WORD2_SMCTRLM0_11             3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                MPU REGD3_WORD2 PIDENM0 [5..5]                                                */
                                 /* MPU_REGD3_WORD2_PIDENM0                                                    */
#define  MPU_REGD3_WORD2_PIDENM0_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD3_WORD2_PIDENM0_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                               MPU REGD3_WORD2 SMCTRLM1 [9..10]                                               */
                                 /* MPU_REGD3_WORD2_SMCTRLM1                                                   */
#define  MPU_REGD3_WORD2_SMCTRLM1_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD3_WORD2_SMCTRLM1_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD3_WORD2_SMCTRLM1_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD3_WORD2_SMCTRLM1_11             3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                               MPU REGD3_WORD2 PIDENM1 [11..11]                                               */
                                 /* MPU_REGD3_WORD2_PIDENM1                                                    */
#define  MPU_REGD3_WORD2_PIDENM1_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD3_WORD2_PIDENM1_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                              MPU REGD3_WORD2 SMCTRLM2 [15..16]                                               */
                                 /* MPU_REGD3_WORD2_SMCTRLM2                                                   */
#define  MPU_REGD3_WORD2_SMCTRLM2_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD3_WORD2_SMCTRLM2_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD3_WORD2_SMCTRLM2_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD3_WORD2_SMCTRLM2_11             3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                              MPU REGD3_WORD2 SMCTRLM3 [21..22]                                               */
                                 /* MPU_REGD3_WORD2_SMCTRLM3                                                   */
#define  MPU_REGD3_WORD2_SMCTRLM3_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD3_WORD2_SMCTRLM3_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD3_WORD2_SMCTRLM3_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD3_WORD2_SMCTRLM3_11             3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                MPU REGD3_WORD2 WENM4 [24..24]                                                */
                                 /* MPU_REGD3_WORD2_WENM4                                                      */
#define  MPU_REGD3_WORD2_WENM4_0                 0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                        write is not performed                                                    */
#define  MPU_REGD3_WORD2_WENM4_1                 1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                MPU REGD3_WORD2 RENM4 [25..25]                                                */
                                 /* MPU_REGD3_WORD2_RENM4                                                      */
#define  MPU_REGD3_WORD2_RENM4_0                 0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                 read is not performed                                                     */
#define  MPU_REGD3_WORD2_RENM4_1                 1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                MPU REGD3_WORD2 WENM5 [26..26]                                                */
                                 /* MPU_REGD3_WORD2_WENM5                                                      */
#define  MPU_REGD3_WORD2_WENM5_0                 0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                     write is not performed                                                    */
#define  MPU_REGD3_WORD2_WENM5_1                 1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                MPU REGD3_WORD2 RENM5 [27..27]                                                */
                                 /* MPU_REGD3_WORD2_RENM5                                                      */
#define  MPU_REGD3_WORD2_RENM5_0                 0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                        read is not performed                                                     */
#define  MPU_REGD3_WORD2_RENM5_1                 1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                MPU REGD3_WORD2 WENM6 [28..28]                                                */
                                 /* MPU_REGD3_WORD2_WENM6                                                      */
#define MPU_REGD3_WORD2_WENM6_0                  0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                     write is not performed                                                    */
#define  MPU_REGD3_WORD2_WENM6_1                 1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                MPU REGD3_WORD2 RENM6 [29..29]                                                */
                                 /* MPU_REGD3_WORD2_RENM6                                                      */
#define  MPU_REGD3_WORD2_RENM6_0                 0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                     read is not performed                                                     */
#define  MPU_REGD3_WORD2_RENM6_1                 1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                MPU REGD3_WORD2 WENM7 [30..30]                                                */
                                 /* MPU_REGD3_WORD2_WENM7                                                      */
#define  MPU_REGD3_WORD2_WENM7_0                 0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                     write is not performed                                                    */
#define  MPU_REGD3_WORD2_WENM7_1                 1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                MPU REGD3_WORD2 RENM7 [31..31]                                                */
                                 /* MPU_REGD3_WORD2_RENM7                                                      */
#define  MPU_REGD3_WORD2_RENM7_0                 0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                     read is not performed                                                     */
#define  MPU_REGD3_WORD2_RENM7_1                 1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                         REGD3_WORD3                                                         */
/*                                                MPU REGD3_WORD3 RDVALID [0..0]                                                */
                                 /* MPU_REGD3_WORD3_RDVALID                                                    */
#define  MPU_REGD3_WORD3_RDVALID_0               0U     /* 0 : Region descriptor is invalid                                          */
#define  MPU_REGD3_WORD3_RDVALID_1               1U     /* 1 : Region descriptor is valid                                            */


/*                                                         REGD4_WORD0                                                         */
/*                                                         REGD4_WORD1                                                         */
/*                                                         REGD4_WORD2                                                         */
/*                                               MPU REGD4_WORD2 SMCTRLM0 [3..4]                                                */
                                 /* MPU_REGD4_WORD2_SMCTRLM0                                                   */
#define  MPU_REGD4_WORD2_SMCTRLM0_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD4_WORD2_SMCTRLM0_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD4_WORD2_SMCTRLM0_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD4_WORD2_SMCTRLM0_11             3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                MPU REGD4_WORD2 PIDENM0 [5..5]                                                */
                                 /* MPU_REGD4_WORD2_PIDENM0                                                    */
#define  MPU_REGD4_WORD2_PIDENM0_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD4_WORD2_PIDENM0_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                               MPU REGD4_WORD2 SMCTRLM1 [9..10]                                               */
                                 /* MPU_REGD4_WORD2_SMCTRLM1                                                   */
#define  MPU_REGD4_WORD2_SMCTRLM1_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD4_WORD2_SMCTRLM1_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD4_WORD2_SMCTRLM1_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD4_WORD2_SMCTRLM1_11             3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                               MPU REGD4_WORD2 PIDENM1 [11..11]                                               */
                                 /* MPU_REGD4_WORD2_PIDENM1                                                    */
#define  MPU_REGD4_WORD2_PIDENM1_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD4_WORD2_PIDENM1_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                              MPU REGD4_WORD2 SMCTRLM2 [15..16]                                               */
                                 /* MPU_REGD4_WORD2_SMCTRLM2                                                   */
#define  MPU_REGD4_WORD2_SMCTRLM2_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD4_WORD2_SMCTRLM2_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD4_WORD2_SMCTRLM2_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD4_WORD2_SMCTRLM2_11             3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                              MPU REGD4_WORD2 SMCTRLM3 [21..22]                                               */
                                 /* MPU_REGD4_WORD2_SMCTRLM3                                                   */
#define  MPU_REGD4_WORD2_SMCTRLM3_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD4_WORD2_SMCTRLM3_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD4_WORD2_SMCTRLM3_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD4_WORD2_SMCTRLM3_11             3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                MPU REGD4_WORD2 WENM4 [24..24]                                                */
                                 /* MPU_REGD4_WORD2_WENM4                                                      */
#define  MPU_REGD4_WORD2_WENM4_0                 0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                     write is not performed                                                    */
#define  MPU_REGD4_WORD2_WENM4_1                 1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                MPU REGD4_WORD2 RENM4 [25..25]                                                */
                                 /* MPU_REGD4_WORD2_RENM4                                                      */
#define  MPU_REGD4_WORD2_RENM4_0                 0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                   read is not performed                                                     */
#define  MPU_REGD4_WORD2_RENM4_1                 1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                MPU REGD4_WORD2 WENM5 [26..26]                                                */
                                 /* MPU_REGD4_WORD2_WENM5                                                      */
#define  MPU_REGD4_WORD2_WENM5_0                 0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                       write is not performed                                                    */
#define  MPU_REGD4_WORD2_WENM5_1                 1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                MPU REGD4_WORD2 RENM5 [27..27]                                                */
                                 /* MPU_REGD4_WORD2_RENM5                                                      */
#define  MPU_REGD4_WORD2_RENM5_0                 0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                               read is not performed                                                     */
#define  MPU_REGD4_WORD2_RENM5_1                 1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                MPU REGD4_WORD2 WENM6 [28..28]                                                */
                                 /* MPU_REGD4_WORD2_WENM6                                                      */
#define  MPU_REGD4_WORD2_WENM6_0                 0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                    write is not performed                                                    */
#define  MPU_REGD4_WORD2_WENM6_1                 1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                MPU REGD4_WORD2 RENM6 [29..29]                                                */
                                 /* MPU_REGD4_WORD2_RENM6                                                      */
#define  MPU_REGD4_WORD2_RENM6_0                 0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                     read is not performed                                                     */
#define  MPU_REGD4_WORD2_RENM6_1                 1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                MPU REGD4_WORD2 WENM7 [30..30]                                                */
                                 /* MPU_REGD4_WORD2_WENM7                                                      */
#define  MPU_REGD4_WORD2_WENM7_0                 0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                write is not performed                                                    */
#define  MPU_REGD4_WORD2_WENM7_1                 1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                MPU REGD4_WORD2 RENM7 [31..31]                                                */
                                 /* MPU_REGD4_WORD2_RENM7                                                      */
#define MPU_REGD4_WORD2_RENM7_0                  0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                       read is not performed                                                     */
#define MPU_REGD4_WORD2_RENM7_1                  1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                         REGD4_WORD3                                                         */
/*                                                MPU REGD4_WORD3 RDVALID [0..0]                                                */
                                 /* MPU_REGD4_WORD3_RDVALID                                                    */
#define  MPU_REGD4_WORD3_RDVALID_0               0U     /* 0 : Region descriptor is invalid                                          */
#define  MPU_REGD4_WORD3_RDVALID_1               1U     /* 1 : Region descriptor is valid                                            */


/*                                                         REGD5_WORD0                                                         */
/*                                                         REGD5_WORD1                                                         */
/*                                                         REGD5_WORD2                                                         */
/*                                               MPU REGD5_WORD2 SMCTRLM0 [3..4]                                                */
                                 /* MPU_REGD5_WORD2_SMCTRLM0                                                   */
#define  MPU_REGD5_WORD2_SMCTRLM0_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD5_WORD2_SMCTRLM0_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD5_WORD2_SMCTRLM0_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD5_WORD2_SMCTRLM0_11             3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                MPU REGD5_WORD2 PIDENM0 [5..5]                                                */
                                 /* MPU_REGD5_WORD2_PIDENM0                                                    */
#define  MPU_REGD5_WORD2_PIDENM0_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD5_WORD2_PIDENM0_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                               MPU REGD5_WORD2 SMCTRLM1 [9..10]                                               */
                                 /* MPU_REGD5_WORD2_SMCTRLM1                                                   */
#define  MPU_REGD5_WORD2_SMCTRLM1_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD5_WORD2_SMCTRLM1_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD5_WORD2_SMCTRLM1_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD5_WORD2_SMCTRLM1_11             3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                               MPU REGD5_WORD2 PIDENM1 [11..11]                                               */
                                 /* MPU_REGD5_WORD2_PIDENM1                                                    */
#define  MPU_REGD5_WORD2_PIDENM1_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD5_WORD2_PIDENM1_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                              MPU REGD5_WORD2 SMCTRLM2 [15..16]                                               */
                                 /* MPU_REGD5_WORD2_SMCTRLM2                                                   */
#define  MPU_REGD5_WORD2_SMCTRLM2_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD5_WORD2_SMCTRLM2_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD5_WORD2_SMCTRLM2_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD5_WORD2_SMCTRLM2_11             3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                              MPU REGD5_WORD2 SMCTRLM3 [21..22]                                               */
                                 /* MPU_REGD5_WORD2_SMCTRLM3                                                   */
#define  MPU_REGD5_WORD2_SMCTRLM3_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD5_WORD2_SMCTRLM3_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD5_WORD2_SMCTRLM3_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD5_WORD2_SMCTRLM3_11             3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                MPU REGD5_WORD2 WENM4 [24..24]                                                */
                                 /* MPU_REGD5_WORD2_WENM4                                                      */
#define  MPU_REGD5_WORD2_WENM4_0                 0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                      write is not performed                                                    */
#define  MPU_REGD5_WORD2_WENM4_1                 1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                MPU REGD5_WORD2 RENM4 [25..25]                                                */
                                 /* MPU_REGD5_WORD2_RENM4                                                      */
#define  MPU_REGD5_WORD2_RENM4_0                 0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                        read is not performed                                                     */
#define  MPU_REGD5_WORD2_RENM4_1                 1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                MPU REGD5_WORD2 WENM5 [26..26]                                                */
                                 /* MPU_REGD5_WORD2_WENM5                                                      */
#define  MPU_REGD5_WORD2_WENM5_0                 0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                 write is not performed                                                    */
#define  MPU_REGD5_WORD2_WENM5_1                 1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                MPU REGD5_WORD2 RENM5 [27..27]                                                */
                                 /* MPU_REGD5_WORD2_RENM5                                                      */
#define  MPU_REGD5_WORD2_RENM5_0                 0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                        read is not performed                                                     */
#define  MPU_REGD5_WORD2_RENM5_1                 1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                MPU REGD5_WORD2 WENM6 [28..28]                                                */
                                 /* MPU_REGD5_WORD2_WENM6                                                      */
#define  MPU_REGD5_WORD2_WENM6_0                 0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                      write is not performed                                                    */
#define  MPU_REGD5_WORD2_WENM6_1                 1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                MPU REGD5_WORD2 RENM6 [29..29]                                                */
                                 /* MPU_REGD5_WORD2_RENM6                                                      */
#define  MPU_REGD5_WORD2_RENM6_0                 0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_REGD5_WORD2_RENM6_1                 1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                MPU REGD5_WORD2 WENM7 [30..30]                                                */
                                 /* MPU_REGD5_WORD2_WENM7                                                      */
#define  MPU_REGD5_WORD2_WENM7_0                 0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                      write is not performed                                                    */
#define  MPU_REGD5_WORD2_WENM7_1                 1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                MPU REGD5_WORD2 RENM7 [31..31]                                                */
                                 /* MPU_REGD5_WORD2_RENM7                                                      */
#define  MPU_REGD5_WORD2_RENM7_0                 0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                       read is not performed                                                     */
#define  MPU_REGD5_WORD2_RENM7_1                 1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                         REGD5_WORD3                                                         */
/*                                                MPU REGD5_WORD3 RDVALID [0..0]                                                */
                                 /* MPU_REGD5_WORD3_RDVALID                                                    */
#define  MPU_REGD5_WORD3_RDVALID_0               0U     /* 0 : Region descriptor is invalid                                          */
#define  MPU_REGD5_WORD3_RDVALID_1               1U     /* 1 : Region descriptor is valid                                            */


/*                                                         REGD6_WORD0                                                         */
/*                                                         REGD6_WORD1                                                         */
/*                                                         REGD6_WORD2                                                         */
/*                                               MPU REGD6_WORD2 SMCTRLM0 [3..4]                                                */
                                 /* MPU_REGD6_WORD2_SMCTRLM0                                                   */
#define  MPU_REGD6_WORD2_SMCTRLM0_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD6_WORD2_SMCTRLM0_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD6_WORD2_SMCTRLM0_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD6_WORD2_SMCTRLM0_11             3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                MPU REGD6_WORD2 PIDENM0 [5..5]                                                */
                                 /* MPU_REGD6_WORD2_PIDENM0                                                    */
#define  MPU_REGD6_WORD2_PIDENM0_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD6_WORD2_PIDENM0_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                               MPU REGD6_WORD2 SMCTRLM1 [9..10]                                               */
                                 /* MPU_REGD6_WORD2_SMCTRLM1                                                   */
#define  MPU_REGD6_WORD2_SMCTRLM1_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD6_WORD2_SMCTRLM1_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD6_WORD2_SMCTRLM1_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD6_WORD2_SMCTRLM1_11             3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                               MPU REGD6_WORD2 PIDENM1 [11..11]                                               */
                                 /* MPU_REGD6_WORD2_PIDENM1                                                    */
#define  MPU_REGD6_WORD2_PIDENM1_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD6_WORD2_PIDENM1_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                              MPU REGD6_WORD2 SMCTRLM2 [15..16]                                               */
                                 /* MPU_REGD6_WORD2_SMCTRLM2                                                   */
#define  MPU_REGD6_WORD2_SMCTRLM2_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD6_WORD2_SMCTRLM2_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD6_WORD2_SMCTRLM2_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD6_WORD2_SMCTRLM2_11             3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                              MPU REGD6_WORD2 SMCTRLM3 [21..22]                                               */
                                 /* MPU_REGD6_WORD2_SMCTRLM3                                                   */
#define  MPU_REGD6_WORD2_SMCTRLM3_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD6_WORD2_SMCTRLM3_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD6_WORD2_SMCTRLM3_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD6_WORD2_SMCTRLM3_11             3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                MPU REGD6_WORD2 WENM4 [24..24]                                                */
                                 /* MPU_REGD6_WORD2_WENM4                                                      */
#define  MPU_REGD6_WORD2_WENM4_0                 0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                        write is not performed                                                    */
#define  MPU_REGD6_WORD2_WENM4_1                 1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                MPU REGD6_WORD2 RENM4 [25..25]                                                */
                                 /* MPU_REGD6_WORD2_RENM4                                                      */
#define  MPU_REGD6_WORD2_RENM4_0                 0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                         read is not performed                                                     */
#define  MPU_REGD6_WORD2_RENM4_1                 1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                MPU REGD6_WORD2 WENM5 [26..26]                                                */
                                 /* MPU_REGD6_WORD2_WENM5                                                      */
#define  MPU_REGD6_WORD2_WENM5_0                 0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_REGD6_WORD2_WENM5_1                 1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                MPU REGD6_WORD2 RENM5 [27..27]                                                */
                                 /* MPU_REGD6_WORD2_RENM5                                                      */
#define  MPU_REGD6_WORD2_RENM5_0                 0U     /* 0 : Bus master 5 reads terminate with an access error and the
    #define                                                     read is not performed                                                     */
#define  MPU_REGD6_WORD2_RENM5_1                 1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                MPU REGD6_WORD2 WENM6 [28..28]                                                */
                                 /* MPU_REGD6_WORD2_WENM6                                                      */
#define  MPU_REGD6_WORD2_WENM6_0                 0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_REGD6_WORD2_WENM6_1                 1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                MPU REGD6_WORD2 RENM6 [29..29]                                                */
                                 /* MPU_REGD6_WORD2_RENM6                                                      */
#define  MPU_REGD6_WORD2_RENM6_0                 0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                       read is not performed                                                     */
#define  MPU_REGD6_WORD2_RENM6_1                 1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                MPU REGD6_WORD2 WENM7 [30..30]                                                */
                                 /* MPU_REGD6_WORD2_WENM7                                                      */
#define  MPU_REGD6_WORD2_WENM7_0                 0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                       write is not performed                                                    */
#define  MPU_REGD6_WORD2_WENM7_1                 1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                MPU REGD6_WORD2 RENM7 [31..31]                                                */
                                 /* MPU_REGD6_WORD2_RENM7                                                      */
#define  MPU_REGD6_WORD2_RENM7_0                 0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                       read is not performed                                                     */
#define  MPU_REGD6_WORD2_RENM7_1                 1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                         REGD6_WORD3                                                         */
/*                                                MPU REGD6_WORD3 RDVALID [0..0]                                                */
                                 /* MPU_REGD6_WORD3_RDVALID                                                    */
#define  MPU_REGD6_WORD3_RDVALID_0               0U     /* 0 : Region descriptor is invalid                                          */
#define  MPU_REGD6_WORD3_RDVALID_1               1U     /* 1 : Region descriptor is valid                                            */


/*                                                         REGD7_WORD0                                                         */
/*                                                         REGD7_WORD1                                                         */
/*                                                         REGD7_WORD2                                                         */
/*                                               MPU REGD7_WORD2 SMCTRLM0 [3..4]                                                */
                                 /* MPU_REGD7_WORD2_SMCTRLM0                                                   */
#define  MPU_REGD7_WORD2_SMCTRLM0_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD7_WORD2_SMCTRLM0_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD7_WORD2_SMCTRLM0_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD7_WORD2_SMCTRLM0_11             3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                MPU REGD7_WORD2 PIDENM0 [5..5]                                                */
                                 /* MPU_REGD7_WORD2_PIDENM0                                                    */
#define  MPU_REGD7_WORD2_PIDENM0_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD7_WORD2_PIDENM0_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                               MPU REGD7_WORD2 SMCTRLM1 [9..10]                                               */
                                 /* MPU_REGD7_WORD2_SMCTRLM1                                                   */
#define  MPU_REGD7_WORD2_SMCTRLM1_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD7_WORD2_SMCTRLM1_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD7_WORD2_SMCTRLM1_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD7_WORD2_SMCTRLM1_11             3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                               MPU REGD7_WORD2 PIDENM1 [11..11]                                               */
                                 /* MPU_REGD7_WORD2_PIDENM1                                                    */
#define  MPU_REGD7_WORD2_PIDENM1_0               0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_REGD7_WORD2_PIDENM1_1               1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                              MPU REGD7_WORD2 SMCTRLM2 [15..16]                                               */
                                 /* MPU_REGD7_WORD2_SMCTRLM2                                                   */
#define  MPU_REGD7_WORD2_SMCTRLM2_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD7_WORD2_SMCTRLM2_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD7_WORD2_SMCTRLM2_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD7_WORD2_SMCTRLM2_11             3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                              MPU REGD7_WORD2 SMCTRLM3 [21..22]                                               */
                                 /* MPU_REGD7_WORD2_SMCTRLM3                                                   */
#define  MPU_REGD7_WORD2_SMCTRLM3_0              0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_REGD7_WORD2_SMCTRLM3_1              1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_REGD7_WORD2_SMCTRLM3_10             2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_REGD7_WORD2_SMCTRLM3_11             3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                MPU REGD7_WORD2 WENM4 [24..24]                                                */
                                 /* MPU_REGD7_WORD2_WENM4                                                      */
#define  MPU_REGD7_WORD2_WENM4_0                 0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_REGD7_WORD2_WENM4_1                 1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                MPU REGD7_WORD2 RENM4 [25..25]                                                */
                                 /* MPU_REGD7_WORD2_RENM4                                                      */
#define  MPU_REGD7_WORD2_RENM4_0                 0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                 read is not performed                                                     */
#define  MPU_REGD7_WORD2_RENM4_1                 1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                MPU REGD7_WORD2 WENM5 [26..26]                                                */
                                 /* MPU_REGD7_WORD2_WENM5                                                      */
#define  MPU_REGD7_WORD2_WENM5_0                 0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                     write is not performed                                                    */
#define  MPU_REGD7_WORD2_WENM5_1                 1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                MPU REGD7_WORD2 RENM5 [27..27]                                                */
                                 /* MPU_REGD7_WORD2_RENM5                                                      */
#define  MPU_REGD7_WORD2_RENM5_0                 0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                     read is not performed                                                     */
#define  MPU_REGD7_WORD2_RENM5_1                 1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                MPU REGD7_WORD2 WENM6 [28..28]                                                */
                                 /* MPU_REGD7_WORD2_WENM6                                                      */
#define  MPU_REGD7_WORD2_WENM6_0                 0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                       write is not performed                                                    */
#define  MPU_REGD7_WORD2_WENM6_1                 1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                MPU REGD7_WORD2 RENM6 [29..29]                                                */
                                 /* MPU_REGD7_WORD2_RENM6                                                      */
#define  MPU_REGD7_WORD2_RENM6_0                 0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                     read is not performed                                                     */
#define  MPU_REGD7_WORD2_RENM6_1                 1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                MPU REGD7_WORD2 WENM7 [30..30]                                                */
                                 /* MPU_REGD7_WORD2_WENM7                                                      */
#define  MPU_REGD7_WORD2_WENM7_0                 0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                  write is not performed                                                    */
#define  MPU_REGD7_WORD2_WENM7_1                 1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                MPU REGD7_WORD2 RENM7 [31..31]                                                */
                                 /* MPU_REGD7_WORD2_RENM7                                                      */
#define  MPU_REGD7_WORD2_RENM7_0                 0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_REGD7_WORD2_RENM7_1                 1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                         REGD7_WORD3                                                         */
/*                                                MPU REGD7_WORD3 RDVALID [0..0]                                                */
                                 /* MPU_REGD7_WORD3_RDVALID                                                    */
#define  MPU_REGD7_WORD3_RDVALID_0               0U     /* 0 : Region descriptor is invalid                                          */
#define  MPU_REGD7_WORD3_RDVALID_1               1U     /* 1 : Region descriptor is valid                                            */


/*                                                          RGDAACC0                                                           */
/*                                                 MPU RGDAACC0 SMCTRLM0 [3..4]                                                 */
                                 /* MPU_RGDAACC0_SMCTRLM0                                                      */
#define  MPU_RGDAACC0_SMCTRLM0_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC0_SMCTRLM0_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC0_SMCTRLM0_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC0_SMCTRLM0_11                3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                 MPU RGDAACC0 PIDENM0 [5..5]                                                  */
                                 /* MPU_RGDAACC0_PIDENM0                                                       */
#define  MPU_RGDAACC0_PIDENM0_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC0_PIDENM0_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC0 SMCTRLM1 [9..10]                                                 */
                                 /* MPU_RGDAACC0_SMCTRLM1                                                      */
#define  MPU_RGDAACC0_SMCTRLM1_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC0_SMCTRLM1_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC0_SMCTRLM1_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC0_SMCTRLM1_11                3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                                MPU RGDAACC0 PIDENM1 [11..11]                                                 */
                                 /* MPU_RGDAACC0_PIDENM1                                                       */
#define  MPU_RGDAACC0_PIDENM1_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC0_PIDENM1_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC0 SMCTRLM2 [15..16]                                                */
                                 /* MPU_RGDAACC0_SMCTRLM2                                                      */
#define  MPU_RGDAACC0_SMCTRLM2_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC0_SMCTRLM2_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC0_SMCTRLM2_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC0_SMCTRLM2_11                3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                                MPU RGDAACC0 SMCTRLM3 [21..22]                                                */
                                 /* MPU_RGDAACC0_SMCTRLM3                                                      */
#define  MPU_RGDAACC0_SMCTRLM3_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC0_SMCTRLM3_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC0_SMCTRLM3_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC0_SMCTRLM3_11                3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                 MPU RGDAACC0 WENM4 [24..24]                                                  */
                                 /* MPU_RGDAACC0_WENM4                                                         */
#define  MPU_RGDAACC0_WENM4_0                    0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_RGDAACC0_WENM4_1                    1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                 MPU RGDAACC0 RENM4 [25..25]                                                  */
                                 /* MPU_RGDAACC0_RENM4                                                         */
#define  MPU_RGDAACC0_RENM4_0                    0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                read is not performed                                                     */
#define  MPU_RGDAACC0_RENM4_1                    1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                 MPU RGDAACC0 WENM5 [26..26]                                                  */
                                 /* MPU_RGDAACC0_WENM5                                                         */
#define  MPU_RGDAACC0_WENM5_0                    0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                   write is not performed                                                    */
#define  MPU_RGDAACC0_WENM5_1                    1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                 MPU RGDAACC0 RENM5 [27..27]                                                  */
                                 /* MPU_RGDAACC0_RENM5                                                         */
#define  MPU_RGDAACC0_RENM5_0                    0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_RGDAACC0_RENM5_1                    1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                 MPU RGDAACC0 WENM6 [28..28]                                                  */
                                 /* MPU_RGDAACC0_WENM6                                                         */
#define  MPU_RGDAACC0_WENM6_0                    0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                write is not performed                                                    */
#define  MPU_RGDAACC0_WENM6_1                    1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                 MPU RGDAACC0 RENM6 [29..29]                                                  */
                                 /* MPU_RGDAACC0_RENM6                                                         */
#define  MPU_RGDAACC0_RENM6_0                    0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                read is not performed                                                     */
#define  MPU_RGDAACC0_RENM6_1                    1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                 MPU RGDAACC0 WENM7 [30..30]                                                  */
                                 /* MPU_RGDAACC0_WENM7                                                         */
#define  MPU_RGDAACC0_WENM7_0                    0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_RGDAACC0_WENM7_1                    1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                 MPU RGDAACC0 RENM7 [31..31]                                                  */
                                 /* MPU_RGDAACC0_RENM7                                                         */
#define  MPU_RGDAACC0_RENM7_0                    0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_RGDAACC0_RENM7_1                    1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                          RGDAACC1                                                           */
/*                                                 MPU RGDAACC1 SMCTRLM0 [3..4]                                                 */
                                 /* MPU_RGDAACC1_SMCTRLM0                                                      */
#define  MPU_RGDAACC1_SMCTRLM0_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC1_SMCTRLM0_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC1_SMCTRLM0_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC1_SMCTRLM0_11                3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                 MPU RGDAACC1 PIDENM0 [5..5]                                                  */
                                 /* MPU_RGDAACC1_PIDENM0                                                       */
#define  MPU_RGDAACC1_PIDENM0_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC1_PIDENM0_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC1 SMCTRLM1 [9..10]                                                 */
                                 /* MPU_RGDAACC1_SMCTRLM1                                                      */
#define  MPU_RGDAACC1_SMCTRLM1_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC1_SMCTRLM1_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC1_SMCTRLM1_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC1_SMCTRLM1_11                3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                                MPU RGDAACC1 PIDENM1 [11..11]                                                 */
                                 /* MPU_RGDAACC1_PIDENM1                                                       */
#define  MPU_RGDAACC1_PIDENM1_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC1_PIDENM1_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC1 SMCTRLM2 [15..16]                                                */
                                 /* MPU_RGDAACC1_SMCTRLM2                                                      */
#define  MPU_RGDAACC1_SMCTRLM2_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC1_SMCTRLM2_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC1_SMCTRLM2_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC1_SMCTRLM2_11                3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                                MPU RGDAACC1 SMCTRLM3 [21..22]                                                */
                                 /* MPU_RGDAACC1_SMCTRLM3                                                      */
#define  MPU_RGDAACC1_SMCTRLM3_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC1_SMCTRLM3_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC1_SMCTRLM3_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC1_SMCTRLM3_11                3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                 MPU RGDAACC1 WENM4 [24..24]                                                  */
                                 /* MPU_RGDAACC1_WENM4                                                         */
#define  MPU_RGDAACC1_WENM4_0                    0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                        write is not performed                                                    */
#define  MPU_RGDAACC1_WENM4_1                    1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                 MPU RGDAACC1 RENM4 [25..25]                                                  */
                                 /* MPU_RGDAACC1_RENM4                                                         */
#define  MPU_RGDAACC1_RENM4_0                    0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                               read is not performed                                                     */
#define  MPU_RGDAACC1_RENM4_1                    1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                 MPU RGDAACC1 WENM5 [26..26]                                                  */
                                 /* MPU_RGDAACC1_WENM5                                                         */
#define  MPU_RGDAACC1_WENM5_0                    0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                               write is not performed                                                    */
#define  MPU_RGDAACC1_WENM5_1                    1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                 MPU RGDAACC1 RENM5 [27..27]                                                  */
                                 /* MPU_RGDAACC1_RENM5                                                         */
#define  MPU_RGDAACC1_RENM5_0                    0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                  read is not performed                                                     */
#define  MPU_RGDAACC1_RENM5_1                    1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                 MPU RGDAACC1 WENM6 [28..28]                                                  */
                                 /* MPU_RGDAACC1_WENM6                                                         */
#define  MPU_RGDAACC1_WENM6_0                    0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                   write is not performed                                                    */
#define  MPU_RGDAACC1_WENM6_1                    1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                 MPU RGDAACC1 RENM6 [29..29]                                                  */
                                 /* MPU_RGDAACC1_RENM6                                                         */
 #define MPU_RGDAACC1_RENM6_0                    0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                     read is not performed                                                     */
 #define MPU_RGDAACC1_RENM6_1                    1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                 MPU RGDAACC1 WENM7 [30..30]                                                  */
                                 /* MPU_RGDAACC1_WENM7                                                         */
#define  MPU_RGDAACC1_WENM7_0                    0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                               write is not performed                                                    */
#define  MPU_RGDAACC1_WENM7_1                    1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                 MPU RGDAACC1 RENM7 [31..31]                                                  */
                                 /* MPU_RGDAACC1_RENM7                                                         */
#define  MPU_RGDAACC1_RENM7_0                    0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                    read is not performed                                                     */
#define  MPU_RGDAACC1_RENM7_1                    1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                          RGDAACC2                                                           */
/*                                                 MPU RGDAACC2 SMCTRLM0 [3..4]                                                 */
                                 /* MPU_RGDAACC2_SMCTRLM0                                                      */
#define  MPU_RGDAACC2_SMCTRLM0_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC2_SMCTRLM0_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC2_SMCTRLM0_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC2_SMCTRLM0_11                3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                 MPU RGDAACC2 PIDENM0 [5..5]                                                  */
                                 /* MPU_RGDAACC2_PIDENM0                                                       */
#define  MPU_RGDAACC2_PIDENM0_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC2_PIDENM0_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC2 SMCTRLM1 [9..10]                                                 */
                                 /* MPU_RGDAACC2_SMCTRLM1                                                      */
#define  MPU_RGDAACC2_SMCTRLM1_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC2_SMCTRLM1_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC2_SMCTRLM1_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC2_SMCTRLM1_11                3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                                MPU RGDAACC2 PIDENM1 [11..11]                                                 */
                                 /* MPU_RGDAACC2_PIDENM1                                                       */
#define  MPU_RGDAACC2_PIDENM1_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC2_PIDENM1_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC2 SMCTRLM2 [15..16]                                                */
                                 /* MPU_RGDAACC2_SMCTRLM2                                                      */
#define  MPU_RGDAACC2_SMCTRLM2_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC2_SMCTRLM2_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC2_SMCTRLM2_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC2_SMCTRLM2_11                3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                                MPU RGDAACC2 SMCTRLM3 [21..22]                                                */
                                 /* MPU_RGDAACC2_SMCTRLM3                                                      */
#define  MPU_RGDAACC2_SMCTRLM3_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC2_SMCTRLM3_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC2_SMCTRLM3_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC2_SMCTRLM3_11                3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                 MPU RGDAACC2 WENM4 [24..24]                                                  */
                                 /* MPU_RGDAACC2_WENM4                                                         */
#define  MPU_RGDAACC2_WENM4_0                    0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                      write is not performed                                                    */
#define  MPU_RGDAACC2_WENM4_1                    1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                 MPU RGDAACC2 RENM4 [25..25]                                                  */
                                 /* MPU_RGDAACC2_RENM4                                                         */
#define  MPU_RGDAACC2_RENM4_0                    0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_RGDAACC2_RENM4_1                    1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                 MPU RGDAACC2 WENM5 [26..26]                                                  */
                                 /* MPU_RGDAACC2_WENM5                                                         */
#define  MPU_RGDAACC2_WENM5_0                    0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                      write is not performed                                                    */
#define  MPU_RGDAACC2_WENM5_1                    1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                 MPU RGDAACC2 RENM5 [27..27]                                                  */
                                 /* MPU_RGDAACC2_RENM5                                                         */
#define  MPU_RGDAACC2_RENM5_0                    0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                        read is not performed                                                     */
#define  MPU_RGDAACC2_RENM5_1                    1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                 MPU RGDAACC2 WENM6 [28..28]                                                  */
                                 /* MPU_RGDAACC2_WENM6                                                         */
#define  MPU_RGDAACC2_WENM6_0                    0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                               write is not performed                                                    */
#define  MPU_RGDAACC2_WENM6_1                    1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                 MPU RGDAACC2 RENM6 [29..29]                                                  */
                                 /* MPU_RGDAACC2_RENM6                                                         */
#define  MPU_RGDAACC2_RENM6_0                    0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                               read is not performed                                                     */
#define  MPU_RGDAACC2_RENM6_1                    1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                 MPU RGDAACC2 WENM7 [30..30]                                                  */
                                 /* MPU_RGDAACC2_WENM7                                                         */
#define  MPU_RGDAACC2_WENM7_0                    0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_RGDAACC2_WENM7_1                    1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                 MPU RGDAACC2 RENM7 [31..31]                                                  */
                                 /* MPU_RGDAACC2_RENM7                                                         */
#define  MPU_RGDAACC2_RENM7_0                    0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                         read is not performed                                                     */
#define  MPU_RGDAACC2_RENM7_1                    1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                          RGDAACC3                                                           */
/*                                                 MPU RGDAACC3 SMCTRLM0 [3..4]                                                 */
                                 /* MPU_RGDAACC3_SMCTRLM0                                                      */
#define  MPU_RGDAACC3_SMCTRLM0_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC3_SMCTRLM0_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC3_SMCTRLM0_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC3_SMCTRLM0_11                3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                 MPU RGDAACC3 PIDENM0 [5..5]                                                  */
                                 /* MPU_RGDAACC3_PIDENM0                                                       */
#define  MPU_RGDAACC3_PIDENM0_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC3_PIDENM0_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC3 SMCTRLM1 [9..10]                                                 */
                                 /* MPU_RGDAACC3_SMCTRLM1                                                      */
#define  MPU_RGDAACC3_SMCTRLM1_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC3_SMCTRLM1_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC3_SMCTRLM1_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC3_SMCTRLM1_11                3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                                MPU RGDAACC3 PIDENM1 [11..11]                                                 */
                                 /* MPU_RGDAACC3_PIDENM1                                                       */
#define  MPU_RGDAACC3_PIDENM1_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC3_PIDENM1_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC3 SMCTRLM2 [15..16]                                                */
                                 /* MPU_RGDAACC3_SMCTRLM2                                                      */
#define  MPU_RGDAACC3_SMCTRLM2_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC3_SMCTRLM2_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC3_SMCTRLM2_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC3_SMCTRLM2_11                3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                                MPU RGDAACC3 SMCTRLM3 [21..22]                                                */
                                 /* MPU_RGDAACC3_SMCTRLM3                                                      */
#define  MPU_RGDAACC3_SMCTRLM3_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC3_SMCTRLM3_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC3_SMCTRLM3_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC3_SMCTRLM3_11                3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                 MPU RGDAACC3 WENM4 [24..24]                                                  */
                                 /* MPU_RGDAACC3_WENM4                                                         */
#define  MPU_RGDAACC3_WENM4_0                    0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                       write is not performed                                                    */
#define  MPU_RGDAACC3_WENM4_1                    1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                 MPU RGDAACC3 RENM4 [25..25]                                                  */
                                 /* MPU_RGDAACC3_RENM4                                                         */
#define  MPU_RGDAACC3_RENM4_0                    0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                         read is not performed                                                     */
#define  MPU_RGDAACC3_RENM4_1                    1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                 MPU RGDAACC3 WENM5 [26..26]                                                  */
                                 /* MPU_RGDAACC3_WENM5                                                         */
#define  MPU_RGDAACC3_WENM5_0                    0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                       write is not performed                                                    */
#define  MPU_RGDAACC3_WENM5_1                    1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                 MPU RGDAACC3 RENM5 [27..27]                                                  */
                                 /* MPU_RGDAACC3_RENM5                                                         */
#define  MPU_RGDAACC3_RENM5_0                    0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                        read is not performed                                                     */
#define  MPU_RGDAACC3_RENM5_1                    1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                 MPU RGDAACC3 WENM6 [28..28]                                                  */
                                 /* MPU_RGDAACC3_WENM6                                                         */
#define  MPU_RGDAACC3_WENM6_0                    0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                        write is not performed                                                    */
#define  MPU_RGDAACC3_WENM6_1                    1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                 MPU RGDAACC3 RENM6 [29..29]                                                  */
                                 /* MPU_RGDAACC3_RENM6                                                         */
#define  MPU_RGDAACC3_RENM6_0                    0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                   read is not performed                                                     */
#define  MPU_RGDAACC3_RENM6_1                    1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                 MPU RGDAACC3 WENM7 [30..30]                                                  */
                                 /* MPU_RGDAACC3_WENM7                                                         */
#define  MPU_RGDAACC3_WENM7_0                    0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_RGDAACC3_WENM7_1                    1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                 MPU RGDAACC3 RENM7 [31..31]                                                  */
                                 /* MPU_RGDAACC3_RENM7                                                         */
#define  MPU_RGDAACC3_RENM7_0                    0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                   read is not performed                                                     */
#define  MPU_RGDAACC3_RENM7_1                    1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                          RGDAACC4                                                           */
/*                                                 MPU RGDAACC4 SMCTRLM0 [3..4]                                                 */
                                 /* MPU_RGDAACC4_SMCTRLM0                                                      */
#define  MPU_RGDAACC4_SMCTRLM0_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC4_SMCTRLM0_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC4_SMCTRLM0_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC4_SMCTRLM0_11                3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                 MPU RGDAACC4 PIDENM0 [5..5]                                                  */
                                 /* MPU_RGDAACC4_PIDENM0                                                       */
#define  MPU_RGDAACC4_PIDENM0_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC4_PIDENM0_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC4 SMCTRLM1 [9..10]                                                 */
                                 /* MPU_RGDAACC4_SMCTRLM1                                                      */
#define  MPU_RGDAACC4_SMCTRLM1_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC4_SMCTRLM1_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC4_SMCTRLM1_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC4_SMCTRLM1_11                3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                                MPU RGDAACC4 PIDENM1 [11..11]                                                 */
                                 /* MPU_RGDAACC4_PIDENM1                                                       */
#define  MPU_RGDAACC4_PIDENM1_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC4_PIDENM1_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC4 SMCTRLM2 [15..16]                                                */
                                 /* MPU_RGDAACC4_SMCTRLM2                                                      */
#define  MPU_RGDAACC4_SMCTRLM2_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC4_SMCTRLM2_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC4_SMCTRLM2_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC4_SMCTRLM2_11                3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                                MPU RGDAACC4 SMCTRLM3 [21..22]                                                */
                                 /* MPU_RGDAACC4_SMCTRLM3                                                      */
#define  MPU_RGDAACC4_SMCTRLM3_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC4_SMCTRLM3_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC4_SMCTRLM3_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC4_SMCTRLM3_11                3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                 MPU RGDAACC4 WENM4 [24..24]                                                  */
                                 /* MPU_RGDAACC4_WENM4                                                         */
#define  MPU_RGDAACC4_WENM4_0                    0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                    write is not performed                                                    */
#define  MPU_RGDAACC4_WENM4_1                    1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                 MPU RGDAACC4 RENM4 [25..25]                                                  */
                                 /* MPU_RGDAACC4_RENM4                                                         */
#define  MPU_RGDAACC4_RENM4_0                    0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                   read is not performed                                                     */
#define  MPU_RGDAACC4_RENM4_1                    1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                 MPU RGDAACC4 WENM5 [26..26]                                                  */
                                 /* MPU_RGDAACC4_WENM5                                                         */
#define  MPU_RGDAACC4_WENM5_0                    0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_RGDAACC4_WENM5_1                    1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                 MPU RGDAACC4 RENM5 [27..27]                                                  */
                                 /* MPU_RGDAACC4_RENM5                                                         */
#define  MPU_RGDAACC4_RENM5_0                    0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                   read is not performed                                                     */
#define  MPU_RGDAACC4_RENM5_1                    1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                 MPU RGDAACC4 WENM6 [28..28]                                                  */
                                 /* MPU_RGDAACC4_WENM6                                                         */
#define  MPU_RGDAACC4_WENM6_0                    0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                write is not performed                                                    */
#define  MPU_RGDAACC4_WENM6_1                    1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                 MPU RGDAACC4 RENM6 [29..29]                                                  */
                                 /* MPU_RGDAACC4_RENM6                                                         */
#define  MPU_RGDAACC4_RENM6_0                    0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                   read is not performed                                                     */
#define  MPU_RGDAACC4_RENM6_1                    1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                 MPU RGDAACC4 WENM7 [30..30]                                                  */
                                 /* MPU_RGDAACC4_WENM7                                                         */
#define  MPU_RGDAACC4_WENM7_0                    0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                        write is not performed                                                    */
#define  MPU_RGDAACC4_WENM7_1                    1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                 MPU RGDAACC4 RENM7 [31..31]                                                  */
                                 /* MPU_RGDAACC4_RENM7                                                         */
#define  MPU_RGDAACC4_RENM7_0                    0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                        read is not performed                                                     */
#define  MPU_RGDAACC4_RENM7_1                    1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                          RGDAACC5                                                           */
/*                                                 MPU RGDAACC5 SMCTRLM0 [3..4]                                                 */
                                 /* MPU_RGDAACC5_SMCTRLM0                                                      */
#define  MPU_RGDAACC5_SMCTRLM0_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC5_SMCTRLM0_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC5_SMCTRLM0_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC5_SMCTRLM0_11                3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                 MPU RGDAACC5 PIDENM0 [5..5]                                                  */
                                 /* MPU_RGDAACC5_PIDENM0                                                       */
#define  MPU_RGDAACC5_PIDENM0_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC5_PIDENM0_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC5 SMCTRLM1 [9..10]                                                 */
                                 /* MPU_RGDAACC5_SMCTRLM1                                                      */
#define  MPU_RGDAACC5_SMCTRLM1_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC5_SMCTRLM1_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC5_SMCTRLM1_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC5_SMCTRLM1_11                3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                                MPU RGDAACC5 PIDENM1 [11..11]                                                 */
                                 /* MPU_RGDAACC5_PIDENM1                                                       */
#define  MPU_RGDAACC5_PIDENM1_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC5_PIDENM1_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC5 SMCTRLM2 [15..16]                                                */
                                 /* MPU_RGDAACC5_SMCTRLM2                                                      */
#define  MPU_RGDAACC5_SMCTRLM2_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC5_SMCTRLM2_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC5_SMCTRLM2_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC5_SMCTRLM2_11                3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                                MPU RGDAACC5 SMCTRLM3 [21..22]                                                */
                                 /* MPU_RGDAACC5_SMCTRLM3                                                      */
#define  MPU_RGDAACC5_SMCTRLM3_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC5_SMCTRLM3_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC5_SMCTRLM3_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC5_SMCTRLM3_11                3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                 MPU RGDAACC5 WENM4 [24..24]                                                  */
                                 /* MPU_RGDAACC5_WENM4                                                         */
#define  MPU_RGDAACC5_WENM4_0                    0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                        write is not performed                                                    */
#define  MPU_RGDAACC5_WENM4_1                    1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                 MPU RGDAACC5 RENM4 [25..25]                                                  */
                                 /* MPU_RGDAACC5_RENM4                                                         */
 #define MPU_RGDAACC5_RENM4_0                    0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                       read is not performed                                                     */
 #define MPU_RGDAACC5_RENM4_1                    1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                 MPU RGDAACC5 WENM5 [26..26]                                                  */
                                 /* MPU_RGDAACC5_WENM5                                                         */
#define  MPU_RGDAACC5_WENM5_0                    0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                       write is not performed                                                    */
#define  MPU_RGDAACC5_WENM5_1                    1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                 MPU RGDAACC5 RENM5 [27..27]                                                  */
                                 /* MPU_RGDAACC5_RENM5                                                         */
#define  MPU_RGDAACC5_RENM5_0                    0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                read is not performed                                                     */
#define  MPU_RGDAACC5_RENM5_1                    1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                 MPU RGDAACC5 WENM6 [28..28]                                                  */
                                 /* MPU_RGDAACC5_WENM6                                                         */
#define  MPU_RGDAACC5_WENM6_0                    0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                      write is not performed                                                    */
#define  MPU_RGDAACC5_WENM6_1                    1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                 MPU RGDAACC5 RENM6 [29..29]                                                  */
                                 /* MPU_RGDAACC5_RENM6                                                         */
#define  MPU_RGDAACC5_RENM6_0                    0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                     read is not performed                                                     */
#define  MPU_RGDAACC5_RENM6_1                    1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                 MPU RGDAACC5 WENM7 [30..30]                                                  */
                                 /* MPU_RGDAACC5_WENM7                                                         */
#define  MPU_RGDAACC5_WENM7_0                    0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                     write is not performed                                                    */
#define  MPU_RGDAACC5_WENM7_1                    1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                 MPU RGDAACC5 RENM7 [31..31]                                                  */
                                 /* MPU_RGDAACC5_RENM7                                                         */
#define  MPU_RGDAACC5_RENM7_0                    0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                  read is not performed                                                     */
#define  MPU_RGDAACC5_RENM7_1                    1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                          RGDAACC6                                                           */
/*                                                 MPU RGDAACC6 SMCTRLM0 [3..4]                                                 */
                                 /* MPU_RGDAACC6_SMCTRLM0                                                      */
#define  MPU_RGDAACC6_SMCTRLM0_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC6_SMCTRLM0_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC6_SMCTRLM0_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC6_SMCTRLM0_11                3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                 MPU RGDAACC6 PIDENM0 [5..5]                                                  */
                                 /* MPU_RGDAACC6_PIDENM0                                                       */
#define  MPU_RGDAACC6_PIDENM0_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC6_PIDENM0_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC6 SMCTRLM1 [9..10]                                                 */
                                 /* MPU_RGDAACC6_SMCTRLM1                                                      */
#define  MPU_RGDAACC6_SMCTRLM1_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC6_SMCTRLM1_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC6_SMCTRLM1_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC6_SMCTRLM1_11                3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                                MPU RGDAACC6 PIDENM1 [11..11]                                                 */
                                 /* MPU_RGDAACC6_PIDENM1                                                       */
#define  MPU_RGDAACC6_PIDENM1_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC6_PIDENM1_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC6 SMCTRLM2 [15..16]                                                */
                                 /* MPU_RGDAACC6_SMCTRLM2                                                      */
#define  MPU_RGDAACC6_SMCTRLM2_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC6_SMCTRLM2_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC6_SMCTRLM2_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC6_SMCTRLM2_11                3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                                MPU RGDAACC6 SMCTRLM3 [21..22]                                                */
                                 /* MPU_RGDAACC6_SMCTRLM3                                                      */
#define  MPU_RGDAACC6_SMCTRLM3_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC6_SMCTRLM3_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC6_SMCTRLM3_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC6_SMCTRLM3_11                3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                 MPU RGDAACC6 WENM4 [24..24]                                                  */
                                 /* MPU_RGDAACC6_WENM4                                                         */
#define  MPU_RGDAACC6_WENM4_0                    0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_RGDAACC6_WENM4_1                    1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                 MPU RGDAACC6 RENM4 [25..25]                                                  */
                                 /* MPU_RGDAACC6_RENM4                                                         */
#define  MPU_RGDAACC6_RENM4_0                    0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                        read is not performed                                                     */
#define  MPU_RGDAACC6_RENM4_1                    1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                 MPU RGDAACC6 WENM5 [26..26]                                                  */
                                 /* MPU_RGDAACC6_WENM5                                                         */
#define  MPU_RGDAACC6_WENM5_0                    0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                    write is not performed                                                    */
#define  MPU_RGDAACC6_WENM5_1                    1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                 MPU RGDAACC6 RENM5 [27..27]                                                  */
                                 /* MPU_RGDAACC6_RENM5                                                         */
#define  MPU_RGDAACC6_RENM5_0                    0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_RGDAACC6_RENM5_1                    1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                 MPU RGDAACC6 WENM6 [28..28]                                                  */
                                 /* MPU_RGDAACC6_WENM6                                                         */
#define  MPU_RGDAACC6_WENM6_0                    0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_RGDAACC6_WENM6_1                    1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                 MPU RGDAACC6 RENM6 [29..29]                                                  */
                                 /* MPU_RGDAACC6_RENM6                                                         */
#define  MPU_RGDAACC6_RENM6_0                    0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_RGDAACC6_RENM6_1                    1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                 MPU RGDAACC6 WENM7 [30..30]                                                  */
                                 /* MPU_RGDAACC6_WENM7                                                         */
#define  MPU_RGDAACC6_WENM7_0                    0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                write is not performed                                                    */
#define  MPU_RGDAACC6_WENM7_1                    1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                 MPU RGDAACC6 RENM7 [31..31]                                                  */
                                 /* MPU_RGDAACC6_RENM7                                                         */
#define  MPU_RGDAACC6_RENM7_0                    0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                    read is not performed                                                     */
#define  MPU_RGDAACC6_RENM7_1                    1U     /* 1 : Bus master 7 reads allowed                                            */


/*                                                          RGDAACC7                                                           */
/*                                                 MPU RGDAACC7 SMCTRLM0 [3..4]                                                 */
                                 /* MPU_RGDAACC7_SMCTRLM0                                                      */
#define  MPU_RGDAACC7_SMCTRLM0_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC7_SMCTRLM0_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC7_SMCTRLM0_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC7_SMCTRLM0_11                3U     /* 11 : Same as User mode defined in M0UM                                    */


/*                                                 MPU RGDAACC7 PIDENM0 [5..5]                                                  */
                                 /* MPU_RGDAACC7_PIDENM0                                                       */
#define  MPU_RGDAACC7_PIDENM0_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC7_PIDENM0_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC7 SMCTRLM1 [9..10]                                                 */
                                 /* MPU_RGDAACC7_SMCTRLM1                                                      */
#define  MPU_RGDAACC7_SMCTRLM1_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC7_SMCTRLM1_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC7_SMCTRLM1_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC7_SMCTRLM1_11                3U     /* 11 : Same as User mode defined in M1UM                                    */


/*                                                MPU RGDAACC7 PIDENM1 [11..11]                                                 */
                                 /* MPU_RGDAACC7_PIDENM1                                                       */
#define  MPU_RGDAACC7_PIDENM1_0                  0U     /* 0 : Do not include the process identifier in the evaluation               */
#define  MPU_RGDAACC7_PIDENM1_1                  1U     /* 1 : Include the process identifier and mask (RGDn.RGDAACC) in
                                                     the region hit evaluation                                                 */


/*                                                MPU RGDAACC7 SMCTRLM2 [15..16]                                                */
                                 /* MPU_RGDAACC7_SMCTRLM2                                                      */
#define  MPU_RGDAACC7_SMCTRLM2_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC7_SMCTRLM2_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC7_SMCTRLM2_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC7_SMCTRLM2_11                3U     /* 11 : Same as User mode defined in M2UM                                    */


/*                                                MPU RGDAACC7 SMCTRLM3 [21..22]                                                */
                                 /* MPU_RGDAACC7_SMCTRLM3                                                      */
#define  MPU_RGDAACC7_SMCTRLM3_0                 0U     /* 0 : r/w/x; readU write and execute allowed                                */
#define  MPU_RGDAACC7_SMCTRLM3_1                 1U     /* 1 : r/x; read and execute allowedU but no write                           */
#define  MPU_RGDAACC7_SMCTRLM3_10                2U     /* 10 : r/w; read and write allowedU but no execute                          */
#define  MPU_RGDAACC7_SMCTRLM3_11                3U     /* 11 : Same as User mode defined in M3UM                                    */


/*                                                 MPU RGDAACC7 WENM4 [24..24]                                                  */
                                 /* MPU_RGDAACC7_WENM4                                                         */
#define  MPU_RGDAACC7_WENM4_0                    0U     /* 0 : Bus master 4 writes terminate with an access error and the
                                                        write is not performed                                                    */
#define  MPU_RGDAACC7_WENM4_1                    1U     /* 1 : Bus master 4 writes allowed                                           */


/*                                                 MPU RGDAACC7 RENM4 [25..25]                                                  */
                                 /* MPU_RGDAACC7_RENM4                                                         */
#define  MPU_RGDAACC7_RENM4_0                    0U     /* 0 : Bus master 4 reads terminate with an access error and the
                                                       read is not performed                                                     */
#define  MPU_RGDAACC7_RENM4_1                    1U     /* 1 : Bus master 4 reads allowed                                            */


/*                                                 MPU RGDAACC7 WENM5 [26..26]                                                  */
                                 /* MPU_RGDAACC7_WENM5                                                         */
#define  MPU_RGDAACC7_WENM5_0                    0U     /* 0 : Bus master 5 writes terminate with an access error and the
                                                         write is not performed                                                    */
#define  MPU_RGDAACC7_WENM5_1                    1U     /* 1 : Bus master 5 writes allowed                                           */


/*                                                 MPU RGDAACC7 RENM5 [27..27]                                                  */
                                 /* MPU_RGDAACC7_RENM5                                                         */
#define  MPU_RGDAACC7_RENM5_0                    0U     /* 0 : Bus master 5 reads terminate with an access error and the
                                                   read is not performed                                                     */
#define  MPU_RGDAACC7_RENM5_1                    1U     /* 1 : Bus master 5 reads allowed                                            */


/*                                                 MPU RGDAACC7 WENM6 [28..28]                                                  */
                                 /* MPU_RGDAACC7_WENM6                                                         */
#define  MPU_RGDAACC7_WENM6_0                    0U     /* 0 : Bus master 6 writes terminate with an access error and the
                                                      write is not performed                                                    */
#define  MPU_RGDAACC7_WENM6_1                    1U     /* 1 : Bus master 6 writes allowed                                           */


/*                                                 MPU RGDAACC7 RENM6 [29..29]                                                  */
                                 /* MPU_RGDAACC7_RENM6                                                         */
#define  MPU_RGDAACC7_RENM6_0                    0U     /* 0 : Bus master 6 reads terminate with an access error and the
                                                      read is not performed                                                     */
#define  MPU_RGDAACC7_RENM6_1                    1U     /* 1 : Bus master 6 reads allowed                                            */


/*                                                 MPU RGDAACC7 WENM7 [30..30]                                                  */
                                 /* MPU_RGDAACC7_WENM7                                                         */
#define  MPU_RGDAACC7_WENM7_0                    0U     /* 0 : Bus master 7 writes terminate with an access error and the
                                                       write is not performed                                                    */
#define  MPU_RGDAACC7_WENM7_1                    1U     /* 1 : Bus master 7 writes allowed                                           */


/*                                                 MPU RGDAACC7 RENM7 [31..31]                                                  */
                                 /* MPU_RGDAACC7_RENM7                                                         */
#define MPU_RGDAACC7_RENM7_0                     0U     /* 0 : Bus master 7 reads terminate with an access error and the
                                                 read is not performed                                                     */
#define MP_RGDAACC7_RENM7_1                     1U     /* 1 : Bus master 7 reads allowed                                            */




/*                                                                                                                             */
/*                                                            EREP                                                             */
/*                                                                                                                             */

/*                                                            CFG0                                                             */
/*                                                EREP CFG0 UINTNENM1 [26..26]                                                 */
                                 /* EREP_CFG0_UINTNENM1                                                       */
#define  EREP_CFG0_UINTNENM1_0                  0U     /* 0 : Interrupt notification of Memory 1 non-correctable error
                                                      events is disabled.                                                       */
#define  EREP_CFG0_UINTNENM1_1                  1U     /* 1 : Interrupt notification of Memory 1 non-correctable error
                                                        events is enabled.                                                        */


/*                                                EREP CFG0 SCINTNENM1 [27..27]                                                */
                                 /* EREP_CFG0_SCINTNENM1                                                      */
#define  EREP_CFG0_SCINTNENM1_0                 0U     /* 0 : Interrupt notification of Memory 1 single-bit correction
                                                        events is disabled.                                                       */
#define  EREP_CFG0_SCINTNENM1_1                 1U     /* 1 : Interrupt notification of Memory 1 single-bit correction
                                                        events is enabled.                                                        */


/*                                                EREP CFG0 UINTNENM0 [30..30]                                                 */
                                 /* EREP_CFG0_UINTNENM0                                                       */
#define  EREP_CFG0_UINTNENM0_0                  0U     /* 0 : Interrupt notification of Memory 0 non-correctable error
                                                      events is disabled.                                                       */
#define  EREP_CFG0_UINTNENM0_1                  1U     /* 1 : Interrupt notification of Memory 0 non-correctable error
                                                       events is enabled.                                                        */


/*                                                EREP CFG0 SCINTNENM0 [31..31]                                                */
                                 /* EREP_CFG0_SCINTNENM0                                                      */
#define  EREP_CFG0_SCINTNENM0_0                 0U     /* 0 : Interrupt notification of Memory 0 single-bit correction
                                                        events is disabled.                                                       */
#define  EREP_CFG0_SCINTNENM0_1                 1U     /* 1 : Interrupt notification of Memory 0 single-bit correction
                                                       events is enabled.                                                        */


/*                                                             STS0                                                             */
/*                                                  EREP STS0 UEFLGM1 [26..26]                                                  */
                                 /* EREP_SRS0_UEFLGM1                                                          */
#define  EREP_SRS0_UEFLGM1_0                     0U     /* 0 : No non-correctable error event on Memory 1 detected                   */
#define  EREP_SRS0_UEFLGM1_1                     1U     /* 1 : Non-correctable error event on Memory 1 detected                      */


/*                                                 EREP STS0 SBCFLGM1 [27..27]                                                  */
                                 /* EREP_SRS0_SBCFLGM1                                                         */
#define  EREP_SRS0_SBCFLGM1_0                    0U     /* 0 : No single-bit correction event on Memory 1 detected                   */
#define  EREP_SRS0_SBCFLGM1_1                    1U     /* 1 : Single-bit correction event on Memory 1 detected                      */


/*                                                  EREP STS0 UEFLGM0 [30..30]                                                  */
                                 /* EREP_SRS0_UEFLGM0                                                          */
#define  EREP_SRS0_UEFLGM0_0                     0U     /* 0 : No non-correctable error event on Memory 0 detected                   */
#define  EREP_SRS0_UEFLGM0_1                     1U     /* 1 : Non-correctable error event on Memory 0 detected                      */


/*                                                 EREP STS0 SBCFLGM0 [31..31]                                                  */
                                 /* EREP_SRS0_SBCFLGM0                                                         */
#define  EREP_SRS0_SBCFLGM0_0                    0U     /* 0 : No single-bit correction event on Memory 0 detected                   */
#define  EREP_SRS0_SBCFLGM0_1                    1U     /* 1 : Single-bit correction event on Memory 0 detected                      */


/* ========================================================  EADDR0  ========================================================= */
/* ========================================================  EADDR1  ========================================================= */


/* =========================================================================================================================== */
/* ================                                           EINJ                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
/*                                                   EINJ CFG GEINJEN [0..0]                                                   */
                                  /* EINJ_CFG_GEINJEN                                                          */
#define  EINJ_CFG_GEINJEN_0                     0U     /* 0 : Disabled                                                              */
#define  EINJ_CFG_GEINJEN_1                     1U     /* 1 : Enabled                                                               */


/*                                                            CHEN                                                             */
/*                                                EINJ CHEN EINJENCH1 [30..30]                                                 */
                                  /* EINJ_CHEN_EINJENCH1                                                       */
#define  EINJ_CHEN_EINJENCH1_0                  0U     /* 0 : Error injection is disabled on Error Injection Channel 1              */
#define  EINJ_CHEN_EINJENCH1_1                  1U     /* 1 : Error injection is enabled on Error Injection Channel 1               */


/*                                                EINJ CHEN EINJENCH0 [31..31]                                                 */
                                  /* EINJ_CHEN_EINJENCH0                                                       */
#define  EINJ_CHEN_EINJENCH0_0                  0U     /* 0 : Error injection is disabled on Error Injection Channel 0              */
#define  EINJ_CHEN_EINJENCH0_1                  1U     /* 1 : Error injection is enabled on Error Injection Channel 0               */


/* ======================================================  CHD0_WORD0  ======================================================= */
/* ======================================================  CHD0_WORD1  ======================================================= */
/* ======================================================  CHD1_WORD0  ======================================================= */
/* ======================================================  CHD1_WORD1  ======================================================= */


/* =========================================================================================================================== */
/* ================                                           FLASH                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  STS  ========================================================== */
/* ===============================================  FLASH STS PROVFLG [4..4]  ================================================ */
                                  /* FLASH_STS_PROVFLG                                                         */
#define  FLASH_STS_PROVFLG_0                    0U     /* 0 : No protection violation detected                                      */
#define  FLASH_STS_PROVFLG_1                    1U     /* 1 : Protection violation detected                                         */


/* ===============================================  FLASH STS ACCEFLG [5..5]  ================================================ */
                                  /* FLASH_STS_ACCEFLG                                                         */
#define  FLASH_STS_ACCEFLG_0                    0U     /* 0 : No access error detected                                              */
#define  FLASH_STS_ACCEFLG_1                    1U     /* 1 : Access error detected                                                 */


/* ===============================================  FLASH STS COLEFLG [6..6]  ================================================ */
                                  /* FLASH_STS_COLEFLG                                                         */
#define  FLASH_STS_COLEFLG_0                    0U     /* 0 : No collision error detected                                           */
#define  FLASH_STS_COLEFLG_1                    1U     /* 1 : Collision error detected                                              */


/* ==========================================================  CFG  ========================================================== */
/* ==============================================  FLASH CFG ERACMDSUS [4..4]  =============================================== */
                                  /* FLASH_CFG_ERACMDSUS                                                       */
#define  FLASH_CFG_ERACMDSUS_0                  0U     /* 0 : No suspend requested                                                  */
#define  FLASH_CFG_ERACMDSUS_1                  1U     /* 1 : Suspend the current Erase Flash Sector command execution              */


/* ===============================================  FLASH CFG ERAABREQ [5..5]  =============================================== */
                                  /* FLASH_CFG_ERAABREQ                                                        */
#define  FLASH_CFG_ERAABREQ_0                   0U     /* 0 : No request or request complete                                        */


/* ===============================================  FLASH CFG RCOLEIEN [6..6]  =============================================== */
                                  /* FLASH_CFG_RCOLEIEN                                                        */
#define  FLASH_CFG_RCOLEIEN_0                   0U     /* 0 : Read collision error interrupt disabled                               */
#define  FLASH_CFG_RCOLEIEN_1                   1U     /* 1 : Read collision error interrupt enabled. An interrupt request
                                                     is generated whenever an FTFC read collision error is detected
                                                     (see the description of FSTAT[RDCOLERR]).                                 */

/* ===============================================  FLASH CFG CMDCIEN [7..7]  ================================================ */
                                  /* FLASH_CFG_CMDCIEN                                                         */
#define  FLASH_CFG_CMDCIEN_0                    0U     /* 0 : Command complete interrupt disabled                                   */
#define  FLASH_CFG_CMDCIEN_1                    1U     /* 1 : Command complete interrupt enabled. An interrupt request
                                                     is generated whenever the STS[OCIFLG] flag is set.                        */


/* ==========================================================  SEC  ========================================================== */
/* ===============================================  FLASH SEC SECFLG [0..1]  ================================================ */
                                  /* FLASH_SEC_SECFLG                                                         */
#define  FLASH_SEC_SECFLG_10                  2U     /* 10 : MCU security status is unsecure (The standard shipping
                                                         condition of the FTFC is unsecure.)                                       */


/* ===============================================  FLASH SEC FCACCEN [2..3]  ================================================ */
                                  /* FLASH_SEC_FCACCEN                                                         */
#define  FLASH_SEC_FCACCEN_00                   0U     /* 00 : Factory access granted                                               */
#define  FLASH_SEC_FCACCEN_11                   3U     /* 11 : Factory access granted                                               */


/* ================================================  FLASH SEC MERAEN [4..5]  ================================================ */
                                  /* FLASH_SEC_MERAEN                                                          */
#define  FLASH_SEC_MERAEN_00                    0U     /* 00 : Mass erase is enabled                                                */
#define  FLASH_SEC_MERAEN_01                    1U     /* 01 : Mass erase is enabled                                                */
#define  FLASH_SEC_MERAEN_11                    3U     /* 11 : Mass erase is enabled                                                */


/* ==============================================  FLASH SEC BKEYACCEN [6..7]  =============================================== */
                                  /* FLASH_SEC_BKEYACCEN                                                       */
#define  FLASH_SEC_BKEYACCEN_00                 0U     /* 00 : Backdoor key access disabled                                         */
#define  FLASH_SEC_BKEYACCEN_01                 1U     /* 01 : Backdoor key access disabled (preferred KEYEN state to
                                                     disable backdoor key access)                                              */
#define  FLASH_SEC_BKEYACCEN_10                 2U     /* 10 : Backdoor key access enabled                                          */
#define  FLASH_SEC_BKEYACCEN_11                 3U     /* 11 : Backdoor key access disabled                                         */


/* ==========================================================  NOPT  ========================================================== */
/* =======================================================  CCMDDATA3  ======================================================= */
/* =======================================================  CCMDDATA2  ======================================================= */
/* =======================================================  CCMDDATA1  ======================================================= */
/* =======================================================  CCMDDATA0  ======================================================= */
/* =======================================================  CCMDDATA7  ======================================================= */
/* =======================================================  CCMDDATA6  ======================================================= */
/* =======================================================  CCMDDATA5  ======================================================= */
/* =======================================================  CCMDDATA4  ======================================================= */
/* =======================================================  CCMDDATAB  ======================================================= */
/* =======================================================  CCMDDATAA  ======================================================= */
/* =======================================================  CCMDDATA9  ======================================================= */
/* =======================================================  CCMDDATA8  ======================================================= */
/* ========================================================  PFPRO3  ========================================================= */
/* ========================================================  PFPRO2  ========================================================= */
/* ========================================================  PFPRO1  ========================================================= */
/* ========================================================  PFPRO0  ========================================================= */
/* ========================================================  EEPRO  ========================================================= */
/* ========================================================  DFPRO  ======================================================== */
/* =============================================  FLASH DFPRO DFPRO [0..7]  ============================================== */
                                 /* FLASH_DFLASHPRO_DFLASHPRO                                                    */
#define  FLASH_DFLASHPRO_DFLASHPRO_00000000         0U     /* 00000000 : Data Flash region is protected                                 */
#define  FLASH_DFLASHPRO_DFLASHPRO_00000001         1U     /* 00000001 : Data Flash region is not protected                             */


/* ========================================================  CSECSTS  ======================================================== */
/* ========================================================  ESTS  ========================================================= */
/* ==============================================  FLASH ESTS DBFIFLG [1..1]  ============================================== */
                                 /* FLASH_ESTS_DBFIFLG                                                      */
#define  FLASH_ESTS_DBFIFLG_0                 0U     /* 0 : Double bit fault not detected during a valid flash read
                                                        access from the platform flash controller                                 */
#define  FLASH_ESTS_DBFIFLG_1                 1U     /* 1 : Double bit fault detected (or FERCNFG[FDFD] is set) during
                                                       a valid flash read access from the platform flash controller              */


/* ========================================================  ECFG  ========================================================= */
/* ==============================================  FLASH ECFG DBFIEN [1..1]  =============================================== */
                                 /* FLASH_ECFG_DBFIEN                                                       */
#define  FLASH_ECFG_DBFIEN_0                  0U     /* 0 : Double bit fault detect interrupt disabled                            */
#define  FLASH_ECFG_DBFIEN_1                  1U     /* 1 : Double bit fault detect interrupt enabled. An interrupt
                                                     request is generated whenever the FERSTAT[DFDIF] flag is
                                                     set.                                                                      */


/* =============================================  FLASH ECFG EDBFINTD [5..5]  ============================================== */
                                 /* FLASH_ECFG_EDBFINTD                                                     */
#define  FLASH_ECFG_EDBFINTD_0                0U     /* 0 : FERSTAT[DFDIF] sets only if a double bit fault is detected
                                                        during read access from the platform flash controller                     */
#define  FLASH_ECFG_EDBFINTD_1                1U     /* 1 : FERSTAT[DFDIF] sets during any valid flash read access from
                                                       the platform flash controller. An interrupt request is
                                                     generated if the DFDIE bit is set.                                        */




/* =========================================================================================================================== */
/* ================                                          DMACHM                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  CFG  ========================================================= */
/* =============================================  DMACHM CFG PRDTREN [6..6]  ============================================== */
                                 /* DMACHM_CFG_PRDTREN                                                     */
#define  DMACHM_CFG_PRDTREN_0                0U     /* 0 : Triggering is disabled. If triggering is disabled and ENBL
                                                      is setU the DMA Channel will simply route the specified
                                                     source to the DMA channel. (Normal mode)                                  */
#define  DMACHM_CFG_PRDTREN_1                1U     /* 1 : Triggering is enabled. If triggering is enabled and ENBL
                                                        is setU the DMAMUX is in Periodic Trigger mode.                           */


/* ===============================================  DMACHM CFG CHEN [7..7]  =============================================== */
                                 /* DMACHM_CFG_CHEN                                                        */
#define  DMACHM_CFG_CHEN_0                   0U     /* 0 : DMA channel is disabled. This mode is primarily used during
                                                        configuration of the DMAMux. The DMA has separate channel
                                                     enables/disablesU which should be used to disable or reconfigure
                                                     a DMA channel.                                                            */
#define  DMACHM_CFG_CHEN_1                   1U     /* 1 : DMA channel is enabled                                                */




/* =========================================================================================================================== */
/* ================                                           CAN                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  MCFG  ========================================================== */
/* ================================================  CAN MCFG IDFFMT [8..9]  ================================================ */
                                  /* CAN_MCFG_IDFFMT                                                          */
#define  CAN_MCFG_IDFFMT_00                    0U     /* 00 : Format A: One full ID (standard and extended) per ID Filter
                                                     Table element.                                                            */
#define  CAN_MCFG_IDFFMT_01                    1U     /* 01 : Format B: Two full standard IDs or two partial 14-bit (standard
                                                     and extended) IDs per ID Filter Table element.                            */
#define  CAN_MCFG_IDFFMT_10                    2U     /* 10 : Format C: Four partial 8-bit Standard IDs per ID Filter
                                                     Table element.                                                            */
#define  CAN_MCFG_IDFFMT_11                    3U     /* 11 : Format D: All frames rejected.                                       */


/* ==============================================  CAN MCFG CANFDEN [11..11]  =============================================== */
                                  /* CAN_MCFG_CANFDEN                                                         */
#define  CAN_MCFG_CANFDEN_1                    1U     /* 1 : CAN FD is enabled. CAN is able to receive and transmit
                                                     messages in both CAN FD and CAN 2.0 formats.                              */
#define  CAN_MCFG_CANFDEN_0                    0U     /* 0 : CAN FD is disabled. CAN is able to receive and transmit
                                                     messages in CAN 2.0 format.                                               */


/* ================================================  CAN MCFG TAEN [12..12]  ================================================ */
                                  /* CAN_MCFG_TAEN                                                            */
#define  CAN_MCFG_TAEN_0                       0U     /* 0 : Abort disabled.                                                       */
#define  CAN_MCFG_TAEN_1                       1U     /* 1 : Abort enabled.                                                        */


/* ===============================================  CAN MCFG LPRIEN [13..13]  =============================================== */
                                  /* CAN_MCFG_LPRIEN                                                          */
#define  CAN_MCFG_LPRIEN_0                     0U     /* 0 : Local Priority disabled.                                              */
#define  CAN_MCFG_LPRIEN_1                     1U     /* 1 : Local Priority enabled.                                               */


/* ================================================  CAN MCFG PNEN [14..14]  ================================================ */
                                  /* CAN_MCFG_PNEN                                                            */
#define  CAN_MCFG_PNEN_0                       0U     /* 0 : Pretended Networking mode is disabled.                                */
#define  CAN_MCFG_PNEN_1                       1U     /* 1 : Pretended Networking mode is enabled.                                 */


/* =================================                CAN MCFG DMAEN [15..15]                                                   */
                                  /* CAN_MCFG_DMAEN                                                           */
#define  CAN_MCFG_DMAEN_0                      0U     /* 0 : DMA feature for RX FIFO disabled.                                     */
#define  CAN_MCFG_DMAEN_1                      1U     /* 1 : DMA feature for RX FIFO enabled.                                      */


/* ==============================================  CAN MCFG IRXMQEN [16..16]  =============================================== */
                                  /* CAN_MCFG_IRXMQEN                                                         */
#define  CAN_MCFG_IRXMQEN_0                    0U     /* 0 : Individual Rx masking and queue feature are disabled. For
                                                        backward compatibility with legacy applicationsU the reading
                                                     of C/S word locks the MB even if it is EMPTY.                             */
#define  CAN_MCFG_IRXMQEN_1                    1U     /* 1 : Individual Rx masking and queue feature are enabled.                  */


/* ================================================  CAN MCFG SRD [17..17]  ================================================= */
                                  /* CAN_MCFG_SRD                                                             */
#define  CAN_MCFG_SRD_0                        0U     /* 0 : Self reception enabled.                                               */
#define  CAN_MCFG_SRD_1                        1U     /* 1 : Self reception disabled.                                              */


/* ================================================  CAN MCFG LPM [20..20]  ================================================= */
                                  /* CAN_MCFG_LPM                                                             */
#define  CAN_MCFG_LPM_0                        0U     /* 0 : CAN is not in a low-power mode.                                   */
#define  CAN_MCFG_LPM_1                        1U     /* 1 : CAN is in a low-power mode.                                       */


/* ================================================  CAN MCFG WIEN [21..21]  ================================================ */
                                  /* CAN_MCFG_WIEN                                                            */
#define  CAN_MCFG_WIEN_0                       0U     /* 0 : TWRNINT and RWRNINT bits are zeroU independent of the values
                                                         in the error counters.                                                    */
#define  CAN_MCFG_WIEN_1                       1U     /* 1 : TWRNINT and RWRNINT bits are set when the respective error
                                                        counter transitions from less than 96 to greater than or
                                                     equal to 96.                                                              */


/* ===============================================  CAN MCFG FRZFLG [24..24]  =============================================== */
                                  /* CAN_MCFG_FRZFLG                                                          */
#define  CAN_MCFG_FRZFLG_0                     0U     /* 0 : CAN not in Freeze modeU prescaler running.                        */
#define  CAN_MCFG_FRZFLG_1                     1U     /* 1 : CAN in Freeze modeU prescaler stopped.                            */


/* ===============================================  CAN MCFG CANRST [25..25]  =============================================== */
                                  /* CAN_MCFG_CANRST                                                          */
#define  CAN_MCFG_CANRST_0                     0U     /* 0 : No reset request.                                                     */
#define  CAN_MCFG_CANRST_1                     1U     /* 1 : Resets the registers affected by soft reset.                          */


/* ===============================================  CAN MCFG NRDY [27..27]  ================================================ */
                                  /* CAN_MCFG_NRDY                                                           */
#define  CAN_MCFG_NRDY_0                      0U     /* 0 : CAN module is either in Normal modeU Listen-Only mode
                                                     or Loop-Back mode.                                                        */


/* ================================================  CAN MCFG EFRZ [28..28]  ================================================ */
                                  /* CAN_MCFG_EFRZ                                                            */
#define  CAN_MCFG_EFRZ_0                       0U     /* 0 : No Freeze mode request.                                               */
#define  CAN_MCFG_EFRZ_1                       1U     /* 1 : Enters Freeze mode if the FRZ bit is asserted.                        */


/* ===============================================  CAN MCFG FIFOEN [29..29]  =============================================== */
                                  /* CAN_MCFG_FIFOEN                                                          */
#define  CAN_MCFG_FIFOEN_0                     0U     /* 0 : Rx FIFO not enabled.                                                  */
#define  CAN_MCFG_FIFOEN_1                     1U     /* 1 : Rx FIFO enabled.                                                      */


/* ===============================================  CAN MCFG FRZEN [30..30]  ================================================ */
                                  /* CAN_MCFG_FRZEN                                                           */
#define  CAN_MCFG_FRZEN_0                      0U     /* 0 : Not enabled to enter Freeze mode.                                     */
#define  CAN_MCFG_FRZEN_1                      1U     /* 1 : Enabled to enter Freeze mode.                                         */


/* ================================================  CAN MCFG CMD [31..31]  ================================================= */
                                  /* CAN_MCFG_CMD                                                             */
#define  CAN_MCFG_CMD_0                        0U     /* 0 : Enable the CAN module.                                            */
#define  CAN_MCFG_CMD_1                        1U     /* 1 : Disable the CAN module.                                           */


/* =========================================================  CTRL1  ========================================================= */
/* ================================================  CAN CTRL1 PTS [0..0]  ================================================= */
                                  /* CAN_CTRL1_PTS                                                           */
#define  CAN_CTRL1_PTS_0                      0U     /* 0 : the length of the propagation segment in the bit time is 0.    */
#define  CAN_CTRL1_PTS_1                      1U     /* 1 : the length of the propagation segment in the bit time is 1.    */
#define  CAN_CTRL1_PTS_2                      2U     /* 2 : the length of the propagation segment in the bit time is 2.    */
#define  CAN_CTRL1_PTS_3                      3U     /* 4 : the length of the propagation segment in the bit time is 3.    */
#define  CAN_CTRL1_PTS_4                      4U     /* 4 : the length of the propagation segment in the bit time is 4.    */
#define  CAN_CTRL1_PTS_5                      5U     /* 5 : the length of the propagation segment in the bit time is 5.    */
#define  CAN_CTRL1_PTS_6                      6U     /* 6 : the length of the propagation segment in the bit time is 6.    */
#define  CAN_CTRL1_PTS_7                      7U     /* 7 : the length of the propagation segment in the bit time is 7.    */

/* ================================================  CAN CTRL1 LOEN [3..3]  ================================================= */
                                  /* CAN_CTRL1_LOEN                                                           */
#define  CAN_CTRL1_LOEN_0                      0U     /* 0 : Listen-Only mode is deactivated.                                      */
#define  CAN_CTRL1_LOEN_1                      1U     /* 1 : CAN module operates in Listen-Only mode.                          */


/* ================================================  CAN CTRL1 TXLB [4..4]  ================================================= */
                                  /* CAN_CTRL1_TXLB                                                           */
#define  CAN_CTRL1_TXLB_0                      0U     /* 0 : Buffer with highest priority is transmitted first.                    */
#define  CAN_CTRL1_TXLB_1                      1U     /* 1 : Lowest number buffer is transmitted first.                            */


/* ===============================================  CAN CTRL1 TMRSYN [5..5]  ================================================ */
                                  /* CAN_CTRL1_TMRSYN                                                         */
#define  CAN_CTRL1_TMRSYN_0                    0U     /* 0 : Timer Sync feature disabled                                           */
#define  CAN_CTRL1_TMRSYN_1                    1U     /* 1 : Timer Sync feature enabled                                            */


/* ================================================  CAN CTRL1 BORD [6..6]  ================================================= */
                                  /* CAN_CTRL1_BORD                                                           */
#define  CAN_CTRL1_BORD_0                      0U     /* 0 : Automatic recovering from Bus Off state enabled.                      */
#define  CAN_CTRL1_BORD_1                      1U     /* 1 : Automatic recovering from Bus Off state disabled.                     */


/* ================================================  CAN CTRL1 TSEN [7..7]  ================================================= */
                                  /* CAN_CTRL1_TSEN                                                           */
#define  CAN_CTRL1_TSEN_0                      0U     /* 0 : Just one sample is used to determine the bit value.                   */
#define  CAN_CTRL1_TSEN_1                      1U     /* 1 : Three samples are used to determine the value of the received
                                                     bit: the regular one (sample point) and 2 preceding samples;
                                                     a majority rule is used.                                                  */


/* ==============================================  CAN CTRL1 RXWIEN [10..10]  =============================================== */
                                  /* CAN_CTRL1_RXWIEN                                                         */
#define  CAN_CTRL1_RXWIEN_0                    0U     /* 0 : Rx Warning Interrupt disabled.                                        */
#define  CAN_CTRL1_RXWIEN_1                    1U     /* 1 : Rx Warning Interrupt enabled.                                         */


/* ==============================================  CAN CTRL1 TXWIEN [11..11]  =============================================== */
                                  /* CAN_CTRL1_TXWIEN                                                         */
#define  CAN_CTRL1_TXWIEN_0                    0U     /* 0 : Tx Warning Interrupt disabled.                                        */
#define  CAN_CTRL1_TXWIEN_1                    1U     /* 1 : Tx Warning Interrupt enabled.                                         */


/* ===============================================  CAN CTRL1 LBEN [12..12]  ================================================ */
                                  /* CAN_CTRL1_LBEN                                                           */
#define  CAN_CTRL1_LBEN_0                      0U     /* 0 : Loop Back disabled.                                                   */
#define  CAN_CTRL1_LBEN_1                      1U     /* 1 : Loop Back enabled.                                                    */


/* ==============================================  CAN CTRL1 CLKSEL [13..13]  =============================================== */
                                  /* CAN_CTRL1_CLKSEL                                                         */
#define  CAN_CTRL1_CLKSEL_0                    0U     /* 0 : The CAN engine clock source is the oscillator clock. Under
                                                         this conditionU the oscillator clock frequency must be
                                                     lower than the bus clock.                                                 */
#define  CAN_CTRL1_CLKSEL_1                    1U     /* 1 : The CAN engine clock source is the peripheral clock.                  */


/* ===============================================  CAN CTRL1 ERRIEN [14..14]  ================================================ */
                                  /* CAN_CTRL1_ERRIEN                                                           */
#define  CAN_CTRL1_ERRIEN_0                      0U     /* 0 : Error interrupt disabled.                                             */
#define  CAN_CTRL1_ERRIEN_1                      1U     /* 1 : Error interrupt enabled.                                              */


/* ===============================================  CAN CTRL1 BOIEN [15..15]  =============================================== */
                                  /* CAN_CTRL1_BOIEN                                                          */
#define  CAN_CTRL1_BOIEN_0                     0U     /* 0 : Bus Off interrupt disabled.                                           */
#define  CAN_CTRL1_BOIEN_1                     1U     /* 1 : Bus Off interrupt enabled.                                            */

/* ===============================================  CAN CTRL1 PBS2 [16..18]  =============================================== */
                                  /* CAN_CTRL1_PBS2                                                          */
#define  CAN_CTRL1_PBS2_1                     1U     /* 1 : the length of phase segment 2 in the bit time is 1.      */
#define  CAN_CTRL1_PBS2_2                     2U     /* 2 : the length of phase segment 2 in the bit time is 2.      */
#define  CAN_CTRL1_PBS2_3                     3U     /* 3 : the length of phase segment 2 in the bit time is 3.      */
#define  CAN_CTRL1_PBS2_4                     4U     /* 4 : the length of phase segment 2 in the bit time is 4.      */
#define  CAN_CTRL1_PBS2_5                     5U     /* 5 : the length of phase segment 2 in the bit time is 5.      */
#define  CAN_CTRL1_PBS2_6                     6U     /* 6 : the length of phase segment 2 in the bit time is 6.      */
#define  CAN_CTRL1_PBS2_7                     7U     /* 7 : the length of phase segment 2 in the bit time is 7.      */

/* ===============================================  CAN CTRL1 PBS1 [19..21]  =============================================== */
                                  /* CAN_CTRL1_PBS1                                                          */
#define  CAN_CTRL1_PBS1_0                     0U     /* 0 : the length of phase segment 1 in the bit time is 0.      */
#define  CAN_CTRL1_PBS1_1                     1U     /* 1 : the length of phase segment 1 in the bit time is 1.      */
#define  CAN_CTRL1_PBS1_2                     2U     /* 2 : the length of phase segment 1 in the bit time is 2.      */
#define  CAN_CTRL1_PBS1_3                     3U     /* 3 : the length of phase segment 1 in the bit time is 3.      */
#define  CAN_CTRL1_PBS1_4                     4U     /* 4 : the length of phase segment 1 in the bit time is 4.      */
#define  CAN_CTRL1_PBS1_5                     5U     /* 5 : the length of phase segment 1 in the bit time is 5.      */
#define  CAN_CTRL1_PBS1_6                     6U     /* 6 : the length of phase segment 1 in the bit time is 6.      */
#define  CAN_CTRL1_PBS1_7                     7U     /* 7 : the length of phase segment 1 in the bit time is 7.      */

/* ===============================================  CAN CTRL1 SJW [22..23]  =============================================== */
                                  /* CAN_CTRL1_SJW                                                          */
#define  CAN_CTRL1_SJW_0                     0U     /* 0 :  the maximum number of time quanta  is 0.      */
#define  CAN_CTRL1_SJW_1                     1U     /* 1 :  the maximum number of time quanta  is 1.      */
#define  CAN_CTRL1_SJW_2                     2U     /* 2 :  the maximum number of time quanta  is 2.      */
#define  CAN_CTRL1_SJW_3                     3U     /* 3 :  the maximum number of time quanta  is 3.      */

/* =========================================================  FRTMR  ========================================================= */
/* =======================================================  RXMASK  ======================================================== */
/* =======================================================  RX14MASK  ======================================================== */
/* =======================================================  RX15MASK  ======================================================== */
/* ========================================================  ERRCNT  ========================================================= */
/* ========================================================  ERRFLG1  ======================================================== */
/* ==============================================  CAN ERRFLG1 ERRFLG [1..1]  =============================================== */
                                 /* CAN_ERRFLG1_ERRFLG                                                       */
#define CAN_ERRFLG1_ERRFLG_0                   0U     /* 0 : No such occurrence.                                                   */
#define CAN_ERRFLG1_ERRFLG_1                   1U     /* 1 : Indicates setting of any Error Bit in the Error and Status
                                                     Register.                                                                 */


/* ===============================================  CAN ERRFLG1 BOFLG [2..2]  =============================================== */
                                 /* CAN_ERRFLG1_BOFLG                                                        */
#define  CAN_ERRFLG1_BOFLG_0                   0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_BOFLG_1                   1U     /* 1 : CAN module entered Bus Off state.                                 */


/* =========                                        CAN ERRFLG1 RXFLG [3..3]                                                  */
                                 /* CAN_ERRFLG1_RXFLG                                                        */
#define  CAN_ERRFLG1_RXFLG_0                   0U     /* 0 : CAN is not receiving a message.                                   */
#define  CAN_ERRFLG1_RXFLG_1                   1U     /* 1 : CAN is receiving a message.                                       */


/* ===============================================  CAN ERRFLG1 FCFLG [4..5]  ================================================ */
                                 /* CAN_ERRFLG1_FCFLG                                                         */
#define  CAN_ERRFLG1_FCFLG_00                   0U     /* 00 : Error Active                                                         */
#define  CAN_ERRFLG1_FCFLG_01                   1U     /* 01 : Error Passive                                                        */
#define  CAN_ERRFLG1_FCFLG_1x_2                 2U     /* 1x_2 : Bus Off                                                            */
#define  CAN_ERRFLG1_FCFLG_1x_3                 3U     /* 1x_3 : Bus Off                                                            */


/* ===============================================  CAN ERRFLG1 TXFLG [6..6]  =============================================== */
                                 /* CAN_ERRFLG1_TXFLG                                                        */
#define  CAN_ERRFLG1_TXFLG_0                   0U     /* 0 : CAN is not transmitting a message.                                */
#define  CAN_ERRFLG1_TXFLG_1                   1U     /* 1 : CAN is transmitting a message.                                    */


/* ===============================================  CAN ERRFLG1 BIDLEFLG [7..7]  =============================================== */
                                 /* CAN_ERRFLG1_BIDLEFLG                                                        */
#define  CAN_ERRFLG1_BIDLEFLG_0                   0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_BIDLEFLG_1                   1U     /* 1 : CAN bus is now IDLE.                                                  */


/* ===============================================  CAN ERRFLG1 RXERRWFLG [8..8]  ================================================ */
                                 /* CAN_ERRFLG1_RXERRWFLG                                                         */
#define  CAN_ERRFLG1_RXERRWFLG_0                    0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_RXERRWFLG_1                    1U     /* 1 : RXERRCNT is greater than or equal to 96.                              */


/* ===============================================  CAN ERRFLG1 TXERRWFLG [9..9]  ================================================ */
                                 /* CAN_ERRFLG1_TXERRWFLG                                                         */
#define  CAN_ERRFLG1_TXERRWFLG_0                    0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_TXERRWFLG_1                    1U     /* 1 : TXERRCNT is greater than or equal to 96.                              */


/* =============================================  CAN ERRFLG1 SERRFLG [10..10]  ============================================= */
                                 /* CAN_ERRFLG1_SERRFLG                                                      */
#define  CAN_ERRFLG1_SERRFLG_0                 0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_SERRFLG_1                 1U     /* 1 : A Stuffing Error occurred since last read of this register.           */


/* =============================================  CAN ERRFLG1 FERRFLG [11..11]  ============================================= */
                                 /* CAN_ERRFLG1_FERRFLG                                                      */
#define  CAN_ERRFLG1_FERRFLG_0                 0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_FERRFLG_1                 1U     /* 1 : A Form Error occurred since last read of this register.               */


/* ============================================  CAN ERRFLG1 CRCERRFLG [12..12]  ============================================ */
                                 /* CAN_ERRFLG1_CRCERRFLG                                                    */
#define  CAN_ERRFLG1_CRCERRFLG_0               0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_CRCERRFLG_1               1U     /* 1 : A CRC error occurred since last read of this register.                */


/* ============================================  CAN ERRFLG1 ACKERRFLG [13..13]  ============================================ */
                                 /* CAN_ERRFLG1_ACKERRFLG                                                    */
#define  CAN_ERRFLG1_ACKERRFLG_0               0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_ACKERRFLG_1               1U     /* 1 : An ACK error occurred since last read of this register.               */


/* ============================================  CAN ERRFLG1 B0ERRFLG [14..14]  ============================================= */
                                 /* CAN_ERRFLG1_B0ERRFLG                                                     */
#define  CAN_ERRFLG1_B0ERRFLG_0                0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_B0ERRFLG_1                1U     /* 1 : At least one bit sent as dominant is received as recessive.           */


/* ============================================  CAN ERRFLG1 B1ERRFLG [15..15]  ============================================= */
                                 /* CAN_ERRFLG1_B1ERRFLG                                                     */
#define  CAN_ERRFLG1_B1ERRFLG_0                0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_B1ERRFLG_1                1U     /* 1 : At least one bit sent as recessive is received as dominant.           */


/* =============================================  CAN ERRFLG1 RXWINTFLG [16..16]  ============================================== */
                                 /* CAN_ERRFLG1_RXWINTFLG                                                       */
#define  CAN_ERRFLG1_RXWINTFLG_0                  0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_RXWINTFLG_1                  1U     /* 1 : The Rx error counter transitioned from less than 96 to greater
                                                     than or equal to 96.                                                      */


/* =============================================  CAN ERRFLG1 TXWINTFLG [17..17]  ============================================== */
                                 /* CAN_ERRFLG1_TXWINTFLG                                                       */
#define  CAN_ERRFLG1_TXWINTFLG_0                  0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_TXWINTFLG_1                  1U     /* 1 : The Tx error counter transitioned from less than 96 to greater
                                                     than or equal to 96.                                                      */


/* ==============================================  CAN ERRFLG1 BSYNFLG [18..18]  =============================================== */
                                 /* CAN_ERRFLG1_BSYNFLG                                                         */
#define  CAN_ERRFLG1_BSYNFLG_0                    0U     /* 0 : CAN is not synchronized to the CAN bus.                           */
#define  CAN_ERRFLG1_BSYNFLG_1                    1U     /* 1 : CAN is synchronized to the CAN bus.                               */


/* =============================================  CAN ERRFLG1 BOCINTFLG [19..19]  ============================================== */
                                 /* CAN_ERRFLG1_BOCINTFLG                                                       */
#define  CAN_ERRFLG1_BOCINTFLG_0                  0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_BOCINTFLG_1                  1U     /* 1 : CAN module has completed Bus Off process.                         */


/* ============================================  CAN ERRFLG1 FDERRFLG [20..20]  ============================================= */
                                 /* CAN_ERRFLG1_FDERRFLG                                                     */
#define  CAN_ERRFLG1_FDERRFLG_0                0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_FDERRFLG_1                1U     /* 1 : Indicates setting of any Error Bit detected in the Data
                                                     Phase of CAN FD frames with the BRS bit set.                              */


/* =============================================  CAN ERRFLG1 OVRFLG [21..21]  ============================================== */
                                 /* CAN_ERRFLG1_OVRFLG                                                       */
#define  CAN_ERRFLG1_OVRFLG_0                  0U     /* 0 : Overrun has not occurred.                                             */
#define  CAN_ERRFLG1_OVRFLG_1                  1U     /* 1 : Overrun has occurred.                                                 */


/* ============================================  CAN ERRFLG1 FDSERRFLG [26..26]  ============================================ */
                                 /* CAN_ERRFLG1_FDSERRFLG                                                    */
#define  CAN_ERRFLG1_FDSERRFLG_0               0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_FDSERRFLG_1               1U     /* 1 : A Stuffing Error occurred since last read of this register.           */


/* ============================================  CAN ERRFLG1 FDFERRFLG [27..27]  ============================================ */
                                 /* CAN_ERRFLG1_FDFERRFLG                                                    */
#define  CAN_ERRFLG1_FDFERRFLG_0               0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_FDFERRFLG_1               1U     /* 1 : A Form Error occurred since last read of this register.               */


/* ===========================================  CAN ERRFLG1 FDCRCERRFLG [28..28]  =========================================== */
                                 /* CAN_ERRFLG1_FDCRCERRFLG                                                  */
#define  CAN_ERRFLG1_FDCRCERRFLG_0             0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_FDCRCERRFLG_1             1U     /* 1 : A CRC error occurred since last read of this register.                */


/* ===========================================  CAN ERRFLG1 FDB0ERRFLG [30..30]  ============================================ */
                                 /* CAN_ERRFLG1_FDB0ERRFLG                                                   */
#define  CAN_ERRFLG1_FDB0ERRFLG_0              0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_FDB0ERRFLG_1              1U     /* 1 : At least one bit sent as dominant is received as recessive.           */


/* ===========================================  CAN ERRFLG1 FDB1ERRFLG [31..31]  ============================================ */
                                 /* CAN_ERRFLG1_FDB1ERRFLG                                                   */
#define  CAN_ERRFLG1_FDB1ERRFLG_0              0U     /* 0 : No such occurrence.                                                   */
#define  CAN_ERRFLG1_FDB1ERRFLG_1              1U     /* 1 : At least one bit sent as recessive is received as dominant.           */


/* =========================================================  MBiIEN  ========================================================= */
/* =========================================================  IFLG  ========================================================== */
/* ================================================  CAN IFLG MB0INT [0..0]  ================================================ */
                                 /* CAN_IFLG_MB0INT                                                          */
#define  CAN_IFLG_MB0INT_0                     0U     /* 0 : The corresponding buffer has no occurrence of successfully
                                                 completed transmission or reception when MCR[RFEN] 0.                     */
#define  CAN_IFLG_MB0INT_1                     1U     /* 1 : The corresponding buffer has successfully completed transmission
                                                       or reception when MCR[RFEN] 0.                                            */


/* ================================================  CAN IFLG MB5INT [5..5]  ================================================ */
                                 /* CAN_IFLG_MB5INT                                                          */
#define  CAN_IFLG_MB5INT_0                     0U     /* 0 : No occurrence of MB5 completing transmission/reception when
                                                 MCR[RFEN] 0U or of frame(s) available in the FIFOU when
                                                     MCR[RFEN] 1                                                               */
#define  CAN_IFLG_MB5INT_1                     1U     /* 1 : MB5 completed transmission/reception when MCR[RFEN] 0U or
                                                 frame(s) available in the Rx FIFO when MCR[RFEN] 1. It
                                                     generates a DMA request in case of MCR[RFEN] and MCR[DMA]
                                                     are enabled.                                                              */


/* ================================================  CAN IFLG MB6INT [6..6]  ================================================ */
                                 /* CAN_IFLG_MB6INT                                                          */
#define  CAN_IFLG_MB6INT_0                     0U     /* 0 : No occurrence of MB6 completing transmission/reception when
                                                        MCR[RFEN] 0U or of Rx FIFO almost full when MCR[RFEN] 1                   */
#define  CAN_IFLG_MB6INT_1                     1U     /* 1 : MB6 completed transmission/reception when MCR[RFEN] 0U or
                                                         Rx FIFO almost full when MCR[RFEN] 1                                      */


/* ================================================  CAN IFLG MB7INT [7..7]  ================================================ */
                                 /* CAN_IFLG_MB7INT                                                          */
#define  CAN_IFLG_MB7INT_0                     0U     /* 0 : No occurrence of MB7 completing transmission/reception when
                                                       MCR[RFEN] 0U or of Rx FIFO overflow when MCR[RFEN] 1                      */
#define  CAN_IFLG_MB7INT_1                     1U     /* 1 : MB7 completed transmission/reception when MCR[RFEN] 0U or
                                                      Rx FIFO overflow when MCR[RFEN] 1                                         */


/* =========================================================  CTRL2  ========================================================= */
/* ================================================  CAN CTRL2 EFD [11..11]  ================================================ */
                                 /* CAN_CTRL2_EFD                                                            */
#define  CAN_CTRL2_EFD_0                       0U     /* 0 : Edge Filter is enabled.                                               */
#define  CAN_CTRL2_EFD_1                       1U     /* 1 : Edge Filter is disabled.                                              */


/* ==============================================  CAN CTRL2 ISOFDEN [12..12]  ============================================== */
                                 /* CAN_CTRL2_ISOFDEN                                                        */
#define  CAN_CTRL2_ISOFDEN_0                   0U     /* 0 : CAN operates using the non-ISO CAN FD protocol.                   */
#define  CAN_CTRL2_ISOFDEN_1                   1U     /* 1 : CAN operates using the ISO CAN FD protocol (ISO 11898-1).         */


/* ===============================================  CAN CTRL2 PEEN [14..14]  ================================================ */
                                 /* CAN_CTRL2_PEEN                                                           */
#define  CAN_CTRL2_PEEN_0                      0U     /* 0 : Protocol Exception is disabled.                                       */
#define  CAN_CTRL2_PEEN_1                      1U     /* 1 : Protocol Exception is enabled.                                        */


/* ==============================================  CAN CTRL2 TMRSRC [15..15]  =============================================== */
                                 /* CAN_CTRL2_TMRSRC                                                         */
#define  CAN_CTRL2_TMRSRC_0                    0U     /* 0 : The Free Running Timer is clocked by the CAN bit clockU
                                                      which defines the baud rate on the CAN bus.                               */
#define  CAN_CTRL2_TMRSRC_1                    1U     /* 1 : The Free Running Timer is clocked by an external time tick.
                                                      The period can be either adjusted to be equal to the baud
                                                     rate on the CAN busU or a different value as required.
                                                     See the device specific section for details about the external
                                                     time tick.                                                                */


/* ===============================================  CAN CTRL2 CMPEN [16..16]  =============================================== */
                                 /* CAN_CTRL2_CMPEN                                                          */
#define  CAN_CTRL2_CMPEN_0                     0U     /* 0 : Rx Mailbox filters IDE bit is always compared and RTR is
                                                      never compared despite mask bits.                                         */
#define  CAN_CTRL2_CMPEN_1                     1U     /* 1 : Enables the comparison of both Rx Mailbox filters IDE and
                                                        RTR bit with their corresponding bits within the incoming
                                                     frame. Mask bits do apply.                                                */


/* ================================================  CAN CTRL2 RFS [17..17]  ================================================ */
                                 /* CAN_CTRL2_RFS                                                            */
#define  CAN_CTRL2_RFS_0                       0U     /* 0 : Remote Response Frame is generated.                                   */
#define  CAN_CTRL2_RFS_1                       1U     /* 1 : Remote Request Frame is stored.                                       */


/* ===============================================  CAN CTRL2 MBPRI [18..18]  =============================================== */
                                 /* CAN_CTRL2_MBPRI                                                          */
#define  CAN_CTRL2_MBPRI_0                     0U     /* 0 : Matching starts from Rx FIFO and continues on Mailboxes.              */
#define  CAN_CTRL2_MBPRI_1                     1U     /* 1 : Matching starts from Mailboxes and continues on Rx FIFO.              */


/* ==============================================  CAN CTRL2 BOCIEN [30..30]  =============================================== */
                                 /* CAN_CTRL2_BOCIEN                                                         */
#define  CAN_CTRL2_BOCIEN_0                    0U     /* 0 : Bus Off Done interrupt disabled.                                      */
#define  CAN_CTRL2_BOCIEN_1                    1U     /* 1 : Bus Off Done interrupt enabled.                                       */


/* =============================================  CAN CTRL2 FDERRIEN [31..31]  ============================================== */
                                 /* CAN_CTRL2_FDERRIEN                                                       */
#define  CAN_CTRL2_FDERRIEN_0                  0U     /* 0 : ERRINT_FAST Error interrupt disabled.                                 */
#define  CAN_CTRL2_FDERRIEN_1                  1U     /* 1 : ERRINT_FAST Error interrupt enabled.                                  */


/* ========================================================  ERRFLG2  ======================================================== */
/* ==============================================  CAN ERRFLG2 IAMBFLG [13..13]  =============================================== */
                                 /* CAN_ERRFLG2_IAMBFLG                                                         */
#define  CAN_ERRFLG2_IAMBFLG_0                    0U     /* 0 : If ESR2[VPS] is assertedU the ESR2[LPTM] is not an inactive
                                                        Mailbox.                                                                  */
#define  CAN_ERRFLG2_IAMBFLG_1                    1U     /* 1 : If ESR2[VPS] is assertedU there is at least one inactive
                                                         Mailbox. LPTM content is the number of the first one.                     */


/* ==============================================  CAN ERRFLG2 CVFLG [14..14]  ============================================== */
                                 /* CAN_ERRFLG2_CVFLG                                                        */
#define  CAN_ERRFLG2_CVFLG_0                   0U     /* 0 : Contents of IMB and LPTM are invalid.                                 */
#define  CAN_ERRFLG2_CVFLG_1                   1U     /* 1 : Contents of IMB and LPTM are valid.                                   */


/* ==========================================================  CRC  ========================================================== */
/* =======================================================  FIFOGMASK  ======================================================= */
/* =======================================================  FIFOINFO  ======================================================== */
/* ========================================================  BTIM  ========================================================= */
/* ==============================================  CAN BTIM EBTEN [31..31]  =============================================== */
                                 /* CAN_BTIM_EBTEN                                                         */
#define  CAN_BTIM_EBTEN_0                    0U     /* 0 : Extended bit time definitions disabled.                               */
#define  CAN_BTIM_EBTEN_1                    1U     /* 1 : Extended bit time definitions enabled.                                */


/* =========================================================  RAMn  ========================================================= */
/* =======================================================  RXIMASK  ======================================================== */
/* ========================================================  PNCTRL1  ======================================================== */
/* ===============================================  CAN PNCTRL1 FCSEL [0..1]  =============================================== */
                                 /* CAN_PNCTRL1_FCSEL                                                        */
#define  CAN_PNCTRL1_FCSEL_00                  0U     /* 00 : Message ID filtering only                                            */
#define  CAN_PNCTRL1_FCSEL_01                  1U     /* 01 : Message ID filtering and payload filtering                           */
#define  CAN_PNCTRL1_FCSEL_10                  2U     /* 10 : Message ID filtering occurring a specified number of times.          */
#define  CAN_PNCTRL1_FCSEL_11                  3U     /* 11 : Message ID filtering and payload filtering a specified
                                                     number of times                                                           */


/* ==============================================  CAN PNCTRL1 IDFLSEL [2..3]  ============================================== */
                                 /* CAN_PNCTRL1_IDFLSEL                                                      */
#define  CAN_PNCTRL1_IDFLSEL_00                0U     /* 00 : Match upon a ID contents against an exact target value               */
#define  CAN_PNCTRL1_IDFLSEL_01                1U     /* 01 : Match upon a ID value greater than or equal to a specified
                                                     target value                                                              */
#define  CAN_PNCTRL1_IDFLSEL_10                2U     /* 10 : Match upon a ID value smaller than or equal to a specified
                                                      target value                                                              */
#define  CAN_PNCTRL1_IDFLSEL_11                3U     /* 11 : Match upon a ID value inside a rangeU greater than or equal
                                                       to a specified lower limit and smaller than or equal a
                                                     specified upper limit                                                     */


/* ==============================================  CAN PNCTRL1 PFLSEL [4..5]  =============================================== */
                                 /* CAN_PNCTRL1_PFLSEL                                                       */
#define  CAN_PNCTRL1_PFLSEL_00                 0U     /* 00 : Match upon a payload contents against an exact target value          */
#define  CAN_PNCTRL1_PFLSEL_01                 1U     /* 01 : Match upon a payload value greater than or equal to a specified
                                                     target value                                                              */
#define  CAN_PNCTRL1_PFLSEL_10                 2U     /* 10 : Match upon a payload value smaller than or equal to a specified
                                                      target value                                                              */
#define  CAN_PNCTRL1_PFLSEL_11                 3U     /* 11 : Match upon a payload value inside a rangeU greater than
                                                      or equal to a specified lower limit and smaller than or
                                                     equal a specified upper limit                                             */


/* ==============================================  CAN PNCTRL1 NUMMSG [8..15]  ============================================== */
                                 /* CAN_PNCTRL1_NUMMSG                                                       */
#define  CAN_PNCTRL1_NUMMSG_00000001           1U     /* 00000001 : Received message must match the predefined filtering
                                                         criteria for ID and/or PL once before generating a wake
                                                     up event.                                                                 */
#define  CAN_PNCTRL1_NUMMSG_00000010           2U     /* 00000010 : Received message must match the predefined filtering
                                                        criteria for ID and/or PL twice before generating a wake
                                                     up event.                                                                 */
#define  CAN_PNCTRL1_NUMMSG_11111111           255U   /* 11111111 : Received message must match the predefined filtering
                                                      criteria for ID and/or PL 255 times before generating a
                                                     wake up event.                                                            */


/* ==============================================  CAN PNCTRL1 WUMEN [16..16]  ============================================== */
                                 /* CAN_PNCTRL1_WUMEN                                                        */
#define  CAN_PNCTRL1_WUMEN_0                   0U     /* 0 : Wake up match event is disabled                                       */
#define  CAN_PNCTRL1_WUMEN_1                   1U     /* 1 : Wake up match event is enabled                                        */


/* ==============================================  CAN PNCTRL1 WUTEN [17..17]  ============================================== */
                                 /* CAN_PNCTRL1_WUTEN                                                        */
#define  CAN_PNCTRL1_WUTEN_0                   0U     /* 0 : Timeout wake up event is disabled                                     */
#define  CAN_PNCTRL1_WUTEN_1                   1U     /* 1 : Timeout wake up event is enabled                                      */



/* ========================================================  PNCTRL2  ======================================================== */
/* =========================================================  PNWM  ========================================================== */
/* ===============================================  CAN PNWM WUMFLG [16..16]  =============================================== */
                                 /* CAN_PNWM_WUMFLG                                                          */
#define  CAN_PNWM_WUMFLG_0                     0U     /* 0 : No wake up by match event detected                                    */
#define  CAN_PNWM_WUMFLG_1                     1U     /* 1 : Wake up by match event detected                                       */


/* ===============================================  CAN PNWM WUTFLG [17..17]  =============================================== */
                                 /* CAN_PNWM_WUTFLG                                                          */
#define  CAN_PNWM_WUTFLG_0                     0U     /* 0 : No wake up by timeout event detected                                  */
#define  CAN_PNWM_WUTFLG_1                     1U     /* 1 : Wake up by timeout event detected                                     */


/* ========================================================  PNIDF1  ========================================================= */
/* ===============================================  CAN PNIDF1 RFF [29..29]  ================================================ */
                                 /* CAN_PNIDF1_RFF                                                           */
#define  CAN_PNIDF1_RFF_0                      0U     /* 0 : Reject remote frame (accept data frame)                               */
#define  CAN_PNIDF1_RFF_1                      1U     /* 1 : Accept remote frame                                                   */


/* ===============================================  CAN PNIDF1 EXFF [30..30]  =============================================== */
                                 /* CAN_PNIDF1_EXFF                                                          */
#define  CAN_PNIDF1_EXFF_0                     0U     /* 0 : Accept standard frame format                                          */
#define  CAN_PNIDF1_EXFF_1                     1U     /* 1 : Accept extended frame format                                          */


/* ========================================================  PNDLCF  ========================================================= */
/* ========================================================  PNPLF1  ========================================================= */
/* ========================================================  PNPHF1  ========================================================= */
/* ========================================================  PNIDF2  ========================================================= */
/* ==============================================  CAN PNIDF2 RFMASK [29..29]  ============================================== */
                                 /* CAN_PNIDF2_RFMASK                                                        */
#define  CAN_PNIDF2_RFMASK_0                   0U     /* 0 : The corresponding bit in the filter is 'dont care'                    */
#define  CAN_PNIDF2_RFMASK_1                   1U     /* 1 : The corresponding bit in the filter is checked                        */


/* =============================================  CAN PNIDF2 EXFMASK [30..30]  ============================================== */
                                 /* CAN_PNIDF2_EXFMASK                                                       */
#define  CAN_PNIDF2_EXFMASK_0                  0U     /* 0 : The corresponding bit in the filter is 'dont care'                    */
#define  CAN_PNIDF2_EXFMASK_1                  1U     /* 1 : The corresponding bit in the filter is checked                        */


/* ========================================================  PNPLF2  ========================================================= */
/* ========================================================  PNPHF2  ========================================================= */
/* ========================================================  WMB0_CS  ======================================================== */
/* ===============================================  CAN WMB0_CS RTR [20..20]  =============================================== */
                                 /* CAN_WMB_CS_WMB_CS_WMB0_CS_RTR                                            */
#define  CAN_WMB_CS_WMB_CS_WMB0_CS_RTR_0       0U     /* 0 : Frame is data one (not remote)                                        */
#define  CAN_WMB_CS_WMB_CS_WMB0_CS_RTR_1       1U     /* 1 : Frame is a remote one                                                 */


/* ===============================================  CAN WMB0_CS IDE [21..21]  =============================================== */
                                 /* CAN_WMB_CS_WMB_CS_WMB0_CS_IDE                                            */
#define  CAN_WMB_CS_WMB_CS_WMB0_CS_IDE_0       0U     /* 0 : Frame format is standard                                              */
#define  CAN_WMB_CS_WMB_CS_WMB0_CS_IDE_1       1U     /* 1 : Frame format is extended                                              */


/* ========================================================  WMB1_CS  ======================================================== */
/* ===============================================  CAN WMB1_CS RTR [20..20]  =============================================== */
                                 /* CAN_WMB_CS_WMB_CS_WMB1_CS_RTR                                            */
#define  CAN_WMB_CS_WMB_CS_WMB1_CS_RTR_0       0U     /* 0 : Frame is data one (not remote)                                        */
#define  CAN_WMB_CS_WMB_CS_WMB1_CS_RTR_1       1U     /* 1 : Frame is a remote one                                                 */


/* ===============================================  CAN WMB1_CS IDE [21..21]  =============================================== */
                                 /* CAN_WMB_CS_WMB_CS_WMB1_CS_IDE                                            */
#define  CAN_WMB_CS_WMB_CS_WMB1_CS_IDE_0       0U     /* 0 : Frame format is standard                                              */
#define  CAN_WMB_CS_WMB_CS_WMB1_CS_IDE_1       1U     /* 1 : Frame format is extended                                              */


/* ========================================================  WMB2_CS  ======================================================== */
/* ===============================================  CAN WMB2_CS RTR [20..20]  =============================================== */
                                 /* CAN_WMB_CS_WMB_CS_WMB2_CS_RTR                                            */
#define  CAN_WMB_CS_WMB_CS_WMB2_CS_RTR_0       0U     /* 0 : Frame is data one (not remote)                                        */
#define  CAN_WMB_CS_WMB_CS_WMB2_CS_RTR_1       1U     /* 1 : Frame is a remote one                                                 */


/* ===============================================  CAN WMB2_CS IDE [21..21]  =============================================== */
                                 /* CAN_WMB_CS_WMB_CS_WMB2_CS_IDE                                            */
#define  CAN_WMB_CS_WMB_CS_WMB2_CS_IDE_0       0U     /* 0 : Frame format is standard                                              */
#define  CAN_WMB_CS_WMB_CS_WMB2_CS_IDE_1       1U     /* 1 : Frame format is extended                                              */


/* ========================================================  WMB3_CS  ======================================================== */
/* ===============================================  CAN WMB3_CS RTR [20..20]  =============================================== */
                                 /* CAN_WMB_CS_WMB_CS_WMB3_CS_RTR                                            */
#define  CAN_WMB_CS_WMB_CS_WMB3_CS_RTR_0       0U     /* 0 : Frame is data one (not remote)                                        */
#define  CAN_WMB_CS_WMB_CS_WMB3_CS_RTR_1       1U     /* 1 : Frame is a remote one                                                 */


/* ===============================================  CAN WMB3_CS IDE [21..21]  =============================================== */
                                 /* CAN_WMB_CS_WMB_CS_WMB3_CS_IDE                                            */
#define  CAN_WMB_CS_WMB_CS_WMB3_CS_IDE_0       0U     /* 0 : Frame format is standard                                              */
#define  CAN_WMB_CS_WMB_CS_WMB3_CS_IDE_1       1U     /* 1 : Frame format is extended                                              */


/* ========================================================  WMB0_ID  ======================================================== */
/* ========================================================  WMB1_ID  ======================================================== */
/* ========================================================  WMB2_ID  ======================================================== */
/* ========================================================  WMB3_ID  ======================================================== */
/* ======================================================  WMB0_LDATA  ====================================================== */
/* ======================================================  WMB1_LDATA  ====================================================== */
/* ======================================================  WMB2_LDATA  ====================================================== */
/* ======================================================  WMB3_LDATA  ====================================================== */
/* ======================================================  WMB0_HDATA  ====================================================== */
/* ======================================================  WMB1_HDATA  ====================================================== */
/* ======================================================  WMB2_HDATA  ====================================================== */
/* ======================================================  WMB3_HDATA  ====================================================== */
/* ========================================================  FDCTRL  ========================================================= */
/* ===============================================  CAN FDCTRL TDCF [14..14]  =============================================== */
                                 /* CAN_FDCTRL_TDCF                                                          */
#define  CAN_FDCTRL_TDCF_0                     0U     /* 0 : Measured loop delay is in range.                                      */
#define  CAN_FDCTRL_TDCF_1                     1U     /* 1 : Measured loop delay is out of range.                                  */


/* ==============================================  CAN FDCTRL TDCEN [15..15]  =============================================== */
                                 /* CAN_FDCTRL_TDCEN                                                         */
#define  CAN_FDCTRL_TDCEN_0                    0U     /* 0 : TDC is disabled                                                       */
#define  CAN_FDCTRL_TDCEN_1                    1U     /* 1 : TDC is enabled                                                        */


/* ==============================================  CAN FDCTRL MBSIZE [16..17]  ============================================== */
                                 /* CAN_FDCTRL_MBSIZE                                                        */
#define  CAN_FDCTRL_MBSIZE_00                  0U     /* 00 : Selects 8 bytes per Message Buffer.                                  */
#define  CAN_FDCTRL_MBSIZE_01                  1U     /* 01 : Selects 16 bytes per Message Buffer.                                 */
#define  CAN_FDCTRL_MBSIZE_10                  2U     /* 10 : Selects 32 bytes per Message Buffer.                                 */
#define  CAN_FDCTRL_MBSIZE_11                  3U     /* 11 : Selects 64 bytes per Message Buffer.                                 */


/* ==============================================  CAN FDCTRL BRSEN [31..31]  =============================================== */
                                 /* CAN_FDCTRL_BRSEN                                                         */
#define  CAN_FDCTRL_BRSEN_0                    0U     /* 0 : Transmit a frame in nominal rate. The BRS bit in the Tx
                                                         MB has no effect.                                                         */
#define  CAN_FDCTRL_BRSEN_1                    1U     /* 1 : Transmit a frame with bit rate switching if the BRS bit
                                                         in the Tx MB is recessive.                                                */


/* ========================================================  FDBTIM  ========================================================= */
/* =========================================================  FDCRC  ========================================================= */


/* =========================================================================================================================== */
/* ================                                           CFGTMR                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  CSTS  ========================================================== */
/* ==============================================  CFGTMR CSTS CLKDFSEL [0..2]  =============================================== */
                                 /* CFGTMR_CSTS_CLKDFSEL                                                       */
#define  CFGTMR_CSTS_CLKDFSEL_000                0U     /* 000 : Divide by 1                                                         */
#define  CFGTMR_CSTS_CLKDFSEL_001                1U     /* 001 : Divide by 2                                                         */
#define  CFGTMR_CSTS_CLKDFSEL_010                2U     /* 010 : Divide by 4                                                         */
#define  CFGTMR_CSTS_CLKDFSEL_011                3U     /* 011 : Divide by 8                                                         */
#define  CFGTMR_CSTS_CLKDFSEL_100                4U     /* 100 : Divide by 16                                                        */
#define  CFGTMR_CSTS_CLKDFSEL_101                5U     /* 101 : Divide by 32                                                        */
#define  CFGTMR_CSTS_CLKDFSEL_110                6U     /* 110 : Divide by 64                                                        */
#define  CFGTMR_CSTS_CLKDFSEL_111                7U     /* 111 : Divide by 128                                                       */


/* ==============================================  CFGTMR CSTS CCLKSSEL [3..4]  =============================================== */
                                 /* CFGTMR_CSTS_CCLKSSEL                                                       */
#define  CFGTMR_CSTS_CCLKSSEL_00                 0U     /* 00 : No clock selected. This in effect disables the CFGTMR counter.          */
#define  CFGTMR_CSTS_CCLKSSEL_01                 1U     /* 01 : CFGTMR input clock                                                      */
#define  CFGTMR_CSTS_CCLKSSEL_10                 2U     /* 10 : Fixed frequency clock                                                */
#define  CFGTMR_CSTS_CCLKSSEL_11                 3U     /* 11 : External clock                                                       */


/* ================================================  CFGTMR CSTS CMSEL [5..5]  ================================================ */
                                 /* CFGTMR_CSTS_CMSEL                                                          */
#define  CFGTMR_CSTS_CMSEL_0                     0U     /* 0 : CFGTMR counter operates in Up Counting mode.                             */
#define  CFGTMR_CSTS_CMSEL_1                     1U     /* 1 : CFGTMR counter operates in Up-Down Counting mode.                        */


/* ================================================  CFGTMR CSTS RPIEN [6..6]  ================================================ */
                                 /* CFGTMR_CSTS_RPIEN                                                          */
#define  CFGTMR_CSTS_RPIEN_0                     0U     /* 0 : Reload point interrupt is disabled.                                   */
#define  CFGTMR_CSTS_RPIEN_1                     1U     /* 1 : Reload point interrupt is enabled.                                    */


/* ================================================  CFGTMR CSTS RFLG [7..7]  ================================================= */
                                 /* CFGTMR_CSTS_RFLG                                                           */
#define  CFGTMR_CSTS_RFLG_0                      0U     /* 0 : A selected reload point did not happen.                               */
#define  CFGTMR_CSTS_RFLG_1                      1U     /* 1 : A selected reload point happened.                                     */


/* ==============================================  CFGTMR CSTS CFGTMROIEN [8..8]  =============================================== */
                                 /* CFGTMR_CSTS_CFGTMROIEN                                                       */
#define  CFGTMR_CSTS_CFGTMROIEN_0                  0U     /* 0 : Disable TOF interrupts. Use software polling.                         */
#define  CFGTMR_CSTS_CFGTMROIEN_1                  1U     /* 1 : Enable TOF interrupts. An interrupt is generated when TOF
                                                     equals one.                                                               */


/* ==============================================  CFGTMR CSTS CFGTMROFLG [9..9]  =============================================== */
                                 /* CFGTMR_CSTS_CFGTMROFLG                                                       */
#define  CFGTMR_CSTS_CFGTMROFLG_0                  0U     /* 0 : CFGTMR counter has not overflowed.                                       */
#define  CFGTMR_CSTS_CFGTMROFLG_1                  1U     /* 1 : CFGTMR counter has overflowed.                                           */


/* =============================================  CFGTMR CSTS PWMOENCH0 [16..16]  ============================================== */
                                 /* CFGTMR_CSTS_PWMOENCH0                                                       */
#define  CFGTMR_CSTS_PWMOENCH0_0                  0U     /* 0 : Channel 0 output port is disabled                                       */
#define  CFGTMR_CSTS_PWMOENCH0_1                  1U     /* 1 : Channel 0 output port is enabled                                        */

/* =============================================  CFGTMR CSTS PWMOENCH1 [17..17]  ============================================== */
                                 /* CFGTMR_CSTS_PWMOENCH1                                                       */
#define  CFGTMR_CSTS_PWMOENCH1_0                  0U     /* 0 : Channel 1 output port is disabled                                       */
#define  CFGTMR_CSTS_PWMOENCH1_1                  1U     /* 1 : Channel 1 output port is enabled                                        */

/* =============================================  CFGTMR CSTS PWMOENCH2 [18..18]  ============================================== */
                                 /* CFGTMR_CSTS_PWMOENCH2                                                       */
#define  CFGTMR_CSTS_PWMOENCH2_0                  0U     /* 0 : Channel 2 output port is disabled                                       */
#define  CFGTMR_CSTS_PWMOENCH2_1                  1U     /* 1 : Channel 2 output port is enabled                                        */

/* =============================================  CFGTMR CSTS PWMOENCH3 [19..19]  ============================================== */
                                 /* CFGTMR_CSTS_PWMOENCH3                                                       */
#define  CFGTMR_CSTS_PWMOENCH3_0                  0U     /* 0 : Channel 3 output port is disabled                                       */
#define  CFGTMR_CSTS_PWMOENCH3_1                  1U     /* 1 : Channel 3 output port is enabled                                        */

/* =============================================  CFGTMR CSTS PWMOENCH4 [20..20]  ============================================== */
                                 /* CFGTMR_CSTS_PWMOENCH4                                                       */
#define  CFGTMR_CSTS_PWMOENCH4_0                  0U     /* 0 : Channel 4 output port is disabled                                       */
#define  CFGTMR_CSTS_PWMOENCH4_1                  1U     /* 1 : Channel 4 output port is enabled                                        */

/* =============================================  CFGTMR CSTS PWMOENCH5 [21..21]  ============================================== */
                                 /* CFGTMR_CSTS_PWMOENCH5                                                       */
#define  CFGTMR_CSTS_PWMOENCH5_0                  0U     /* 0 : Channel 5 output port is disabled                                       */
#define  CFGTMR_CSTS_PWMOENCH5_1                  1U     /* 1 : Channel 5 output port is enabled                                        */

/* =============================================  CFGTMR CSTS PWMOENCH6 [22..22]  ============================================== */
                                 /* CFGTMR_CSTS_PWMOENCH6                                                       */
#define  CFGTMR_CSTS_PWMOENCH6_0                  0U     /* 0 : Channel 6 output port is disabled                                       */
#define  CFGTMR_CSTS_PWMOENCH6_1                  1U     /* 1 : Channel 6 output port is enabled                                        */

/* =============================================  CFGTMR CSTS PWMOENCH7 [23..23]  ============================================== */
                                 /* CFGTMR_CSTS_PWMOENCH7                                                       */
#define  CFGTMR_CSTS_PWMOENCH7_0                  0U     /* 0 : Channel 7 output port is disabled                                       */
#define  CFGTMR_CSTS_PWMOENCH7_1                  1U     /* 1 : Channel 7 output port is enabled                                        */


/* ==============================================  CFGTMR CSTS FPSCSEL [24..27]  ============================================== */
                                 /* CFGTMR_CSTS_FPSCSEL                                                        */
#define  CFGTMR_CSTS_FPSCSEL_0000                0U     /* 0000 : Divide by 1                                                        */
#define  CFGTMR_CSTS_FPSCSEL_0001                1U     /* 0001 : Divide by 2                                                        */
#define  CFGTMR_CSTS_FPSCSEL_0010                2U     /* 0010 : Divide by 3                                                        */
#define  CFGTMR_CSTS_FPSCSEL_0011                3U     /* 0011 : Divide by 4                                                        */
#define  CFGTMR_CSTS_FPSCSEL_0100                4U     /* 0100 : Divide by 5                                                        */
#define  CFGTMR_CSTS_FPSCSEL_0101                5U     /* 0101 : Divide by 6                                                        */
#define  CFGTMR_CSTS_FPSCSEL_0110                6U     /* 0110 : Divide by 7                                                        */
#define  CFGTMR_CSTS_FPSCSEL_0111                7U     /* 0111 : Divide by 8                                                        */
#define  CFGTMR_CSTS_FPSCSEL_1000                8U     /* 1000 : Divide by 9                                                        */
#define  CFGTMR_CSTS_FPSCSEL_1001                9U     /* 1001 : Divide by 10                                                       */
#define  CFGTMR_CSTS_FPSCSEL_1010                10U    /* 1010 : Divide by 11                                                       */
#define  CFGTMR_CSTS_FPSCSEL_1011                11U    /* 1011 : Divide by 12                                                       */
#define  CFGTMR_CSTS_FPSCSEL_1100                12U    /* 1100 : Divide by 13                                                       */
#define  CFGTMR_CSTS_FPSCSEL_1101                13U    /* 1101 : Divide by 14                                                       */
#define  CFGTMR_CSTS_FPSCSEL_1110                14U    /* 1110 : Divide by 15                                                       */
#define  CFGTMR_CSTS_FPSCSEL_1111                15U    /* 1111 : Divide by 16                                                       */


/* ==========================================================  CNT  ========================================================== */
/* ==========================================================  MOD  ========================================================== */
/* ========================================================  CHnCSTS  ======================================================== */
/* ==============================================  CFGTMR CHnCSTS DMAEN [0..0]  =============================================== */
                                 /* CFGTMR_CHnCSTS_DMAEN                                         */
#define  CFGTMR_CHnCSTS_DMAEN_0    0U     /* 0 : Disable DMA transfers.                                                */
#define  CFGTMR_CHnCSTS_DMAEN_1    1U     /* 1 : Enable DMA transfers.                                                 */


/* =============================================  CFGTMR CHnCSTS CRSTCTRL [1..1]  ============================================= */
                                 /* CFGTMR_CHnCSTS_CRSTCTRL                                      */
#define  CFGTMR_CHnCSTS_CRSTCTRL_0   0U   /* 0 : CFGTMR counter is not reset when the selected channel (n) input
                                                        event is detected.                                                        */
#define  CFGTMR_CHnCSTS_CRSTCTRL_1   1U   /* 1 : CFGTMR counter is reset when the selected channel (n) input
                                                        event is detected.                                                        */

/* ==============================================  CFGTMR CHnCSTS CHMSEL0 [2..2]  =============================================== */
                                 /* CFGTMR_CHnCSTS_CHMSEL0                                         */
#define  CFGTMR_CHnCSTS_CHMSEL0_0    0U
#define  CFGTMR_CHnCSTS_CHMSEL0_1    1U

/* ==============================================  CFGTMR CHnCSTS CHMSEL1 [3..3]  =============================================== */
                                 /* CFGTMR_CHnCSTS_CHMSEL1                                         */
#define  CFGTMR_CHnCSTS_CHMSEL1_0    0U
#define  CFGTMR_CHnCSTS_CHMSEL1_1    1U

/* ==============================================  CFGTMR CHnCSTS CHMSEL2 [4..4]  =============================================== */
                                 /* CFGTMR_CHnCSTS_CHMSEL2                                         */
#define  CFGTMR_CHnCSTS_CHMSEL2_0    0U
#define  CFGTMR_CHnCSTS_CHMSEL2_1    1U

/* ==============================================  CFGTMR CHnCSTS CHMSEL3 [5..5]  =============================================== */
                                 /* CFGTMR_CHnCSTS_CHMSEL3                                         */
#define  CFGTMR_CHnCSTS_CHMSEL3_0    0U
#define  CFGTMR_CHnCSTS_CHMSEL3_1    1U

/* ==============================================  CFGTMR CHnCSTS CHIEN [6..6]  =============================================== */
                                 /* CFGTMR_CHnCSTS_CHIEN                                         */
#define  CFGTMR_CHnCSTS_CHIEN_0    0U     /* 0 : Disable channel (n) interrupt. Use software polling.                  */
#define  CFGTMR_CHnCSTS_CHIEN_1    1U     /* 1 : Enable channel (n) interrupt.                                         */


/* =============================================  CFGTMR CHnCSTS CHEVFLG [7..7]  ============================================== */
                                 /* CFGTMR_CHnCSTS_CHEVFLG                                       */
#define  CFGTMR_CHnCSTS_CHEVFLG_0   0U    /* 0 : No channel (n) event has occurred.                                    */
#define  CFGTMR_CHnCSTS_CHEVFLG_1   1U    /* 1 : A channel (n) event has occurred.                                     */


/* ============================================  CFGTMR CHnCSTS CHOTMCTRL [8..8]  ============================================= */
                                 /* CFGTMR_CHnCSTS_CHOTMCTRL                                     */
#define  CFGTMR_CHnCSTS_CHOTMCTRL_0   0U  /* 0 : Channel outputs will generate the normal PWM outputs without
                                                       generating a pulse.                                                       */
#define  CFGTMR_CHnCSTS_CHOTMCTRL_1   1U  /* 1 : If a match in the channel occursU a trigger generation on
                                                        channel output will happen. The trigger pulse width has
                                                     one CFGTMR clock cycle.                                                      */


/* ==============================================  CFGTMR CHnCSTS CHISTS [9..9]  ============================================== */
                                 /* CFGTMR_CHnCSTS_CHISTS                                        */
#define  CFGTMR_CHnCSTS_CHISTS_0   0U     /* 0 : The channel (n) input is zero.                                        */
#define  CFGTMR_CHnCSTS_CHISTS_1   1U     /* 1 : The channel (n) input is one.                                         */


/* ============================================  CFGTMR CHnCSTS CHOLSEL [10..10]  ============================================= */
                                 /* CFGTMR_CHnCSTS_CHOLSEL                                       */
#define  CFGTMR_CHnCSTS_CHOLSEL_0   0U    /* 0 : The channel (n) output is zero.                                       */
#define  CFGTMR_CHnCSTS_CHOLSEL_1   1U    /* 1 : The channel (n) output is one.                                        */

/* =========================================================  CHnV  ========================================================== */
/* =========================================================  INITV  ========================================================= */
/* =========================================================  CCSTS  ========================================================= */
/* ==============================================  CFGTMR CCSTS CHEVFLG0 [0..0]  =============================================== */
                                 /* CFGTMR_CCSTS_CHEVFLG0                                                       */
#define  CFGTMR_CCSTS_CHEVFLG0_0                  0U     /* 0 : No channel event has occurred.                                        */
#define  CFGTMR_CCSTS_CHEVFLG0_1                  1U     /* 1 : A channel event has occurred.                                         */

/* ==============================================  CFGTMR CCSTS CHEVFLG1 [1..1]  =============================================== */
                                 /* CFGTMR_CCSTS_CHEVFLG1                                                       */
#define  CFGTMR_CCSTS_CHEVFLG1_0                  0U     /* 0 : No channel event has occurred.                                        */
#define  CFGTMR_CCSTS_CHEVFLG1_1                  1U     /* 1 : A channel event has occurred.                                         */

/* ==============================================  CFGTMR CCSTS CHEVFLG2 [2..2]  =============================================== */
                                 /* CFGTMR_CCSTS_CHEVFLG2                                                       */
#define  CFGTMR_CCSTS_CHEVFLG2_0                  0U     /* 0 : No channel event has occurred.                                        */
#define  CFGTMR_CCSTS_CHEVFLG2_1                  1U     /* 1 : A channel event has occurred.                                         */

/* ==============================================  CFGTMR CCSTS CHEVFLG3 [3..3]  =============================================== */
                                 /* CFGTMR_CCSTS_CHEVFLG3                                                       */
#define  CFGTMR_CCSTS_CHEVFLG3_0                  0U     /* 0 : No channel event has occurred.                                        */
#define  CFGTMR_CCSTS_CHEVFLG3_1                  1U     /* 1 : A channel event has occurred.                                         */

/* ==============================================  CFGTMR CCSTS CHEVFLG4 [4..4]  =============================================== */
                                 /* CFGTMR_CCSTS_CHEVFLG4                                                       */
#define  CFGTMR_CCSTS_CHEVFLG4_0                  0U     /* 0 : No channel event has occurred.                                        */
#define  CFGTMR_CCSTS_CHEVFLG4_1                  1U     /* 1 : A channel event has occurred.                                         */

/* ==============================================  CFGTMR CCSTS CHEVFLG [5..5]  =============================================== */
                                 /* CFGTMR_CCSTS_CHEVFLG5                                                      */
#define  CFGTMR_CCSTS_CHEVFLG5_0                  0U     /* 0 : No channel event has occurred.                                        */
#define  CFGTMR_CCSTS_CHEVFLG5_1                  1U     /* 1 : A channel event has occurred.                                         */

/* ==============================================  CFGTMR CCSTS CHEVFLG6 [6..6]  =============================================== */
                                 /* CFGTMR_CCSTS_CHEVFLG6                                                       */
#define  CFGTMR_CCSTS_CHEVFLG6_0                  0U     /* 0 : No channel event has occurred.                                        */
#define  CFGTMR_CCSTS_CHEVFLG6_1                  1U     /* 1 : A channel event has occurred.                                         */

/* ==============================================  CFGTMR CCSTS CHEVFLG7 [7..7]  =============================================== */
                                 /* CFGTMR_CCSTS_CHEVFLG7                                                       */
#define  CFGTMR_CCSTS_CHEVFLG7_0                  0U     /* 0 : No channel event has occurred.                                        */
#define  CFGTMR_CCSTS_CHEVFLG7_1                  1U     /* 1 : A channel event has occurred.                                         */


/* ==========================================================  FMSEL  ========================================================== */
/* ================================================  CFGTMR FMSEL CFGTMREN [0..0]  ================================================ */
                                 /* CFGTMR_FMSEL_CFGTMREN                                                          */
#define  CFGTMR_FMSEL_CFGTMREN_0                     0U     /* 0 : TPM compatibility. Free running counter and synchronization
                                                       compatible with TPM.                                                      */
#define  CFGTMR_FMSEL_CFGTMREN_1                     1U     /* 1 : Free running counter and synchronization are different from
                                                      TPM behavior.                                                             */


/* ===============================================  CFGTMR FMSEL WPUNLOCK [2..2]  =============================================== */
                                 /* CFGTMR_FMSEL_WPUNLOCK                                                        */
#define  CFGTMR_FMSEL_WPUNLOCK_0                   0U     /* 0 : Write protection is enabled.                                          */
#define  CFGTMR_FMSEL_WPUNLOCK_1                   1U     /* 1 : Write protection is disabled.                                         */


/* ===============================================  CFGTMR FMSEL PWMSMCFG [3..3]  =============================================== */
                                 /* CFGTMR_FMSEL_PWMSMCFG                                                        */
#define  CFGTMR_FMSEL_PWMSMCFG_0                   0U     /* 0 : No restrictions. Software and hardware triggers can be used
                                                         by MODU CnVU OUTMASKU and CFGTMR counter synchronization.                    */
#define  CFGTMR_FMSEL_PWMSMCFG_1                   1U     /* 1 : Software trigger can only be used by MOD and CHnV synchronizationU
                                                         and hardware triggers can only be used by OUTMASK and CFGTMR
                                                     counter synchronization.                                                  */


/* ================================================  CFGTMR FMSEL CTMEN [4..4]  ================================================= */
                                 /* CFGTMR_FMSEL_CTMEN                                                           */
#define  CFGTMR_FMSEL_CTMEN_0                      0U     /* 0 : Capture test mode is disabled.                                        */
#define  CFGTMR_FMSEL_CTMEN_1                      1U     /* 1 : Capture test mode is enabled.                                         */


/* ==============================================  CFGTMR FMSEL FCTRLMSEL [5..6]  =============================================== */
                                 /* CFGTMR_FMSEL_FCTRLMSEL                                                       */
#define  CFGTMR_FMSEL_FCTRLMSEL_00                 0U     /* 00 : Fault control is disabled for all channels.                          */
#define  CFGTMR_FMSEL_FCTRLMSEL_01                 1U     /* 01 : Fault control is enabled for even channels only (channels
                                                     0U 2U 4U and 6)U and the selected mode is the manual fault
                                                     clearing.                                                                 */
#define  CFGTMR_FMSEL_FCTRLMSEL_10                 2U     /* 10 : Fault control is enabled for all channelsU and the selected
                                                       mode is the manual fault clearing.                                        */
#define  CFGTMR_FMSEL_FCTRLMSEL_11                 3U     /* 11 : Fault control is enabled for all channelsU and the selected
                                                       mode is the automatic fault clearing.                                     */


/* ===============================================  CFGTMR FMSEL FCTRLIEN [7..7]  =============================================== */
                                 /* CFGTMR_FMSEL_FCTRLIEN                                                        */
#define  CFGTMR_FMSEL_FCTRLIEN_0                   0U     /* 0 : Fault control interrupt is disabled.                                  */
#define  CFGTMR_FMSEL_FCTRLIEN_1                   1U     /* 1 : Fault control interrupt is enabled.                                   */


/* ==========================================================  SYN  ========================================================== */
/* ===============================================  CFGTMR SYN MINLPEN [0..0]  ================================================ */
                                 /* CFGTMR_SYN_MINLPEN                                                         */
#define  CFGTMR_SYN_MINLPEN_0                    0U     /* 0 : The minimum loading point is disabled.                                */
#define  CFGTMR_SYN_MINLPEN_1                    1U     /* 1 : The minimum loading point is enabled.                                 */


/* ===============================================  CFGTMR SYN MAXLPEN [1..1]  ================================================ */
                                 /* CFGTMR_SYN_MAXLPEN                                                         */
#define  CFGTMR_SYN_MAXLPEN_0                    0U     /* 0 : The maximum loading point is disabled.                                */
#define  CFGTMR_SYN_MAXLPEN_1                    1U     /* 1 : The maximum loading point is enabled.                                 */


/* ==============================================  CFGTMR SYN CFGTMRCRINT [2..2]  =============================================== */
                                 /* CFGTMR_SYN_CFGTMRCRINT                                                       */
#define  CFGTMR_SYN_CFGTMRCRINT_0                  0U     /* 0 : CFGTMR counter continues to count normally.                              */
#define  CFGTMR_SYN_CFGTMRCRINT_1                  1U     /* 1 : CFGTMR counter is updated with its initial value when the selected
                                                     trigger is detected.                                                      */


/* ===============================================  CFGTMR SYN OVSMSEL [3..3]  ================================================ */
                                 /* CFGTMR_SYN_OVSMSEL                                                         */
#define  CFGTMR_SYN_OVSMSEL_0                    0U     /* 0 : OUTMASK register is updated with the value of its buffer
                                                        in all rising edges of the CFGTMR input clock.                               */
#define  CFGTMR_SYN_OVSMSEL_1                    1U     /* 1 : OUTMASK register is updated with the value of its buffer
                                                        only by the PWM synchronization.                                          */


/* ===============================================  CFGTMR SYN HWT0SEL [4..4]  ================================================ */
                                 /* CFGTMR_SYN_HWT0SEL                                                         */
#define  CFGTMR_SYN_HWT0SEL_0                    0U     /* 0 : Trigger is disabled.                                                  */
#define  CFGTMR_SYN_HWT0SEL_1                    1U     /* 1 : Trigger is enabled.                                                   */


/* ===============================================  CFGTMR SYN HWT1SEL [5..5]  ================================================ */
                                 /* CFGTMR_SYN_HWT1SEL                                                         */
#define  CFGTMR_SYN_HWT1SEL_0                    0U     /* 0 : Trigger is disabled.                                                  */
#define  CFGTMR_SYN_HWT1SEL_1                    1U     /* 1 : Trigger is enabled.                                                   */


/* ===============================================  CFGTMR SYN HWT2SEL [6..6]  ================================================ */
                                 /* CFGTMR_SYN_HWT2SEL                                                         */
#define  CFGTMR_SYN_HWT2SEL_0                    0U     /* 0 : Trigger is disabled.                                                  */
#define  CFGTMR_SYN_HWT2SEL_1                    1U     /* 1 : Trigger is enabled.                                                   */


/* ================================================  CFGTMR SYN SWTSEL [7..7]  ================================================ */
                                 /* CFGTMR_SYN_SWTSEL                                                          */
#define  CFGTMR_SYN_SWTSEL_0                     0U     /* 0 : Software trigger is not selected.                                     */
#define  CFGTMR_SYN_SWTSEL_1                     1U     /* 1 : Software trigger is selected.                                         */


/* =========================================================  CHOI  ========================================================== */
/* ===============================================  CFGTMR CHOI CHOISEL0 [0..0]  =============================================== */
                                 /* CFGTMR_CHOI_CHOISEL0                                                        */
#define  CFGTMR_CHOI_CHOISEL0_0                   0U     /* 0 : The initialization value is 0.                                        */
#define  CFGTMR_CHOI_CHOISEL0_1                   1U     /* 1 : The initialization value is 1.                                        */

/* ===============================================  CFGTMR CHOI CHOISEL1 [1..1]  =============================================== */
                                 /* CFGTMR_CHOI_CHOISEL1                                                        */
#define  CFGTMR_CHOI_CHOISEL1_0                   0U     /* 0 : The initialization value is 0.                                        */
#define  CFGTMR_CHOI_CHOISEL1_1                   1U     /* 1 : The initialization value is 1.                                        */

/* ===============================================  CFGTMR CHOI CHOISEL2 [2..2]  =============================================== */
                                 /* CFGTMR_CHOI_CHOISEL2                                                        */
#define  CFGTMR_CHOI_CHOISEL2_0                   0U     /* 0 : The initialization value is 0.                                        */
#define  CFGTMR_CHOI_CHOISEL2_1                   1U     /* 1 : The initialization value is 1.                                        */

/* ===============================================  CFGTMR CHOI CHOISEL3 [3..3]  =============================================== */
                                 /* CFGTMR_CHOI_CHOISEL3                                                        */
#define  CFGTMR_CHOI_CHOISEL3_0                   0U     /* 0 : The initialization value is 0.                                        */
#define  CFGTMR_CHOI_CHOISEL3_1                   1U     /* 1 : The initialization value is 1.                                        */

/* ===============================================  CFGTMR CHOI CHOISEL4 [4..4]  =============================================== */
                                 /* CFGTMR_CHOI_CHOISEL4                                                        */
#define  CFGTMR_CHOI_CHOISEL4_0                   0U     /* 0 : The initialization value is 0.                                        */
#define  CFGTMR_CHOI_CHOISEL4_1                   1U     /* 1 : The initialization value is 1.                                        */

/* ===============================================  CFGTMR CHOI CHOISEL5 [5..5]  =============================================== */
                                 /* CFGTMR_CHOI_CHOISEL5                                                        */
#define  CFGTMR_CHOI_CHOISEL5_0                   0U     /* 0 : The initialization value is 0.                                        */
#define  CFGTMR_CHOI_CHOISEL5_1                   1U     /* 1 : The initialization value is 1.                                        */

/* ===============================================  CFGTMR CHOI CHOISEL6 [6..6]  =============================================== */
                                 /* CFGTMR_CHOI_CHOISEL6                                                        */
#define  CFGTMR_CHOI_CHOISEL6_0                   0U     /* 0 : The initialization value is 0.                                        */
#define  CFGTMR_CHOI_CHOISEL6_1                   1U     /* 1 : The initialization value is 1.                                        */

/* ===============================================  CFGTMR CHOI CHOISEL7 [7..7]  =============================================== */
                                 /* CFGTMR_CHOI_CHOISEL7                                                        */
#define  CFGTMR_CHOI_CHOISEL7_0                   0U     /* 0 : The initialization value is 0.                                        */
#define  CFGTMR_CHOI_CHOISEL7_1                   1U     /* 1 : The initialization value is 1.                                        */


/* =========================================================  OMASK  ========================================================= */
/* ==============================================  CFGTMR OMASK CHOMASK0 [0..0]  =============================================== */
                                 /* CFGTMR_OMASK_CHOMASK0                                                       */
#define  CFGTMR_OMASK_CHOMASK0_0                  0U     /* 0 : Channel output is not masked. It continues to operate normally.       */
#define  CFGTMR_OMASK_CHOMASK0_1                  1U     /* 1 : Channel output is masked. It is forced to its inactive state.         */

/* ==============================================  CFGTMR OMASK CHOMASK1 [1..1]  =============================================== */
                                 /* CFGTMR_OMASK_CHOMASK1                                                       */
#define  CFGTMR_OMASK_CHOMASK1_0                  0U     /* 0 : Channel output is not masked. It continues to operate normally.       */
#define  CFGTMR_OMASK_CHOMASK1_1                  1U     /* 1 : Channel output is masked. It is forced to its inactive state.         */
/* ==============================================  CFGTMR OMASK CHOMASK2 [2..2]  =============================================== */
                                 /* CFGTMR_OMASK_CHOMASK2                                                       */
#define  CFGTMR_OMASK_CHOMASK2_0                  0U     /* 0 : Channel output is not masked. It continues to operate normally.       */
#define  CFGTMR_OMASK_CHOMASK2_1                  1U     /* 1 : Channel output is masked. It is forced to its inactive state.         */
/* ==============================================  CFGTMR OMASK CHOMASK3 [3..3]  =============================================== */
                                 /* CFGTMR_OMASK_CHOMASK3                                                       */
#define  CFGTMR_OMASK_CHOMASK3_0                  0U     /* 0 : Channel output is not masked. It continues to operate normally.       */
#define  CFGTMR_OMASK_CHOMASK3_1                  1U     /* 1 : Channel output is masked. It is forced to its inactive state.         */
/* ==============================================  CFGTMR OMASK CHOMASK4 [4..4]  =============================================== */
                                 /* CFGTMR_OMASK_CHOMASK4                                                       */
#define  CFGTMR_OMASK_CHOMASK4_0                  0U     /* 0 : Channel output is not masked. It continues to operate normally.       */
#define  CFGTMR_OMASK_CHOMASK4_1                  1U     /* 1 : Channel output is masked. It is forced to its inactive state.         */
/* ==============================================  CFGTMR OMASK CHOMASK5 [5..5]  =============================================== */
                                 /* CFGTMR_OMASK_CHOMASK5                                                       */
#define  CFGTMR_OMASK_CHOMASK5_0                  0U     /* 0 : Channel output is not masked. It continues to operate normally.       */
#define  CFGTMR_OMASK_CHOMASK5_1                  1U     /* 1 : Channel output is masked. It is forced to its inactive state.         */
/* ==============================================  CFGTMR OMASK CHOMASK6 [6..6]  =============================================== */
                                 /* CFGTMR_OMASK_CHOMASK6                                                       */
#define  CFGTMR_OMASK_CHOMASK6_0                  0U     /* 0 : Channel output is not masked. It continues to operate normally.       */
#define  CFGTMR_OMASK_CHOMASK6_1                  1U     /* 1 : Channel output is masked. It is forced to its inactive state.         */
/* ==============================================  CFGTMR OMASK CHOMASK7 [7..7]  =============================================== */
                                 /* CFGTMR_OMASK_CHOMASK7                                                       */
#define  CFGTMR_OMASK_CHOMASK7_0                  0U     /* 0 : Channel output is not masked. It continues to operate normally.       */
#define  CFGTMR_OMASK_CHOMASK7_1                  1U     /* 1 : Channel output is masked. It is forced to its inactive state.         */

/* =========================================================  FLCH  ========================================================== */
/* ================================================  CFGTMR FLCH CCHO0 [1..1]  ================================================ */
                                 /* CFGTMR_FLCH_CCHO0                                                          */
#define  CFGTMR_FLCH_CCHO0_0                     0U     /* 0 : The channel (n+1) output is the same as the channel (n)
                                                       output.                                                                   */
#define  CFGTMR_FLCH_CCHO0_1                     1U     /* 1 : The channel (n+1) output is the complement of the channel
                                                        (n) output.                                                               */


/* ===============================================  CFGTMR FLCH DECSTS0 [3..3]  =============================================== */
                                 /* CFGTMR_FLCH_DECSTS0                                                        */
#define  CFGTMR_FLCH_DECSTS0_0                   0U     /* 0 : The dual edge captures are inactive.                                  */
#define  CFGTMR_FLCH_DECSTS0_1                   1U     /* 1 : The dual edge captures are active.                                    */


/* ===============================================  CFGTMR FLCH DTIEN0 [4..4]  ================================================ */
                                 /* CFGTMR_FLCH_DTIEN0                                                         */
#define  CFGTMR_FLCH_DTIEN0_0                    0U     /* 0 : The deadtime insertion in this pair of channels is disabled.          */
#define  CFGTMR_FLCH_DTIEN0_1                    1U     /* 1 : The deadtime insertion in this pair of channels is enabled.           */


/* ==============================================  CFGTMR FLCH PWMSYNEN0 [5..5]  ============================================== */
                                 /* CFGTMR_FLCH_PWMSYNEN0                                                      */
#define  CFGTMR_FLCH_PWMSYNEN0_0                 0U     /* 0 : The PWM synchronization in this pair of channels is disabled.         */
#define  CFGTMR_FLCH_PWMSYNEN0_1                 1U     /* 1 : The PWM synchronization in this pair of channels is enabled.          */


/* ==============================================  CFGTMR FLCH FCTRLEN0 [6..6]  =============================================== */
                                 /* CFGTMR_FLCH_FCTRLEN0                                                       */
#define  CFGTMR_FLCH_FCTRLEN0_0                  0U     /* 0 : The fault control in this pair of channels is disabled.               */
#define  CFGTMR_FLCH_FCTRLEN0_1                  1U     /* 1 : The fault control in this pair of channels is enabled.                */

/* ================================================  CFGTMR FLCH CCHO1 [9..9]  ================================================ */
                                 /* CFGTMR_FLCH_CCHO1                                                          */
#define  CFGTMR_FLCH_CCHO1_0                     0U     /* 0 : The channel (n+1) output is the same as the channel (n)
                                                       output.                                                                   */
#define  CFGTMR_FLCH_CCHO1_1                     1U     /* 1 : The channel (n+1) output is the complement of the channel
                                                     (n) output.                                                               */


/* ==============================================  CFGTMR FLCH DECSTS1 [11..11]  ============================================== */
                                 /* CFGTMR_FLCH_DECSTS1                                                        */
#define  CFGTMR_FLCH_DECSTS1_0                   0U     /* 0 : The dual edge captures are inactive.                                  */
#define  CFGTMR_FLCH_DECSTS1_1                   1U     /* 1 : The dual edge captures are active.                                    */


/* ==============================================  CFGTMR FLCH DTIEN1 [12..12]  =============================================== */
                                 /* CFGTMR_FLCH_DTIEN1                                                         */
#define  CFGTMR_FLCH_DTIEN1_0                    0U     /* 0 : The deadtime insertion in this pair of channels is disabled.          */
#define  CFGTMR_FLCH_DTIEN1_1                    1U     /* 1 : The deadtime insertion in this pair of channels is enabled.           */


/* =============================================  CFGTMR FLCH PWMSYNEN1 [13..13]  ============================================= */
                                 /* CFGTMR_FLCH_PWMSYNEN1                                                      */
#define  CFGTMR_FLCH_PWMSYNEN1_0                 0U     /* 0 : The PWM synchronization in this pair of channels is disabled.         */
#define  CFGTMR_FLCH_PWMSYNEN1_1                 1U     /* 1 : The PWM synchronization in this pair of channels is enabled.          */


/* =============================================  CFGTMR FLCH FCTRLEN1 [14..14]  ============================================== */
                                 /* CFGTMR_FLCH_FCTRLEN1                                                       */
#define  CFGTMR_FLCH_FCTRLEN1_0                  0U     /* 0 : The fault control in this pair of channels is disabled.               */
#define  CFGTMR_FLCH_FCTRLEN1_1                  1U     /* 1 : The fault control in this pair of channels is enabled.                */


/* ===============================================  CFGTMR FLCH CCHO2 [17..17]  =============================================== */
                                 /* CFGTMR_FLCH_CCHO2                                                          */
#define  CFGTMR_FLCH_CCHO2_0                     0U     /* 0 : The channel (n+1) output is the same as the channel (n)
                                                        output.                                                                   */
#define  CFGTMR_FLCH_CCHO2_1                     1U     /* 1 : The channel (n+1) output is the complement of the channel
                                                        (n) output.                                                               */


/* ==============================================  CFGTMR FLCH DECSTS2 [19..19]  ============================================== */
                                 /* CFGTMR_FLCH_DECSTS2                                                        */
#define  CFGTMR_FLCH_DECSTS2_0                   0U     /* 0 : The dual edge captures are inactive.                                  */
#define  CFGTMR_FLCH_DECSTS2_1                   1U     /* 1 : The dual edge captures are active.                                    */


/* ==============================================  CFGTMR FLCH DTIEN2 [20..20]  =============================================== */
                                 /* CFGTMR_FLCH_DTIEN2                                                         */
#define  CFGTMR_FLCH_DTIEN2_0                    0U     /* 0 : The deadtime insertion in this pair of channels is disabled.          */
#define  CFGTMR_FLCH_DTIEN2_1                    1U     /* 1 : The deadtime insertion in this pair of channels is enabled.           */


/* =============================================  CFGTMR FLCH PWMSYNEN2 [21..21]  ============================================= */
                                 /* CFGTMR_FLCH_PWMSYNEN2                                                      */
#define  CFGTMR_FLCH_PWMSYNEN2_0                 0U     /* 0 : The PWM synchronization in this pair of channels is disabled.         */
#define  CFGTMR_FLCH_PWMSYNEN2_1                 1U     /* 1 : The PWM synchronization in this pair of channels is enabled.          */


/* =============================================  CFGTMR FLCH FCTRLEN2 [22..22]  ============================================== */
                                 /* CFGTMR_FLCH_FCTRLEN2                                                       */
#define  CFGTMR_FLCH_FCTRLEN2_0                  0U     /* 0 : The fault control in this pair of channels is disabled.               */
#define  CFGTMR_FLCH_FCTRLEN2_1                  1U     /* 1 : The fault control in this pair of channels is enabled.                */


/* ===============================================  CFGTMR FLCH CCHO3 [25..25]  =============================================== */
                                 /* CFGTMR_FLCH_CCHO3                                                          */
#define  CFGTMR_FLCH_CCHO3_0                     0U     /* 0 : The channel (n+1) output is the same as the channel (n)
                                                         output.                                                                   */
#define  CFGTMR_FLCH_CCHO3_1                     1U     /* 1 : The channel (n+1) output is the complement of the channel
                                                        (n) output.                                                               */


/* ==============================================  CFGTMR FLCH DECSTS3 [27..27]  ============================================== */
                                 /* CFGTMR_FLCH_DECSTS3                                                        */
#define  CFGTMR_FLCH_DECSTS3_0                   0U     /* 0 : The dual edge captures are inactive.                                  */
#define  CFGTMR_FLCH_DECSTS3_1                   1U     /* 1 : The dual edge captures are active.                                    */


/* ==============================================  CFGTMR FLCH DTIEN3 [28..28]  =============================================== */
                                 /* CFGTMR_FLCH_DTIEN3                                                         */
#define  CFGTMR_FLCH_DTIEN3_0                    0U     /* 0 : The deadtime insertion in this pair of channels is disabled.          */
#define  CFGTMR_FLCH_DTIEN3_1                    1U     /* 1 : The deadtime insertion in this pair of channels is enabled.           */


/* =============================================  CFGTMR FLCH PWMSYNEN3 [29..29]  ============================================= */
                                 /* CFGTMR_FLCH_PWMSYNEN3                                                      */
#define  CFGTMR_FLCH_PWMSYNEN3_0                 0U     /* 0 : The PWM synchronization in this pair of channels is disabled.         */
#define  CFGTMR_FLCH_PWMSYNEN3_1                 1U     /* 1 : The PWM synchronization in this pai