/*!
 * @file        csec_test_data.h
 *
 * @brief       The data used for testing CSEC functions
 *
 * @version     V1.0.0
 *
 * @date        2026-01-31
 *
 * @attention
 *
 *  Copyright (C) 2026 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

#include "csec_test_data.h"

/** @addtogroup APM32F445_Examples
  @{
*/

/** @addtogroup CSEC_Security
  @{
*/

/** @defgroup CSEC_Security_Variables Variables
  @{
*/

/* The empty used when the MASTER_ECU_KEY has not been loaded */
uint8_t g_emptyKey[KEY_SIZE] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

/* The MASTER_ECU_KEY */
uint8_t g_masterEcuKey[KEY_SIZE] = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
};

/* The user key used for encryption/decryption and CMAC generation */
uint8_t g_userKey[KEY_SIZE] = {
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F
};

/* Plain text for AES-128 ECB encryption/decryption */
uint8_t g_ecbPlainText[ECB_TEXT_SIZE] = {
    0x39, 0x15, 0xD9, 0x07, 0xAA, 0x6A, 0x0E, 0x6C,
    0xEE, 0x1F, 0xB9, 0xA3, 0xBA, 0x49, 0xA9, 0xEA,
    0x2E, 0x7E, 0xD0, 0xD7, 0x7B, 0x56, 0x86, 0x9C,
    0x7D, 0x69, 0x99, 0x7B, 0xAF, 0x7D, 0xA0, 0x6D,
    0x43, 0x2D, 0xCF, 0x95, 0xCE, 0x0E, 0x29, 0x7B,
    0xF2, 0x8B, 0x47, 0xEE, 0x5A, 0x64, 0xE5, 0x72,
    0x49, 0x36, 0x85, 0x7C, 0xA1, 0xFD, 0xC9, 0x57,
    0x11, 0xAF, 0xA2, 0xA2, 0x53, 0xDB, 0x08, 0x7C,
    0xDB, 0xDD, 0x65, 0x6D, 0x14, 0xC0, 0x3B, 0xB2,
    0x0D, 0xF2, 0x50, 0x1C, 0xF8, 0x5A, 0x99, 0x7B,
    0xF2, 0xA5, 0xC0, 0xEA, 0x90, 0xC1, 0xEF, 0xDC,
    0xEB, 0x0B, 0x47, 0xCE, 0x43, 0x85, 0xB9, 0x0F,
    0x14, 0xC4, 0x84, 0x36, 0xA0, 0xF7, 0x35, 0xAD,
    0x91, 0xBE, 0x0F, 0x65, 0xCE, 0x3D, 0x9D, 0x72,
    0xE8, 0x6C, 0x24, 0xDD, 0xCF, 0x64, 0x3C, 0xEE,
    0xAB, 0xB2, 0x38, 0x49, 0xFF, 0x00, 0xDC, 0x65,
    0x85, 0xDB, 0x9C, 0x2C, 0x11, 0xC2, 0x0B, 0x23,
    0x52, 0x91, 0xEF, 0xE1, 0xC4, 0x03, 0xE5, 0x12,
    0x35, 0x36, 0xF6, 0xC0, 0xCA, 0xCD, 0x21, 0x8E,
    0x7E, 0x4B, 0x5A, 0xCE, 0x1D, 0xCF, 0xD2, 0x55
};

/* Cipher text for AES-128 ECB encryption/decryption */
uint8_t g_ecbCipherText[ECB_TEXT_SIZE] = {
    0xE1, 0x4A, 0x64, 0x64, 0xB5, 0x05, 0x88, 0x18,
    0x84, 0xF7, 0x63, 0x02, 0xCB, 0xFE, 0xC6, 0xA4,
    0x23, 0x5A, 0xF0, 0xCF, 0xEA, 0x25, 0x19, 0x88,
    0x67, 0x22, 0xF5, 0x5A, 0x87, 0x6A, 0x16, 0x84,
    0xD0, 0x8C, 0xC0, 0x2F, 0x9B, 0x3E, 0x57, 0xD1,
    0xAA, 0x80, 0x62, 0x4C, 0xB2, 0x7B, 0x98, 0x9E,
    0x39, 0x4E, 0x9E, 0x94, 0x07, 0x1A, 0x0C, 0x5D,
    0xC5, 0x68, 0x0E, 0x4F, 0x9F, 0xA0, 0x79, 0x67,
    0x71, 0xEB, 0x58, 0x1A, 0x10, 0xAA, 0xC1, 0xFF,
    0xB8, 0x7E, 0x8A, 0xCF, 0xF8, 0x3E, 0xB0, 0xC9,
    0xB9, 0x51, 0xAF, 0x46, 0xDB, 0x2F, 0x61, 0x9E,
    0xA3, 0x41, 0x6E, 0xB8, 0x74, 0x6A, 0x4A, 0x63,
    0x74, 0x99, 0x4A, 0xEF, 0x1D, 0x90, 0xBF, 0xB9,
    0xDF, 0x82, 0x5A, 0x57, 0x45, 0x27, 0x38, 0x8E,
    0x91, 0x55, 0x60, 0x51, 0x7A, 0x40, 0xD6, 0x8C,
    0x10, 0x29, 0xB0, 0x29, 0xF0, 0x0A, 0xC8, 0xCD,
    0x8B, 0x26, 0xB3, 0x30, 0x83, 0x9A, 0xB8, 0x5D,
    0x15, 0xA1, 0x4A, 0xD8, 0x9F, 0xF6, 0xC8, 0x18,
    0x2A, 0xAD, 0x5B, 0x69, 0x08, 0xAB, 0xF3, 0x04,
    0x1C, 0xD6, 0xFD, 0xCB, 0x10, 0x09, 0x0D, 0xBC
};

/* IV used for AES-128 CBC encryption/decryption */
uint8_t g_cbcIv[CBC_IV_SIZE] = {
    0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48
};

/* Plain text for AES-128 CBC encryption/decryption */
uint8_t g_cbcPlainText[CBC_TEXT_SIZE] = {
    0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
    0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x60,
    0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
    0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x70,
    0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88,
    0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x80
};

/* Cipher text for AES-128 CBC encryption/decryption */
uint8_t g_cbcCipherText[CBC_TEXT_SIZE] = {
    0xCA, 0x67, 0x38, 0x0E, 0xA7, 0x98, 0x05, 0x79,
    0x0D, 0x98, 0x4E, 0x9A, 0xE2, 0x89, 0x55, 0x02,
    0xFB, 0x74, 0x24, 0x5B, 0x71, 0x21, 0x2D, 0x1E,
    0xDF, 0x9C, 0x43, 0xF0, 0x6B, 0xC8, 0x6A, 0x0E,
    0xAE, 0xB9, 0xB9, 0x53, 0x86, 0x5C, 0x07, 0xC0,
    0xFC, 0x69, 0x28, 0x98, 0x4E, 0xF9, 0xD9, 0xF6
};

/* The input message used to generate CMAC */
uint8_t g_macMessage[MAC_MSG_SIZE] = {
    0x31, 0x31, 0x32, 0x32, 0x33, 0x33, 0x34, 0x34,
    0x35, 0x35, 0x36, 0x36, 0x37, 0x37, 0x38, 0x38,
    0x39, 0x39, 0x30, 0x30, 0x61, 0x61, 0x62, 0x62,
    0x63, 0x63, 0x64, 0x64, 0x65, 0x65, 0x66, 0x66,
    0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E,
    0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76,
    0x31, 0x31, 0x32, 0x32, 0x33, 0x33, 0x34, 0x34,
    0x35, 0x35, 0x36, 0x36, 0x37, 0x37, 0x38, 0x38,
    0x39, 0x39, 0x30, 0x30, 0x61, 0x61, 0x62, 0x62,
    0x63, 0x63, 0x64, 0x64, 0x65, 0x65, 0x66, 0x66,
    0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E,
    0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76
};

/* The expected CMAC values for the input message */
uint8_t g_macValues[16] = {
    0x14, 0xA8, 0xB5, 0x38, 0x5F, 0x8A, 0xEA, 0xD6,
    0xC4, 0x65, 0x54, 0xA8, 0xE7, 0xBC, 0xF1, 0xDA
};

/**@} end of group CSEC_Security_Variables*/
/**@} end of group CSEC_Security*/
/**@} end of group Examples*/
