/*!
 * @file       Board.h
 *
 * @brief      Header file for Board
 *
 * @version     V1.0.0
 *
 * @date        2026-01-31
 *
 * @attention
 *
 *  Copyright (C) 2026 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef BOARD_H
#define BOARD_H

/* Includes */
#if defined (APM32F445_EVAL)
#include "Board_APM32F445_EVAL\inc\board_apm32f445_eval.h"
#elif defined (APM32F446_EVAL)
#include "Board_APM32F446_EVAL\inc\board_apm32f446_eval.h"

#else
#error "Please select first the APM32F445_446 board to be used (in board.h)"
#endif


#endif

