/*!
 * @file        main.h
 *
 * @brief       Header for main.c module
 *
 * @version     V1.0.0
 *
 * @date        2022-02-21
 *
 * @attention
 *
 *  Copyright (C) 2020-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes */
#include "delay.h"
#include "oled.h"
#include "led.h"
#include "apm32f0xx.h"
#include "tsc_user.h"

#include "apm32f0xx_gpio.h"
#include "apm32f0xx_rcm.h"

/** @addtogroup Examples
  @{
  */

/** @addtogroup TSC_KeyLinearRotate
  @{
  */

/** @defgroup TSC_KeyLinearRotate_Macros Macros
  @{
  */

/**@} end of group TSC_KeyLinearRotate_Macros */

/** @defgroup TSC_KeyLinearRotate_Enumerations Enumerations
  @{
  */

/**@} end of group TSC_KeyLinearRotate_Enumerations */

/** @defgroup TSC_KeyLinearRotate_Structures Structures
  @{
  */

/**@} end of group TSC_KeyLinearRotate_Structures */

/** @defgroup TSC_KeyLinearRotate_Variables Variables
  @{
  */

/**@} end of group TSC_KeyLinearRotate_Variables */

/** @defgroup TSC_KeyLinearRotate_Functions Functions
  @{
  */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */

/**@} end of group TSC_KeyLinearRotate_Functions */
/**@} end of group TSC_KeyLinearRotate */
/**@} end of group Examples */
